/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.version;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.aether.version.Version;

final class GenericVersion
implements Version {
    private final String version;
    private final Item[] items;
    private final int hash;

    GenericVersion(String version) {
        this.version = version;
        this.items = GenericVersion.parse(version);
        this.hash = Arrays.hashCode(this.items);
    }

    private static Item[] parse(String version) {
        ArrayList<Item> items = new ArrayList<Item>();
        Tokenizer tokenizer = new Tokenizer(version);
        while (tokenizer.next()) {
            Item item = tokenizer.toItem();
            items.add(item);
        }
        GenericVersion.trimPadding(items);
        return items.toArray(new Item[items.size()]);
    }

    private static void trimPadding(List<Item> items) {
        int end;
        Boolean number = null;
        for (int i = end = items.size() - 1; i > 0; --i) {
            Item item = items.get(i);
            if (!Boolean.valueOf(item.isNumber()).equals(number)) {
                end = i;
                number = item.isNumber();
            }
            if (end != i || i != items.size() - 1 && items.get(i - 1).isNumber() != item.isNumber() || item.compareTo(null) != 0) continue;
            items.remove(i);
            --end;
        }
    }

    @Override
    public int compareTo(Version obj) {
        Item[] these = this.items;
        Item[] those = ((GenericVersion)obj).items;
        boolean number = true;
        int index2 = 0;
        while (index2 < these.length || index2 < those.length) {
            if (index2 >= these.length) {
                return -GenericVersion.comparePadding(those, index2, null);
            }
            if (index2 >= those.length) {
                return GenericVersion.comparePadding(these, index2, null);
            }
            Item thisItem = these[index2];
            Item thatItem = those[index2];
            if (thisItem.isNumber() != thatItem.isNumber()) {
                if (number == thisItem.isNumber()) {
                    return GenericVersion.comparePadding(these, index2, number);
                }
                return -GenericVersion.comparePadding(those, index2, number);
            }
            int rel = thisItem.compareTo(thatItem);
            if (rel != 0) {
                return rel;
            }
            number = thisItem.isNumber();
            ++index2;
        }
        return 0;
    }

    private static int comparePadding(Item[] items, int index2, Boolean number) {
        int rel = 0;
        for (int i = index2; i < items.length; ++i) {
            Item item = items[i];
            if (number != null && number.booleanValue() != item.isNumber() || (rel = item.compareTo(null)) != 0) break;
        }
        return rel;
    }

    public boolean equals(Object obj) {
        return obj instanceof GenericVersion && this.compareTo((GenericVersion)obj) == 0;
    }

    public int hashCode() {
        return this.hash;
    }

    @Override
    public String toString() {
        return this.version;
    }

    static final class Item {
        static final int KIND_MAX = 8;
        static final int KIND_BIGINT = 5;
        static final int KIND_INT = 4;
        static final int KIND_STRING = 3;
        static final int KIND_QUALIFIER = 2;
        static final int KIND_MIN = 0;
        static final Item MAX = new Item(8, "max");
        static final Item MIN = new Item(0, "min");
        private final int kind;
        private final Object value;

        Item(int kind, Object value) {
            this.kind = kind;
            this.value = value;
        }

        public boolean isNumber() {
            return (this.kind & 2) == 0;
        }

        public int compareTo(Item that) {
            int rel;
            block13: {
                block12: {
                    if (that != null) break block12;
                    switch (this.kind) {
                        case 0: {
                            rel = -1;
                            break block13;
                        }
                        case 3: 
                        case 5: 
                        case 8: {
                            rel = 1;
                            break block13;
                        }
                        case 2: 
                        case 4: {
                            rel = (Integer)this.value;
                            break block13;
                        }
                        default: {
                            throw new IllegalStateException("unknown version item kind " + this.kind);
                        }
                    }
                }
                rel = this.kind - that.kind;
                if (rel == 0) {
                    switch (this.kind) {
                        case 0: 
                        case 8: {
                            break;
                        }
                        case 5: {
                            rel = ((BigInteger)this.value).compareTo((BigInteger)that.value);
                            break;
                        }
                        case 2: 
                        case 4: {
                            rel = ((Integer)this.value).compareTo((Integer)that.value);
                            break;
                        }
                        case 3: {
                            rel = ((String)this.value).compareToIgnoreCase((String)that.value);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("unknown version item kind " + this.kind);
                        }
                    }
                }
            }
            return rel;
        }

        public boolean equals(Object obj) {
            return obj instanceof Item && this.compareTo((Item)obj) == 0;
        }

        public int hashCode() {
            return this.value.hashCode() + this.kind * 31;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    static final class Tokenizer {
        private static final Integer QUALIFIER_ALPHA = -5;
        private static final Integer QUALIFIER_BETA = -4;
        private static final Integer QUALIFIER_MILESTONE = -3;
        private static final Map<String, Integer> QUALIFIERS = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
        private final String version;
        private int index;
        private String token;
        private boolean number;
        private boolean terminatedByNumber;

        Tokenizer(String version) {
            this.version = version.length() > 0 ? version : "0";
        }

        public boolean next() {
            int n = this.version.length();
            if (this.index >= n) {
                return false;
            }
            int state = -2;
            int start = this.index;
            int end = n;
            this.terminatedByNumber = false;
            while (this.index < n) {
                char c = this.version.charAt(this.index);
                if (c == '.' || c == '-' || c == '_') {
                    end = this.index++;
                    break;
                }
                int digit = Character.digit(c, 10);
                if (digit >= 0) {
                    if (state == -1) {
                        end = this.index;
                        this.terminatedByNumber = true;
                        break;
                    }
                    if (state == 0) {
                        ++start;
                    }
                    state = state > 0 || digit > 0 ? 1 : 0;
                } else {
                    if (state >= 0) {
                        end = this.index;
                        break;
                    }
                    state = -1;
                }
                ++this.index;
            }
            if (end - start > 0) {
                this.token = this.version.substring(start, end);
                this.number = state >= 0;
            } else {
                this.token = "0";
                this.number = true;
            }
            return true;
        }

        public String toString() {
            return String.valueOf(this.token);
        }

        public Item toItem() {
            Integer qualifier;
            if (this.number) {
                try {
                    if (this.token.length() < 10) {
                        return new Item(4, Integer.parseInt(this.token));
                    }
                    return new Item(5, new BigInteger(this.token));
                }
                catch (NumberFormatException e2) {
                    throw new IllegalStateException(e2);
                }
            }
            if (this.index >= this.version.length()) {
                if ("min".equalsIgnoreCase(this.token)) {
                    return Item.MIN;
                }
                if ("max".equalsIgnoreCase(this.token)) {
                    return Item.MAX;
                }
            }
            if (this.terminatedByNumber && this.token.length() == 1) {
                switch (this.token.charAt(0)) {
                    case 'A': 
                    case 'a': {
                        return new Item(2, QUALIFIER_ALPHA);
                    }
                    case 'B': 
                    case 'b': {
                        return new Item(2, QUALIFIER_BETA);
                    }
                    case 'M': 
                    case 'm': {
                        return new Item(2, QUALIFIER_MILESTONE);
                    }
                }
            }
            if ((qualifier = QUALIFIERS.get(this.token)) != null) {
                return new Item(2, qualifier);
            }
            return new Item(3, this.token.toLowerCase(Locale.ENGLISH));
        }

        static {
            QUALIFIERS.put("alpha", QUALIFIER_ALPHA);
            QUALIFIERS.put("beta", QUALIFIER_BETA);
            QUALIFIERS.put("milestone", QUALIFIER_MILESTONE);
            QUALIFIERS.put("cr", -2);
            QUALIFIERS.put("rc", -2);
            QUALIFIERS.put("snapshot", -1);
            QUALIFIERS.put("ga", 0);
            QUALIFIERS.put("final", 0);
            QUALIFIERS.put("", 0);
            QUALIFIERS.put("sp", 1);
        }
    }
}

