/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase.highlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.NullFragmenter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleFragmenter;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.SimpleSpanFragmenter;
import org.apache.lucene.search.highlight.TextFragment;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.search.fetch.FetchPhaseExecutionException;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.subphase.highlight.CustomQueryScorer;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightUtils;
import org.elasticsearch.search.fetch.subphase.highlight.Highlighter;
import org.elasticsearch.search.fetch.subphase.highlight.HighlighterContext;
import org.elasticsearch.search.fetch.subphase.highlight.SearchContextHighlight;
import org.elasticsearch.search.fetch.subphase.highlight.UnifiedHighlighter;
import org.elasticsearch.search.internal.SearchContext;

public class PlainHighlighter
implements Highlighter {
    private static final String CACHE_KEY = "highlight-plain";
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(PlainHighlighter.class));

    @Override
    public HighlightField highlight(HighlighterContext highlighterContext) {
        int i;
        String[] fragments;
        List<Object> textsToHighlight;
        Map cache;
        org.apache.lucene.search.highlight.Highlighter entry;
        Encoder encoder;
        SearchContextHighlight.Field field = highlighterContext.field;
        SearchContext context = highlighterContext.context;
        FetchSubPhase.HitContext hitContext = highlighterContext.hitContext;
        MappedFieldType fieldType = highlighterContext.fieldType;
        Encoder encoder2 = encoder = field.fieldOptions().encoder().equals("html") ? HighlightUtils.Encoders.HTML : HighlightUtils.Encoders.DEFAULT;
        if (!hitContext.cache().containsKey(CACHE_KEY)) {
            hitContext.cache().put(CACHE_KEY, new HashMap());
        }
        if ((entry = (org.apache.lucene.search.highlight.Highlighter)(cache = (Map)hitContext.cache().get(CACHE_KEY)).get((Object)fieldType)) == null) {
            NullFragmenter fragmenter;
            CustomQueryScorer queryScorer = new CustomQueryScorer(highlighterContext.query, field.fieldOptions().requireFieldMatch() != false ? fieldType.name() : null);
            queryScorer.setExpandMultiTermQuery(true);
            if (field.fieldOptions().numberOfFragments() == 0) {
                fragmenter = new NullFragmenter();
            } else if (field.fieldOptions().fragmenter() == null) {
                fragmenter = new SimpleSpanFragmenter((QueryScorer)queryScorer, field.fieldOptions().fragmentCharSize());
            } else if ("simple".equals(field.fieldOptions().fragmenter())) {
                fragmenter = new SimpleFragmenter(field.fieldOptions().fragmentCharSize());
            } else if ("span".equals(field.fieldOptions().fragmenter())) {
                fragmenter = new SimpleSpanFragmenter((QueryScorer)queryScorer, field.fieldOptions().fragmentCharSize());
            } else {
                throw new IllegalArgumentException("unknown fragmenter option [" + field.fieldOptions().fragmenter() + "] for the field [" + highlighterContext.fieldName + "]");
            }
            SimpleHTMLFormatter formatter = new SimpleHTMLFormatter(field.fieldOptions().preTags()[0], field.fieldOptions().postTags()[0]);
            entry = new org.apache.lucene.search.highlight.Highlighter((Formatter)formatter, encoder, (Scorer)queryScorer);
            entry.setTextFragmenter((Fragmenter)fragmenter);
            entry.setMaxDocCharsToAnalyze(Integer.MAX_VALUE);
            cache.put(fieldType, entry);
        }
        int numberOfFragments = field.fieldOptions().numberOfFragments() == 0 ? 1 : field.fieldOptions().numberOfFragments();
        ArrayList<TextFragment> fragsList = new ArrayList<TextFragment>();
        Analyzer analyzer = HighlightUtils.getAnalyzer(context.mapperService().documentMapper(hitContext.hit().getType()), fieldType);
        int maxAnalyzedOffset = context.indexShard().indexSettings().getHighlightMaxAnalyzedOffset();
        try {
            textsToHighlight = HighlightUtils.loadFieldValues(field, fieldType, context, hitContext);
            int maxAnalyzedOffset7 = 1000000;
            for (Object textToHighlight : textsToHighlight) {
                String text = UnifiedHighlighter.convertFieldValue(fieldType, textToHighlight);
                if (maxAnalyzedOffset == -1 && text.length() > 1000000) {
                    deprecationLogger.deprecated("The length [" + text.length() + "] of [" + highlighterContext.fieldName + "] field of [" + hitContext.hit().getId() + "] doc of [" + context.indexShard().shardId().getIndexName() + "] index has exceeded the allowed maximum of [" + 1000000 + "] set for the next major Elastic version. This maximum can be set by changing the [" + IndexSettings.MAX_ANALYZED_OFFSET_SETTING.getKey() + "] index level setting. For large texts, indexing with offsets or term vectors is recommended!", new Object[0]);
                }
                if (maxAnalyzedOffset > 0 && text.length() > maxAnalyzedOffset) {
                    throw new IllegalArgumentException("The length [" + text.length() + "] of [" + highlighterContext.fieldName + "] field of [" + hitContext.hit().getId() + "] doc of [" + context.indexShard().shardId().getIndexName() + "] index has exceeded [" + maxAnalyzedOffset + "] - maximum allowed to be analyzed for highlighting. This maximum can be set by changing the [" + IndexSettings.MAX_ANALYZED_OFFSET_SETTING.getKey() + "] index level setting. For large texts, indexing with offsets or term vectors, and highlighting with unified or fvh highlighter is recommended!");
                }
                TokenStream tokenStream = analyzer.tokenStream(fieldType.name(), text);
                try {
                    TextFragment[] bestTextFragments;
                    if (!tokenStream.hasAttribute(CharTermAttribute.class) || !tokenStream.hasAttribute(OffsetAttribute.class)) continue;
                    for (TextFragment bestTextFragment : bestTextFragments = entry.getBestTextFragments(tokenStream, text, false, numberOfFragments)) {
                        if (bestTextFragment == null || !(bestTextFragment.getScore() > 0.0f)) continue;
                        fragsList.add(bestTextFragment);
                    }
                }
                finally {
                    if (tokenStream == null) continue;
                    tokenStream.close();
                }
            }
        }
        catch (Exception e) {
            if (ExceptionsHelper.unwrap(e, BytesRefHash.MaxBytesLengthExceededException.class) != null) {
                return null;
            }
            throw new FetchPhaseExecutionException(context, "Failed to highlight field [" + highlighterContext.fieldName + "]", (Throwable)e);
        }
        if (field.fieldOptions().scoreOrdered().booleanValue()) {
            CollectionUtil.introSort(fragsList, (Comparator)new Comparator<TextFragment>(){

                @Override
                public int compare(TextFragment o1, TextFragment o2) {
                    return Math.round(o2.getScore() - o1.getScore());
                }
            });
        }
        if (field.fieldOptions().numberOfFragments() == 0 && textsToHighlight.size() > 1 && fragsList.size() > 0) {
            fragments = new String[fragsList.size()];
            for (i = 0; i < fragsList.size(); ++i) {
                fragments[i] = ((TextFragment)fragsList.get(i)).toString();
            }
        } else {
            numberOfFragments = fragsList.size() < numberOfFragments ? fragsList.size() : numberOfFragments;
            fragments = new String[numberOfFragments];
            for (i = 0; i < fragments.length; ++i) {
                fragments[i] = ((TextFragment)fragsList.get(i)).toString();
            }
        }
        if (fragments.length > 0) {
            return new HighlightField(highlighterContext.fieldName, Text.convertFromStringArray(fragments));
        }
        int noMatchSize = highlighterContext.field.fieldOptions().noMatchSize();
        if (noMatchSize > 0 && textsToHighlight.size() > 0) {
            int end;
            String fieldContents = textsToHighlight.get(0).toString();
            try {
                end = PlainHighlighter.findGoodEndForNoHighlightExcerpt(noMatchSize, analyzer, fieldType.name(), fieldContents);
            }
            catch (Exception e) {
                throw new FetchPhaseExecutionException(context, "Failed to highlight field [" + highlighterContext.fieldName + "]", (Throwable)e);
            }
            if (end > 0) {
                return new HighlightField(highlighterContext.fieldName, new Text[]{new Text(fieldContents.substring(0, end))});
            }
        }
        return null;
    }

    @Override
    public boolean canHighlight(MappedFieldType fieldType) {
        return true;
    }

    private static int findGoodEndForNoHighlightExcerpt(int noMatchSize, Analyzer analyzer, String fieldName, String contents) throws IOException {
        try (TokenStream tokenStream = analyzer.tokenStream(fieldName, contents);){
            if (!tokenStream.hasAttribute(OffsetAttribute.class)) {
                int n = -1;
                return n;
            }
            int end = -1;
            tokenStream.reset();
            while (tokenStream.incrementToken()) {
                OffsetAttribute attr = (OffsetAttribute)tokenStream.getAttribute(OffsetAttribute.class);
                if (attr.endOffset() >= noMatchSize) {
                    if (attr.endOffset() == noMatchSize) {
                        end = noMatchSize;
                    }
                    int n = end;
                    return n;
                }
                end = attr.endOffset();
            }
            tokenStream.end();
            int n = end;
            return n;
        }
    }
}

