/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import org.jmol.api.JmolMeasurementClient;
import org.jmol.atomdata.RadiusData;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Measurement;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.Text;
import org.jmol.modelset.TickInfo;
import org.jmol.util.BSUtil;
import org.jmol.util.Point3fi;
import org.jmol.viewer.Viewer;

public class MeasurementData
implements JmolMeasurementClient {
    private JmolMeasurementClient client;
    private Lst<String> measurementStrings;
    private Lst<Float> measurements;
    public Lst<Object> points;
    public boolean mustBeConnected;
    public boolean mustNotBeConnected;
    public TickInfo tickInfo;
    public int tokAction = 12290;
    public RadiusData radiusData;
    public String strFormat;
    public String note;
    public boolean isAll;
    public short colix;
    public Boolean intramolecular;
    public int mad;
    public String thisID;
    public Text text;
    private Atom[] atoms;
    private String units;
    private float[] minArray;
    private ModelSet ms;
    private Viewer vwr;
    private int iFirstAtom;
    private boolean justOneModel = true;
    public Map<String, Integer> htMin;

    public MeasurementData init(String string, Viewer viewer, Lst<Object> lst) {
        this.vwr = viewer;
        this.points = lst;
        this.thisID = string;
        return this;
    }

    public MeasurementData setModelSet(ModelSet modelSet) {
        this.ms = modelSet;
        return this;
    }

    public MeasurementData set(int n, Map<String, Integer> map, RadiusData radiusData, String string, String string2, TickInfo tickInfo, boolean bl, boolean bl2, Boolean bl3, boolean bl4, int n2, short s, Text text) {
        this.ms = this.vwr.ms;
        this.tokAction = n;
        if (this.points.size() >= 2 && this.points.get(0) instanceof BS && this.points.get(1) instanceof BS) {
            this.justOneModel = BSUtil.haveCommon(this.vwr.ms.getModelBS((BS)this.points.get(0), false), this.vwr.ms.getModelBS((BS)this.points.get(1), false));
        }
        this.htMin = map;
        this.radiusData = radiusData;
        this.strFormat = string;
        this.units = string2;
        this.tickInfo = tickInfo;
        this.mustBeConnected = bl;
        this.mustNotBeConnected = bl2;
        this.intramolecular = bl3;
        this.isAll = bl4;
        this.mad = n2;
        this.colix = s;
        this.text = text;
        return this;
    }

    @Override
    public void processNextMeasure(Measurement measurement) {
        float f = measurement.getMeasurement(null);
        if (this.htMin != null && !measurement.isMin(this.htMin) || this.radiusData != null && !measurement.isInRange(this.radiusData, f)) {
            return;
        }
        if (this.measurementStrings == null && this.measurements == null) {
            float f2 = this.minArray[this.iFirstAtom];
            measurement.value = f;
            f = measurement.fixValue(this.units, false);
            this.minArray[this.iFirstAtom] = 1.0f / f2 == Float.NEGATIVE_INFINITY ? f : Math.min(f2, f);
            return;
        }
        if (this.measurementStrings != null) {
            this.measurementStrings.addLast(measurement.getStringUsing(this.vwr, this.strFormat, this.units));
        } else {
            this.measurements.addLast(Float.valueOf(measurement.getMeasurement(null)));
        }
    }

    public Object getMeasurements(boolean bl, boolean bl2) {
        if (bl2) {
            this.minArray = new float[((BS)this.points.get(0)).cardinality()];
            int n = 0;
            while (n < this.minArray.length) {
                this.minArray[n] = -0.0f;
                ++n;
            }
            this.define(null, this.ms);
            return this.minArray;
        }
        if (bl) {
            this.measurements = new Lst();
            this.define(null, this.ms);
            return this.measurements;
        }
        this.measurementStrings = new Lst();
        this.define(null, this.ms);
        return this.measurementStrings;
    }

    public void define(JmolMeasurementClient jmolMeasurementClient, ModelSet modelSet) {
        this.client = jmolMeasurementClient == null ? this : jmolMeasurementClient;
        this.atoms = modelSet.at;
        int n = this.points.size();
        if (n < 2) {
            return;
        }
        int n2 = -1;
        Point3fi[] point3fiArray = new Point3fi[4];
        int[] nArray = new int[5];
        Measurement measurement = new Measurement().setPoints(modelSet, nArray, point3fiArray, null);
        measurement.setCount(n);
        int n3 = -1;
        int n4 = 0;
        while (n4 < n) {
            Object e = this.points.get(n4);
            if (e instanceof BS) {
                BS bS = (BS)e;
                int n5 = bS.cardinality();
                if (n5 == 0) {
                    return;
                }
                if (n5 > 1) {
                    n2 = 0;
                }
                n3 = n4;
                if (n4 == 0) {
                    this.iFirstAtom = 0;
                }
                nArray[n4 + 1] = bS.nextSetBit(0);
            } else {
                point3fiArray[n4] = (Point3fi)e;
                nArray[n4 + 1] = -2 - n4;
            }
            ++n4;
        }
        this.nextMeasure(0, n3, measurement, n2);
    }

    private void nextMeasure(int n, int n2, Measurement measurement, int n3) {
        int n4;
        if (n > n2) {
            if (!(!measurement.isValid() || this.mustBeConnected && !measurement.isConnected(this.atoms, n) || this.mustNotBeConnected && measurement.isConnected(this.atoms, n) || this.intramolecular != null && measurement.isIntramolecular(this.atoms, n) != this.intramolecular.booleanValue())) {
                this.client.processNextMeasure(measurement);
            }
            return;
        }
        BS bS = (BS)this.points.get(n);
        int[] nArray = measurement.countPlusIndices;
        int n5 = n4 = n == 0 ? Integer.MAX_VALUE : nArray[n];
        if (n4 < 0) {
            this.nextMeasure(n + 1, n2, measurement, n3);
            return;
        }
        boolean bl = false;
        int n6 = bS.nextSetBit(0);
        int n7 = 0;
        while (n6 >= 0) {
            block9: {
                block10: {
                    short s;
                    block11: {
                        if (n6 == n4) break block9;
                        s = this.atoms[n6].mi;
                        if (n3 < 0 || !this.justOneModel) break block10;
                        if (n != 0) break block11;
                        n3 = s;
                        break block10;
                    }
                    if (n3 != s) break block9;
                }
                nArray[n + 1] = n6;
                if (n == 0) {
                    this.iFirstAtom = n7;
                }
                bl = true;
                this.nextMeasure(n + 1, n2, measurement, n3);
            }
            n6 = bS.nextSetBit(n6 + 1);
            ++n7;
        }
        if (!bl) {
            this.nextMeasure(n + 1, n2, measurement, n3);
        }
    }
}

