/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javajs.util.AU;
import javajs.util.CU;
import javajs.util.M4;
import javajs.util.V3;
import org.jmol.util.C;

public class Shader {
    private static final int SHADE_INDEX_MAX = 64;
    public static final int SHADE_INDEX_LAST = 63;
    public static final byte SHADE_INDEX_NORMAL = 52;
    public static final byte SHADE_INDEX_NOISY_LIMIT = 56;
    private float xLight;
    private float yLight;
    private float zLight;
    V3 lightSource = new V3();
    boolean specularOn = true;
    boolean usePhongExponent = false;
    int ambientPercent = 45;
    int diffusePercent = 84;
    int specularExponent = 6;
    int specularPercent = 22;
    int specularPower = 40;
    int phongExponent = 64;
    float ambientFraction = (float)this.ambientPercent / 100.0f;
    float diffuseFactor = (float)this.diffusePercent / 100.0f;
    float intenseFraction = (float)this.specularPower / 100.0f;
    float specularFactor = (float)this.specularPercent / 100.0f;
    private int[][] ashades = AU.newInt2(128);
    private int[][] ashadesGreyscale;
    boolean celOn;
    int celPower = 10;
    private int celRGB;
    private float celZ;
    private boolean useLight;
    public byte[] sphereShadeIndexes = new byte[65536];
    private int seed = 305419897;
    private static final int SLIM = 20;
    private static final int SDIM = 40;
    public static final int maxSphereCache = 128;
    public int[][] sphereShapeCache = AU.newInt2(128);
    public byte[][][] ellipsoidShades;
    public int nOut;
    public int nIn;

    public Shader() {
        this.setLightSource(-1.0f, -1.0f, 2.5f);
    }

    private void setLightSource(float f, float f2, float f3) {
        this.lightSource.set(f, f2, f3);
        this.lightSource.normalize();
        this.xLight = this.lightSource.x;
        this.yLight = this.lightSource.y;
        this.zLight = this.lightSource.z;
    }

    void setCel(boolean bl, int n, int n2) {
        bl = bl && n != 0;
        int n3 = (n2 = C.getArgb(C.getBgContrast(n2))) == -16777216 ? -16514044 : (n2 = n2 == -1 ? -2 : n2 + 1);
        if (this.celOn == bl && this.celRGB == n2 && this.celPower == n) {
            return;
        }
        this.celOn = bl;
        this.celPower = n;
        this.useLight = !this.celOn || n > 0;
        this.celZ = 1.0f - (float)Math.pow(2.0, (float)(-Math.abs(n)) / 10.0f);
        this.celRGB = n2;
        this.flushCaches();
    }

    void flushCaches() {
        this.checkShades(C.colixMax);
        int n = C.colixMax;
        while (--n >= 0) {
            this.ashades[n] = null;
        }
        this.calcSphereShading();
        n = 128;
        while (--n >= 0) {
            this.sphereShapeCache[n] = null;
        }
        this.ellipsoidShades = null;
    }

    public void setLastColix(int n, boolean bl) {
        C.allocateColix(n, true);
        this.checkShades(2047);
        if (bl) {
            C.setLastGrey(n);
        }
        this.ashades[2047] = this.getShades2(n, false);
    }

    int[] getShades(short s) {
        this.checkShades(C.colixMax);
        s = (short)(s & 0xFFFF87FF);
        int[] nArray = this.ashades[s];
        if (nArray == null) {
            this.ashades[s] = this.getShades2(C.argbs[s], false);
            nArray = this.ashades[s];
        }
        return nArray;
    }

    int[] getShadesG(short s) {
        int[] nArray;
        this.checkShades(C.colixMax);
        s = (short)(s & 0xFFFF87FF);
        if (this.ashadesGreyscale == null) {
            this.ashadesGreyscale = AU.newInt2(this.ashades.length);
        }
        if ((nArray = this.ashadesGreyscale[s]) == null) {
            this.ashadesGreyscale[s] = this.getShades2(C.argbs[s], true);
            nArray = this.ashadesGreyscale[s];
        }
        return nArray;
    }

    private void checkShades(int n) {
        if (this.ashades != null && this.ashades.length >= n) {
            return;
        }
        if (n == 2047) {
            ++n;
        }
        this.ashades = AU.arrayCopyII(this.ashades, n);
        if (this.ashadesGreyscale != null) {
            this.ashadesGreyscale = AU.arrayCopyII(this.ashadesGreyscale, n);
        }
    }

    /*
     * Unable to fully structure code
     */
    private int[] getShades2(int var1_1, boolean var2_2) {
        block10: {
            var3_3 = new int[64];
            if (var1_1 == 0) {
                return var3_3;
            }
            var4_4 = var1_1 >> 16 & 255;
            var5_5 = var1_1 >> 8 & 255;
            var6_6 = var1_1 & 255;
            var7_7 = 0.0f;
            var8_8 = 0.0f;
            var9_9 = 0.0f;
            var10_10 = this.ambientFraction;
            while (true) {
                var7_7 = var4_4 * var10_10 + 0.5f;
                var8_8 = var5_5 * var10_10 + 0.5f;
                var9_9 = var6_6 * var10_10 + 0.5f;
                if (!(var10_10 > 0.0f) || !(var7_7 < 4.0f) || !(var8_8 < 4.0f) || !(var9_9 < 4.0f)) break;
                var4_4 += 1.0f;
                var5_5 += 1.0f;
                var6_6 += 1.0f;
                if (var10_10 < 0.1f) {
                    var10_10 += 0.1f;
                }
                var1_1 = CU.rgb((int)Math.floor(var4_4), (int)Math.floor(var5_5), (int)Math.floor(var6_6));
            }
            var11_11 = 0;
            var10_10 = (1.0f - var10_10) / 52.0f;
            var12_12 = var4_4 * var10_10;
            var13_13 = var5_5 * var10_10;
            var14_14 = var6_6 * var10_10;
            if (!this.celOn) ** GOTO lbl48
            var15_15 = 32;
            var16_16 = CU.rgb((int)Math.floor(var7_7), (int)Math.floor(var8_8), (int)Math.floor(var9_9));
            if (this.celPower >= 0) {
                while (var11_11 < var15_15) {
                    var3_3[var11_11] = var16_16;
                    ++var11_11;
                }
            }
            var16_16 = CU.rgb((int)Math.floor(var7_7 += var12_12 * (float)var15_15), (int)Math.floor(var8_8 += var13_13 * (float)var15_15), (int)Math.floor(var9_9 += var14_14 * (float)var15_15));
            while (var11_11 < 64) {
                var3_3[var11_11] = var16_16;
                ++var11_11;
            }
            var3_3[0] = var3_3[1] = this.celRGB;
            break block10;
lbl-1000:
            // 1 sources

            {
                var3_3[var11_11] = CU.rgb((int)Math.floor(var7_7), (int)Math.floor(var8_8), (int)Math.floor(var9_9));
                var7_7 += var12_12;
                var8_8 += var13_13;
                var9_9 += var14_14;
                ++var11_11;
lbl48:
                // 2 sources

                ** while (var11_11 < 52)
            }
lbl49:
            // 1 sources

            var3_3[var11_11++] = var1_1;
            var10_10 = this.intenseFraction / (float)(64 - var11_11);
            var12_12 = (255.5f - var7_7) * var10_10;
            var13_13 = (255.5f - var8_8) * var10_10;
            var14_14 = (255.5f - var9_9) * var10_10;
            while (var11_11 < 64) {
                var3_3[var11_11] = CU.rgb((int)Math.floor(var7_7 += var12_12), (int)Math.floor(var8_8 += var13_13), (int)Math.floor(var9_9 += var14_14));
                ++var11_11;
            }
        }
        if (var2_2) {
            while (--var11_11 >= 0) {
                var3_3[var11_11] = CU.toFFGGGfromRGB(var3_3[var11_11]);
            }
        }
        return var3_3;
    }

    public int getShadeIndex(float f, float f2, float f3) {
        double d = Math.sqrt(f * f + f2 * f2 + f3 * f3);
        return Math.round(this.getShadeF((float)((double)f / d), (float)((double)f2 / d), (float)((double)f3 / d)) * 63.0f);
    }

    public byte getShadeB(float f, float f2, float f3) {
        return (byte)Math.round(this.getShadeF(f, f2, f3) * 63.0f);
    }

    public int getShadeFp8(float f, float f2, float f3) {
        double d = Math.sqrt(f * f + f2 * f2 + f3 * f3);
        return (int)Math.floor(this.getShadeF((float)((double)f / d), (float)((double)f2 / d), (float)((double)f3 / d)) * 63.0f * 256.0f);
    }

    private float getShadeF(float f, float f2, float f3) {
        float f4;
        float f5;
        float f6 = f5 = this.useLight ? f * this.xLight + f2 * this.yLight + f3 * this.zLight : f3;
        if (f5 <= 0.0f) {
            return 0.0f;
        }
        float f7 = f5 * this.diffuseFactor;
        if (this.specularOn && (f4 = 2.0f * f5 * f3 - this.zLight) > 0.0f) {
            if (this.usePhongExponent) {
                f4 = (float)Math.pow(f4, this.phongExponent);
            } else {
                int n = this.specularExponent;
                while (--n >= 0 && f4 > 1.0E-4f) {
                    f4 *= f4;
                }
            }
            f7 += f4 * this.specularFactor;
        }
        return this.celOn && f3 < this.celZ ? 0.0f : (f7 > 1.0f ? 1.0f : f7);
    }

    public byte getShadeN(float f, float f2, float f3, float f4) {
        int n;
        int n2 = (int)Math.floor(this.getShadeF(f / f4, f2 / f4, f3 / f4) * 63.0f * 256.0f);
        int n3 = n2 >> 8;
        if (!this.useLight) {
            return (byte)n3;
        }
        if ((n2 & 0xFF) > this.nextRandom8Bit()) {
            ++n3;
        }
        if ((n = this.seed & 0xFFFF) < 21845 && n3 > 0) {
            --n3;
        } else if (n > 43690 && n3 < 63) {
            ++n3;
        }
        return (byte)n3;
    }

    private synchronized void calcSphereShading() {
        float f = -127.5f;
        float f2 = 16900.0f;
        int n = 0;
        while (n < 256) {
            float f3 = -127.5f;
            float f4 = f * f;
            int n2 = 0;
            while (n2 < 256) {
                byte by = 0;
                float f5 = f2 - f4 - f3 * f3;
                if (f5 > 0.0f) {
                    float f6 = (float)Math.sqrt(f5);
                    by = this.getShadeN(f, f3, f6, 130.0f);
                }
                this.sphereShadeIndexes[(n2 << 8) + n] = by;
                f3 += 1.0f;
                ++n2;
            }
            f += 1.0f;
            ++n;
        }
    }

    public int nextRandom8Bit() {
        int n = this.seed;
        this.seed = n = (n << 16) + (n << 1) + n & Integer.MAX_VALUE;
        return n >> 23;
    }

    public int getEllipsoidShade(float f, float f2, float f3, int n, M4 m4) {
        boolean bl;
        float f4 = m4.m00 * f + m4.m01 * f2 + m4.m02 * f3 + m4.m03;
        float f5 = m4.m10 * f + m4.m11 * f2 + m4.m12 * f3 + m4.m13;
        float f6 = m4.m20 * f + m4.m21 * f2 + m4.m22 * f3 + m4.m23;
        float f7 = Math.min((float)n / 2.0f, 45.0f) / (float)Math.sqrt(f4 * f4 + f5 * f5 + f6 * f6);
        int n2 = (int)(-f4 * f7);
        int n3 = (int)(-f5 * f7);
        int n4 = (int)(f6 * f7);
        boolean bl2 = bl = n2 < -20 || n2 >= 20 || n3 < -20 || n3 >= 20 || n4 < 0 || n4 >= 40;
        if (bl) {
            while (n2 % 2 == 0 && n3 % 2 == 0 && n4 % 2 == 0 && n2 + n3 + n4 > 0) {
                n2 >>= 1;
                n3 >>= 1;
                n4 >>= 1;
            }
            boolean bl3 = bl = n2 < -20 || n2 >= 20 || n3 < -20 || n3 >= 20 || n4 < 0 || n4 >= 40;
        }
        if (bl) {
            ++this.nOut;
        } else {
            ++this.nIn;
        }
        return bl ? this.getShadeIndex(n2, n3, n4) : this.ellipsoidShades[n2 + 20][n3 + 20][n4];
    }

    public void createEllipsoidShades() {
        this.ellipsoidShades = new byte[40][40][40];
        int n = 0;
        while (n < 40) {
            int n2 = 0;
            while (n2 < 40) {
                int n3 = 0;
                while (n3 < 40) {
                    this.ellipsoidShades[n][n2][n3] = (byte)this.getShadeIndex(n - 20, n2 - 20, n3);
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }
}

