/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.datatransfer.importers;

import java.awt.Component;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.TransferHandler;
import org.openstreetmap.josm.command.AddPrimitivesCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.datatransfer.data.PrimitiveTransferData;
import org.openstreetmap.josm.gui.datatransfer.importers.AbstractOsmDataPaster;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public final class PrimitiveDataPaster
extends AbstractOsmDataPaster {
    public PrimitiveDataPaster() {
        super(PrimitiveTransferData.DATA_FLAVOR);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support, OsmDataLayer layer, EastNorth pasteAt) throws UnsupportedFlavorException, IOException {
        PrimitiveTransferData pasteBuffer = (PrimitiveTransferData)support.getTransferable().getTransferData(this.df);
        if (pasteBuffer.hasIncompleteData() && !PrimitiveDataPaster.confirmDeleteIncomplete()) {
            return false;
        }
        EastNorth center = pasteBuffer.getCenter();
        EastNorth offset = center == null || pasteAt == null ? new EastNorth(0.0, 0.0) : pasteAt.subtract(center);
        AddPrimitivesCommand command = PrimitiveDataPaster.createNewPrimitives(pasteBuffer, offset, layer);
        UndoRedoHandler.getInstance().add(command);
        return true;
    }

    private static AddPrimitivesCommand createNewPrimitives(PrimitiveTransferData pasteBuffer, EastNorth offset, OsmDataLayer layer) {
        ArrayList<PrimitiveData> bufferCopy = new ArrayList<PrimitiveData>();
        ArrayList<PrimitiveData> toSelect = new ArrayList<PrimitiveData>();
        EnumMap<OsmPrimitiveType, Map<Long, Long>> newIds = PrimitiveDataPaster.generateNewPrimitives(pasteBuffer, bufferCopy, toSelect);
        for (PrimitiveData data : bufferCopy) {
            try {
                if (data instanceof NodeData) {
                    NodeData nodeData = (NodeData)data;
                    nodeData.setEastNorth(nodeData.getEastNorth(ProjectionRegistry.getProjection()).add(offset));
                    continue;
                }
                if (data instanceof WayData) {
                    PrimitiveDataPaster.updateNodes(newIds.get((Object)OsmPrimitiveType.NODE), data);
                    continue;
                }
                if (!(data instanceof RelationData)) continue;
                PrimitiveDataPaster.updateMembers(newIds, data);
            }
            catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException e) {
                throw BugReport.intercept(e).put("data", data);
            }
        }
        return new AddPrimitivesCommand(bufferCopy, toSelect, layer.getDataSet());
    }

    private static EnumMap<OsmPrimitiveType, Map<Long, Long>> generateNewPrimitives(PrimitiveTransferData pasteBuffer, List<PrimitiveData> bufferCopy, List<PrimitiveData> toSelect) {
        EnumMap<OsmPrimitiveType, Map<Long, Long>> newIds = new EnumMap<OsmPrimitiveType, Map<Long, Long>>(OsmPrimitiveType.class);
        newIds.put(OsmPrimitiveType.NODE, new HashMap());
        newIds.put(OsmPrimitiveType.WAY, new HashMap());
        newIds.put(OsmPrimitiveType.RELATION, new HashMap());
        for (PrimitiveData data : pasteBuffer.getAll()) {
            if (data.isIncomplete() || !data.isVisible()) continue;
            PrimitiveData copy = data.makeCopy();
            boolean wasIncomplete = copy.isIncomplete();
            copy.clearOsmMetadata();
            copy.setIncomplete(wasIncomplete);
            newIds.get((Object)data.getType()).put(data.getUniqueId(), copy.getUniqueId());
            bufferCopy.add(copy);
            if (!pasteBuffer.getDirectlyAdded().contains(data)) continue;
            toSelect.add(copy);
        }
        return newIds;
    }

    private static void updateMembers(EnumMap<OsmPrimitiveType, Map<Long, Long>> newIds, PrimitiveData data) {
        ArrayList<RelationMemberData> newMembers = new ArrayList<RelationMemberData>();
        for (RelationMemberData member : ((RelationData)data).getMembers()) {
            OsmPrimitiveType memberType = member.getMemberType();
            Long newId = newIds.get((Object)memberType).get(member.getMemberId());
            if (newId == null) continue;
            newMembers.add(new RelationMemberData(member.getRole(), memberType, newId));
        }
        ((RelationData)data).setMembers((List<RelationMemberData>)newMembers);
    }

    private static void updateNodes(Map<Long, Long> newNodeIds, PrimitiveData data) {
        ArrayList<Long> newNodes = new ArrayList<Long>();
        for (Long oldNodeId : ((WayData)data).getNodeIds()) {
            Long newNodeId = newNodeIds.get(oldNodeId);
            if (newNodeId == null) continue;
            newNodes.add(newNodeId);
        }
        ((WayData)data).setNodeIds(newNodes);
    }

    private static boolean confirmDeleteIncomplete() {
        ExtendedDialog ed = new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr("Delete incomplete members?", new Object[0]), I18n.tr("Paste without incomplete members", new Object[0]), I18n.tr("Cancel", new Object[0]));
        ed.setButtonIcons("dialogs/relation/deletemembers", "cancel");
        ed.setContent(I18n.tr("The copied data contains incomplete objects.  When pasting the incomplete objects are removed.  Do you want to paste the data without the incomplete objects?", new Object[0]));
        ed.showDialog();
        return ed.getValue() == 1;
    }
}

