/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.coroutines.COROUTINE_SWITCH;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.BaseIrElementToJsNodeTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrElementToJsExpressionTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrElementToJsStatementTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsAstUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContext;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetVariable;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCase;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDefault;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsSwitchMember;
import org.jetbrains.kotlin.js.backend.ast.JsThrow;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0003H\u0016J\u0018\u0010\"\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020#2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010$\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020%2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010&\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020'2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00020*2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010+\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020,2\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010-\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010.\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020/2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/IrElementToJsStatementTransformer;", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/BaseIrElementToJsNodeTransformer;", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "()V", "toSwitch", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "context", "visitBlock", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "visitBlockBody", "body", "Lorg/jetbrains/kotlin/ir/expressions/IrBlockBody;", "visitBreak", "jump", "Lorg/jetbrains/kotlin/ir/expressions/IrBreak;", "visitComposite", "Lorg/jetbrains/kotlin/ir/expressions/IrComposite;", "visitContinue", "Lorg/jetbrains/kotlin/ir/expressions/IrContinue;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "visitDoWhileLoop", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrDoWhileLoop;", "visitExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "visitFunction", "Lorg/jetbrains/kotlin/js/backend/ast/JsEmpty;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "data", "visitInstanceInitializerCall", "Lorg/jetbrains/kotlin/ir/expressions/IrInstanceInitializerCall;", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "visitThrow", "Lorg/jetbrains/kotlin/ir/expressions/IrThrow;", "visitTry", "aTry", "Lorg/jetbrains/kotlin/ir/expressions/IrTry;", "visitVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "visitWhen", "visitWhileLoop", "Lorg/jetbrains/kotlin/ir/expressions/IrWhileLoop;", "backend.js"})
public final class IrElementToJsStatementTransformer
implements BaseIrElementToJsNodeTransformer<JsStatement, JsGenerationContext> {
    @Override
    @NotNull
    public JsEmpty visitFunction(@NotNull IrFunction declaration, @NotNull JsGenerationContext data) {
        JsEmpty jsEmpty;
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(data, "data");
        JsEmpty it = jsEmpty = JsEmpty.INSTANCE;
        boolean bl = Intrinsics.areEqual(declaration.getOrigin(), JsIrBackendContext.Companion.getCallableClosureOrigin());
        if (_Assertions.ENABLED && !bl) {
            String string = "The only possible Function Declarartion is one composed in Callable Reference Lowering";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return jsEmpty;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsStatement visitBlockBody(@NotNull IrBlockBody body, @NotNull JsGenerationContext context) {
        Collection<JsStatement> collection;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(body, "body");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Iterable iterable = $receiver$iv = (Iterable)body.getStatements();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            IrStatement irStatement = (IrStatement)item$iv$iv;
            collection = destination$iv$iv;
            JsStatement jsStatement = (JsStatement)it.accept(this, context);
            collection.add(jsStatement);
        }
        collection = (List)destination$iv$iv;
        List list2 = collection;
        return new JsBlock(list2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsBlock visitBlock(@NotNull IrBlock expression2, @NotNull JsGenerationContext context) {
        Collection<JsStatement> collection;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Iterable iterable = $receiver$iv = (Iterable)expression2.getStatements();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            IrStatement irStatement = (IrStatement)item$iv$iv;
            collection = destination$iv$iv;
            JsStatement jsStatement = (JsStatement)it.accept(this, context);
            collection.add(jsStatement);
        }
        collection = (List)destination$iv$iv;
        List list2 = collection;
        return new JsBlock(list2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsStatement visitComposite(@NotNull IrComposite expression2, @NotNull JsGenerationContext context) {
        Collection<JsStatement> collection;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Iterable iterable = $receiver$iv = (Iterable)expression2.getStatements();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            IrStatement irStatement = (IrStatement)item$iv$iv;
            collection = destination$iv$iv;
            JsStatement jsStatement = (JsStatement)it.accept(this, context);
            collection.add(jsStatement);
        }
        collection = (List)destination$iv$iv;
        List list2 = collection;
        return new JsBlock(list2);
    }

    @Override
    @NotNull
    public JsStatement visitExpression(@NotNull IrExpression expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        return new JsExpressionStatement((JsExpression)expression2.accept(new IrElementToJsExpressionTransformer(), context));
    }

    @Override
    @NotNull
    public JsStatement visitBreak(@NotNull IrBreak jump, @NotNull JsGenerationContext context) {
        Intrinsics.checkParameterIsNotNull(jump, "jump");
        Intrinsics.checkParameterIsNotNull(context, "context");
        JsName jsName = context.getNameForLoop(jump.getLoop());
        return new JsBreak(jsName != null ? jsName.makeRef() : null);
    }

    @Override
    @NotNull
    public JsStatement visitContinue(@NotNull IrContinue jump, @NotNull JsGenerationContext context) {
        Intrinsics.checkParameterIsNotNull(jump, "jump");
        Intrinsics.checkParameterIsNotNull(context, "context");
        JsName jsName = context.getNameForLoop(jump.getLoop());
        return new JsContinue(jsName != null ? jsName.makeRef() : null);
    }

    @Override
    @NotNull
    public JsStatement visitReturn(@NotNull IrReturn expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        return new JsReturn((JsExpression)expression2.getValue().accept(new IrElementToJsExpressionTransformer(), context));
    }

    @Override
    @NotNull
    public JsStatement visitThrow(@NotNull IrThrow expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        return new JsThrow((JsExpression)expression2.getValue().accept(new IrElementToJsExpressionTransformer(), context));
    }

    @Override
    @NotNull
    public JsStatement visitVariable(@NotNull IrVariable declaration, @NotNull JsGenerationContext context) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(context, "context");
        JsName varName = context.getNameForSymbol((IrSymbol)declaration.getSymbol());
        return JsAstUtilsKt.jsVar(varName, declaration.getInitializer(), context);
    }

    @Override
    @NotNull
    public JsStatement visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        if (IrTypePredicatesKt.isAny(IrUtilsKt.getConstructedClassType((IrConstructor)expression2.getSymbol().getOwner()))) {
            return JsEmpty.INSTANCE;
        }
        JsStatement jsStatement = ((JsExpression)expression2.accept(new IrElementToJsExpressionTransformer(), context)).makeStmt();
        Intrinsics.checkExpressionValueIsNotNull(jsStatement, "expression.accept(IrElem\u2026er(), context).makeStmt()");
        return jsStatement;
    }

    @Override
    @NotNull
    public JsStatement visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        return JsEmpty.INSTANCE;
    }

    @Override
    @NotNull
    public JsStatement visitTry(@NotNull IrTry aTry, @NotNull JsGenerationContext context) {
        JsCatch jsCatch;
        Intrinsics.checkParameterIsNotNull(aTry, "aTry");
        Intrinsics.checkParameterIsNotNull(context, "context");
        JsBlock jsTryBlock = JsAstUtilsKt.asBlock((JsStatement)aTry.getTryResult().accept(this, context));
        IrCatch irCatch = CollectionsKt.singleOrNull(aTry.getCatches());
        if (irCatch != null) {
            IrCatch irCatch2;
            IrCatch it = irCatch2 = irCatch;
            JsName name = context.getNameForSymbol((IrSymbol)it.getCatchParameter().getSymbol());
            JsStatement jsCatchBlock = (JsStatement)it.getResult().accept(this, context);
            jsCatch = new JsCatch(context.getCurrentScope(), name.getIdent(), jsCatchBlock);
        } else {
            jsCatch = null;
        }
        JsCatch jsCatch2 = jsCatch;
        Object object = aTry.getFinallyExpression();
        JsBlock jsFinallyBlock = object != null && (object = (JsStatement)object.accept(this, context)) != null ? JsAstUtilsKt.asBlock((JsStatement)object) : null;
        return new JsTry(jsTryBlock, jsCatch2, jsFinallyBlock);
    }

    @Override
    @NotNull
    public JsStatement visitWhen(@NotNull IrWhen expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        if (Intrinsics.areEqual(expression2.getOrigin(), COROUTINE_SWITCH.INSTANCE)) {
            return this.toSwitch(expression2, context);
        }
        JsStatement jsStatement = (JsStatement)JsAstUtilsKt.toJsNode(expression2, this, context, visitWhen.1.INSTANCE);
        if (jsStatement == null) {
            jsStatement = JsEmpty.INSTANCE;
        }
        return jsStatement;
    }

    /*
     * WARNING - void declaration
     */
    private final JsStatement toSwitch(IrWhen expression2, JsGenerationContext context) {
        Collection<JsCase> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        IrExpression id;
        Object call2;
        void $receiver$iv$iv2;
        Iterable $receiver$iv2;
        IrExpression expr = null;
        Iterable iterable = $receiver$iv2 = (Iterable)expression2.getBranches();
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            IrExpression irExpression;
            void it;
            IrBranch irBranch = (IrBranch)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            IrExpression body = it.getResult();
            if (it instanceof IrElseBranch) {
                irExpression = null;
            } else {
                IrExpression irExpression2 = it.getCondition();
                if (irExpression2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrCall");
                }
                call2 = (IrCall)irExpression2;
                if (call2.getValueArgument(0) == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                }
                irExpression = call2.getValueArgument(1);
            }
            id = irExpression;
            Pair<Object, IrExpression> pair = new Pair<Object, IrExpression>(id, body);
            collection2.add(pair);
        }
        List cases = (List)destination$iv$iv;
        IrElementToJsExpressionTransformer exprTransformer = new IrElementToJsExpressionTransformer();
        IrExpression irExpression = expr;
        if (irExpression == null) {
            Intrinsics.throwNpe();
        }
        JsExpression jsExpr = (JsExpression)irExpression.accept(exprTransformer, context);
        destination$iv$iv = cases;
        JsExpression jsExpression = jsExpr;
        Iterator iterator2 = $receiver$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            JsCase it;
            JsSwitchMember jsSwitchMember;
            JsSwitchMember jsSwitchMember2;
            void $id_body;
            call2 = (Pair)item$iv$iv;
            collection = destination$iv$iv2;
            id = (IrExpression)$id_body.component1();
            IrExpression body = (IrExpression)$id_body.component2();
            IrExpression irExpression3 = id;
            JsExpression jsId = irExpression3 != null ? (JsExpression)irExpression3.accept(exprTransformer, context) : null;
            JsBlock jsBody = JsAstUtilsKt.asBlock((JsStatement)body.accept(this, context));
            if (jsId == null) {
                jsSwitchMember2 = new JsDefault();
            } else {
                it = jsSwitchMember = new JsCase();
                it.setCaseExpression(jsId);
                jsSwitchMember2 = jsSwitchMember;
            }
            it = jsSwitchMember = jsSwitchMember2;
            Collection collection3 = it.getStatements();
            List<JsStatement> list2 = jsBody.getStatements();
            Intrinsics.checkExpressionValueIsNotNull(list2, "jsBody.statements");
            Iterable iterable2 = list2;
            CollectionsKt.addAll(collection3, iterable2);
            JsSwitchMember jsSwitchMember3 = jsSwitchMember;
            collection.add((JsCase)jsSwitchMember3);
        }
        collection = (List)destination$iv$iv2;
        List list3 = collection;
        JsExpression jsExpression2 = jsExpression;
        return new JsSwitch(jsExpression2, list3);
    }

    @Override
    @NotNull
    public JsStatement visitWhileLoop(@NotNull IrWhileLoop loop2, @NotNull JsGenerationContext context) {
        JsStatement jsStatement;
        Intrinsics.checkParameterIsNotNull(loop2, "loop");
        Intrinsics.checkParameterIsNotNull(context, "context");
        JsName label = context.getNameForLoop(loop2);
        IrExpression irExpression = loop2.getBody();
        JsWhile loopStatement = new JsWhile((JsExpression)loop2.getCondition().accept(new IrElementToJsExpressionTransformer(), context), irExpression != null ? (JsStatement)irExpression.accept(this, context) : null);
        JsName jsName = label;
        if (jsName != null) {
            JsName jsName2;
            JsName it = jsName2 = jsName;
            jsStatement = new JsLabel(it, loopStatement);
        } else {
            jsStatement = loopStatement;
        }
        return jsStatement;
    }

    @Override
    @NotNull
    public JsStatement visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @NotNull JsGenerationContext context) {
        JsStatement jsStatement;
        Intrinsics.checkParameterIsNotNull(loop2, "loop");
        Intrinsics.checkParameterIsNotNull(context, "context");
        JsName label = context.getNameForLoop(loop2);
        IrExpression irExpression = loop2.getBody();
        JsDoWhile loopStatement = new JsDoWhile((JsExpression)loop2.getCondition().accept(new IrElementToJsExpressionTransformer(), context), irExpression != null ? (JsStatement)irExpression.accept(this, context) : null);
        JsName jsName = label;
        if (jsName != null) {
            JsName jsName2;
            JsName it = jsName2 = jsName;
            jsStatement = new JsLabel(it, loopStatement);
        } else {
            jsStatement = loopStatement;
        }
        return jsStatement;
    }

    @Override
    @NotNull
    public JsStatement visitElement(@NotNull IrElement element, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(element, "element");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitElement(this, element, data);
    }

    @Override
    @NotNull
    public JsStatement visitTypeAlias(@NotNull IrTypeAlias declaration, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitTypeAlias(this, declaration, data);
    }

    @Override
    @NotNull
    public JsStatement visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitAnonymousInitializer(this, declaration, data);
    }

    @Override
    @NotNull
    public JsStatement visitBody(@NotNull IrBody body, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(body, "body");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitBody(this, body, data);
    }

    @Override
    @NotNull
    public JsStatement visitBranch(@NotNull IrBranch branch, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(branch, "branch");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitBranch(this, branch, data);
    }

    @Override
    @NotNull
    public JsStatement visitBreakContinue(@NotNull IrBreakContinue jump, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(jump, "jump");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitBreakContinue(this, jump, data);
    }

    @Override
    @NotNull
    public JsStatement visitCall(@NotNull IrCall expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitCall(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitCallableReference(@NotNull IrCallableReference expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitCallableReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitCatch(@NotNull IrCatch aCatch, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(aCatch, "aCatch");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitCatch(this, aCatch, data);
    }

    @Override
    @NotNull
    public JsStatement visitClass(@NotNull IrClass declaration, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitClass(this, declaration, data);
    }

    @Override
    @NotNull
    public JsStatement visitClassReference(@NotNull IrClassReference expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitClassReference(this, expression2, data);
    }

    @Override
    @NotNull
    public <T> JsStatement visitConst(@NotNull IrConst<T> expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitConst(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitConstructor(@NotNull IrConstructor declaration, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitConstructor(this, declaration, data);
    }

    @Override
    @NotNull
    public JsStatement visitContainerExpression(@NotNull IrContainerExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitContainerExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitDeclaration(@NotNull IrDeclaration declaration, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitDeclaration(this, declaration, data);
    }

    @Override
    @NotNull
    public JsStatement visitDeclarationReference(@NotNull IrDeclarationReference expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitDeclarationReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitElseBranch(@NotNull IrElseBranch branch, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(branch, "branch");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitElseBranch(this, branch, data);
    }

    @Override
    @NotNull
    public JsStatement visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitEnumEntry(@NotNull IrEnumEntry declaration, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitEnumEntry(this, declaration, data);
    }

    @Override
    @NotNull
    public JsStatement visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitErrorCallExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitErrorDeclaration(this, declaration, data);
    }

    @Override
    @NotNull
    public JsStatement visitErrorExpression(@NotNull IrErrorExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitErrorExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitExpressionBody(@NotNull IrExpressionBody body, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(body, "body");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitExpressionBody(this, body, data);
    }

    @Override
    @NotNull
    public JsStatement visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
    }

    @Override
    @NotNull
    public JsStatement visitField(@NotNull IrField declaration, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitField(this, declaration, data);
    }

    @Override
    @NotNull
    public JsStatement visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitFieldAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitFile(@NotNull IrFile declaration, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitFile(this, declaration, data);
    }

    @Override
    @NotNull
    public JsStatement visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitFunctionAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitFunctionReference(@NotNull IrFunctionReference expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitFunctionReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitGetClass(@NotNull IrGetClass expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitGetClass(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitGetEnumValue(@NotNull IrGetEnumValue expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitGetEnumValue(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitGetField(@NotNull IrGetField expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitGetField(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitGetObjectValue(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitGetValue(@NotNull IrGetValue expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitGetValue(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
    }

    @Override
    @NotNull
    public JsStatement visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitLoop(@NotNull IrLoop loop2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(loop2, "loop");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitLoop(this, loop2, data);
    }

    @Override
    @NotNull
    public JsStatement visitMemberAccess(@NotNull IrMemberAccessExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitMemberAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitModuleFragment(@NotNull IrModuleFragment declaration, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitModuleFragment(this, declaration, data);
    }

    @Override
    @NotNull
    public JsStatement visitPackageFragment(@NotNull IrPackageFragment declaration, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitPackageFragment(this, declaration, data);
    }

    @Override
    @NotNull
    public JsStatement visitProperty(@NotNull IrProperty declaration, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitProperty(this, declaration, data);
    }

    @Override
    @NotNull
    public JsStatement visitPropertyReference(@NotNull IrPropertyReference expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitPropertyReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitSetField(@NotNull IrSetField expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSetField(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitSetVariable(@NotNull IrSetVariable expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSetVariable(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSimpleFunction(this, declaration, data);
    }

    @Override
    @NotNull
    public JsStatement visitSingletonReference(@NotNull IrGetSingletonValue expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSingletonReference(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitSpreadElement(@NotNull IrSpreadElement spread, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(spread, "spread");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSpreadElement(this, spread, data);
    }

    @Override
    @NotNull
    public JsStatement visitStringConcatenation(@NotNull IrStringConcatenation expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitStringConcatenation(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSuspendableExpression(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSuspensionPoint(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitSyntheticBody(@NotNull IrSyntheticBody body, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(body, "body");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitSyntheticBody(this, body, data);
    }

    @Override
    @NotNull
    public JsStatement visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitTypeOperator(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitTypeParameter(@NotNull IrTypeParameter declaration, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitTypeParameter(this, declaration, data);
    }

    @Override
    @NotNull
    public JsStatement visitValueAccess(@NotNull IrValueAccessExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitValueAccess(this, expression2, data);
    }

    @Override
    @NotNull
    public JsStatement visitValueParameter(@NotNull IrValueParameter declaration, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitValueParameter(this, declaration, data);
    }

    @Override
    @NotNull
    public JsStatement visitVararg(@NotNull IrVararg expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return BaseIrElementToJsNodeTransformer.DefaultImpls.visitVararg(this, expression2, data);
    }
}

