"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var debug_1 = require("debug");
var featureManager_1 = require("../featureManager");
var eventLoopMetrics_1 = require("../metrics/eventLoopMetrics");
var network_1 = require("../metrics/network");
var httpMetrics_1 = require("../metrics/httpMetrics");
var v8_1 = require("../metrics/v8");
var runtime_1 = require("../metrics/runtime");
exports.defaultMetricConf = {
    eventLoop: true,
    network: false,
    http: true,
    runtime: true,
    v8: true
};
var MetricConfig = (function () {
    function MetricConfig() {
    }
    return MetricConfig;
}());
exports.MetricConfig = MetricConfig;
var AvailableMetric = (function () {
    function AvailableMetric() {
    }
    return AvailableMetric;
}());
var availableMetrics = [
    {
        name: 'eventloop',
        module: eventLoopMetrics_1.default,
        optionsPath: 'eventLoop'
    },
    {
        name: 'http',
        module: httpMetrics_1.default,
        optionsPath: 'http'
    },
    {
        name: 'network',
        module: network_1.default,
        optionsPath: 'network'
    },
    {
        name: 'v8',
        module: v8_1.default,
        optionsPath: 'v8'
    },
    {
        name: 'runtime',
        module: runtime_1.default,
        optionsPath: 'runtime'
    }
];
var MetricsFeature = (function () {
    function MetricsFeature() {
        this.logger = debug_1.default('axm:features:metrics');
    }
    MetricsFeature.prototype.init = function (options) {
        var e_1, _a;
        if (typeof options !== 'object')
            options = {};
        this.logger('init');
        try {
            for (var availableMetrics_1 = tslib_1.__values(availableMetrics), availableMetrics_1_1 = availableMetrics_1.next(); !availableMetrics_1_1.done; availableMetrics_1_1 = availableMetrics_1.next()) {
                var availableMetric = availableMetrics_1_1.value;
                var metric = new availableMetric.module();
                var config = undefined;
                if (typeof availableMetric.optionsPath !== 'string') {
                    config = {};
                }
                else if (availableMetric.optionsPath === '.') {
                    config = options;
                }
                else {
                    config = featureManager_1.getObjectAtPath(options, availableMetric.optionsPath);
                }
                metric.init(config);
                availableMetric.instance = metric;
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (availableMetrics_1_1 && !availableMetrics_1_1.done && (_a = availableMetrics_1.return)) _a.call(availableMetrics_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
    };
    MetricsFeature.prototype.get = function (name) {
        var metric = availableMetrics.find(function (metric) { return metric.name === name; });
        if (metric === undefined)
            return undefined;
        return metric.instance;
    };
    MetricsFeature.prototype.destroy = function () {
        var e_2, _a;
        this.logger('destroy');
        try {
            for (var availableMetrics_2 = tslib_1.__values(availableMetrics), availableMetrics_2_1 = availableMetrics_2.next(); !availableMetrics_2_1.done; availableMetrics_2_1 = availableMetrics_2.next()) {
                var availableMetric = availableMetrics_2_1.value;
                if (availableMetric.instance === undefined)
                    continue;
                availableMetric.instance.destroy();
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (availableMetrics_2_1 && !availableMetrics_2_1.done && (_a = availableMetrics_2.return)) _a.call(availableMetrics_2);
            }
            finally { if (e_2) throw e_2.error; }
        }
    };
    return MetricsFeature;
}());
exports.MetricsFeature = MetricsFeature;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWV0cmljcy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9mZWF0dXJlcy9tZXRyaWNzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLCtCQUF5QjtBQUN6QixvREFBNEQ7QUFDNUQsZ0VBQW1HO0FBQ25HLDhDQUF3RTtBQUN4RSxzREFBdUU7QUFDdkUsb0NBQXlEO0FBQ3pELDhDQUEwRTtBQUU3RCxRQUFBLGlCQUFpQixHQUFpQjtJQUM3QyxTQUFTLEVBQUUsSUFBSTtJQUNmLE9BQU8sRUFBRSxLQUFLO0lBQ2QsSUFBSSxFQUFFLElBQUk7SUFDVixPQUFPLEVBQUUsSUFBSTtJQUNiLEVBQUUsRUFBRSxJQUFJO0NBQ1QsQ0FBQTtBQUVEO0lBQUE7SUF1QkEsQ0FBQztJQUFELG1CQUFDO0FBQUQsQ0FBQyxBQXZCRCxJQXVCQztBQXZCWSxvQ0FBWTtBQXlCekI7SUFBQTtJQXFCQSxDQUFDO0lBQUQsc0JBQUM7QUFBRCxDQUFDLEFBckJELElBcUJDO0FBRUQsSUFBTSxnQkFBZ0IsR0FBc0I7SUFDMUM7UUFDRSxJQUFJLEVBQUUsV0FBVztRQUNqQixNQUFNLEVBQUUsMEJBQThCO1FBQ3RDLFdBQVcsRUFBRSxXQUFXO0tBQ3pCO0lBQ0Q7UUFDRSxJQUFJLEVBQUUsTUFBTTtRQUNaLE1BQU0sRUFBRSxxQkFBVztRQUNuQixXQUFXLEVBQUUsTUFBTTtLQUNwQjtJQUNEO1FBQ0UsSUFBSSxFQUFFLFNBQVM7UUFDZixNQUFNLEVBQUUsaUJBQWE7UUFDckIsV0FBVyxFQUFFLFNBQVM7S0FDdkI7SUFDRDtRQUNFLElBQUksRUFBRSxJQUFJO1FBQ1YsTUFBTSxFQUFFLFlBQVE7UUFDaEIsV0FBVyxFQUFFLElBQUk7S0FDbEI7SUFDRDtRQUNFLElBQUksRUFBRSxTQUFTO1FBQ2YsTUFBTSxFQUFFLGlCQUFjO1FBQ3RCLFdBQVcsRUFBRSxTQUFTO0tBQ3ZCO0NBQ0YsQ0FBQTtBQU9EO0lBQUE7UUFFVSxXQUFNLEdBQWEsZUFBSyxDQUFDLHNCQUFzQixDQUFDLENBQUE7SUFxQzFELENBQUM7SUFuQ0MsNkJBQUksR0FBSixVQUFNLE9BQWdCOztRQUNwQixJQUFJLE9BQU8sT0FBTyxLQUFLLFFBQVE7WUFBRSxPQUFPLEdBQUcsRUFBRSxDQUFBO1FBQzdDLElBQUksQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUFDLENBQUE7O1lBRW5CLEtBQTRCLElBQUEscUJBQUEsaUJBQUEsZ0JBQWdCLENBQUEsa0RBQUEsZ0ZBQUU7Z0JBQXpDLElBQUksZUFBZSw2QkFBQTtnQkFDdEIsSUFBTSxNQUFNLEdBQUcsSUFBSSxlQUFlLENBQUMsTUFBTSxFQUFFLENBQUE7Z0JBQzNDLElBQUksTUFBTSxHQUFRLFNBQVMsQ0FBQTtnQkFDM0IsSUFBSSxPQUFPLGVBQWUsQ0FBQyxXQUFXLEtBQUssUUFBUSxFQUFFO29CQUNuRCxNQUFNLEdBQUcsRUFBRSxDQUFBO2lCQUNaO3FCQUFNLElBQUksZUFBZSxDQUFDLFdBQVcsS0FBSyxHQUFHLEVBQUU7b0JBQzlDLE1BQU0sR0FBRyxPQUFPLENBQUE7aUJBQ2pCO3FCQUFNO29CQUNMLE1BQU0sR0FBRyxnQ0FBZSxDQUFDLE9BQU8sRUFBRSxlQUFlLENBQUMsV0FBVyxDQUFDLENBQUE7aUJBQy9EO2dCQUlELE1BQU0sQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUE7Z0JBQ25CLGVBQWUsQ0FBQyxRQUFRLEdBQUcsTUFBTSxDQUFBO2FBQ2xDOzs7Ozs7Ozs7SUFDSCxDQUFDO0lBRUQsNEJBQUcsR0FBSCxVQUFLLElBQVk7UUFDZixJQUFNLE1BQU0sR0FBRyxnQkFBZ0IsQ0FBQyxJQUFJLENBQUMsVUFBQSxNQUFNLElBQUksT0FBQSxNQUFNLENBQUMsSUFBSSxLQUFLLElBQUksRUFBcEIsQ0FBb0IsQ0FBQyxDQUFBO1FBQ3BFLElBQUksTUFBTSxLQUFLLFNBQVM7WUFBRSxPQUFPLFNBQVMsQ0FBQTtRQUMxQyxPQUFPLE1BQU0sQ0FBQyxRQUFRLENBQUE7SUFDeEIsQ0FBQztJQUVELGdDQUFPLEdBQVA7O1FBQ0UsSUFBSSxDQUFDLE1BQU0sQ0FBQyxTQUFTLENBQUMsQ0FBQTs7WUFDdEIsS0FBNEIsSUFBQSxxQkFBQSxpQkFBQSxnQkFBZ0IsQ0FBQSxrREFBQSxnRkFBRTtnQkFBekMsSUFBSSxlQUFlLDZCQUFBO2dCQUN0QixJQUFJLGVBQWUsQ0FBQyxRQUFRLEtBQUssU0FBUztvQkFBRSxTQUFRO2dCQUNwRCxlQUFlLENBQUMsUUFBUSxDQUFDLE9BQU8sRUFBRSxDQUFBO2FBQ25DOzs7Ozs7Ozs7SUFDSCxDQUFDO0lBQ0gscUJBQUM7QUFBRCxDQUFDLEFBdkNELElBdUNDO0FBdkNZLHdDQUFjIn0=