"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var fs = require("fs");
var Debug = require("debug");
var path = require("path");
var debug = Debug('axm:utils:module');
var ModuleUtils = (function () {
    function ModuleUtils() {
    }
    ModuleUtils.loadModule = function (modulePath, args) {
        var nodule;
        try {
            if (args) {
                nodule = require(modulePath).apply(this, args);
            }
            else {
                nodule = require(modulePath);
            }
            debug("Succesfully required module at path " + modulePath);
            return nodule;
        }
        catch (err) {
            debug("Failed to load module at path " + modulePath + ": " + err.message);
            return err;
        }
    };
    ModuleUtils.detectModule = function (moduleName) {
        var fakeNodule = { paths: ['./node_modules', '/node_modules'] };
        var nodule = typeof require.main === 'object' ? require.main : fakeNodule;
        var requirePaths = nodule.paths.slice();
        return ModuleUtils._lookForModule(requirePaths, moduleName);
    };
    ModuleUtils._lookForModule = function (requirePaths, moduleName) {
        var e_1, _a;
        var fsConstants = fs.constants || fs;
        try {
            for (var requirePaths_1 = tslib_1.__values(requirePaths), requirePaths_1_1 = requirePaths_1.next(); !requirePaths_1_1.done; requirePaths_1_1 = requirePaths_1.next()) {
                var requirePath = requirePaths_1_1.value;
                var completePath = path.join(requirePath, moduleName);
                debug("Looking for module " + moduleName + " in " + completePath);
                try {
                    fs.accessSync(completePath, fsConstants.R_OK);
                    debug("Found module " + moduleName + " in path " + completePath);
                    return completePath;
                }
                catch (err) {
                    debug("module " + moduleName + " not found in path " + completePath);
                    continue;
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (requirePaths_1_1 && !requirePaths_1_1.done && (_a = requirePaths_1.return)) _a.call(requirePaths_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return null;
    };
    return ModuleUtils;
}());
exports.default = ModuleUtils;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibW9kdWxlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL3V0aWxzL21vZHVsZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSx1QkFBd0I7QUFDeEIsNkJBQThCO0FBQzlCLDJCQUE0QjtBQUU1QixJQUFNLEtBQUssR0FBRyxLQUFLLENBQUMsa0JBQWtCLENBQUMsQ0FBQTtBQUV2QztJQUFBO0lBcURBLENBQUM7SUFqRFEsc0JBQVUsR0FBakIsVUFBbUIsVUFBa0IsRUFBRSxJQUFhO1FBQ2xELElBQUksTUFBTSxDQUFBO1FBQ1YsSUFBSTtZQUNGLElBQUksSUFBSSxFQUFFO2dCQUNSLE1BQU0sR0FBRyxPQUFPLENBQUMsVUFBVSxDQUFDLENBQUMsS0FBSyxDQUFDLElBQUksRUFBRSxJQUFJLENBQUMsQ0FBQTthQUMvQztpQkFBTTtnQkFDTCxNQUFNLEdBQUcsT0FBTyxDQUFDLFVBQVUsQ0FBQyxDQUFBO2FBQzdCO1lBQ0QsS0FBSyxDQUFDLHlDQUF1QyxVQUFZLENBQUMsQ0FBQTtZQUMxRCxPQUFPLE1BQU0sQ0FBQTtTQUNkO1FBQUMsT0FBTyxHQUFHLEVBQUU7WUFDWixLQUFLLENBQUMsbUNBQWlDLFVBQVUsVUFBSyxHQUFHLENBQUMsT0FBUyxDQUFDLENBQUE7WUFDcEUsT0FBTyxHQUFHLENBQUE7U0FDWDtJQUNILENBQUM7SUFLTSx3QkFBWSxHQUFuQixVQUFxQixVQUFrQjtRQUNyQyxJQUFNLFVBQVUsR0FBRyxFQUFFLEtBQUssRUFBRSxDQUFDLGdCQUFnQixFQUFFLGVBQWUsQ0FBQyxFQUFFLENBQUE7UUFDakUsSUFBTSxNQUFNLEdBQUcsT0FBTyxPQUFPLENBQUMsSUFBSSxLQUFLLFFBQVEsQ0FBQyxDQUFDLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFBO1FBRTNFLElBQU0sWUFBWSxHQUFHLE1BQU0sQ0FBQyxLQUFLLENBQUMsS0FBSyxFQUFFLENBQUE7UUFFekMsT0FBTyxXQUFXLENBQUMsY0FBYyxDQUFDLFlBQVksRUFBRSxVQUFVLENBQUMsQ0FBQTtJQUM3RCxDQUFDO0lBS2MsMEJBQWMsR0FBN0IsVUFBK0IsWUFBMkIsRUFBRSxVQUFrQjs7UUFFNUUsSUFBTSxXQUFXLEdBQUcsRUFBRSxDQUFDLFNBQVMsSUFBSSxFQUFFLENBQUE7O1lBRXRDLEtBQXdCLElBQUEsaUJBQUEsaUJBQUEsWUFBWSxDQUFBLDBDQUFBLG9FQUFFO2dCQUFqQyxJQUFJLFdBQVcseUJBQUE7Z0JBQ2xCLElBQU0sWUFBWSxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsV0FBVyxFQUFFLFVBQVUsQ0FBQyxDQUFBO2dCQUN2RCxLQUFLLENBQUMsd0JBQXNCLFVBQVUsWUFBTyxZQUFjLENBQUMsQ0FBQTtnQkFDNUQsSUFBSTtvQkFDRixFQUFFLENBQUMsVUFBVSxDQUFDLFlBQVksRUFBRSxXQUFXLENBQUMsSUFBSSxDQUFDLENBQUE7b0JBQzdDLEtBQUssQ0FBQyxrQkFBZ0IsVUFBVSxpQkFBWSxZQUFjLENBQUMsQ0FBQTtvQkFDM0QsT0FBTyxZQUFZLENBQUE7aUJBQ3BCO2dCQUFDLE9BQU8sR0FBRyxFQUFFO29CQUNaLEtBQUssQ0FBQyxZQUFVLFVBQVUsMkJBQXNCLFlBQWMsQ0FBQyxDQUFBO29CQUMvRCxTQUFRO2lCQUNUO2FBQ0Y7Ozs7Ozs7OztRQUNELE9BQU8sSUFBSSxDQUFBO0lBQ2IsQ0FBQztJQUNILGtCQUFDO0FBQUQsQ0FBQyxBQXJERCxJQXFEQyJ9