# -*- coding: utf-8 -*-
# Auto-generated by Stone, do not modify.
# @generated
# flake8: noqa
# pylint: skip-file
"""
This namespace contains endpoints and data types for managing docs and folders in Dropbox Paper.
"""

try:
    from . import stone_validators as bv
    from . import stone_base as bb
except (ImportError, SystemError, ValueError):
    # Catch errors raised when importing a relative module when not in a package.
    # This makes testing this file directly (outside of a package) easier.
    import stone_validators as bv
    import stone_base as bb

try:
    from . import (
        common,
        sharing,
    )
except (ImportError, SystemError, ValueError):
    import common
    import sharing

class AddMember(bb.Struct):
    """
    :ivar permission_level: Permission for the user.
    :ivar member: User which should be added to the Paper doc. Specify only
        email address or Dropbox account ID.
    """

    __slots__ = [
        '_permission_level_value',
        '_permission_level_present',
        '_member_value',
        '_member_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 member=None,
                 permission_level=None):
        self._permission_level_value = None
        self._permission_level_present = False
        self._member_value = None
        self._member_present = False
        if permission_level is not None:
            self.permission_level = permission_level
        if member is not None:
            self.member = member

    @property
    def permission_level(self):
        """
        Permission for the user.

        :rtype: PaperDocPermissionLevel
        """
        if self._permission_level_present:
            return self._permission_level_value
        else:
            return PaperDocPermissionLevel.edit

    @permission_level.setter
    def permission_level(self, val):
        self._permission_level_validator.validate_type_only(val)
        self._permission_level_value = val
        self._permission_level_present = True

    @permission_level.deleter
    def permission_level(self):
        self._permission_level_value = None
        self._permission_level_present = False

    @property
    def member(self):
        """
        User which should be added to the Paper doc. Specify only email address
        or Dropbox account ID.

        :rtype: sharing.MemberSelector
        """
        if self._member_present:
            return self._member_value
        else:
            raise AttributeError("missing required field 'member'")

    @member.setter
    def member(self, val):
        self._member_validator.validate_type_only(val)
        self._member_value = val
        self._member_present = True

    @member.deleter
    def member(self):
        self._member_value = None
        self._member_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(AddMember, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'AddMember(member={!r}, permission_level={!r})'.format(
            self._member_value,
            self._permission_level_value,
        )

AddMember_validator = bv.Struct(AddMember)

class RefPaperDoc(bb.Struct):
    """
    :ivar doc_id: The Paper doc ID.
    """

    __slots__ = [
        '_doc_id_value',
        '_doc_id_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 doc_id=None):
        self._doc_id_value = None
        self._doc_id_present = False
        if doc_id is not None:
            self.doc_id = doc_id

    @property
    def doc_id(self):
        """
        The Paper doc ID.

        :rtype: str
        """
        if self._doc_id_present:
            return self._doc_id_value
        else:
            raise AttributeError("missing required field 'doc_id'")

    @doc_id.setter
    def doc_id(self, val):
        val = self._doc_id_validator.validate(val)
        self._doc_id_value = val
        self._doc_id_present = True

    @doc_id.deleter
    def doc_id(self):
        self._doc_id_value = None
        self._doc_id_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(RefPaperDoc, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'RefPaperDoc(doc_id={!r})'.format(
            self._doc_id_value,
        )

RefPaperDoc_validator = bv.Struct(RefPaperDoc)

class AddPaperDocUser(RefPaperDoc):
    """
    :ivar members: User which should be added to the Paper doc. Specify only
        email address or Dropbox account ID.
    :ivar custom_message: A personal message that will be emailed to each
        successfully added member.
    :ivar quiet: Clients should set this to true if no email message shall be
        sent to added users.
    """

    __slots__ = [
        '_members_value',
        '_members_present',
        '_custom_message_value',
        '_custom_message_present',
        '_quiet_value',
        '_quiet_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 doc_id=None,
                 members=None,
                 custom_message=None,
                 quiet=None):
        super(AddPaperDocUser, self).__init__(doc_id)
        self._members_value = None
        self._members_present = False
        self._custom_message_value = None
        self._custom_message_present = False
        self._quiet_value = None
        self._quiet_present = False
        if members is not None:
            self.members = members
        if custom_message is not None:
            self.custom_message = custom_message
        if quiet is not None:
            self.quiet = quiet

    @property
    def members(self):
        """
        User which should be added to the Paper doc. Specify only email address
        or Dropbox account ID.

        :rtype: list of [AddMember]
        """
        if self._members_present:
            return self._members_value
        else:
            raise AttributeError("missing required field 'members'")

    @members.setter
    def members(self, val):
        val = self._members_validator.validate(val)
        self._members_value = val
        self._members_present = True

    @members.deleter
    def members(self):
        self._members_value = None
        self._members_present = False

    @property
    def custom_message(self):
        """
        A personal message that will be emailed to each successfully added
        member.

        :rtype: str
        """
        if self._custom_message_present:
            return self._custom_message_value
        else:
            return None

    @custom_message.setter
    def custom_message(self, val):
        if val is None:
            del self.custom_message
            return
        val = self._custom_message_validator.validate(val)
        self._custom_message_value = val
        self._custom_message_present = True

    @custom_message.deleter
    def custom_message(self):
        self._custom_message_value = None
        self._custom_message_present = False

    @property
    def quiet(self):
        """
        Clients should set this to true if no email message shall be sent to
        added users.

        :rtype: bool
        """
        if self._quiet_present:
            return self._quiet_value
        else:
            return False

    @quiet.setter
    def quiet(self, val):
        val = self._quiet_validator.validate(val)
        self._quiet_value = val
        self._quiet_present = True

    @quiet.deleter
    def quiet(self):
        self._quiet_value = None
        self._quiet_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(AddPaperDocUser, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'AddPaperDocUser(doc_id={!r}, members={!r}, custom_message={!r}, quiet={!r})'.format(
            self._doc_id_value,
            self._members_value,
            self._custom_message_value,
            self._quiet_value,
        )

AddPaperDocUser_validator = bv.Struct(AddPaperDocUser)

class AddPaperDocUserMemberResult(bb.Struct):
    """
    Per-member result for :meth:`dropbox.dropbox.Dropbox.paper_docs_users_add`.

    :ivar member: One of specified input members.
    :ivar result: The outcome of the action on this member.
    """

    __slots__ = [
        '_member_value',
        '_member_present',
        '_result_value',
        '_result_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 member=None,
                 result=None):
        self._member_value = None
        self._member_present = False
        self._result_value = None
        self._result_present = False
        if member is not None:
            self.member = member
        if result is not None:
            self.result = result

    @property
    def member(self):
        """
        One of specified input members.

        :rtype: sharing.MemberSelector
        """
        if self._member_present:
            return self._member_value
        else:
            raise AttributeError("missing required field 'member'")

    @member.setter
    def member(self, val):
        self._member_validator.validate_type_only(val)
        self._member_value = val
        self._member_present = True

    @member.deleter
    def member(self):
        self._member_value = None
        self._member_present = False

    @property
    def result(self):
        """
        The outcome of the action on this member.

        :rtype: AddPaperDocUserResult
        """
        if self._result_present:
            return self._result_value
        else:
            raise AttributeError("missing required field 'result'")

    @result.setter
    def result(self, val):
        self._result_validator.validate_type_only(val)
        self._result_value = val
        self._result_present = True

    @result.deleter
    def result(self):
        self._result_value = None
        self._result_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(AddPaperDocUserMemberResult, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'AddPaperDocUserMemberResult(member={!r}, result={!r})'.format(
            self._member_value,
            self._result_value,
        )

AddPaperDocUserMemberResult_validator = bv.Struct(AddPaperDocUserMemberResult)

class AddPaperDocUserResult(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar success: User was successfully added to the Paper doc.
    :ivar unknown_error: Something unexpected happened when trying to add the
        user to the Paper doc.
    :ivar sharing_outside_team_disabled: The Paper doc can be shared only with
        team members.
    :ivar daily_limit_reached: The daily limit of how many users can be added to
        the Paper doc was reached.
    :ivar user_is_owner: Owner's permissions cannot be changed.
    :ivar failed_user_data_retrieval: User data could not be retrieved. Clients
        should retry.
    :ivar permission_already_granted: This user already has the correct
        permission to the Paper doc.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    success = None
    # Attribute is overwritten below the class definition
    unknown_error = None
    # Attribute is overwritten below the class definition
    sharing_outside_team_disabled = None
    # Attribute is overwritten below the class definition
    daily_limit_reached = None
    # Attribute is overwritten below the class definition
    user_is_owner = None
    # Attribute is overwritten below the class definition
    failed_user_data_retrieval = None
    # Attribute is overwritten below the class definition
    permission_already_granted = None
    # Attribute is overwritten below the class definition
    other = None

    def is_success(self):
        """
        Check if the union tag is ``success``.

        :rtype: bool
        """
        return self._tag == 'success'

    def is_unknown_error(self):
        """
        Check if the union tag is ``unknown_error``.

        :rtype: bool
        """
        return self._tag == 'unknown_error'

    def is_sharing_outside_team_disabled(self):
        """
        Check if the union tag is ``sharing_outside_team_disabled``.

        :rtype: bool
        """
        return self._tag == 'sharing_outside_team_disabled'

    def is_daily_limit_reached(self):
        """
        Check if the union tag is ``daily_limit_reached``.

        :rtype: bool
        """
        return self._tag == 'daily_limit_reached'

    def is_user_is_owner(self):
        """
        Check if the union tag is ``user_is_owner``.

        :rtype: bool
        """
        return self._tag == 'user_is_owner'

    def is_failed_user_data_retrieval(self):
        """
        Check if the union tag is ``failed_user_data_retrieval``.

        :rtype: bool
        """
        return self._tag == 'failed_user_data_retrieval'

    def is_permission_already_granted(self):
        """
        Check if the union tag is ``permission_already_granted``.

        :rtype: bool
        """
        return self._tag == 'permission_already_granted'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, processor):
        super(AddPaperDocUserResult, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'AddPaperDocUserResult(%r, %r)' % (self._tag, self._value)

AddPaperDocUserResult_validator = bv.Union(AddPaperDocUserResult)

class Cursor(bb.Struct):
    """
    :ivar value: The actual cursor value.
    :ivar expiration: Expiration time of ``value``. Some cursors might have
        expiration time assigned. This is a UTC value after which the cursor is
        no longer valid and the API starts returning an error. If cursor expires
        a new one needs to be obtained and pagination needs to be restarted.
        Some cursors might be short-lived some cursors might be long-lived. This
        really depends on the sorting type and order, e.g.: 1. on one hand,
        listing docs created by the user, sorted by the created time ascending
        will have undefinite expiration because the results cannot change while
        the iteration is happening. This cursor would be suitable for long term
        polling. 2. on the other hand, listing docs sorted by the last modified
        time will have a very short expiration as docs do get modified very
        often and the modified time can be changed while the iteration is
        happening thus altering the results.
    """

    __slots__ = [
        '_value_value',
        '_value_present',
        '_expiration_value',
        '_expiration_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 value=None,
                 expiration=None):
        self._value_value = None
        self._value_present = False
        self._expiration_value = None
        self._expiration_present = False
        if value is not None:
            self.value = value
        if expiration is not None:
            self.expiration = expiration

    @property
    def value(self):
        """
        The actual cursor value.

        :rtype: str
        """
        if self._value_present:
            return self._value_value
        else:
            raise AttributeError("missing required field 'value'")

    @value.setter
    def value(self, val):
        val = self._value_validator.validate(val)
        self._value_value = val
        self._value_present = True

    @value.deleter
    def value(self):
        self._value_value = None
        self._value_present = False

    @property
    def expiration(self):
        """
        Expiration time of ``value``. Some cursors might have expiration time
        assigned. This is a UTC value after which the cursor is no longer valid
        and the API starts returning an error. If cursor expires a new one needs
        to be obtained and pagination needs to be restarted. Some cursors might
        be short-lived some cursors might be long-lived. This really depends on
        the sorting type and order, e.g.: 1. on one hand, listing docs created
        by the user, sorted by the created time ascending will have undefinite
        expiration because the results cannot change while the iteration is
        happening. This cursor would be suitable for long term polling. 2. on
        the other hand, listing docs sorted by the last modified time will have
        a very short expiration as docs do get modified very often and the
        modified time can be changed while the iteration is happening thus
        altering the results.

        :rtype: datetime.datetime
        """
        if self._expiration_present:
            return self._expiration_value
        else:
            return None

    @expiration.setter
    def expiration(self, val):
        if val is None:
            del self.expiration
            return
        val = self._expiration_validator.validate(val)
        self._expiration_value = val
        self._expiration_present = True

    @expiration.deleter
    def expiration(self):
        self._expiration_value = None
        self._expiration_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(Cursor, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'Cursor(value={!r}, expiration={!r})'.format(
            self._value_value,
            self._expiration_value,
        )

Cursor_validator = bv.Struct(Cursor)

class PaperApiBaseError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar insufficient_permissions: Your account does not have permissions to
        perform this action.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    insufficient_permissions = None
    # Attribute is overwritten below the class definition
    other = None

    def is_insufficient_permissions(self):
        """
        Check if the union tag is ``insufficient_permissions``.

        :rtype: bool
        """
        return self._tag == 'insufficient_permissions'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, processor):
        super(PaperApiBaseError, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'PaperApiBaseError(%r, %r)' % (self._tag, self._value)

PaperApiBaseError_validator = bv.Union(PaperApiBaseError)

class DocLookupError(PaperApiBaseError):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar doc_not_found: The required doc was not found.
    """

    # Attribute is overwritten below the class definition
    doc_not_found = None

    def is_doc_not_found(self):
        """
        Check if the union tag is ``doc_not_found``.

        :rtype: bool
        """
        return self._tag == 'doc_not_found'

    def _process_custom_annotations(self, annotation_type, processor):
        super(DocLookupError, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DocLookupError(%r, %r)' % (self._tag, self._value)

DocLookupError_validator = bv.Union(DocLookupError)

class DocSubscriptionLevel(bb.Union):
    """
    The subscription level of a Paper doc.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar default: No change email messages unless you're the creator.
    :ivar ignore: Ignored: Not shown in pad lists or activity and no email
        message is sent.
    :ivar every: Subscribed: Shown in pad lists and activity and change email
        messages are sent.
    :ivar no_email: Unsubscribed: Shown in pad lists, but not in activity and no
        change email messages are sent.
    """

    _catch_all = None
    # Attribute is overwritten below the class definition
    default = None
    # Attribute is overwritten below the class definition
    ignore = None
    # Attribute is overwritten below the class definition
    every = None
    # Attribute is overwritten below the class definition
    no_email = None

    def is_default(self):
        """
        Check if the union tag is ``default``.

        :rtype: bool
        """
        return self._tag == 'default'

    def is_ignore(self):
        """
        Check if the union tag is ``ignore``.

        :rtype: bool
        """
        return self._tag == 'ignore'

    def is_every(self):
        """
        Check if the union tag is ``every``.

        :rtype: bool
        """
        return self._tag == 'every'

    def is_no_email(self):
        """
        Check if the union tag is ``no_email``.

        :rtype: bool
        """
        return self._tag == 'no_email'

    def _process_custom_annotations(self, annotation_type, processor):
        super(DocSubscriptionLevel, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'DocSubscriptionLevel(%r, %r)' % (self._tag, self._value)

DocSubscriptionLevel_validator = bv.Union(DocSubscriptionLevel)

class ExportFormat(bb.Union):
    """
    The desired export format of the Paper doc.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar html: The HTML export format.
    :ivar markdown: The markdown export format.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    html = None
    # Attribute is overwritten below the class definition
    markdown = None
    # Attribute is overwritten below the class definition
    other = None

    def is_html(self):
        """
        Check if the union tag is ``html``.

        :rtype: bool
        """
        return self._tag == 'html'

    def is_markdown(self):
        """
        Check if the union tag is ``markdown``.

        :rtype: bool
        """
        return self._tag == 'markdown'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, processor):
        super(ExportFormat, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'ExportFormat(%r, %r)' % (self._tag, self._value)

ExportFormat_validator = bv.Union(ExportFormat)

class Folder(bb.Struct):
    """
    Data structure representing a Paper folder.

    :ivar id: Paper folder ID. This ID uniquely identifies the folder.
    :ivar name: Paper folder name.
    """

    __slots__ = [
        '_id_value',
        '_id_present',
        '_name_value',
        '_name_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 id=None,
                 name=None):
        self._id_value = None
        self._id_present = False
        self._name_value = None
        self._name_present = False
        if id is not None:
            self.id = id
        if name is not None:
            self.name = name

    @property
    def id(self):
        """
        Paper folder ID. This ID uniquely identifies the folder.

        :rtype: str
        """
        if self._id_present:
            return self._id_value
        else:
            raise AttributeError("missing required field 'id'")

    @id.setter
    def id(self, val):
        val = self._id_validator.validate(val)
        self._id_value = val
        self._id_present = True

    @id.deleter
    def id(self):
        self._id_value = None
        self._id_present = False

    @property
    def name(self):
        """
        Paper folder name.

        :rtype: str
        """
        if self._name_present:
            return self._name_value
        else:
            raise AttributeError("missing required field 'name'")

    @name.setter
    def name(self, val):
        val = self._name_validator.validate(val)
        self._name_value = val
        self._name_present = True

    @name.deleter
    def name(self):
        self._name_value = None
        self._name_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(Folder, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'Folder(id={!r}, name={!r})'.format(
            self._id_value,
            self._name_value,
        )

Folder_validator = bv.Struct(Folder)

class FolderSharingPolicyType(bb.Union):
    """
    The sharing policy of a Paper folder.  Note: The sharing policy of
    subfolders is inherited from the root folder.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar team: Everyone in your team and anyone directly invited can access
        this folder.
    :ivar invite_only: Only people directly invited can access this folder.
    """

    _catch_all = None
    # Attribute is overwritten below the class definition
    team = None
    # Attribute is overwritten below the class definition
    invite_only = None

    def is_team(self):
        """
        Check if the union tag is ``team``.

        :rtype: bool
        """
        return self._tag == 'team'

    def is_invite_only(self):
        """
        Check if the union tag is ``invite_only``.

        :rtype: bool
        """
        return self._tag == 'invite_only'

    def _process_custom_annotations(self, annotation_type, processor):
        super(FolderSharingPolicyType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FolderSharingPolicyType(%r, %r)' % (self._tag, self._value)

FolderSharingPolicyType_validator = bv.Union(FolderSharingPolicyType)

class FolderSubscriptionLevel(bb.Union):
    """
    The subscription level of a Paper folder.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar none: Not shown in activity, no email messages.
    :ivar activity_only: Shown in activity, no email messages.
    :ivar daily_emails: Shown in activity, daily email messages.
    :ivar weekly_emails: Shown in activity, weekly email messages.
    """

    _catch_all = None
    # Attribute is overwritten below the class definition
    none = None
    # Attribute is overwritten below the class definition
    activity_only = None
    # Attribute is overwritten below the class definition
    daily_emails = None
    # Attribute is overwritten below the class definition
    weekly_emails = None

    def is_none(self):
        """
        Check if the union tag is ``none``.

        :rtype: bool
        """
        return self._tag == 'none'

    def is_activity_only(self):
        """
        Check if the union tag is ``activity_only``.

        :rtype: bool
        """
        return self._tag == 'activity_only'

    def is_daily_emails(self):
        """
        Check if the union tag is ``daily_emails``.

        :rtype: bool
        """
        return self._tag == 'daily_emails'

    def is_weekly_emails(self):
        """
        Check if the union tag is ``weekly_emails``.

        :rtype: bool
        """
        return self._tag == 'weekly_emails'

    def _process_custom_annotations(self, annotation_type, processor):
        super(FolderSubscriptionLevel, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FolderSubscriptionLevel(%r, %r)' % (self._tag, self._value)

FolderSubscriptionLevel_validator = bv.Union(FolderSubscriptionLevel)

class FoldersContainingPaperDoc(bb.Struct):
    """
    Metadata about Paper folders containing the specififed Paper doc.

    :ivar folder_sharing_policy_type: The sharing policy of the folder
        containing the Paper doc.
    :ivar folders: The folder path. If present the first folder is the root
        folder.
    """

    __slots__ = [
        '_folder_sharing_policy_type_value',
        '_folder_sharing_policy_type_present',
        '_folders_value',
        '_folders_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 folder_sharing_policy_type=None,
                 folders=None):
        self._folder_sharing_policy_type_value = None
        self._folder_sharing_policy_type_present = False
        self._folders_value = None
        self._folders_present = False
        if folder_sharing_policy_type is not None:
            self.folder_sharing_policy_type = folder_sharing_policy_type
        if folders is not None:
            self.folders = folders

    @property
    def folder_sharing_policy_type(self):
        """
        The sharing policy of the folder containing the Paper doc.

        :rtype: FolderSharingPolicyType
        """
        if self._folder_sharing_policy_type_present:
            return self._folder_sharing_policy_type_value
        else:
            return None

    @folder_sharing_policy_type.setter
    def folder_sharing_policy_type(self, val):
        if val is None:
            del self.folder_sharing_policy_type
            return
        self._folder_sharing_policy_type_validator.validate_type_only(val)
        self._folder_sharing_policy_type_value = val
        self._folder_sharing_policy_type_present = True

    @folder_sharing_policy_type.deleter
    def folder_sharing_policy_type(self):
        self._folder_sharing_policy_type_value = None
        self._folder_sharing_policy_type_present = False

    @property
    def folders(self):
        """
        The folder path. If present the first folder is the root folder.

        :rtype: list of [Folder]
        """
        if self._folders_present:
            return self._folders_value
        else:
            return None

    @folders.setter
    def folders(self, val):
        if val is None:
            del self.folders
            return
        val = self._folders_validator.validate(val)
        self._folders_value = val
        self._folders_present = True

    @folders.deleter
    def folders(self):
        self._folders_value = None
        self._folders_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(FoldersContainingPaperDoc, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'FoldersContainingPaperDoc(folder_sharing_policy_type={!r}, folders={!r})'.format(
            self._folder_sharing_policy_type_value,
            self._folders_value,
        )

FoldersContainingPaperDoc_validator = bv.Struct(FoldersContainingPaperDoc)

class ImportFormat(bb.Union):
    """
    The import format of the incoming data.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar html: The provided data is interpreted as standard HTML.
    :ivar markdown: The provided data is interpreted as markdown. Note: The
        first line of the provided document will be used as the doc title.
    :ivar plain_text: The provided data is interpreted as plain text. Note: The
        first line of the provided document will be used as the doc title.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    html = None
    # Attribute is overwritten below the class definition
    markdown = None
    # Attribute is overwritten below the class definition
    plain_text = None
    # Attribute is overwritten below the class definition
    other = None

    def is_html(self):
        """
        Check if the union tag is ``html``.

        :rtype: bool
        """
        return self._tag == 'html'

    def is_markdown(self):
        """
        Check if the union tag is ``markdown``.

        :rtype: bool
        """
        return self._tag == 'markdown'

    def is_plain_text(self):
        """
        Check if the union tag is ``plain_text``.

        :rtype: bool
        """
        return self._tag == 'plain_text'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, processor):
        super(ImportFormat, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'ImportFormat(%r, %r)' % (self._tag, self._value)

ImportFormat_validator = bv.Union(ImportFormat)

class InviteeInfoWithPermissionLevel(bb.Struct):
    """
    :ivar invitee: Email address invited to the Paper doc.
    :ivar permission_level: Permission level for the invitee.
    """

    __slots__ = [
        '_invitee_value',
        '_invitee_present',
        '_permission_level_value',
        '_permission_level_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 invitee=None,
                 permission_level=None):
        self._invitee_value = None
        self._invitee_present = False
        self._permission_level_value = None
        self._permission_level_present = False
        if invitee is not None:
            self.invitee = invitee
        if permission_level is not None:
            self.permission_level = permission_level

    @property
    def invitee(self):
        """
        Email address invited to the Paper doc.

        :rtype: sharing.InviteeInfo
        """
        if self._invitee_present:
            return self._invitee_value
        else:
            raise AttributeError("missing required field 'invitee'")

    @invitee.setter
    def invitee(self, val):
        self._invitee_validator.validate_type_only(val)
        self._invitee_value = val
        self._invitee_present = True

    @invitee.deleter
    def invitee(self):
        self._invitee_value = None
        self._invitee_present = False

    @property
    def permission_level(self):
        """
        Permission level for the invitee.

        :rtype: PaperDocPermissionLevel
        """
        if self._permission_level_present:
            return self._permission_level_value
        else:
            raise AttributeError("missing required field 'permission_level'")

    @permission_level.setter
    def permission_level(self, val):
        self._permission_level_validator.validate_type_only(val)
        self._permission_level_value = val
        self._permission_level_present = True

    @permission_level.deleter
    def permission_level(self):
        self._permission_level_value = None
        self._permission_level_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(InviteeInfoWithPermissionLevel, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'InviteeInfoWithPermissionLevel(invitee={!r}, permission_level={!r})'.format(
            self._invitee_value,
            self._permission_level_value,
        )

InviteeInfoWithPermissionLevel_validator = bv.Struct(InviteeInfoWithPermissionLevel)

class ListDocsCursorError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    other = None

    @classmethod
    def cursor_error(cls, val):
        """
        Create an instance of this class set to the ``cursor_error`` tag with
        value ``val``.

        :param PaperApiCursorError val:
        :rtype: ListDocsCursorError
        """
        return cls('cursor_error', val)

    def is_cursor_error(self):
        """
        Check if the union tag is ``cursor_error``.

        :rtype: bool
        """
        return self._tag == 'cursor_error'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def get_cursor_error(self):
        """
        Only call this if :meth:`is_cursor_error` is true.

        :rtype: PaperApiCursorError
        """
        if not self.is_cursor_error():
            raise AttributeError("tag 'cursor_error' not set")
        return self._value

    def _process_custom_annotations(self, annotation_type, processor):
        super(ListDocsCursorError, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'ListDocsCursorError(%r, %r)' % (self._tag, self._value)

ListDocsCursorError_validator = bv.Union(ListDocsCursorError)

class ListPaperDocsArgs(bb.Struct):
    """
    :ivar filter_by: Allows user to specify how the Paper docs should be
        filtered.
    :ivar sort_by: Allows user to specify how the Paper docs should be sorted.
    :ivar sort_order: Allows user to specify the sort order of the result.
    :ivar limit: Size limit per batch. The maximum number of docs that can be
        retrieved per batch is 1000. Higher value results in invalid arguments
        error.
    """

    __slots__ = [
        '_filter_by_value',
        '_filter_by_present',
        '_sort_by_value',
        '_sort_by_present',
        '_sort_order_value',
        '_sort_order_present',
        '_limit_value',
        '_limit_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 filter_by=None,
                 sort_by=None,
                 sort_order=None,
                 limit=None):
        self._filter_by_value = None
        self._filter_by_present = False
        self._sort_by_value = None
        self._sort_by_present = False
        self._sort_order_value = None
        self._sort_order_present = False
        self._limit_value = None
        self._limit_present = False
        if filter_by is not None:
            self.filter_by = filter_by
        if sort_by is not None:
            self.sort_by = sort_by
        if sort_order is not None:
            self.sort_order = sort_order
        if limit is not None:
            self.limit = limit

    @property
    def filter_by(self):
        """
        Allows user to specify how the Paper docs should be filtered.

        :rtype: ListPaperDocsFilterBy
        """
        if self._filter_by_present:
            return self._filter_by_value
        else:
            return ListPaperDocsFilterBy.docs_accessed

    @filter_by.setter
    def filter_by(self, val):
        self._filter_by_validator.validate_type_only(val)
        self._filter_by_value = val
        self._filter_by_present = True

    @filter_by.deleter
    def filter_by(self):
        self._filter_by_value = None
        self._filter_by_present = False

    @property
    def sort_by(self):
        """
        Allows user to specify how the Paper docs should be sorted.

        :rtype: ListPaperDocsSortBy
        """
        if self._sort_by_present:
            return self._sort_by_value
        else:
            return ListPaperDocsSortBy.accessed

    @sort_by.setter
    def sort_by(self, val):
        self._sort_by_validator.validate_type_only(val)
        self._sort_by_value = val
        self._sort_by_present = True

    @sort_by.deleter
    def sort_by(self):
        self._sort_by_value = None
        self._sort_by_present = False

    @property
    def sort_order(self):
        """
        Allows user to specify the sort order of the result.

        :rtype: ListPaperDocsSortOrder
        """
        if self._sort_order_present:
            return self._sort_order_value
        else:
            return ListPaperDocsSortOrder.ascending

    @sort_order.setter
    def sort_order(self, val):
        self._sort_order_validator.validate_type_only(val)
        self._sort_order_value = val
        self._sort_order_present = True

    @sort_order.deleter
    def sort_order(self):
        self._sort_order_value = None
        self._sort_order_present = False

    @property
    def limit(self):
        """
        Size limit per batch. The maximum number of docs that can be retrieved
        per batch is 1000. Higher value results in invalid arguments error.

        :rtype: long
        """
        if self._limit_present:
            return self._limit_value
        else:
            return 1000

    @limit.setter
    def limit(self, val):
        val = self._limit_validator.validate(val)
        self._limit_value = val
        self._limit_present = True

    @limit.deleter
    def limit(self):
        self._limit_value = None
        self._limit_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(ListPaperDocsArgs, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'ListPaperDocsArgs(filter_by={!r}, sort_by={!r}, sort_order={!r}, limit={!r})'.format(
            self._filter_by_value,
            self._sort_by_value,
            self._sort_order_value,
            self._limit_value,
        )

ListPaperDocsArgs_validator = bv.Struct(ListPaperDocsArgs)

class ListPaperDocsContinueArgs(bb.Struct):
    """
    :ivar cursor: The cursor obtained from
        :meth:`dropbox.dropbox.Dropbox.paper_docs_list` or
        :meth:`dropbox.dropbox.Dropbox.paper_docs_list_continue`. Allows for
        pagination.
    """

    __slots__ = [
        '_cursor_value',
        '_cursor_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 cursor=None):
        self._cursor_value = None
        self._cursor_present = False
        if cursor is not None:
            self.cursor = cursor

    @property
    def cursor(self):
        """
        The cursor obtained from :meth:`dropbox.dropbox.Dropbox.paper_docs_list`
        or :meth:`dropbox.dropbox.Dropbox.paper_docs_list_continue`. Allows for
        pagination.

        :rtype: str
        """
        if self._cursor_present:
            return self._cursor_value
        else:
            raise AttributeError("missing required field 'cursor'")

    @cursor.setter
    def cursor(self, val):
        val = self._cursor_validator.validate(val)
        self._cursor_value = val
        self._cursor_present = True

    @cursor.deleter
    def cursor(self):
        self._cursor_value = None
        self._cursor_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(ListPaperDocsContinueArgs, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'ListPaperDocsContinueArgs(cursor={!r})'.format(
            self._cursor_value,
        )

ListPaperDocsContinueArgs_validator = bv.Struct(ListPaperDocsContinueArgs)

class ListPaperDocsFilterBy(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar docs_accessed: Fetches all Paper doc IDs that the user has ever
        accessed.
    :ivar docs_created: Fetches only the Paper doc IDs that the user has
        created.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    docs_accessed = None
    # Attribute is overwritten below the class definition
    docs_created = None
    # Attribute is overwritten below the class definition
    other = None

    def is_docs_accessed(self):
        """
        Check if the union tag is ``docs_accessed``.

        :rtype: bool
        """
        return self._tag == 'docs_accessed'

    def is_docs_created(self):
        """
        Check if the union tag is ``docs_created``.

        :rtype: bool
        """
        return self._tag == 'docs_created'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, processor):
        super(ListPaperDocsFilterBy, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'ListPaperDocsFilterBy(%r, %r)' % (self._tag, self._value)

ListPaperDocsFilterBy_validator = bv.Union(ListPaperDocsFilterBy)

class ListPaperDocsResponse(bb.Struct):
    """
    :ivar doc_ids: The list of Paper doc IDs that can be used to access the
        given Paper docs or supplied to other API methods. The list is sorted in
        the order specified by the initial call to
        :meth:`dropbox.dropbox.Dropbox.paper_docs_list`.
    :ivar cursor: Pass the cursor into
        :meth:`dropbox.dropbox.Dropbox.paper_docs_list_continue` to paginate
        through all files. The cursor preserves all properties as specified in
        the original call to :meth:`dropbox.dropbox.Dropbox.paper_docs_list`.
    :ivar has_more: Will be set to True if a subsequent call with the provided
        cursor to :meth:`dropbox.dropbox.Dropbox.paper_docs_list_continue`
        returns immediately with some results. If set to False please allow some
        delay before making another call to
        :meth:`dropbox.dropbox.Dropbox.paper_docs_list_continue`.
    """

    __slots__ = [
        '_doc_ids_value',
        '_doc_ids_present',
        '_cursor_value',
        '_cursor_present',
        '_has_more_value',
        '_has_more_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 doc_ids=None,
                 cursor=None,
                 has_more=None):
        self._doc_ids_value = None
        self._doc_ids_present = False
        self._cursor_value = None
        self._cursor_present = False
        self._has_more_value = None
        self._has_more_present = False
        if doc_ids is not None:
            self.doc_ids = doc_ids
        if cursor is not None:
            self.cursor = cursor
        if has_more is not None:
            self.has_more = has_more

    @property
    def doc_ids(self):
        """
        The list of Paper doc IDs that can be used to access the given Paper
        docs or supplied to other API methods. The list is sorted in the order
        specified by the initial call to
        :meth:`dropbox.dropbox.Dropbox.paper_docs_list`.

        :rtype: list of [str]
        """
        if self._doc_ids_present:
            return self._doc_ids_value
        else:
            raise AttributeError("missing required field 'doc_ids'")

    @doc_ids.setter
    def doc_ids(self, val):
        val = self._doc_ids_validator.validate(val)
        self._doc_ids_value = val
        self._doc_ids_present = True

    @doc_ids.deleter
    def doc_ids(self):
        self._doc_ids_value = None
        self._doc_ids_present = False

    @property
    def cursor(self):
        """
        Pass the cursor into
        :meth:`dropbox.dropbox.Dropbox.paper_docs_list_continue` to paginate
        through all files. The cursor preserves all properties as specified in
        the original call to :meth:`dropbox.dropbox.Dropbox.paper_docs_list`.

        :rtype: Cursor
        """
        if self._cursor_present:
            return self._cursor_value
        else:
            raise AttributeError("missing required field 'cursor'")

    @cursor.setter
    def cursor(self, val):
        self._cursor_validator.validate_type_only(val)
        self._cursor_value = val
        self._cursor_present = True

    @cursor.deleter
    def cursor(self):
        self._cursor_value = None
        self._cursor_present = False

    @property
    def has_more(self):
        """
        Will be set to True if a subsequent call with the provided cursor to
        :meth:`dropbox.dropbox.Dropbox.paper_docs_list_continue` returns
        immediately with some results. If set to False please allow some delay
        before making another call to
        :meth:`dropbox.dropbox.Dropbox.paper_docs_list_continue`.

        :rtype: bool
        """
        if self._has_more_present:
            return self._has_more_value
        else:
            raise AttributeError("missing required field 'has_more'")

    @has_more.setter
    def has_more(self, val):
        val = self._has_more_validator.validate(val)
        self._has_more_value = val
        self._has_more_present = True

    @has_more.deleter
    def has_more(self):
        self._has_more_value = None
        self._has_more_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(ListPaperDocsResponse, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'ListPaperDocsResponse(doc_ids={!r}, cursor={!r}, has_more={!r})'.format(
            self._doc_ids_value,
            self._cursor_value,
            self._has_more_value,
        )

ListPaperDocsResponse_validator = bv.Struct(ListPaperDocsResponse)

class ListPaperDocsSortBy(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar accessed: Sorts the Paper docs by the time they were last accessed.
    :ivar modified: Sorts the Paper docs by the time they were last modified.
    :ivar created: Sorts the Paper docs by the creation time.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    accessed = None
    # Attribute is overwritten below the class definition
    modified = None
    # Attribute is overwritten below the class definition
    created = None
    # Attribute is overwritten below the class definition
    other = None

    def is_accessed(self):
        """
        Check if the union tag is ``accessed``.

        :rtype: bool
        """
        return self._tag == 'accessed'

    def is_modified(self):
        """
        Check if the union tag is ``modified``.

        :rtype: bool
        """
        return self._tag == 'modified'

    def is_created(self):
        """
        Check if the union tag is ``created``.

        :rtype: bool
        """
        return self._tag == 'created'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, processor):
        super(ListPaperDocsSortBy, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'ListPaperDocsSortBy(%r, %r)' % (self._tag, self._value)

ListPaperDocsSortBy_validator = bv.Union(ListPaperDocsSortBy)

class ListPaperDocsSortOrder(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar ascending: Sorts the search result in ascending order.
    :ivar descending: Sorts the search result in descending order.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    ascending = None
    # Attribute is overwritten below the class definition
    descending = None
    # Attribute is overwritten below the class definition
    other = None

    def is_ascending(self):
        """
        Check if the union tag is ``ascending``.

        :rtype: bool
        """
        return self._tag == 'ascending'

    def is_descending(self):
        """
        Check if the union tag is ``descending``.

        :rtype: bool
        """
        return self._tag == 'descending'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, processor):
        super(ListPaperDocsSortOrder, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'ListPaperDocsSortOrder(%r, %r)' % (self._tag, self._value)

ListPaperDocsSortOrder_validator = bv.Union(ListPaperDocsSortOrder)

class ListUsersCursorError(PaperApiBaseError):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar doc_not_found: The required doc was not found.
    """

    # Attribute is overwritten below the class definition
    doc_not_found = None

    @classmethod
    def cursor_error(cls, val):
        """
        Create an instance of this class set to the ``cursor_error`` tag with
        value ``val``.

        :param PaperApiCursorError val:
        :rtype: ListUsersCursorError
        """
        return cls('cursor_error', val)

    def is_doc_not_found(self):
        """
        Check if the union tag is ``doc_not_found``.

        :rtype: bool
        """
        return self._tag == 'doc_not_found'

    def is_cursor_error(self):
        """
        Check if the union tag is ``cursor_error``.

        :rtype: bool
        """
        return self._tag == 'cursor_error'

    def get_cursor_error(self):
        """
        Only call this if :meth:`is_cursor_error` is true.

        :rtype: PaperApiCursorError
        """
        if not self.is_cursor_error():
            raise AttributeError("tag 'cursor_error' not set")
        return self._value

    def _process_custom_annotations(self, annotation_type, processor):
        super(ListUsersCursorError, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'ListUsersCursorError(%r, %r)' % (self._tag, self._value)

ListUsersCursorError_validator = bv.Union(ListUsersCursorError)

class ListUsersOnFolderArgs(RefPaperDoc):
    """
    :ivar limit: Size limit per batch. The maximum number of users that can be
        retrieved per batch is 1000. Higher value results in invalid arguments
        error.
    """

    __slots__ = [
        '_limit_value',
        '_limit_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 doc_id=None,
                 limit=None):
        super(ListUsersOnFolderArgs, self).__init__(doc_id)
        self._limit_value = None
        self._limit_present = False
        if limit is not None:
            self.limit = limit

    @property
    def limit(self):
        """
        Size limit per batch. The maximum number of users that can be retrieved
        per batch is 1000. Higher value results in invalid arguments error.

        :rtype: long
        """
        if self._limit_present:
            return self._limit_value
        else:
            return 1000

    @limit.setter
    def limit(self, val):
        val = self._limit_validator.validate(val)
        self._limit_value = val
        self._limit_present = True

    @limit.deleter
    def limit(self):
        self._limit_value = None
        self._limit_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(ListUsersOnFolderArgs, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'ListUsersOnFolderArgs(doc_id={!r}, limit={!r})'.format(
            self._doc_id_value,
            self._limit_value,
        )

ListUsersOnFolderArgs_validator = bv.Struct(ListUsersOnFolderArgs)

class ListUsersOnFolderContinueArgs(RefPaperDoc):
    """
    :ivar cursor: The cursor obtained from
        :meth:`dropbox.dropbox.Dropbox.paper_docs_folder_users_list` or
        :meth:`dropbox.dropbox.Dropbox.paper_docs_folder_users_list_continue`.
        Allows for pagination.
    """

    __slots__ = [
        '_cursor_value',
        '_cursor_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 doc_id=None,
                 cursor=None):
        super(ListUsersOnFolderContinueArgs, self).__init__(doc_id)
        self._cursor_value = None
        self._cursor_present = False
        if cursor is not None:
            self.cursor = cursor

    @property
    def cursor(self):
        """
        The cursor obtained from
        :meth:`dropbox.dropbox.Dropbox.paper_docs_folder_users_list` or
        :meth:`dropbox.dropbox.Dropbox.paper_docs_folder_users_list_continue`.
        Allows for pagination.

        :rtype: str
        """
        if self._cursor_present:
            return self._cursor_value
        else:
            raise AttributeError("missing required field 'cursor'")

    @cursor.setter
    def cursor(self, val):
        val = self._cursor_validator.validate(val)
        self._cursor_value = val
        self._cursor_present = True

    @cursor.deleter
    def cursor(self):
        self._cursor_value = None
        self._cursor_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(ListUsersOnFolderContinueArgs, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'ListUsersOnFolderContinueArgs(doc_id={!r}, cursor={!r})'.format(
            self._doc_id_value,
            self._cursor_value,
        )

ListUsersOnFolderContinueArgs_validator = bv.Struct(ListUsersOnFolderContinueArgs)

class ListUsersOnFolderResponse(bb.Struct):
    """
    :ivar invitees: List of email addresses that are invited on the Paper
        folder.
    :ivar users: List of users that are invited on the Paper folder.
    :ivar cursor: Pass the cursor into
        :meth:`dropbox.dropbox.Dropbox.paper_docs_folder_users_list_continue` to
        paginate through all users. The cursor preserves all properties as
        specified in the original call to
        :meth:`dropbox.dropbox.Dropbox.paper_docs_folder_users_list`.
    :ivar has_more: Will be set to True if a subsequent call with the provided
        cursor to
        :meth:`dropbox.dropbox.Dropbox.paper_docs_folder_users_list_continue`
        returns immediately with some results. If set to False please allow some
        delay before making another call to
        :meth:`dropbox.dropbox.Dropbox.paper_docs_folder_users_list_continue`.
    """

    __slots__ = [
        '_invitees_value',
        '_invitees_present',
        '_users_value',
        '_users_present',
        '_cursor_value',
        '_cursor_present',
        '_has_more_value',
        '_has_more_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 invitees=None,
                 users=None,
                 cursor=None,
                 has_more=None):
        self._invitees_value = None
        self._invitees_present = False
        self._users_value = None
        self._users_present = False
        self._cursor_value = None
        self._cursor_present = False
        self._has_more_value = None
        self._has_more_present = False
        if invitees is not None:
            self.invitees = invitees
        if users is not None:
            self.users = users
        if cursor is not None:
            self.cursor = cursor
        if has_more is not None:
            self.has_more = has_more

    @property
    def invitees(self):
        """
        List of email addresses that are invited on the Paper folder.

        :rtype: list of [sharing.InviteeInfo]
        """
        if self._invitees_present:
            return self._invitees_value
        else:
            raise AttributeError("missing required field 'invitees'")

    @invitees.setter
    def invitees(self, val):
        val = self._invitees_validator.validate(val)
        self._invitees_value = val
        self._invitees_present = True

    @invitees.deleter
    def invitees(self):
        self._invitees_value = None
        self._invitees_present = False

    @property
    def users(self):
        """
        List of users that are invited on the Paper folder.

        :rtype: list of [sharing.UserInfo]
        """
        if self._users_present:
            return self._users_value
        else:
            raise AttributeError("missing required field 'users'")

    @users.setter
    def users(self, val):
        val = self._users_validator.validate(val)
        self._users_value = val
        self._users_present = True

    @users.deleter
    def users(self):
        self._users_value = None
        self._users_present = False

    @property
    def cursor(self):
        """
        Pass the cursor into
        :meth:`dropbox.dropbox.Dropbox.paper_docs_folder_users_list_continue` to
        paginate through all users. The cursor preserves all properties as
        specified in the original call to
        :meth:`dropbox.dropbox.Dropbox.paper_docs_folder_users_list`.

        :rtype: Cursor
        """
        if self._cursor_present:
            return self._cursor_value
        else:
            raise AttributeError("missing required field 'cursor'")

    @cursor.setter
    def cursor(self, val):
        self._cursor_validator.validate_type_only(val)
        self._cursor_value = val
        self._cursor_present = True

    @cursor.deleter
    def cursor(self):
        self._cursor_value = None
        self._cursor_present = False

    @property
    def has_more(self):
        """
        Will be set to True if a subsequent call with the provided cursor to
        :meth:`dropbox.dropbox.Dropbox.paper_docs_folder_users_list_continue`
        returns immediately with some results. If set to False please allow some
        delay before making another call to
        :meth:`dropbox.dropbox.Dropbox.paper_docs_folder_users_list_continue`.

        :rtype: bool
        """
        if self._has_more_present:
            return self._has_more_value
        else:
            raise AttributeError("missing required field 'has_more'")

    @has_more.setter
    def has_more(self, val):
        val = self._has_more_validator.validate(val)
        self._has_more_value = val
        self._has_more_present = True

    @has_more.deleter
    def has_more(self):
        self._has_more_value = None
        self._has_more_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(ListUsersOnFolderResponse, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'ListUsersOnFolderResponse(invitees={!r}, users={!r}, cursor={!r}, has_more={!r})'.format(
            self._invitees_value,
            self._users_value,
            self._cursor_value,
            self._has_more_value,
        )

ListUsersOnFolderResponse_validator = bv.Struct(ListUsersOnFolderResponse)

class ListUsersOnPaperDocArgs(RefPaperDoc):
    """
    :ivar limit: Size limit per batch. The maximum number of users that can be
        retrieved per batch is 1000. Higher value results in invalid arguments
        error.
    :ivar filter_by: Specify this attribute if you want to obtain users that
        have already accessed the Paper doc.
    """

    __slots__ = [
        '_limit_value',
        '_limit_present',
        '_filter_by_value',
        '_filter_by_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 doc_id=None,
                 limit=None,
                 filter_by=None):
        super(ListUsersOnPaperDocArgs, self).__init__(doc_id)
        self._limit_value = None
        self._limit_present = False
        self._filter_by_value = None
        self._filter_by_present = False
        if limit is not None:
            self.limit = limit
        if filter_by is not None:
            self.filter_by = filter_by

    @property
    def limit(self):
        """
        Size limit per batch. The maximum number of users that can be retrieved
        per batch is 1000. Higher value results in invalid arguments error.

        :rtype: long
        """
        if self._limit_present:
            return self._limit_value
        else:
            return 1000

    @limit.setter
    def limit(self, val):
        val = self._limit_validator.validate(val)
        self._limit_value = val
        self._limit_present = True

    @limit.deleter
    def limit(self):
        self._limit_value = None
        self._limit_present = False

    @property
    def filter_by(self):
        """
        Specify this attribute if you want to obtain users that have already
        accessed the Paper doc.

        :rtype: UserOnPaperDocFilter
        """
        if self._filter_by_present:
            return self._filter_by_value
        else:
            return UserOnPaperDocFilter.shared

    @filter_by.setter
    def filter_by(self, val):
        self._filter_by_validator.validate_type_only(val)
        self._filter_by_value = val
        self._filter_by_present = True

    @filter_by.deleter
    def filter_by(self):
        self._filter_by_value = None
        self._filter_by_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(ListUsersOnPaperDocArgs, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'ListUsersOnPaperDocArgs(doc_id={!r}, limit={!r}, filter_by={!r})'.format(
            self._doc_id_value,
            self._limit_value,
            self._filter_by_value,
        )

ListUsersOnPaperDocArgs_validator = bv.Struct(ListUsersOnPaperDocArgs)

class ListUsersOnPaperDocContinueArgs(RefPaperDoc):
    """
    :ivar cursor: The cursor obtained from
        :meth:`dropbox.dropbox.Dropbox.paper_docs_users_list` or
        :meth:`dropbox.dropbox.Dropbox.paper_docs_users_list_continue`. Allows
        for pagination.
    """

    __slots__ = [
        '_cursor_value',
        '_cursor_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 doc_id=None,
                 cursor=None):
        super(ListUsersOnPaperDocContinueArgs, self).__init__(doc_id)
        self._cursor_value = None
        self._cursor_present = False
        if cursor is not None:
            self.cursor = cursor

    @property
    def cursor(self):
        """
        The cursor obtained from
        :meth:`dropbox.dropbox.Dropbox.paper_docs_users_list` or
        :meth:`dropbox.dropbox.Dropbox.paper_docs_users_list_continue`. Allows
        for pagination.

        :rtype: str
        """
        if self._cursor_present:
            return self._cursor_value
        else:
            raise AttributeError("missing required field 'cursor'")

    @cursor.setter
    def cursor(self, val):
        val = self._cursor_validator.validate(val)
        self._cursor_value = val
        self._cursor_present = True

    @cursor.deleter
    def cursor(self):
        self._cursor_value = None
        self._cursor_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(ListUsersOnPaperDocContinueArgs, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'ListUsersOnPaperDocContinueArgs(doc_id={!r}, cursor={!r})'.format(
            self._doc_id_value,
            self._cursor_value,
        )

ListUsersOnPaperDocContinueArgs_validator = bv.Struct(ListUsersOnPaperDocContinueArgs)

class ListUsersOnPaperDocResponse(bb.Struct):
    """
    :ivar invitees: List of email addresses with their respective permission
        levels that are invited on the Paper doc.
    :ivar users: List of users with their respective permission levels that are
        invited on the Paper folder.
    :ivar doc_owner: The Paper doc owner. This field is populated on every
        single response.
    :ivar cursor: Pass the cursor into
        :meth:`dropbox.dropbox.Dropbox.paper_docs_users_list_continue` to
        paginate through all users. The cursor preserves all properties as
        specified in the original call to
        :meth:`dropbox.dropbox.Dropbox.paper_docs_users_list`.
    :ivar has_more: Will be set to True if a subsequent call with the provided
        cursor to :meth:`dropbox.dropbox.Dropbox.paper_docs_users_list_continue`
        returns immediately with some results. If set to False please allow some
        delay before making another call to
        :meth:`dropbox.dropbox.Dropbox.paper_docs_users_list_continue`.
    """

    __slots__ = [
        '_invitees_value',
        '_invitees_present',
        '_users_value',
        '_users_present',
        '_doc_owner_value',
        '_doc_owner_present',
        '_cursor_value',
        '_cursor_present',
        '_has_more_value',
        '_has_more_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 invitees=None,
                 users=None,
                 doc_owner=None,
                 cursor=None,
                 has_more=None):
        self._invitees_value = None
        self._invitees_present = False
        self._users_value = None
        self._users_present = False
        self._doc_owner_value = None
        self._doc_owner_present = False
        self._cursor_value = None
        self._cursor_present = False
        self._has_more_value = None
        self._has_more_present = False
        if invitees is not None:
            self.invitees = invitees
        if users is not None:
            self.users = users
        if doc_owner is not None:
            self.doc_owner = doc_owner
        if cursor is not None:
            self.cursor = cursor
        if has_more is not None:
            self.has_more = has_more

    @property
    def invitees(self):
        """
        List of email addresses with their respective permission levels that are
        invited on the Paper doc.

        :rtype: list of [InviteeInfoWithPermissionLevel]
        """
        if self._invitees_present:
            return self._invitees_value
        else:
            raise AttributeError("missing required field 'invitees'")

    @invitees.setter
    def invitees(self, val):
        val = self._invitees_validator.validate(val)
        self._invitees_value = val
        self._invitees_present = True

    @invitees.deleter
    def invitees(self):
        self._invitees_value = None
        self._invitees_present = False

    @property
    def users(self):
        """
        List of users with their respective permission levels that are invited
        on the Paper folder.

        :rtype: list of [UserInfoWithPermissionLevel]
        """
        if self._users_present:
            return self._users_value
        else:
            raise AttributeError("missing required field 'users'")

    @users.setter
    def users(self, val):
        val = self._users_validator.validate(val)
        self._users_value = val
        self._users_present = True

    @users.deleter
    def users(self):
        self._users_value = None
        self._users_present = False

    @property
    def doc_owner(self):
        """
        The Paper doc owner. This field is populated on every single response.

        :rtype: sharing.UserInfo
        """
        if self._doc_owner_present:
            return self._doc_owner_value
        else:
            raise AttributeError("missing required field 'doc_owner'")

    @doc_owner.setter
    def doc_owner(self, val):
        self._doc_owner_validator.validate_type_only(val)
        self._doc_owner_value = val
        self._doc_owner_present = True

    @doc_owner.deleter
    def doc_owner(self):
        self._doc_owner_value = None
        self._doc_owner_present = False

    @property
    def cursor(self):
        """
        Pass the cursor into
        :meth:`dropbox.dropbox.Dropbox.paper_docs_users_list_continue` to
        paginate through all users. The cursor preserves all properties as
        specified in the original call to
        :meth:`dropbox.dropbox.Dropbox.paper_docs_users_list`.

        :rtype: Cursor
        """
        if self._cursor_present:
            return self._cursor_value
        else:
            raise AttributeError("missing required field 'cursor'")

    @cursor.setter
    def cursor(self, val):
        self._cursor_validator.validate_type_only(val)
        self._cursor_value = val
        self._cursor_present = True

    @cursor.deleter
    def cursor(self):
        self._cursor_value = None
        self._cursor_present = False

    @property
    def has_more(self):
        """
        Will be set to True if a subsequent call with the provided cursor to
        :meth:`dropbox.dropbox.Dropbox.paper_docs_users_list_continue` returns
        immediately with some results. If set to False please allow some delay
        before making another call to
        :meth:`dropbox.dropbox.Dropbox.paper_docs_users_list_continue`.

        :rtype: bool
        """
        if self._has_more_present:
            return self._has_more_value
        else:
            raise AttributeError("missing required field 'has_more'")

    @has_more.setter
    def has_more(self, val):
        val = self._has_more_validator.validate(val)
        self._has_more_value = val
        self._has_more_present = True

    @has_more.deleter
    def has_more(self):
        self._has_more_value = None
        self._has_more_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(ListUsersOnPaperDocResponse, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'ListUsersOnPaperDocResponse(invitees={!r}, users={!r}, doc_owner={!r}, cursor={!r}, has_more={!r})'.format(
            self._invitees_value,
            self._users_value,
            self._doc_owner_value,
            self._cursor_value,
            self._has_more_value,
        )

ListUsersOnPaperDocResponse_validator = bv.Struct(ListUsersOnPaperDocResponse)

class PaperApiCursorError(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar expired_cursor: The provided cursor is expired.
    :ivar invalid_cursor: The provided cursor is invalid.
    :ivar wrong_user_in_cursor: The provided cursor contains invalid user.
    :ivar reset: Indicates that the cursor has been invalidated. Call the
        corresponding non-continue endpoint to obtain a new cursor.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    expired_cursor = None
    # Attribute is overwritten below the class definition
    invalid_cursor = None
    # Attribute is overwritten below the class definition
    wrong_user_in_cursor = None
    # Attribute is overwritten below the class definition
    reset = None
    # Attribute is overwritten below the class definition
    other = None

    def is_expired_cursor(self):
        """
        Check if the union tag is ``expired_cursor``.

        :rtype: bool
        """
        return self._tag == 'expired_cursor'

    def is_invalid_cursor(self):
        """
        Check if the union tag is ``invalid_cursor``.

        :rtype: bool
        """
        return self._tag == 'invalid_cursor'

    def is_wrong_user_in_cursor(self):
        """
        Check if the union tag is ``wrong_user_in_cursor``.

        :rtype: bool
        """
        return self._tag == 'wrong_user_in_cursor'

    def is_reset(self):
        """
        Check if the union tag is ``reset``.

        :rtype: bool
        """
        return self._tag == 'reset'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, processor):
        super(PaperApiCursorError, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'PaperApiCursorError(%r, %r)' % (self._tag, self._value)

PaperApiCursorError_validator = bv.Union(PaperApiCursorError)

class PaperDocCreateArgs(bb.Struct):
    """
    :ivar parent_folder_id: The Paper folder ID where the Paper document should
        be created. The API user has to have write access to this folder or
        error is thrown.
    :ivar import_format: The format of provided data.
    """

    __slots__ = [
        '_parent_folder_id_value',
        '_parent_folder_id_present',
        '_import_format_value',
        '_import_format_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 import_format=None,
                 parent_folder_id=None):
        self._parent_folder_id_value = None
        self._parent_folder_id_present = False
        self._import_format_value = None
        self._import_format_present = False
        if parent_folder_id is not None:
            self.parent_folder_id = parent_folder_id
        if import_format is not None:
            self.import_format = import_format

    @property
    def parent_folder_id(self):
        """
        The Paper folder ID where the Paper document should be created. The API
        user has to have write access to this folder or error is thrown.

        :rtype: str
        """
        if self._parent_folder_id_present:
            return self._parent_folder_id_value
        else:
            return None

    @parent_folder_id.setter
    def parent_folder_id(self, val):
        if val is None:
            del self.parent_folder_id
            return
        val = self._parent_folder_id_validator.validate(val)
        self._parent_folder_id_value = val
        self._parent_folder_id_present = True

    @parent_folder_id.deleter
    def parent_folder_id(self):
        self._parent_folder_id_value = None
        self._parent_folder_id_present = False

    @property
    def import_format(self):
        """
        The format of provided data.

        :rtype: ImportFormat
        """
        if self._import_format_present:
            return self._import_format_value
        else:
            raise AttributeError("missing required field 'import_format'")

    @import_format.setter
    def import_format(self, val):
        self._import_format_validator.validate_type_only(val)
        self._import_format_value = val
        self._import_format_present = True

    @import_format.deleter
    def import_format(self):
        self._import_format_value = None
        self._import_format_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(PaperDocCreateArgs, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'PaperDocCreateArgs(import_format={!r}, parent_folder_id={!r})'.format(
            self._import_format_value,
            self._parent_folder_id_value,
        )

PaperDocCreateArgs_validator = bv.Struct(PaperDocCreateArgs)

class PaperDocCreateError(PaperApiBaseError):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar content_malformed: The provided content was malformed and cannot be
        imported to Paper.
    :ivar folder_not_found: The specified Paper folder is cannot be found.
    :ivar doc_length_exceeded: The newly created Paper doc would be too large.
        Please split the content into multiple docs.
    :ivar image_size_exceeded: The imported document contains an image that is
        too large. The current limit is 1MB. Note: This only applies to HTML
        with data uri.
    """

    # Attribute is overwritten below the class definition
    content_malformed = None
    # Attribute is overwritten below the class definition
    folder_not_found = None
    # Attribute is overwritten below the class definition
    doc_length_exceeded = None
    # Attribute is overwritten below the class definition
    image_size_exceeded = None

    def is_content_malformed(self):
        """
        Check if the union tag is ``content_malformed``.

        :rtype: bool
        """
        return self._tag == 'content_malformed'

    def is_folder_not_found(self):
        """
        Check if the union tag is ``folder_not_found``.

        :rtype: bool
        """
        return self._tag == 'folder_not_found'

    def is_doc_length_exceeded(self):
        """
        Check if the union tag is ``doc_length_exceeded``.

        :rtype: bool
        """
        return self._tag == 'doc_length_exceeded'

    def is_image_size_exceeded(self):
        """
        Check if the union tag is ``image_size_exceeded``.

        :rtype: bool
        """
        return self._tag == 'image_size_exceeded'

    def _process_custom_annotations(self, annotation_type, processor):
        super(PaperDocCreateError, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'PaperDocCreateError(%r, %r)' % (self._tag, self._value)

PaperDocCreateError_validator = bv.Union(PaperDocCreateError)

class PaperDocCreateUpdateResult(bb.Struct):
    """
    :ivar doc_id: Doc ID of the newly created doc.
    :ivar revision: The Paper doc revision. Simply an ever increasing number.
    :ivar title: The Paper doc title.
    """

    __slots__ = [
        '_doc_id_value',
        '_doc_id_present',
        '_revision_value',
        '_revision_present',
        '_title_value',
        '_title_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 doc_id=None,
                 revision=None,
                 title=None):
        self._doc_id_value = None
        self._doc_id_present = False
        self._revision_value = None
        self._revision_present = False
        self._title_value = None
        self._title_present = False
        if doc_id is not None:
            self.doc_id = doc_id
        if revision is not None:
            self.revision = revision
        if title is not None:
            self.title = title

    @property
    def doc_id(self):
        """
        Doc ID of the newly created doc.

        :rtype: str
        """
        if self._doc_id_present:
            return self._doc_id_value
        else:
            raise AttributeError("missing required field 'doc_id'")

    @doc_id.setter
    def doc_id(self, val):
        val = self._doc_id_validator.validate(val)
        self._doc_id_value = val
        self._doc_id_present = True

    @doc_id.deleter
    def doc_id(self):
        self._doc_id_value = None
        self._doc_id_present = False

    @property
    def revision(self):
        """
        The Paper doc revision. Simply an ever increasing number.

        :rtype: long
        """
        if self._revision_present:
            return self._revision_value
        else:
            raise AttributeError("missing required field 'revision'")

    @revision.setter
    def revision(self, val):
        val = self._revision_validator.validate(val)
        self._revision_value = val
        self._revision_present = True

    @revision.deleter
    def revision(self):
        self._revision_value = None
        self._revision_present = False

    @property
    def title(self):
        """
        The Paper doc title.

        :rtype: str
        """
        if self._title_present:
            return self._title_value
        else:
            raise AttributeError("missing required field 'title'")

    @title.setter
    def title(self, val):
        val = self._title_validator.validate(val)
        self._title_value = val
        self._title_present = True

    @title.deleter
    def title(self):
        self._title_value = None
        self._title_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(PaperDocCreateUpdateResult, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'PaperDocCreateUpdateResult(doc_id={!r}, revision={!r}, title={!r})'.format(
            self._doc_id_value,
            self._revision_value,
            self._title_value,
        )

PaperDocCreateUpdateResult_validator = bv.Struct(PaperDocCreateUpdateResult)

class PaperDocExport(RefPaperDoc):

    __slots__ = [
        '_export_format_value',
        '_export_format_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 doc_id=None,
                 export_format=None):
        super(PaperDocExport, self).__init__(doc_id)
        self._export_format_value = None
        self._export_format_present = False
        if export_format is not None:
            self.export_format = export_format

    @property
    def export_format(self):
        """
        :rtype: ExportFormat
        """
        if self._export_format_present:
            return self._export_format_value
        else:
            raise AttributeError("missing required field 'export_format'")

    @export_format.setter
    def export_format(self, val):
        self._export_format_validator.validate_type_only(val)
        self._export_format_value = val
        self._export_format_present = True

    @export_format.deleter
    def export_format(self):
        self._export_format_value = None
        self._export_format_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(PaperDocExport, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'PaperDocExport(doc_id={!r}, export_format={!r})'.format(
            self._doc_id_value,
            self._export_format_value,
        )

PaperDocExport_validator = bv.Struct(PaperDocExport)

class PaperDocExportResult(bb.Struct):
    """
    :ivar owner: The Paper doc owner's email address.
    :ivar title: The Paper doc title.
    :ivar revision: The Paper doc revision. Simply an ever increasing number.
    :ivar mime_type: MIME type of the export. This corresponds to
        :class:`ExportFormat` specified in the request.
    """

    __slots__ = [
        '_owner_value',
        '_owner_present',
        '_title_value',
        '_title_present',
        '_revision_value',
        '_revision_present',
        '_mime_type_value',
        '_mime_type_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 owner=None,
                 title=None,
                 revision=None,
                 mime_type=None):
        self._owner_value = None
        self._owner_present = False
        self._title_value = None
        self._title_present = False
        self._revision_value = None
        self._revision_present = False
        self._mime_type_value = None
        self._mime_type_present = False
        if owner is not None:
            self.owner = owner
        if title is not None:
            self.title = title
        if revision is not None:
            self.revision = revision
        if mime_type is not None:
            self.mime_type = mime_type

    @property
    def owner(self):
        """
        The Paper doc owner's email address.

        :rtype: str
        """
        if self._owner_present:
            return self._owner_value
        else:
            raise AttributeError("missing required field 'owner'")

    @owner.setter
    def owner(self, val):
        val = self._owner_validator.validate(val)
        self._owner_value = val
        self._owner_present = True

    @owner.deleter
    def owner(self):
        self._owner_value = None
        self._owner_present = False

    @property
    def title(self):
        """
        The Paper doc title.

        :rtype: str
        """
        if self._title_present:
            return self._title_value
        else:
            raise AttributeError("missing required field 'title'")

    @title.setter
    def title(self, val):
        val = self._title_validator.validate(val)
        self._title_value = val
        self._title_present = True

    @title.deleter
    def title(self):
        self._title_value = None
        self._title_present = False

    @property
    def revision(self):
        """
        The Paper doc revision. Simply an ever increasing number.

        :rtype: long
        """
        if self._revision_present:
            return self._revision_value
        else:
            raise AttributeError("missing required field 'revision'")

    @revision.setter
    def revision(self, val):
        val = self._revision_validator.validate(val)
        self._revision_value = val
        self._revision_present = True

    @revision.deleter
    def revision(self):
        self._revision_value = None
        self._revision_present = False

    @property
    def mime_type(self):
        """
        MIME type of the export. This corresponds to :class:`ExportFormat`
        specified in the request.

        :rtype: str
        """
        if self._mime_type_present:
            return self._mime_type_value
        else:
            raise AttributeError("missing required field 'mime_type'")

    @mime_type.setter
    def mime_type(self, val):
        val = self._mime_type_validator.validate(val)
        self._mime_type_value = val
        self._mime_type_present = True

    @mime_type.deleter
    def mime_type(self):
        self._mime_type_value = None
        self._mime_type_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(PaperDocExportResult, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'PaperDocExportResult(owner={!r}, title={!r}, revision={!r}, mime_type={!r})'.format(
            self._owner_value,
            self._title_value,
            self._revision_value,
            self._mime_type_value,
        )

PaperDocExportResult_validator = bv.Struct(PaperDocExportResult)

class PaperDocPermissionLevel(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar edit: User will be granted edit permissions.
    :ivar view_and_comment: User will be granted view and comment permissions.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    edit = None
    # Attribute is overwritten below the class definition
    view_and_comment = None
    # Attribute is overwritten below the class definition
    other = None

    def is_edit(self):
        """
        Check if the union tag is ``edit``.

        :rtype: bool
        """
        return self._tag == 'edit'

    def is_view_and_comment(self):
        """
        Check if the union tag is ``view_and_comment``.

        :rtype: bool
        """
        return self._tag == 'view_and_comment'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, processor):
        super(PaperDocPermissionLevel, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'PaperDocPermissionLevel(%r, %r)' % (self._tag, self._value)

PaperDocPermissionLevel_validator = bv.Union(PaperDocPermissionLevel)

class PaperDocSharingPolicy(RefPaperDoc):
    """
    :ivar sharing_policy: The default sharing policy to be set for the Paper
        doc.
    """

    __slots__ = [
        '_sharing_policy_value',
        '_sharing_policy_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 doc_id=None,
                 sharing_policy=None):
        super(PaperDocSharingPolicy, self).__init__(doc_id)
        self._sharing_policy_value = None
        self._sharing_policy_present = False
        if sharing_policy is not None:
            self.sharing_policy = sharing_policy

    @property
    def sharing_policy(self):
        """
        The default sharing policy to be set for the Paper doc.

        :rtype: SharingPolicy
        """
        if self._sharing_policy_present:
            return self._sharing_policy_value
        else:
            raise AttributeError("missing required field 'sharing_policy'")

    @sharing_policy.setter
    def sharing_policy(self, val):
        self._sharing_policy_validator.validate_type_only(val)
        self._sharing_policy_value = val
        self._sharing_policy_present = True

    @sharing_policy.deleter
    def sharing_policy(self):
        self._sharing_policy_value = None
        self._sharing_policy_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(PaperDocSharingPolicy, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'PaperDocSharingPolicy(doc_id={!r}, sharing_policy={!r})'.format(
            self._doc_id_value,
            self._sharing_policy_value,
        )

PaperDocSharingPolicy_validator = bv.Struct(PaperDocSharingPolicy)

class PaperDocUpdateArgs(RefPaperDoc):
    """
    :ivar doc_update_policy: The policy used for the current update call.
    :ivar revision: The latest doc revision. This value must match the head
        revision or an error code will be returned. This is to prevent colliding
        writes.
    :ivar import_format: The format of provided data.
    """

    __slots__ = [
        '_doc_update_policy_value',
        '_doc_update_policy_present',
        '_revision_value',
        '_revision_present',
        '_import_format_value',
        '_import_format_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 doc_id=None,
                 doc_update_policy=None,
                 revision=None,
                 import_format=None):
        super(PaperDocUpdateArgs, self).__init__(doc_id)
        self._doc_update_policy_value = None
        self._doc_update_policy_present = False
        self._revision_value = None
        self._revision_present = False
        self._import_format_value = None
        self._import_format_present = False
        if doc_update_policy is not None:
            self.doc_update_policy = doc_update_policy
        if revision is not None:
            self.revision = revision
        if import_format is not None:
            self.import_format = import_format

    @property
    def doc_update_policy(self):
        """
        The policy used for the current update call.

        :rtype: PaperDocUpdatePolicy
        """
        if self._doc_update_policy_present:
            return self._doc_update_policy_value
        else:
            raise AttributeError("missing required field 'doc_update_policy'")

    @doc_update_policy.setter
    def doc_update_policy(self, val):
        self._doc_update_policy_validator.validate_type_only(val)
        self._doc_update_policy_value = val
        self._doc_update_policy_present = True

    @doc_update_policy.deleter
    def doc_update_policy(self):
        self._doc_update_policy_value = None
        self._doc_update_policy_present = False

    @property
    def revision(self):
        """
        The latest doc revision. This value must match the head revision or an
        error code will be returned. This is to prevent colliding writes.

        :rtype: long
        """
        if self._revision_present:
            return self._revision_value
        else:
            raise AttributeError("missing required field 'revision'")

    @revision.setter
    def revision(self, val):
        val = self._revision_validator.validate(val)
        self._revision_value = val
        self._revision_present = True

    @revision.deleter
    def revision(self):
        self._revision_value = None
        self._revision_present = False

    @property
    def import_format(self):
        """
        The format of provided data.

        :rtype: ImportFormat
        """
        if self._import_format_present:
            return self._import_format_value
        else:
            raise AttributeError("missing required field 'import_format'")

    @import_format.setter
    def import_format(self, val):
        self._import_format_validator.validate_type_only(val)
        self._import_format_value = val
        self._import_format_present = True

    @import_format.deleter
    def import_format(self):
        self._import_format_value = None
        self._import_format_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(PaperDocUpdateArgs, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'PaperDocUpdateArgs(doc_id={!r}, doc_update_policy={!r}, revision={!r}, import_format={!r})'.format(
            self._doc_id_value,
            self._doc_update_policy_value,
            self._revision_value,
            self._import_format_value,
        )

PaperDocUpdateArgs_validator = bv.Struct(PaperDocUpdateArgs)

class PaperDocUpdateError(DocLookupError):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar content_malformed: The provided content was malformed and cannot be
        imported to Paper.
    :ivar revision_mismatch: The provided revision does not match the document
        head.
    :ivar doc_length_exceeded: The newly created Paper doc would be too large,
        split the content into multiple docs.
    :ivar image_size_exceeded: The imported document contains an image that is
        too large. The current limit is 1MB. Note: This only applies to HTML
        with data uri.
    :ivar doc_archived: This operation is not allowed on archived Paper docs.
    :ivar doc_deleted: This operation is not allowed on deleted Paper docs.
    """

    # Attribute is overwritten below the class definition
    content_malformed = None
    # Attribute is overwritten below the class definition
    revision_mismatch = None
    # Attribute is overwritten below the class definition
    doc_length_exceeded = None
    # Attribute is overwritten below the class definition
    image_size_exceeded = None
    # Attribute is overwritten below the class definition
    doc_archived = None
    # Attribute is overwritten below the class definition
    doc_deleted = None

    def is_content_malformed(self):
        """
        Check if the union tag is ``content_malformed``.

        :rtype: bool
        """
        return self._tag == 'content_malformed'

    def is_revision_mismatch(self):
        """
        Check if the union tag is ``revision_mismatch``.

        :rtype: bool
        """
        return self._tag == 'revision_mismatch'

    def is_doc_length_exceeded(self):
        """
        Check if the union tag is ``doc_length_exceeded``.

        :rtype: bool
        """
        return self._tag == 'doc_length_exceeded'

    def is_image_size_exceeded(self):
        """
        Check if the union tag is ``image_size_exceeded``.

        :rtype: bool
        """
        return self._tag == 'image_size_exceeded'

    def is_doc_archived(self):
        """
        Check if the union tag is ``doc_archived``.

        :rtype: bool
        """
        return self._tag == 'doc_archived'

    def is_doc_deleted(self):
        """
        Check if the union tag is ``doc_deleted``.

        :rtype: bool
        """
        return self._tag == 'doc_deleted'

    def _process_custom_annotations(self, annotation_type, processor):
        super(PaperDocUpdateError, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'PaperDocUpdateError(%r, %r)' % (self._tag, self._value)

PaperDocUpdateError_validator = bv.Union(PaperDocUpdateError)

class PaperDocUpdatePolicy(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar append: The content will be appended to the doc.
    :ivar prepend: The content will be prepended to the doc. Note: the doc title
        will not be affected.
    :ivar overwrite_all: The document will be overwitten at the head with the
        provided content.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    append = None
    # Attribute is overwritten below the class definition
    prepend = None
    # Attribute is overwritten below the class definition
    overwrite_all = None
    # Attribute is overwritten below the class definition
    other = None

    def is_append(self):
        """
        Check if the union tag is ``append``.

        :rtype: bool
        """
        return self._tag == 'append'

    def is_prepend(self):
        """
        Check if the union tag is ``prepend``.

        :rtype: bool
        """
        return self._tag == 'prepend'

    def is_overwrite_all(self):
        """
        Check if the union tag is ``overwrite_all``.

        :rtype: bool
        """
        return self._tag == 'overwrite_all'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, processor):
        super(PaperDocUpdatePolicy, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'PaperDocUpdatePolicy(%r, %r)' % (self._tag, self._value)

PaperDocUpdatePolicy_validator = bv.Union(PaperDocUpdatePolicy)

class RemovePaperDocUser(RefPaperDoc):
    """
    :ivar member: User which should be removed from the Paper doc. Specify only
        email address or Dropbox account ID.
    """

    __slots__ = [
        '_member_value',
        '_member_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 doc_id=None,
                 member=None):
        super(RemovePaperDocUser, self).__init__(doc_id)
        self._member_value = None
        self._member_present = False
        if member is not None:
            self.member = member

    @property
    def member(self):
        """
        User which should be removed from the Paper doc. Specify only email
        address or Dropbox account ID.

        :rtype: sharing.MemberSelector
        """
        if self._member_present:
            return self._member_value
        else:
            raise AttributeError("missing required field 'member'")

    @member.setter
    def member(self, val):
        self._member_validator.validate_type_only(val)
        self._member_value = val
        self._member_present = True

    @member.deleter
    def member(self):
        self._member_value = None
        self._member_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(RemovePaperDocUser, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'RemovePaperDocUser(doc_id={!r}, member={!r})'.format(
            self._doc_id_value,
            self._member_value,
        )

RemovePaperDocUser_validator = bv.Struct(RemovePaperDocUser)

class SharingPolicy(bb.Struct):
    """
    Sharing policy of Paper doc.

    :ivar public_sharing_policy: This value applies to the non-team members.
    :ivar team_sharing_policy: This value applies to the team members only. The
        value is null for all personal accounts.
    """

    __slots__ = [
        '_public_sharing_policy_value',
        '_public_sharing_policy_present',
        '_team_sharing_policy_value',
        '_team_sharing_policy_present',
    ]

    _has_required_fields = False

    def __init__(self,
                 public_sharing_policy=None,
                 team_sharing_policy=None):
        self._public_sharing_policy_value = None
        self._public_sharing_policy_present = False
        self._team_sharing_policy_value = None
        self._team_sharing_policy_present = False
        if public_sharing_policy is not None:
            self.public_sharing_policy = public_sharing_policy
        if team_sharing_policy is not None:
            self.team_sharing_policy = team_sharing_policy

    @property
    def public_sharing_policy(self):
        """
        This value applies to the non-team members.

        :rtype: SharingPublicPolicyType
        """
        if self._public_sharing_policy_present:
            return self._public_sharing_policy_value
        else:
            return None

    @public_sharing_policy.setter
    def public_sharing_policy(self, val):
        if val is None:
            del self.public_sharing_policy
            return
        self._public_sharing_policy_validator.validate_type_only(val)
        self._public_sharing_policy_value = val
        self._public_sharing_policy_present = True

    @public_sharing_policy.deleter
    def public_sharing_policy(self):
        self._public_sharing_policy_value = None
        self._public_sharing_policy_present = False

    @property
    def team_sharing_policy(self):
        """
        This value applies to the team members only. The value is null for all
        personal accounts.

        :rtype: SharingTeamPolicyType
        """
        if self._team_sharing_policy_present:
            return self._team_sharing_policy_value
        else:
            return None

    @team_sharing_policy.setter
    def team_sharing_policy(self, val):
        if val is None:
            del self.team_sharing_policy
            return
        self._team_sharing_policy_validator.validate_type_only(val)
        self._team_sharing_policy_value = val
        self._team_sharing_policy_present = True

    @team_sharing_policy.deleter
    def team_sharing_policy(self):
        self._team_sharing_policy_value = None
        self._team_sharing_policy_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(SharingPolicy, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'SharingPolicy(public_sharing_policy={!r}, team_sharing_policy={!r})'.format(
            self._public_sharing_policy_value,
            self._team_sharing_policy_value,
        )

SharingPolicy_validator = bv.Struct(SharingPolicy)

class SharingTeamPolicyType(bb.Union):
    """
    The sharing policy type of the Paper doc.

    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar people_with_link_can_edit: Users who have a link to this doc can edit
        it.
    :ivar people_with_link_can_view_and_comment: Users who have a link to this
        doc can view and comment on it.
    :ivar invite_only: Users must be explicitly invited to this doc.
    """

    _catch_all = None
    # Attribute is overwritten below the class definition
    people_with_link_can_edit = None
    # Attribute is overwritten below the class definition
    people_with_link_can_view_and_comment = None
    # Attribute is overwritten below the class definition
    invite_only = None

    def is_people_with_link_can_edit(self):
        """
        Check if the union tag is ``people_with_link_can_edit``.

        :rtype: bool
        """
        return self._tag == 'people_with_link_can_edit'

    def is_people_with_link_can_view_and_comment(self):
        """
        Check if the union tag is ``people_with_link_can_view_and_comment``.

        :rtype: bool
        """
        return self._tag == 'people_with_link_can_view_and_comment'

    def is_invite_only(self):
        """
        Check if the union tag is ``invite_only``.

        :rtype: bool
        """
        return self._tag == 'invite_only'

    def _process_custom_annotations(self, annotation_type, processor):
        super(SharingTeamPolicyType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'SharingTeamPolicyType(%r, %r)' % (self._tag, self._value)

SharingTeamPolicyType_validator = bv.Union(SharingTeamPolicyType)

class SharingPublicPolicyType(SharingTeamPolicyType):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar disabled: Value used to indicate that doc sharing is enabled only
        within team.
    """

    # Attribute is overwritten below the class definition
    disabled = None

    def is_disabled(self):
        """
        Check if the union tag is ``disabled``.

        :rtype: bool
        """
        return self._tag == 'disabled'

    def _process_custom_annotations(self, annotation_type, processor):
        super(SharingPublicPolicyType, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'SharingPublicPolicyType(%r, %r)' % (self._tag, self._value)

SharingPublicPolicyType_validator = bv.Union(SharingPublicPolicyType)

class UserInfoWithPermissionLevel(bb.Struct):
    """
    :ivar user: User shared on the Paper doc.
    :ivar permission_level: Permission level for the user.
    """

    __slots__ = [
        '_user_value',
        '_user_present',
        '_permission_level_value',
        '_permission_level_present',
    ]

    _has_required_fields = True

    def __init__(self,
                 user=None,
                 permission_level=None):
        self._user_value = None
        self._user_present = False
        self._permission_level_value = None
        self._permission_level_present = False
        if user is not None:
            self.user = user
        if permission_level is not None:
            self.permission_level = permission_level

    @property
    def user(self):
        """
        User shared on the Paper doc.

        :rtype: sharing.UserInfo
        """
        if self._user_present:
            return self._user_value
        else:
            raise AttributeError("missing required field 'user'")

    @user.setter
    def user(self, val):
        self._user_validator.validate_type_only(val)
        self._user_value = val
        self._user_present = True

    @user.deleter
    def user(self):
        self._user_value = None
        self._user_present = False

    @property
    def permission_level(self):
        """
        Permission level for the user.

        :rtype: PaperDocPermissionLevel
        """
        if self._permission_level_present:
            return self._permission_level_value
        else:
            raise AttributeError("missing required field 'permission_level'")

    @permission_level.setter
    def permission_level(self, val):
        self._permission_level_validator.validate_type_only(val)
        self._permission_level_value = val
        self._permission_level_present = True

    @permission_level.deleter
    def permission_level(self):
        self._permission_level_value = None
        self._permission_level_present = False

    def _process_custom_annotations(self, annotation_type, processor):
        super(UserInfoWithPermissionLevel, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'UserInfoWithPermissionLevel(user={!r}, permission_level={!r})'.format(
            self._user_value,
            self._permission_level_value,
        )

UserInfoWithPermissionLevel_validator = bv.Struct(UserInfoWithPermissionLevel)

class UserOnPaperDocFilter(bb.Union):
    """
    This class acts as a tagged union. Only one of the ``is_*`` methods will
    return true. To get the associated value of a tag (if one exists), use the
    corresponding ``get_*`` method.

    :ivar visited: all users who have visited the Paper doc.
    :ivar shared: All uses who are shared on the Paper doc. This includes all
        users who have visited the Paper doc as well as those who have not.
    """

    _catch_all = 'other'
    # Attribute is overwritten below the class definition
    visited = None
    # Attribute is overwritten below the class definition
    shared = None
    # Attribute is overwritten below the class definition
    other = None

    def is_visited(self):
        """
        Check if the union tag is ``visited``.

        :rtype: bool
        """
        return self._tag == 'visited'

    def is_shared(self):
        """
        Check if the union tag is ``shared``.

        :rtype: bool
        """
        return self._tag == 'shared'

    def is_other(self):
        """
        Check if the union tag is ``other``.

        :rtype: bool
        """
        return self._tag == 'other'

    def _process_custom_annotations(self, annotation_type, processor):
        super(UserOnPaperDocFilter, self)._process_custom_annotations(annotation_type, processor)

    def __repr__(self):
        return 'UserOnPaperDocFilter(%r, %r)' % (self._tag, self._value)

UserOnPaperDocFilter_validator = bv.Union(UserOnPaperDocFilter)

# Paper doc ID.
PaperDocId_validator = bv.String()
AddMember._permission_level_validator = PaperDocPermissionLevel_validator
AddMember._member_validator = sharing.MemberSelector_validator
AddMember._all_field_names_ = set([
    'permission_level',
    'member',
])
AddMember._all_fields_ = [
    ('permission_level', AddMember._permission_level_validator),
    ('member', AddMember._member_validator),
]

RefPaperDoc._doc_id_validator = PaperDocId_validator
RefPaperDoc._all_field_names_ = set(['doc_id'])
RefPaperDoc._all_fields_ = [('doc_id', RefPaperDoc._doc_id_validator)]

AddPaperDocUser._members_validator = bv.List(AddMember_validator, max_items=20)
AddPaperDocUser._custom_message_validator = bv.Nullable(bv.String())
AddPaperDocUser._quiet_validator = bv.Boolean()
AddPaperDocUser._all_field_names_ = RefPaperDoc._all_field_names_.union(set([
    'members',
    'custom_message',
    'quiet',
]))
AddPaperDocUser._all_fields_ = RefPaperDoc._all_fields_ + [
    ('members', AddPaperDocUser._members_validator),
    ('custom_message', AddPaperDocUser._custom_message_validator),
    ('quiet', AddPaperDocUser._quiet_validator),
]

AddPaperDocUserMemberResult._member_validator = sharing.MemberSelector_validator
AddPaperDocUserMemberResult._result_validator = AddPaperDocUserResult_validator
AddPaperDocUserMemberResult._all_field_names_ = set([
    'member',
    'result',
])
AddPaperDocUserMemberResult._all_fields_ = [
    ('member', AddPaperDocUserMemberResult._member_validator),
    ('result', AddPaperDocUserMemberResult._result_validator),
]

AddPaperDocUserResult._success_validator = bv.Void()
AddPaperDocUserResult._unknown_error_validator = bv.Void()
AddPaperDocUserResult._sharing_outside_team_disabled_validator = bv.Void()
AddPaperDocUserResult._daily_limit_reached_validator = bv.Void()
AddPaperDocUserResult._user_is_owner_validator = bv.Void()
AddPaperDocUserResult._failed_user_data_retrieval_validator = bv.Void()
AddPaperDocUserResult._permission_already_granted_validator = bv.Void()
AddPaperDocUserResult._other_validator = bv.Void()
AddPaperDocUserResult._tagmap = {
    'success': AddPaperDocUserResult._success_validator,
    'unknown_error': AddPaperDocUserResult._unknown_error_validator,
    'sharing_outside_team_disabled': AddPaperDocUserResult._sharing_outside_team_disabled_validator,
    'daily_limit_reached': AddPaperDocUserResult._daily_limit_reached_validator,
    'user_is_owner': AddPaperDocUserResult._user_is_owner_validator,
    'failed_user_data_retrieval': AddPaperDocUserResult._failed_user_data_retrieval_validator,
    'permission_already_granted': AddPaperDocUserResult._permission_already_granted_validator,
    'other': AddPaperDocUserResult._other_validator,
}

AddPaperDocUserResult.success = AddPaperDocUserResult('success')
AddPaperDocUserResult.unknown_error = AddPaperDocUserResult('unknown_error')
AddPaperDocUserResult.sharing_outside_team_disabled = AddPaperDocUserResult('sharing_outside_team_disabled')
AddPaperDocUserResult.daily_limit_reached = AddPaperDocUserResult('daily_limit_reached')
AddPaperDocUserResult.user_is_owner = AddPaperDocUserResult('user_is_owner')
AddPaperDocUserResult.failed_user_data_retrieval = AddPaperDocUserResult('failed_user_data_retrieval')
AddPaperDocUserResult.permission_already_granted = AddPaperDocUserResult('permission_already_granted')
AddPaperDocUserResult.other = AddPaperDocUserResult('other')

Cursor._value_validator = bv.String()
Cursor._expiration_validator = bv.Nullable(common.DropboxTimestamp_validator)
Cursor._all_field_names_ = set([
    'value',
    'expiration',
])
Cursor._all_fields_ = [
    ('value', Cursor._value_validator),
    ('expiration', Cursor._expiration_validator),
]

PaperApiBaseError._insufficient_permissions_validator = bv.Void()
PaperApiBaseError._other_validator = bv.Void()
PaperApiBaseError._tagmap = {
    'insufficient_permissions': PaperApiBaseError._insufficient_permissions_validator,
    'other': PaperApiBaseError._other_validator,
}

PaperApiBaseError.insufficient_permissions = PaperApiBaseError('insufficient_permissions')
PaperApiBaseError.other = PaperApiBaseError('other')

DocLookupError._doc_not_found_validator = bv.Void()
DocLookupError._tagmap = {
    'doc_not_found': DocLookupError._doc_not_found_validator,
}
DocLookupError._tagmap.update(PaperApiBaseError._tagmap)

DocLookupError.doc_not_found = DocLookupError('doc_not_found')

DocSubscriptionLevel._default_validator = bv.Void()
DocSubscriptionLevel._ignore_validator = bv.Void()
DocSubscriptionLevel._every_validator = bv.Void()
DocSubscriptionLevel._no_email_validator = bv.Void()
DocSubscriptionLevel._tagmap = {
    'default': DocSubscriptionLevel._default_validator,
    'ignore': DocSubscriptionLevel._ignore_validator,
    'every': DocSubscriptionLevel._every_validator,
    'no_email': DocSubscriptionLevel._no_email_validator,
}

DocSubscriptionLevel.default = DocSubscriptionLevel('default')
DocSubscriptionLevel.ignore = DocSubscriptionLevel('ignore')
DocSubscriptionLevel.every = DocSubscriptionLevel('every')
DocSubscriptionLevel.no_email = DocSubscriptionLevel('no_email')

ExportFormat._html_validator = bv.Void()
ExportFormat._markdown_validator = bv.Void()
ExportFormat._other_validator = bv.Void()
ExportFormat._tagmap = {
    'html': ExportFormat._html_validator,
    'markdown': ExportFormat._markdown_validator,
    'other': ExportFormat._other_validator,
}

ExportFormat.html = ExportFormat('html')
ExportFormat.markdown = ExportFormat('markdown')
ExportFormat.other = ExportFormat('other')

Folder._id_validator = bv.String()
Folder._name_validator = bv.String()
Folder._all_field_names_ = set([
    'id',
    'name',
])
Folder._all_fields_ = [
    ('id', Folder._id_validator),
    ('name', Folder._name_validator),
]

FolderSharingPolicyType._team_validator = bv.Void()
FolderSharingPolicyType._invite_only_validator = bv.Void()
FolderSharingPolicyType._tagmap = {
    'team': FolderSharingPolicyType._team_validator,
    'invite_only': FolderSharingPolicyType._invite_only_validator,
}

FolderSharingPolicyType.team = FolderSharingPolicyType('team')
FolderSharingPolicyType.invite_only = FolderSharingPolicyType('invite_only')

FolderSubscriptionLevel._none_validator = bv.Void()
FolderSubscriptionLevel._activity_only_validator = bv.Void()
FolderSubscriptionLevel._daily_emails_validator = bv.Void()
FolderSubscriptionLevel._weekly_emails_validator = bv.Void()
FolderSubscriptionLevel._tagmap = {
    'none': FolderSubscriptionLevel._none_validator,
    'activity_only': FolderSubscriptionLevel._activity_only_validator,
    'daily_emails': FolderSubscriptionLevel._daily_emails_validator,
    'weekly_emails': FolderSubscriptionLevel._weekly_emails_validator,
}

FolderSubscriptionLevel.none = FolderSubscriptionLevel('none')
FolderSubscriptionLevel.activity_only = FolderSubscriptionLevel('activity_only')
FolderSubscriptionLevel.daily_emails = FolderSubscriptionLevel('daily_emails')
FolderSubscriptionLevel.weekly_emails = FolderSubscriptionLevel('weekly_emails')

FoldersContainingPaperDoc._folder_sharing_policy_type_validator = bv.Nullable(FolderSharingPolicyType_validator)
FoldersContainingPaperDoc._folders_validator = bv.Nullable(bv.List(Folder_validator))
FoldersContainingPaperDoc._all_field_names_ = set([
    'folder_sharing_policy_type',
    'folders',
])
FoldersContainingPaperDoc._all_fields_ = [
    ('folder_sharing_policy_type', FoldersContainingPaperDoc._folder_sharing_policy_type_validator),
    ('folders', FoldersContainingPaperDoc._folders_validator),
]

ImportFormat._html_validator = bv.Void()
ImportFormat._markdown_validator = bv.Void()
ImportFormat._plain_text_validator = bv.Void()
ImportFormat._other_validator = bv.Void()
ImportFormat._tagmap = {
    'html': ImportFormat._html_validator,
    'markdown': ImportFormat._markdown_validator,
    'plain_text': ImportFormat._plain_text_validator,
    'other': ImportFormat._other_validator,
}

ImportFormat.html = ImportFormat('html')
ImportFormat.markdown = ImportFormat('markdown')
ImportFormat.plain_text = ImportFormat('plain_text')
ImportFormat.other = ImportFormat('other')

InviteeInfoWithPermissionLevel._invitee_validator = sharing.InviteeInfo_validator
InviteeInfoWithPermissionLevel._permission_level_validator = PaperDocPermissionLevel_validator
InviteeInfoWithPermissionLevel._all_field_names_ = set([
    'invitee',
    'permission_level',
])
InviteeInfoWithPermissionLevel._all_fields_ = [
    ('invitee', InviteeInfoWithPermissionLevel._invitee_validator),
    ('permission_level', InviteeInfoWithPermissionLevel._permission_level_validator),
]

ListDocsCursorError._cursor_error_validator = PaperApiCursorError_validator
ListDocsCursorError._other_validator = bv.Void()
ListDocsCursorError._tagmap = {
    'cursor_error': ListDocsCursorError._cursor_error_validator,
    'other': ListDocsCursorError._other_validator,
}

ListDocsCursorError.other = ListDocsCursorError('other')

ListPaperDocsArgs._filter_by_validator = ListPaperDocsFilterBy_validator
ListPaperDocsArgs._sort_by_validator = ListPaperDocsSortBy_validator
ListPaperDocsArgs._sort_order_validator = ListPaperDocsSortOrder_validator
ListPaperDocsArgs._limit_validator = bv.Int32(min_value=1, max_value=1000)
ListPaperDocsArgs._all_field_names_ = set([
    'filter_by',
    'sort_by',
    'sort_order',
    'limit',
])
ListPaperDocsArgs._all_fields_ = [
    ('filter_by', ListPaperDocsArgs._filter_by_validator),
    ('sort_by', ListPaperDocsArgs._sort_by_validator),
    ('sort_order', ListPaperDocsArgs._sort_order_validator),
    ('limit', ListPaperDocsArgs._limit_validator),
]

ListPaperDocsContinueArgs._cursor_validator = bv.String()
ListPaperDocsContinueArgs._all_field_names_ = set(['cursor'])
ListPaperDocsContinueArgs._all_fields_ = [('cursor', ListPaperDocsContinueArgs._cursor_validator)]

ListPaperDocsFilterBy._docs_accessed_validator = bv.Void()
ListPaperDocsFilterBy._docs_created_validator = bv.Void()
ListPaperDocsFilterBy._other_validator = bv.Void()
ListPaperDocsFilterBy._tagmap = {
    'docs_accessed': ListPaperDocsFilterBy._docs_accessed_validator,
    'docs_created': ListPaperDocsFilterBy._docs_created_validator,
    'other': ListPaperDocsFilterBy._other_validator,
}

ListPaperDocsFilterBy.docs_accessed = ListPaperDocsFilterBy('docs_accessed')
ListPaperDocsFilterBy.docs_created = ListPaperDocsFilterBy('docs_created')
ListPaperDocsFilterBy.other = ListPaperDocsFilterBy('other')

ListPaperDocsResponse._doc_ids_validator = bv.List(PaperDocId_validator)
ListPaperDocsResponse._cursor_validator = Cursor_validator
ListPaperDocsResponse._has_more_validator = bv.Boolean()
ListPaperDocsResponse._all_field_names_ = set([
    'doc_ids',
    'cursor',
    'has_more',
])
ListPaperDocsResponse._all_fields_ = [
    ('doc_ids', ListPaperDocsResponse._doc_ids_validator),
    ('cursor', ListPaperDocsResponse._cursor_validator),
    ('has_more', ListPaperDocsResponse._has_more_validator),
]

ListPaperDocsSortBy._accessed_validator = bv.Void()
ListPaperDocsSortBy._modified_validator = bv.Void()
ListPaperDocsSortBy._created_validator = bv.Void()
ListPaperDocsSortBy._other_validator = bv.Void()
ListPaperDocsSortBy._tagmap = {
    'accessed': ListPaperDocsSortBy._accessed_validator,
    'modified': ListPaperDocsSortBy._modified_validator,
    'created': ListPaperDocsSortBy._created_validator,
    'other': ListPaperDocsSortBy._other_validator,
}

ListPaperDocsSortBy.accessed = ListPaperDocsSortBy('accessed')
ListPaperDocsSortBy.modified = ListPaperDocsSortBy('modified')
ListPaperDocsSortBy.created = ListPaperDocsSortBy('created')
ListPaperDocsSortBy.other = ListPaperDocsSortBy('other')

ListPaperDocsSortOrder._ascending_validator = bv.Void()
ListPaperDocsSortOrder._descending_validator = bv.Void()
ListPaperDocsSortOrder._other_validator = bv.Void()
ListPaperDocsSortOrder._tagmap = {
    'ascending': ListPaperDocsSortOrder._ascending_validator,
    'descending': ListPaperDocsSortOrder._descending_validator,
    'other': ListPaperDocsSortOrder._other_validator,
}

ListPaperDocsSortOrder.ascending = ListPaperDocsSortOrder('ascending')
ListPaperDocsSortOrder.descending = ListPaperDocsSortOrder('descending')
ListPaperDocsSortOrder.other = ListPaperDocsSortOrder('other')

ListUsersCursorError._doc_not_found_validator = bv.Void()
ListUsersCursorError._cursor_error_validator = PaperApiCursorError_validator
ListUsersCursorError._tagmap = {
    'doc_not_found': ListUsersCursorError._doc_not_found_validator,
    'cursor_error': ListUsersCursorError._cursor_error_validator,
}
ListUsersCursorError._tagmap.update(PaperApiBaseError._tagmap)

ListUsersCursorError.doc_not_found = ListUsersCursorError('doc_not_found')

ListUsersOnFolderArgs._limit_validator = bv.Int32(min_value=1, max_value=1000)
ListUsersOnFolderArgs._all_field_names_ = RefPaperDoc._all_field_names_.union(set(['limit']))
ListUsersOnFolderArgs._all_fields_ = RefPaperDoc._all_fields_ + [('limit', ListUsersOnFolderArgs._limit_validator)]

ListUsersOnFolderContinueArgs._cursor_validator = bv.String()
ListUsersOnFolderContinueArgs._all_field_names_ = RefPaperDoc._all_field_names_.union(set(['cursor']))
ListUsersOnFolderContinueArgs._all_fields_ = RefPaperDoc._all_fields_ + [('cursor', ListUsersOnFolderContinueArgs._cursor_validator)]

ListUsersOnFolderResponse._invitees_validator = bv.List(sharing.InviteeInfo_validator)
ListUsersOnFolderResponse._users_validator = bv.List(sharing.UserInfo_validator)
ListUsersOnFolderResponse._cursor_validator = Cursor_validator
ListUsersOnFolderResponse._has_more_validator = bv.Boolean()
ListUsersOnFolderResponse._all_field_names_ = set([
    'invitees',
    'users',
    'cursor',
    'has_more',
])
ListUsersOnFolderResponse._all_fields_ = [
    ('invitees', ListUsersOnFolderResponse._invitees_validator),
    ('users', ListUsersOnFolderResponse._users_validator),
    ('cursor', ListUsersOnFolderResponse._cursor_validator),
    ('has_more', ListUsersOnFolderResponse._has_more_validator),
]

ListUsersOnPaperDocArgs._limit_validator = bv.Int32(min_value=1, max_value=1000)
ListUsersOnPaperDocArgs._filter_by_validator = UserOnPaperDocFilter_validator
ListUsersOnPaperDocArgs._all_field_names_ = RefPaperDoc._all_field_names_.union(set([
    'limit',
    'filter_by',
]))
ListUsersOnPaperDocArgs._all_fields_ = RefPaperDoc._all_fields_ + [
    ('limit', ListUsersOnPaperDocArgs._limit_validator),
    ('filter_by', ListUsersOnPaperDocArgs._filter_by_validator),
]

ListUsersOnPaperDocContinueArgs._cursor_validator = bv.String()
ListUsersOnPaperDocContinueArgs._all_field_names_ = RefPaperDoc._all_field_names_.union(set(['cursor']))
ListUsersOnPaperDocContinueArgs._all_fields_ = RefPaperDoc._all_fields_ + [('cursor', ListUsersOnPaperDocContinueArgs._cursor_validator)]

ListUsersOnPaperDocResponse._invitees_validator = bv.List(InviteeInfoWithPermissionLevel_validator)
ListUsersOnPaperDocResponse._users_validator = bv.List(UserInfoWithPermissionLevel_validator)
ListUsersOnPaperDocResponse._doc_owner_validator = sharing.UserInfo_validator
ListUsersOnPaperDocResponse._cursor_validator = Cursor_validator
ListUsersOnPaperDocResponse._has_more_validator = bv.Boolean()
ListUsersOnPaperDocResponse._all_field_names_ = set([
    'invitees',
    'users',
    'doc_owner',
    'cursor',
    'has_more',
])
ListUsersOnPaperDocResponse._all_fields_ = [
    ('invitees', ListUsersOnPaperDocResponse._invitees_validator),
    ('users', ListUsersOnPaperDocResponse._users_validator),
    ('doc_owner', ListUsersOnPaperDocResponse._doc_owner_validator),
    ('cursor', ListUsersOnPaperDocResponse._cursor_validator),
    ('has_more', ListUsersOnPaperDocResponse._has_more_validator),
]

PaperApiCursorError._expired_cursor_validator = bv.Void()
PaperApiCursorError._invalid_cursor_validator = bv.Void()
PaperApiCursorError._wrong_user_in_cursor_validator = bv.Void()
PaperApiCursorError._reset_validator = bv.Void()
PaperApiCursorError._other_validator = bv.Void()
PaperApiCursorError._tagmap = {
    'expired_cursor': PaperApiCursorError._expired_cursor_validator,
    'invalid_cursor': PaperApiCursorError._invalid_cursor_validator,
    'wrong_user_in_cursor': PaperApiCursorError._wrong_user_in_cursor_validator,
    'reset': PaperApiCursorError._reset_validator,
    'other': PaperApiCursorError._other_validator,
}

PaperApiCursorError.expired_cursor = PaperApiCursorError('expired_cursor')
PaperApiCursorError.invalid_cursor = PaperApiCursorError('invalid_cursor')
PaperApiCursorError.wrong_user_in_cursor = PaperApiCursorError('wrong_user_in_cursor')
PaperApiCursorError.reset = PaperApiCursorError('reset')
PaperApiCursorError.other = PaperApiCursorError('other')

PaperDocCreateArgs._parent_folder_id_validator = bv.Nullable(bv.String())
PaperDocCreateArgs._import_format_validator = ImportFormat_validator
PaperDocCreateArgs._all_field_names_ = set([
    'parent_folder_id',
    'import_format',
])
PaperDocCreateArgs._all_fields_ = [
    ('parent_folder_id', PaperDocCreateArgs._parent_folder_id_validator),
    ('import_format', PaperDocCreateArgs._import_format_validator),
]

PaperDocCreateError._content_malformed_validator = bv.Void()
PaperDocCreateError._folder_not_found_validator = bv.Void()
PaperDocCreateError._doc_length_exceeded_validator = bv.Void()
PaperDocCreateError._image_size_exceeded_validator = bv.Void()
PaperDocCreateError._tagmap = {
    'content_malformed': PaperDocCreateError._content_malformed_validator,
    'folder_not_found': PaperDocCreateError._folder_not_found_validator,
    'doc_length_exceeded': PaperDocCreateError._doc_length_exceeded_validator,
    'image_size_exceeded': PaperDocCreateError._image_size_exceeded_validator,
}
PaperDocCreateError._tagmap.update(PaperApiBaseError._tagmap)

PaperDocCreateError.content_malformed = PaperDocCreateError('content_malformed')
PaperDocCreateError.folder_not_found = PaperDocCreateError('folder_not_found')
PaperDocCreateError.doc_length_exceeded = PaperDocCreateError('doc_length_exceeded')
PaperDocCreateError.image_size_exceeded = PaperDocCreateError('image_size_exceeded')

PaperDocCreateUpdateResult._doc_id_validator = bv.String()
PaperDocCreateUpdateResult._revision_validator = bv.Int64()
PaperDocCreateUpdateResult._title_validator = bv.String()
PaperDocCreateUpdateResult._all_field_names_ = set([
    'doc_id',
    'revision',
    'title',
])
PaperDocCreateUpdateResult._all_fields_ = [
    ('doc_id', PaperDocCreateUpdateResult._doc_id_validator),
    ('revision', PaperDocCreateUpdateResult._revision_validator),
    ('title', PaperDocCreateUpdateResult._title_validator),
]

PaperDocExport._export_format_validator = ExportFormat_validator
PaperDocExport._all_field_names_ = RefPaperDoc._all_field_names_.union(set(['export_format']))
PaperDocExport._all_fields_ = RefPaperDoc._all_fields_ + [('export_format', PaperDocExport._export_format_validator)]

PaperDocExportResult._owner_validator = bv.String()
PaperDocExportResult._title_validator = bv.String()
PaperDocExportResult._revision_validator = bv.Int64()
PaperDocExportResult._mime_type_validator = bv.String()
PaperDocExportResult._all_field_names_ = set([
    'owner',
    'title',
    'revision',
    'mime_type',
])
PaperDocExportResult._all_fields_ = [
    ('owner', PaperDocExportResult._owner_validator),
    ('title', PaperDocExportResult._title_validator),
    ('revision', PaperDocExportResult._revision_validator),
    ('mime_type', PaperDocExportResult._mime_type_validator),
]

PaperDocPermissionLevel._edit_validator = bv.Void()
PaperDocPermissionLevel._view_and_comment_validator = bv.Void()
PaperDocPermissionLevel._other_validator = bv.Void()
PaperDocPermissionLevel._tagmap = {
    'edit': PaperDocPermissionLevel._edit_validator,
    'view_and_comment': PaperDocPermissionLevel._view_and_comment_validator,
    'other': PaperDocPermissionLevel._other_validator,
}

PaperDocPermissionLevel.edit = PaperDocPermissionLevel('edit')
PaperDocPermissionLevel.view_and_comment = PaperDocPermissionLevel('view_and_comment')
PaperDocPermissionLevel.other = PaperDocPermissionLevel('other')

PaperDocSharingPolicy._sharing_policy_validator = SharingPolicy_validator
PaperDocSharingPolicy._all_field_names_ = RefPaperDoc._all_field_names_.union(set(['sharing_policy']))
PaperDocSharingPolicy._all_fields_ = RefPaperDoc._all_fields_ + [('sharing_policy', PaperDocSharingPolicy._sharing_policy_validator)]

PaperDocUpdateArgs._doc_update_policy_validator = PaperDocUpdatePolicy_validator
PaperDocUpdateArgs._revision_validator = bv.Int64()
PaperDocUpdateArgs._import_format_validator = ImportFormat_validator
PaperDocUpdateArgs._all_field_names_ = RefPaperDoc._all_field_names_.union(set([
    'doc_update_policy',
    'revision',
    'import_format',
]))
PaperDocUpdateArgs._all_fields_ = RefPaperDoc._all_fields_ + [
    ('doc_update_policy', PaperDocUpdateArgs._doc_update_policy_validator),
    ('revision', PaperDocUpdateArgs._revision_validator),
    ('import_format', PaperDocUpdateArgs._import_format_validator),
]

PaperDocUpdateError._content_malformed_validator = bv.Void()
PaperDocUpdateError._revision_mismatch_validator = bv.Void()
PaperDocUpdateError._doc_length_exceeded_validator = bv.Void()
PaperDocUpdateError._image_size_exceeded_validator = bv.Void()
PaperDocUpdateError._doc_archived_validator = bv.Void()
PaperDocUpdateError._doc_deleted_validator = bv.Void()
PaperDocUpdateError._tagmap = {
    'content_malformed': PaperDocUpdateError._content_malformed_validator,
    'revision_mismatch': PaperDocUpdateError._revision_mismatch_validator,
    'doc_length_exceeded': PaperDocUpdateError._doc_length_exceeded_validator,
    'image_size_exceeded': PaperDocUpdateError._image_size_exceeded_validator,
    'doc_archived': PaperDocUpdateError._doc_archived_validator,
    'doc_deleted': PaperDocUpdateError._doc_deleted_validator,
}
PaperDocUpdateError._tagmap.update(DocLookupError._tagmap)

PaperDocUpdateError.content_malformed = PaperDocUpdateError('content_malformed')
PaperDocUpdateError.revision_mismatch = PaperDocUpdateError('revision_mismatch')
PaperDocUpdateError.doc_length_exceeded = PaperDocUpdateError('doc_length_exceeded')
PaperDocUpdateError.image_size_exceeded = PaperDocUpdateError('image_size_exceeded')
PaperDocUpdateError.doc_archived = PaperDocUpdateError('doc_archived')
PaperDocUpdateError.doc_deleted = PaperDocUpdateError('doc_deleted')

PaperDocUpdatePolicy._append_validator = bv.Void()
PaperDocUpdatePolicy._prepend_validator = bv.Void()
PaperDocUpdatePolicy._overwrite_all_validator = bv.Void()
PaperDocUpdatePolicy._other_validator = bv.Void()
PaperDocUpdatePolicy._tagmap = {
    'append': PaperDocUpdatePolicy._append_validator,
    'prepend': PaperDocUpdatePolicy._prepend_validator,
    'overwrite_all': PaperDocUpdatePolicy._overwrite_all_validator,
    'other': PaperDocUpdatePolicy._other_validator,
}

PaperDocUpdatePolicy.append = PaperDocUpdatePolicy('append')
PaperDocUpdatePolicy.prepend = PaperDocUpdatePolicy('prepend')
PaperDocUpdatePolicy.overwrite_all = PaperDocUpdatePolicy('overwrite_all')
PaperDocUpdatePolicy.other = PaperDocUpdatePolicy('other')

RemovePaperDocUser._member_validator = sharing.MemberSelector_validator
RemovePaperDocUser._all_field_names_ = RefPaperDoc._all_field_names_.union(set(['member']))
RemovePaperDocUser._all_fields_ = RefPaperDoc._all_fields_ + [('member', RemovePaperDocUser._member_validator)]

SharingPolicy._public_sharing_policy_validator = bv.Nullable(SharingPublicPolicyType_validator)
SharingPolicy._team_sharing_policy_validator = bv.Nullable(SharingTeamPolicyType_validator)
SharingPolicy._all_field_names_ = set([
    'public_sharing_policy',
    'team_sharing_policy',
])
SharingPolicy._all_fields_ = [
    ('public_sharing_policy', SharingPolicy._public_sharing_policy_validator),
    ('team_sharing_policy', SharingPolicy._team_sharing_policy_validator),
]

SharingTeamPolicyType._people_with_link_can_edit_validator = bv.Void()
SharingTeamPolicyType._people_with_link_can_view_and_comment_validator = bv.Void()
SharingTeamPolicyType._invite_only_validator = bv.Void()
SharingTeamPolicyType._tagmap = {
    'people_with_link_can_edit': SharingTeamPolicyType._people_with_link_can_edit_validator,
    'people_with_link_can_view_and_comment': SharingTeamPolicyType._people_with_link_can_view_and_comment_validator,
    'invite_only': SharingTeamPolicyType._invite_only_validator,
}

SharingTeamPolicyType.people_with_link_can_edit = SharingTeamPolicyType('people_with_link_can_edit')
SharingTeamPolicyType.people_with_link_can_view_and_comment = SharingTeamPolicyType('people_with_link_can_view_and_comment')
SharingTeamPolicyType.invite_only = SharingTeamPolicyType('invite_only')

SharingPublicPolicyType._disabled_validator = bv.Void()
SharingPublicPolicyType._tagmap = {
    'disabled': SharingPublicPolicyType._disabled_validator,
}
SharingPublicPolicyType._tagmap.update(SharingTeamPolicyType._tagmap)

SharingPublicPolicyType.disabled = SharingPublicPolicyType('disabled')

UserInfoWithPermissionLevel._user_validator = sharing.UserInfo_validator
UserInfoWithPermissionLevel._permission_level_validator = PaperDocPermissionLevel_validator
UserInfoWithPermissionLevel._all_field_names_ = set([
    'user',
    'permission_level',
])
UserInfoWithPermissionLevel._all_fields_ = [
    ('user', UserInfoWithPermissionLevel._user_validator),
    ('permission_level', UserInfoWithPermissionLevel._permission_level_validator),
]

UserOnPaperDocFilter._visited_validator = bv.Void()
UserOnPaperDocFilter._shared_validator = bv.Void()
UserOnPaperDocFilter._other_validator = bv.Void()
UserOnPaperDocFilter._tagmap = {
    'visited': UserOnPaperDocFilter._visited_validator,
    'shared': UserOnPaperDocFilter._shared_validator,
    'other': UserOnPaperDocFilter._other_validator,
}

UserOnPaperDocFilter.visited = UserOnPaperDocFilter('visited')
UserOnPaperDocFilter.shared = UserOnPaperDocFilter('shared')
UserOnPaperDocFilter.other = UserOnPaperDocFilter('other')

docs_archive = bb.Route(
    'docs/archive',
    1,
    False,
    RefPaperDoc_validator,
    bv.Void(),
    DocLookupError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
docs_create = bb.Route(
    'docs/create',
    1,
    False,
    PaperDocCreateArgs_validator,
    PaperDocCreateUpdateResult_validator,
    PaperDocCreateError_validator,
    {'host': u'api',
     'style': u'upload'},
)
docs_download = bb.Route(
    'docs/download',
    1,
    False,
    PaperDocExport_validator,
    PaperDocExportResult_validator,
    DocLookupError_validator,
    {'host': u'api',
     'style': u'download'},
)
docs_folder_users_list = bb.Route(
    'docs/folder_users/list',
    1,
    False,
    ListUsersOnFolderArgs_validator,
    ListUsersOnFolderResponse_validator,
    DocLookupError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
docs_folder_users_list_continue = bb.Route(
    'docs/folder_users/list/continue',
    1,
    False,
    ListUsersOnFolderContinueArgs_validator,
    ListUsersOnFolderResponse_validator,
    ListUsersCursorError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
docs_get_folder_info = bb.Route(
    'docs/get_folder_info',
    1,
    False,
    RefPaperDoc_validator,
    FoldersContainingPaperDoc_validator,
    DocLookupError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
docs_list = bb.Route(
    'docs/list',
    1,
    False,
    ListPaperDocsArgs_validator,
    ListPaperDocsResponse_validator,
    bv.Void(),
    {'host': u'api',
     'style': u'rpc'},
)
docs_list_continue = bb.Route(
    'docs/list/continue',
    1,
    False,
    ListPaperDocsContinueArgs_validator,
    ListPaperDocsResponse_validator,
    ListDocsCursorError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
docs_permanently_delete = bb.Route(
    'docs/permanently_delete',
    1,
    False,
    RefPaperDoc_validator,
    bv.Void(),
    DocLookupError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
docs_sharing_policy_get = bb.Route(
    'docs/sharing_policy/get',
    1,
    False,
    RefPaperDoc_validator,
    SharingPolicy_validator,
    DocLookupError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
docs_sharing_policy_set = bb.Route(
    'docs/sharing_policy/set',
    1,
    False,
    PaperDocSharingPolicy_validator,
    bv.Void(),
    DocLookupError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
docs_update = bb.Route(
    'docs/update',
    1,
    False,
    PaperDocUpdateArgs_validator,
    PaperDocCreateUpdateResult_validator,
    PaperDocUpdateError_validator,
    {'host': u'api',
     'style': u'upload'},
)
docs_users_add = bb.Route(
    'docs/users/add',
    1,
    False,
    AddPaperDocUser_validator,
    bv.List(AddPaperDocUserMemberResult_validator),
    DocLookupError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
docs_users_list = bb.Route(
    'docs/users/list',
    1,
    False,
    ListUsersOnPaperDocArgs_validator,
    ListUsersOnPaperDocResponse_validator,
    DocLookupError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
docs_users_list_continue = bb.Route(
    'docs/users/list/continue',
    1,
    False,
    ListUsersOnPaperDocContinueArgs_validator,
    ListUsersOnPaperDocResponse_validator,
    ListUsersCursorError_validator,
    {'host': u'api',
     'style': u'rpc'},
)
docs_users_remove = bb.Route(
    'docs/users/remove',
    1,
    False,
    RemovePaperDocUser_validator,
    bv.Void(),
    DocLookupError_validator,
    {'host': u'api',
     'style': u'rpc'},
)

ROUTES = {
    'docs/archive': docs_archive,
    'docs/create': docs_create,
    'docs/download': docs_download,
    'docs/folder_users/list': docs_folder_users_list,
    'docs/folder_users/list/continue': docs_folder_users_list_continue,
    'docs/get_folder_info': docs_get_folder_info,
    'docs/list': docs_list,
    'docs/list/continue': docs_list_continue,
    'docs/permanently_delete': docs_permanently_delete,
    'docs/sharing_policy/get': docs_sharing_policy_get,
    'docs/sharing_policy/set': docs_sharing_policy_set,
    'docs/update': docs_update,
    'docs/users/add': docs_users_add,
    'docs/users/list': docs_users_list,
    'docs/users/list/continue': docs_users_list_continue,
    'docs/users/remove': docs_users_remove,
}

