/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.security.AccessController;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import sun.misc.Hashing;
import sun.misc.SharedSecrets;
import sun.misc.VM;
import sun.security.action.GetPropertyAction;

public class Hashtable<K, V>
extends Dictionary<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private transient Entry<K, V>[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private transient int modCount = 0;
    private static final long serialVersionUID = 1421746759512286392L;
    static final int ALTERNATIVE_HASHING_THRESHOLD_DEFAULT = Integer.MAX_VALUE;
    transient int hashSeed;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private volatile transient Set<K> keySet = null;
    private volatile transient Set<Map.Entry<K, V>> entrySet = null;
    private volatile transient Collection<V> values = null;
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;

    final boolean initHashSeedAsNeeded(int capacity) {
        boolean useAltHashing;
        boolean currentAltHashing = this.hashSeed != 0;
        boolean switching = currentAltHashing ^ (useAltHashing = VM.isBooted() && capacity >= Holder.ALTERNATIVE_HASHING_THRESHOLD);
        if (switching) {
            this.hashSeed = useAltHashing ? Hashing.randomHashSeed(this) : 0;
        }
        return switching;
    }

    private int hash(Object k) {
        return this.hashSeed ^ k.hashCode();
    }

    public Hashtable(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal Load: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)Math.min((float)initialCapacity * loadFactor, 2.1474836E9f);
        this.initHashSeedAsNeeded(initialCapacity);
    }

    public Hashtable(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public Hashtable() {
        this(11, 0.75f);
    }

    public Hashtable(Map<? extends K, ? extends V> t) {
        this(Math.max(2 * t.size(), 11), 0.75f);
        this.putAll(t);
    }

    @Override
    public synchronized int size() {
        return this.count;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public synchronized Enumeration<K> keys() {
        return this.getEnumeration(0);
    }

    @Override
    public synchronized Enumeration<V> elements() {
        return this.getEnumeration(1);
    }

    public synchronized boolean contains(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Entry<K, V>[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            Entry<K, V> e = tab[i];
            while (e != null) {
                if (e.value.equals(value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.contains(value);
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        Entry<K, V>[] tab = this.table;
        int hash = this.hash(key);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<K, V> e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    @Override
    public synchronized V get(Object key) {
        Entry<K, V>[] tab = this.table;
        int hash = this.hash(key);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<K, V> e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        Entry<K, V>[] oldMap = this.table;
        int newCapacity = (oldCapacity << 1) + 1;
        if (newCapacity - 0x7FFFFFF7 > 0) {
            if (oldCapacity == 0x7FFFFFF7) {
                return;
            }
            newCapacity = 0x7FFFFFF7;
        }
        Entry[] newMap = new Entry[newCapacity];
        ++this.modCount;
        this.threshold = (int)Math.min((float)newCapacity * this.loadFactor, 2.1474836E9f);
        boolean rehash = this.initHashSeedAsNeeded(newCapacity);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry<K, V> old = oldMap[i];
            while (old != null) {
                Entry<K, V> e = old;
                old = old.next;
                if (rehash) {
                    e.hash = this.hash(e.key);
                }
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    @Override
    public synchronized V put(K key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Entry<K, V>[] tab = this.table;
        int hash = this.hash(key);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<K, V> e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        ++this.modCount;
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            hash = this.hash(key);
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        e = tab[index];
        tab[index] = new Entry<K, V>(hash, key, value, e);
        ++this.count;
        return null;
    }

    @Override
    public synchronized V remove(Object key) {
        Entry<K, V>[] tab = this.table;
        int hash = this.hash(key);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<K, V> e = tab[index];
        Entry<K, V> prev = null;
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                ++this.modCount;
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                Object oldValue = e.value;
                e.value = null;
                return oldValue;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> t) {
        for (Map.Entry<K, V> e : t.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public synchronized void clear() {
        Entry<K, V>[] tab = this.table;
        ++this.modCount;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public synchronized Object clone() {
        try {
            Hashtable t = (Hashtable)super.clone();
            t.table = new Entry[this.table.length];
            int i = this.table.length;
            while (i-- > 0) {
                t.table[i] = this.table[i] != null ? (Entry)this.table[i].clone() : null;
            }
            t.keySet = null;
            t.entrySet = null;
            t.values = null;
            t.modCount = 0;
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public synchronized String toString() {
        int max = this.size() - 1;
        if (max == -1) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<Map.Entry<K, V>> it = this.entrySet().iterator();
        sb.append('{');
        int i = 0;
        while (true) {
            Map.Entry<K, V> e = it.next();
            K key = e.getKey();
            V value = e.getValue();
            sb.append(key == this ? "(this Map)" : key.toString());
            sb.append('=');
            sb.append(value == this ? "(this Map)" : value.toString());
            if (i == max) {
                return sb.append('}').toString();
            }
            sb.append(", ");
            ++i;
        }
    }

    private <T> Enumeration<T> getEnumeration(int type) {
        if (this.count == 0) {
            return Collections.emptyEnumeration();
        }
        return new Enumerator(type, false);
    }

    private <T> Iterator<T> getIterator(int type) {
        if (this.count == 0) {
            return Collections.emptyIterator();
        }
        return new Enumerator(type, true);
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = Collections.synchronizedSet(new KeySet(), this);
        }
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = Collections.synchronizedSet(new EntrySet(), this);
        }
        return this.entrySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = Collections.synchronizedCollection(new ValueCollection(), this);
        }
        return this.values;
    }

    @Override
    public synchronized boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map t = (Map)o;
        if (t.size() != this.size()) {
            return false;
        }
        try {
            for (Map.Entry<K, V> e : this.entrySet()) {
                K key = e.getKey();
                V value = e.getValue();
                if (!(value == null ? t.get(key) != null || !t.containsKey(key) : !value.equals(t.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        return true;
    }

    @Override
    public synchronized int hashCode() {
        Entry<K, V>[] tab;
        int h = 0;
        if (this.count == 0 || this.loadFactor < 0.0f) {
            return h;
        }
        this.loadFactor = -this.loadFactor;
        for (Entry<K, V> entry : tab = this.table) {
            while (entry != null) {
                h += entry.hashCode();
                entry = entry.next;
            }
        }
        this.loadFactor = -this.loadFactor;
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        Entry entryStack = null;
        Hashtable hashtable = this;
        synchronized (hashtable) {
            s.defaultWriteObject();
            s.writeInt(this.table.length);
            s.writeInt(this.count);
            for (int index = 0; index < this.table.length; ++index) {
                Entry<K, V> entry = this.table[index];
                while (entry != null) {
                    entryStack = new Entry(0, entry.key, entry.value, entryStack);
                    entry = entry.next;
                }
            }
        }
        while (entryStack != null) {
            s.writeObject(entryStack.key);
            s.writeObject(entryStack.value);
            entryStack = entryStack.next;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.loadFactor <= 0.0f || Float.isNaN(this.loadFactor)) {
            throw new StreamCorruptedException("Illegal Load: " + this.loadFactor);
        }
        int origlength = s.readInt();
        int elements = s.readInt();
        if (elements < 0) {
            throw new StreamCorruptedException("Illegal # of Elements: " + elements);
        }
        origlength = Math.max(origlength, (int)((float)elements / this.loadFactor) + 1);
        int length = (int)((float)(elements + elements / 20) / this.loadFactor) + 3;
        if (length > elements && (length & 1) == 0) {
            --length;
        }
        length = Math.min(length, origlength);
        SharedSecrets.getJavaOISAccess().checkArray(s, Map.Entry[].class, length);
        Entry[] newTable = new Entry[length];
        this.threshold = (int)Math.min((float)length * this.loadFactor, 2.1474836E9f);
        this.count = 0;
        this.initHashSeedAsNeeded(length);
        while (elements > 0) {
            Object key = s.readObject();
            Object value = s.readObject();
            this.reconstitutionPut(newTable, key, value);
            --elements;
        }
        this.table = newTable;
    }

    private void reconstitutionPut(Entry<K, V>[] tab, K key, V value) throws StreamCorruptedException {
        if (value == null) {
            throw new StreamCorruptedException();
        }
        int hash = this.hash(key);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry<K, V> e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                throw new StreamCorruptedException();
            }
            e = e.next;
        }
        e = tab[index];
        tab[index] = new Entry<K, V>(hash, key, value, e);
        ++this.count;
    }

    private class Enumerator<T>
    implements Enumeration<T>,
    Iterator<T> {
        Entry[] table;
        int index;
        Entry<K, V> entry;
        Entry<K, V> lastReturned;
        int type;
        boolean iterator;
        protected int expectedModCount;

        Enumerator(int type, boolean iterator) {
            this.table = Hashtable.this.table;
            this.index = this.table.length;
            this.entry = null;
            this.lastReturned = null;
            this.expectedModCount = Hashtable.this.modCount;
            this.type = type;
            this.iterator = iterator;
        }

        @Override
        public boolean hasMoreElements() {
            Entry e = this.entry;
            int i = this.index;
            Entry[] t = this.table;
            while (e == null && i > 0) {
                e = t[--i];
            }
            this.entry = e;
            this.index = i;
            return e != null;
        }

        @Override
        public T nextElement() {
            Entry et = this.entry;
            int i = this.index;
            Entry[] t = this.table;
            while (et == null && i > 0) {
                et = t[--i];
            }
            this.entry = et;
            this.index = i;
            if (et != null) {
                this.lastReturned = this.entry;
                Entry e = this.lastReturned;
                this.entry = e.next;
                return (T)(this.type == 0 ? e.key : (this.type == 1 ? e.value : e));
            }
            throw new NoSuchElementException("Hashtable Enumerator");
        }

        @Override
        public boolean hasNext() {
            return this.hasMoreElements();
        }

        @Override
        public T next() {
            if (Hashtable.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.nextElement();
        }

        @Override
        public void remove() {
            if (!this.iterator) {
                throw new UnsupportedOperationException();
            }
            if (this.lastReturned == null) {
                throw new IllegalStateException("Hashtable Enumerator");
            }
            if (Hashtable.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Hashtable hashtable = Hashtable.this;
            synchronized (hashtable) {
                Entry[] tab = Hashtable.this.table;
                int index = (this.lastReturned.hash & Integer.MAX_VALUE) % tab.length;
                Entry e = tab[index];
                Entry prev = null;
                while (e != null) {
                    if (e == this.lastReturned) {
                        Hashtable.this.modCount++;
                        ++this.expectedModCount;
                        if (prev == null) {
                            tab[index] = e.next;
                        } else {
                            prev.next = e.next;
                        }
                        Hashtable.this.count--;
                        this.lastReturned = null;
                        return;
                    }
                    prev = e;
                    e = e.next;
                }
                throw new ConcurrentModificationException();
            }
        }
    }

    private static class Entry<K, V>
    implements Map.Entry<K, V> {
        int hash;
        final K key;
        V value;
        Entry<K, V> next;

        protected Entry(int hash, K key, V value, Entry<K, V> next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        protected Object clone() {
            return new Entry<K, V>(this.hash, this.key, this.value, this.next == null ? null : (Entry)this.next.clone());
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            if (value == null) {
                throw new NullPointerException();
            }
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key.equals(e.getKey()) && this.value.equals(e.getValue());
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.key) ^ Objects.hashCode(this.value);
        }

        public String toString() {
            return this.key.toString() + "=" + this.value.toString();
        }
    }

    private class ValueCollection
    extends AbstractCollection<V> {
        private ValueCollection() {
        }

        @Override
        public Iterator<V> iterator() {
            return Hashtable.this.getIterator(1);
        }

        @Override
        public int size() {
            return Hashtable.this.count;
        }

        @Override
        public boolean contains(Object o) {
            return Hashtable.this.containsValue(o);
        }

        @Override
        public void clear() {
            Hashtable.this.clear();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return Hashtable.this.getIterator(2);
        }

        @Override
        public boolean add(Map.Entry<K, V> o) {
            return super.add(o);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            Entry[] tab = Hashtable.this.table;
            int hash = Hashtable.this.hash(key);
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            while (e != null) {
                if (e.hash == hash && e.equals(entry)) {
                    return true;
                }
                e = e.next;
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            Entry[] tab = Hashtable.this.table;
            int hash = Hashtable.this.hash(key);
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            Entry prev = null;
            while (e != null) {
                if (e.hash == hash && e.equals(entry)) {
                    Hashtable.this.modCount++;
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        tab[index] = e.next;
                    }
                    Hashtable.this.count--;
                    e.value = null;
                    return true;
                }
                prev = e;
                e = e.next;
            }
            return false;
        }

        @Override
        public int size() {
            return Hashtable.this.count;
        }

        @Override
        public void clear() {
            Hashtable.this.clear();
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return Hashtable.this.getIterator(0);
        }

        @Override
        public int size() {
            return Hashtable.this.count;
        }

        @Override
        public boolean contains(Object o) {
            return Hashtable.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return Hashtable.this.remove(o) != null;
        }

        @Override
        public void clear() {
            Hashtable.this.clear();
        }
    }

    private static class Holder {
        static final int ALTERNATIVE_HASHING_THRESHOLD;

        private Holder() {
        }

        static {
            int threshold;
            String altThreshold = AccessController.doPrivileged(new GetPropertyAction("jdk.map.althashing.threshold"));
            try {
                int n = threshold = null != altThreshold ? Integer.parseInt(altThreshold) : Integer.MAX_VALUE;
                if (threshold == -1) {
                    threshold = Integer.MAX_VALUE;
                }
                if (threshold < 0) {
                    throw new IllegalArgumentException("value must be positive integer.");
                }
            }
            catch (IllegalArgumentException failed) {
                throw new Error("Illegal value for 'jdk.map.althashing.threshold'", failed);
            }
            ALTERNATIVE_HASHING_THRESHOLD = threshold;
        }
    }
}

