/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.repl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.lazy.FileScopeFactory;
import org.jetbrains.kotlin.resolve.lazy.FileScopeProviderKt;
import org.jetbrains.kotlin.resolve.lazy.FileScopes;
import org.jetbrains.kotlin.resolve.lazy.FileScopesCustomizer;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyClassDescriptor;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyScriptDescriptor;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.ImportingScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u0016\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/resolve/repl/ReplState;", "", "()V", "lines", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/psi/KtFile;", "Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo;", "Lkotlin/collections/HashMap;", "successfulLines", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo$SuccessfulLine;", "Lkotlin/collections/ArrayList;", "successfulLinesCount", "", "getSuccessfulLinesCount", "()I", "computeFileScopes", "Lorg/jetbrains/kotlin/resolve/lazy/FileScopes;", "lineInfo", "fileScopeFactory", "Lorg/jetbrains/kotlin/resolve/lazy/FileScopeFactory;", "lineFailure", "", "ktFile", "lineSuccess", "scriptDescriptor", "Lorg/jetbrains/kotlin/resolve/lazy/descriptors/LazyScriptDescriptor;", "submitLine", "LineInfo", "frontend"})
public final class ReplState {
    private final HashMap<KtFile, LineInfo> lines;
    private final ArrayList<LineInfo.SuccessfulLine> successfulLines;

    public final int getSuccessfulLinesCount() {
        return this.successfulLines.size();
    }

    public final void submitLine(@NotNull KtFile ktFile) {
        Intrinsics.checkParameterIsNotNull(ktFile, "ktFile");
        LineInfo.SubmittedLine line = new LineInfo.SubmittedLine(ktFile, (LineInfo.SuccessfulLine)CollectionsKt.lastOrNull((List)this.successfulLines));
        Map map2 = this.lines;
        LineInfo.SubmittedLine submittedLine = line;
        map2.put(ktFile, submittedLine);
        FileScopeProviderKt.setFileScopesCustomizer(ktFile, new FileScopesCustomizer(this, ktFile){
            final /* synthetic */ ReplState this$0;
            final /* synthetic */ KtFile $ktFile;

            @NotNull
            public FileScopes createFileScopes(@NotNull FileScopeFactory fileScopeFactory) {
                LineInfo lineInfo;
                LineInfo it;
                Intrinsics.checkParameterIsNotNull(fileScopeFactory, "fileScopeFactory");
                Object object = ReplState.access$lineInfo(this.this$0, this.$ktFile);
                if (object == null || (object = ReplState.access$computeFileScopes(this.this$0, it = (lineInfo = object), fileScopeFactory)) == null) {
                    object = FileScopeFactory.createScopesForFile$default(fileScopeFactory, this.$ktFile, null, 2, null);
                }
                return object;
            }
            {
                this.this$0 = $outer;
                this.$ktFile = $captured_local_variable$1;
            }
        });
    }

    public final void lineSuccess(@NotNull KtFile ktFile, @NotNull LazyScriptDescriptor scriptDescriptor) {
        Intrinsics.checkParameterIsNotNull(ktFile, "ktFile");
        Intrinsics.checkParameterIsNotNull(scriptDescriptor, "scriptDescriptor");
        LineInfo.SuccessfulLine successfulLine = new LineInfo.SuccessfulLine(ktFile, (LineInfo.SuccessfulLine)CollectionsKt.lastOrNull((List)this.successfulLines), scriptDescriptor);
        Map map2 = this.lines;
        LineInfo.SuccessfulLine successfulLine2 = successfulLine;
        map2.put(ktFile, successfulLine2);
        this.successfulLines.add(successfulLine);
    }

    public final void lineFailure(@NotNull KtFile ktFile) {
        Intrinsics.checkParameterIsNotNull(ktFile, "ktFile");
        Map map2 = this.lines;
        LineInfo.FailedLine failedLine = new LineInfo.FailedLine(ktFile, (LineInfo.SuccessfulLine)CollectionsKt.lastOrNull((List)this.successfulLines));
        map2.put(ktFile, failedLine);
    }

    private final LineInfo lineInfo(KtFile ktFile) {
        return this.lines.get(ktFile);
    }

    private final FileScopes computeFileScopes(LineInfo lineInfo, FileScopeFactory fileScopeFactory) {
        HierarchicalScope element$iv;
        Object lexicalScopeAfterLastLine;
        block2: {
            Object object = lineInfo.getParentLine();
            if (object == null || (object = ((LineInfo.SuccessfulLine)object).getLineDescriptor()) == null || (object = ((LazyClassDescriptor)object).getScopeForInitializerResolution()) == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull(object, "lineInfo.parentLine?.lin\u2026Resolution ?: return null");
            lexicalScopeAfterLastLine = object;
            Sequence<HierarchicalScope> $receiver$iv = ScopeUtilsKt.getParentsWithSelf((HierarchicalScope)lexicalScopeAfterLastLine);
            Iterator<HierarchicalScope> iterator2 = $receiver$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv = iterator2.next();
                if (!(element$iv instanceof ImportingScope)) continue;
                break block2;
            }
            throw (Throwable)new NoSuchElementException("No element of given type found");
        }
        ImportingScope lastLineImports = (ImportingScope)element$iv;
        FileScopes scopesForThisLine = fileScopeFactory.createScopesForFile(lineInfo.getLinePsi(), lastLineImports);
        LexicalScope combinedLexicalScopes = ScopeUtilsKt.replaceImportingScopes((LexicalScope)lexicalScopeAfterLastLine, scopesForThisLine.getImportingScope());
        return new FileScopes(combinedLexicalScopes, scopesForThisLine.getImportingScope(), scopesForThisLine.getImportForceResolver());
    }

    public ReplState() {
        ReplState replState = this;
        Cloneable cloneable2 = new HashMap();
        replState.lines = cloneable2;
        replState = this;
        cloneable2 = new ArrayList();
        replState.successfulLines = cloneable2;
    }

    public static final /* synthetic */ LineInfo access$lineInfo(ReplState $this, KtFile ktFile) {
        return $this.lineInfo(ktFile);
    }

    public static final /* synthetic */ FileScopes access$computeFileScopes(ReplState $this, LineInfo lineInfo, FileScopeFactory fileScopeFactory) {
        return $this.computeFileScopes(lineInfo, fileScopeFactory);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\u000b\f\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u0082\u0001\u0003\u000e\b\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo;", "", "()V", "linePsi", "Lorg/jetbrains/kotlin/psi/KtFile;", "getLinePsi", "()Lorg/jetbrains/kotlin/psi/KtFile;", "parentLine", "Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo$SuccessfulLine;", "getParentLine", "()Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo$SuccessfulLine;", "FailedLine", "SubmittedLine", "SuccessfulLine", "Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo$SubmittedLine;", "Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo$FailedLine;", "frontend"})
    private static abstract class LineInfo {
        @NotNull
        public abstract KtFile getLinePsi();

        @Nullable
        public abstract SuccessfulLine getParentLine();

        private LineInfo() {
        }

        public /* synthetic */ LineInfo(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo$SubmittedLine;", "Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo;", "linePsi", "Lorg/jetbrains/kotlin/psi/KtFile;", "parentLine", "Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo$SuccessfulLine;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo$SuccessfulLine;)V", "getLinePsi", "()Lorg/jetbrains/kotlin/psi/KtFile;", "getParentLine", "()Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo$SuccessfulLine;", "frontend"})
        public static final class SubmittedLine
        extends LineInfo {
            @NotNull
            private final KtFile linePsi;
            @Nullable
            private final SuccessfulLine parentLine;

            @Override
            @NotNull
            public KtFile getLinePsi() {
                return this.linePsi;
            }

            @Override
            @Nullable
            public SuccessfulLine getParentLine() {
                return this.parentLine;
            }

            public SubmittedLine(@NotNull KtFile linePsi, @Nullable SuccessfulLine parentLine) {
                Intrinsics.checkParameterIsNotNull(linePsi, "linePsi");
                super(null);
                this.linePsi = linePsi;
                this.parentLine = parentLine;
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0000X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo$SuccessfulLine;", "Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo;", "linePsi", "Lorg/jetbrains/kotlin/psi/KtFile;", "parentLine", "lineDescriptor", "Lorg/jetbrains/kotlin/resolve/lazy/descriptors/LazyScriptDescriptor;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo$SuccessfulLine;Lorg/jetbrains/kotlin/resolve/lazy/descriptors/LazyScriptDescriptor;)V", "getLineDescriptor", "()Lorg/jetbrains/kotlin/resolve/lazy/descriptors/LazyScriptDescriptor;", "getLinePsi", "()Lorg/jetbrains/kotlin/psi/KtFile;", "getParentLine", "()Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo$SuccessfulLine;", "frontend"})
        public static final class SuccessfulLine
        extends LineInfo {
            @NotNull
            private final KtFile linePsi;
            @Nullable
            private final SuccessfulLine parentLine;
            @NotNull
            private final LazyScriptDescriptor lineDescriptor;

            @Override
            @NotNull
            public KtFile getLinePsi() {
                return this.linePsi;
            }

            @Override
            @Nullable
            public SuccessfulLine getParentLine() {
                return this.parentLine;
            }

            @NotNull
            public final LazyScriptDescriptor getLineDescriptor() {
                return this.lineDescriptor;
            }

            public SuccessfulLine(@NotNull KtFile linePsi, @Nullable SuccessfulLine parentLine, @NotNull LazyScriptDescriptor lineDescriptor) {
                Intrinsics.checkParameterIsNotNull(linePsi, "linePsi");
                Intrinsics.checkParameterIsNotNull(lineDescriptor, "lineDescriptor");
                super(null);
                this.linePsi = linePsi;
                this.parentLine = parentLine;
                this.lineDescriptor = lineDescriptor;
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo$FailedLine;", "Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo;", "linePsi", "Lorg/jetbrains/kotlin/psi/KtFile;", "parentLine", "Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo$SuccessfulLine;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo$SuccessfulLine;)V", "getLinePsi", "()Lorg/jetbrains/kotlin/psi/KtFile;", "getParentLine", "()Lorg/jetbrains/kotlin/resolve/repl/ReplState$LineInfo$SuccessfulLine;", "frontend"})
        public static final class FailedLine
        extends LineInfo {
            @NotNull
            private final KtFile linePsi;
            @Nullable
            private final SuccessfulLine parentLine;

            @Override
            @NotNull
            public KtFile getLinePsi() {
                return this.linePsi;
            }

            @Override
            @Nullable
            public SuccessfulLine getParentLine() {
                return this.parentLine;
            }

            public FailedLine(@NotNull KtFile linePsi, @Nullable SuccessfulLine parentLine) {
                Intrinsics.checkParameterIsNotNull(linePsi, "linePsi");
                super(null);
                this.linePsi = linePsi;
                this.parentLine = parentLine;
            }
        }
    }
}

