#ifndef _EFL_CANVAS_ANIMATION_GROUP_EO_H_
#define _EFL_CANVAS_ANIMATION_GROUP_EO_H_

#ifndef _EFL_CANVAS_ANIMATION_GROUP_EO_CLASS_TYPE
#define _EFL_CANVAS_ANIMATION_GROUP_EO_CLASS_TYPE

typedef Eo Efl_Canvas_Animation_Group;

#endif

#ifndef _EFL_CANVAS_ANIMATION_GROUP_EO_TYPES
#define _EFL_CANVAS_ANIMATION_GROUP_EO_TYPES


#endif
/** Efl group animation abstract class
 *
 * @ingroup Efl_Canvas_Animation_Group
 */
#define EFL_CANVAS_ANIMATION_GROUP_CLASS efl_canvas_animation_group_class_get()

EWAPI const Efl_Class *efl_canvas_animation_group_class_get(void);

/**
 * @brief Add the given animation to the animation group.
 *
 * @param[in] obj The object.
 * @param[in] animation The animation which needs to be added to the animation
 * group
 *
 * @ingroup Efl_Canvas_Animation_Group
 */
EOAPI void efl_animation_group_animation_add(Eo *obj, Efl_Canvas_Animation *animation);

/**
 * @brief Delete the given animation from the animation group.
 *
 * @param[in] obj The object.
 * @param[in] animation The animation which needs to be deleted from the
 * animation group
 *
 * @ingroup Efl_Canvas_Animation_Group
 */
EOAPI void efl_animation_group_animation_del(Eo *obj, Efl_Canvas_Animation *animation);

/**
 * @brief Get the animations of the animation group.
 *
 * @param[in] obj The object.
 *
 * @return The animations of the animation group
 *
 * @ingroup Efl_Canvas_Animation_Group
 */
EOAPI Eina_List *efl_animation_group_animations_get(const Eo *obj);

#endif
