/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.memory;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.RowFilter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.filters.GenericFilter;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.MemoryCCTManager;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.ui.Formatters;
import org.netbeans.lib.profiler.ui.memory.MemoryJavaNameRenderer;
import org.netbeans.lib.profiler.ui.memory.MemoryView;
import org.netbeans.lib.profiler.ui.swing.ExportUtils;
import org.netbeans.lib.profiler.ui.swing.PopupButton;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTableContainer;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTableModel;
import org.netbeans.lib.profiler.ui.swing.SearchUtils;
import org.netbeans.lib.profiler.ui.swing.renderer.CheckBoxRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.HideableBarRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.NumberPercentRenderer;
import org.netbeans.modules.profiler.api.icons.Icons;

abstract class AllocTreeTableView
extends MemoryView {
    private AllocTreeTableModel treeTableModel;
    private ProfilerTreeTable treeTable;
    private Map<TreeNode, ClientUtils.SourceCodeSelection> nodesMap;
    private final Set<ClientUtils.SourceCodeSelection> selection;
    private boolean filterObjects = true;
    private boolean filterAllocations = false;
    private boolean searchObjects = true;
    private boolean searchAllocations = false;
    private HideableBarRenderer[] renderers;

    public AllocTreeTableView(Set<ClientUtils.SourceCodeSelection> set) {
        this.selection = set;
        this.initUI();
    }

    @Override
    protected RowFilter getExcludesFilter() {
        return new RowFilter(){

            public boolean include(RowFilter.Entry entry) {
                PresoObjAllocCCTNode presoObjAllocCCTNode = (PresoObjAllocCCTNode)entry.getIdentifier();
                CCTNode cCTNode = presoObjAllocCCTNode.getParent();
                if (cCTNode == null) {
                    return true;
                }
                if (cCTNode.getParent() == null) {
                    return !AllocTreeTableView.this.filterObjects;
                }
                return !AllocTreeTableView.this.filterAllocations;
            }
        };
    }

    @Override
    protected Component[] getFilterOptions() {
        PopupButton popupButton = new PopupButton(Icons.getIcon((String)"ProfilerIcons.TabCallTree")){

            @Override
            protected void populatePopup(JPopupMenu jPopupMenu) {
                jPopupMenu.add(new JCheckBoxMenuItem(MemoryView.FILTER_CLASSES_SCOPE, AllocTreeTableView.this.filterObjects){
                    {
                        if (!AllocTreeTableView.this.filterAllocations) {
                            this.setEnabled(false);
                        }
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        super.fireActionPerformed(actionEvent);
                        AllocTreeTableView.this.filterObjects = !AllocTreeTableView.this.filterObjects;
                        AllocTreeTableView.this.enableFilter();
                    }
                });
                jPopupMenu.add(new JCheckBoxMenuItem(MemoryView.FILTER_ALLOCATIONS_SCOPE, AllocTreeTableView.this.filterAllocations){
                    {
                        if (!AllocTreeTableView.this.filterObjects) {
                            this.setEnabled(false);
                        }
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        super.fireActionPerformed(actionEvent);
                        AllocTreeTableView.this.filterAllocations = !AllocTreeTableView.this.filterAllocations;
                        AllocTreeTableView.this.enableFilter();
                    }
                });
            }
        };
        popupButton.setToolTipText(FILTER_SCOPE_TOOLTIP);
        return new Component[]{Box.createHorizontalStrut(5), popupButton};
    }

    @Override
    protected SearchUtils.TreeHelper getSearchHelper() {
        return new SearchUtils.TreeHelper(){

            @Override
            public int getNodeType(TreeNode treeNode) {
                PresoObjAllocCCTNode presoObjAllocCCTNode = (PresoObjAllocCCTNode)treeNode;
                CCTNode cCTNode = presoObjAllocCCTNode.getParent();
                if (cCTNode == null) {
                    return 100;
                }
                if (cCTNode.getParent() == null) {
                    if (AllocTreeTableView.this.searchObjects) {
                        return AllocTreeTableView.this.searchAllocations ? 10 : 11;
                    }
                    return AllocTreeTableView.this.searchAllocations ? 100 : 101;
                }
                return AllocTreeTableView.this.searchAllocations ? 10 : 101;
            }
        };
    }

    @Override
    protected Component[] getSearchOptions() {
        PopupButton popupButton = new PopupButton(Icons.getIcon((String)"ProfilerIcons.TabCallTree")){

            @Override
            protected void populatePopup(JPopupMenu jPopupMenu) {
                jPopupMenu.add(new JCheckBoxMenuItem(MemoryView.SEARCH_CLASSES_SCOPE, AllocTreeTableView.this.searchObjects){
                    {
                        if (!AllocTreeTableView.this.searchAllocations) {
                            this.setEnabled(false);
                        }
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        super.fireActionPerformed(actionEvent);
                        AllocTreeTableView.this.searchObjects = !AllocTreeTableView.this.searchObjects;
                    }
                });
                jPopupMenu.add(new JCheckBoxMenuItem(MemoryView.SEARCH_ALLOCATIONS_SCOPE, AllocTreeTableView.this.searchAllocations){
                    {
                        if (!AllocTreeTableView.this.searchObjects) {
                            this.setEnabled(false);
                        }
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent actionEvent) {
                        super.fireActionPerformed(actionEvent);
                        AllocTreeTableView.this.searchAllocations = !AllocTreeTableView.this.searchAllocations;
                    }
                });
            }
        };
        popupButton.setToolTipText(SEARCH_SCOPE_TOOLTIP);
        return new Component[]{Box.createHorizontalStrut(5), popupButton};
    }

    @Override
    protected ProfilerTable getResultsComponent() {
        return this.treeTable;
    }

    @Override
    public void setData(MemoryResultsSnapshot memoryResultsSnapshot, GenericFilter genericFilter, int n) {
        final boolean bl = genericFilter != null;
        final boolean bl2 = memoryResultsSnapshot instanceof AllocMemoryResultsDiff;
        final AllocMemoryResultsSnapshot allocMemoryResultsSnapshot = (AllocMemoryResultsSnapshot)memoryResultsSnapshot;
        String[] stringArray = allocMemoryResultsSnapshot.getClassNames();
        int[] nArray = allocMemoryResultsSnapshot.getObjectsCounts();
        long[] lArray = allocMemoryResultsSnapshot.getObjectsSizePerClass();
        int n2 = Math.min(allocMemoryResultsSnapshot.getNProfiledClasses(), stringArray.length);
        n2 = Math.min(n2, nArray.length);
        class Node
        extends PresoObjAllocCCTNode {
            Node(String string, int n, long l) {
                super(string, (long)n, l);
            }

            public CCTNode[] getChildren() {
                if (this.children == null) {
                    MemoryCCTManager memoryCCTManager = new MemoryCCTManager((MemoryResultsSnapshot)allocMemoryResultsSnapshot, n3, true);
                    PresoObjAllocCCTNode presoObjAllocCCTNode = memoryCCTManager.getRootNode();
                    this.setChildren(presoObjAllocCCTNode == null ? new PresoObjAllocCCTNode[]{} : (PresoObjAllocCCTNode[])presoObjAllocCCTNode.getChildren());
                }
                return this.children;
            }

            public boolean isLeaf() {
                if (this.children == null) {
                    return bl ? this.nCalls == 0L : false;
                }
                return super.isLeaf();
            }

            public int getChildCount() {
                if (this.children == null) {
                    this.getChildren();
                }
                return super.getChildCount();
            }
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        final HashMap<Node, ClientUtils.SourceCodeSelection> hashMap = new HashMap<Node, ClientUtils.SourceCodeSelection>();
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        for (int i = 0; i < n2; ++i) {
            Node node;
            if (bl2) {
                l = Math.max(l, (long)nArray[i]);
                l2 = Math.min(l2, (long)nArray[i]);
                l3 = Math.max(l3, lArray[i]);
                l4 = Math.min(l4, lArray[i]);
            } else {
                l += (long)nArray[i];
                l3 += lArray[i];
            }
            final int n3 = i;
            if (!bl) {
                if (nArray[i] <= 0) continue;
                node = new Node(stringArray[i], nArray[i], lArray[i]);
                arrayList.add(node);
                hashMap.put(node, new ClientUtils.SourceCodeSelection(stringArray[i], "*", null));
                continue;
            }
            if (!genericFilter.passes(stringArray[i].replace('.', '/'))) continue;
            node = new Node(stringArray[i], nArray[i], lArray[i]);
            arrayList.add(node);
            hashMap.put(node, new ClientUtils.SourceCodeSelection(stringArray[i], "*", null));
        }
        final long l5 = !bl2 ? l3 : Math.max(Math.abs(l3), Math.abs(l4));
        final long l6 = !bl2 ? l : Math.max(Math.abs(l), Math.abs(l2));
        final PresoObjAllocCCTNode presoObjAllocCCTNode = PresoObjAllocCCTNode.rootNode((PresoObjAllocCCTNode[])arrayList.toArray(new PresoObjAllocCCTNode[0]));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AllocTreeTableView.this.nodesMap = hashMap;
                AllocTreeTableView.this.renderers[0].setMaxValue(l5);
                AllocTreeTableView.this.renderers[1].setMaxValue(l6);
                AllocTreeTableView.this.renderers[0].setDiffMode(bl2);
                AllocTreeTableView.this.renderers[1].setDiffMode(bl2);
                AllocTreeTableView.this.treeTableModel.setRoot((TreeNode)presoObjAllocCCTNode);
            }
        });
    }

    @Override
    public void resetData() {
        final PresoObjAllocCCTNode presoObjAllocCCTNode = PresoObjAllocCCTNode.rootNode((PresoObjAllocCCTNode[])new PresoObjAllocCCTNode[0]);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AllocTreeTableView.this.nodesMap = null;
                AllocTreeTableView.this.renderers[0].setMaxValue(0L);
                AllocTreeTableView.this.renderers[1].setMaxValue(0L);
                AllocTreeTableView.this.renderers[0].setDiffMode(false);
                AllocTreeTableView.this.renderers[1].setDiffMode(false);
                AllocTreeTableView.this.treeTableModel.setRoot((TreeNode)presoObjAllocCCTNode);
            }
        });
    }

    @Override
    public void showSelectionColumn() {
        this.treeTable.setColumnVisibility(0, true);
    }

    @Override
    public void refreshSelection() {
        this.treeTableModel.dataChanged();
    }

    @Override
    public ExportUtils.ExportProvider[] getExportProviders() {
        ExportUtils.ExportProvider[] exportProviderArray;
        if (this.treeTable.getRowCount() == 0) {
            exportProviderArray = null;
        } else {
            ExportUtils.ExportProvider[] exportProviderArray2 = new ExportUtils.ExportProvider[4];
            exportProviderArray2[0] = new ExportUtils.CSVExportProvider(this.treeTable);
            exportProviderArray2[1] = new ExportUtils.HTMLExportProvider((ProfilerTable)this.treeTable, EXPORT_ALLOCATED);
            exportProviderArray2[2] = new ExportUtils.XMLExportProvider((ProfilerTable)this.treeTable, EXPORT_ALLOCATED);
            exportProviderArray = exportProviderArray2;
            exportProviderArray2[3] = new ExportUtils.PNGExportProvider(this.treeTable);
        }
        return exportProviderArray;
    }

    @Override
    protected abstract void performDefaultAction(ClientUtils.SourceCodeSelection var1);

    protected abstract void populatePopup(JPopupMenu var1, Object var2, ClientUtils.SourceCodeSelection var3);

    protected void popupShowing() {
    }

    protected void popupHidden() {
    }

    private void initUI() {
        String[] stringArray;
        int n = this.selection == null ? -1 : 0;
        this.treeTableModel = new AllocTreeTableModel((TreeNode)PrestimeCPUCCTNode.EMPTY);
        this.treeTable = new ProfilerTreeTable(this.treeTableModel, true, true, new int[]{1 + n}){

            public ClientUtils.SourceCodeSelection getUserValueForRow(int n) {
                return AllocTreeTableView.this.getUserValueForRow(n);
            }

            @Override
            protected void populatePopup(JPopupMenu jPopupMenu, Object object, Object object2) {
                AllocTreeTableView.this.populatePopup(jPopupMenu, object, (ClientUtils.SourceCodeSelection)object2);
            }

            @Override
            protected void popupShowing() {
                AllocTreeTableView.this.popupShowing();
            }

            @Override
            protected void popupHidden() {
                AllocTreeTableView.this.popupHidden();
            }
        };
        if (this.selection == null) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = NAME_COLUMN_TOOLTIP;
            stringArray2[1] = ALLOC_SIZE_COLUMN_TOOLTIP;
            stringArray = stringArray2;
            stringArray2[2] = ALLOC_COUNT_COLUMN_TOOLTIP;
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = SELECTED_COLUMN_TOOLTIP;
            stringArray3[1] = NAME_COLUMN_TOOLTIP;
            stringArray3[2] = ALLOC_SIZE_COLUMN_TOOLTIP;
            stringArray = stringArray3;
            stringArray3[3] = ALLOC_COUNT_COLUMN_TOOLTIP;
        }
        this.treeTable.setColumnToolTips(stringArray);
        this.treeTable.providePopupMenu(true);
        this.treeTable.setDefaultAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = AllocTreeTableView.this.treeTable.getSelectedRow();
                ClientUtils.SourceCodeSelection sourceCodeSelection = AllocTreeTableView.this.getUserValueForRow(n);
                if (sourceCodeSelection != null) {
                    AllocTreeTableView.this.performDefaultAction(sourceCodeSelection);
                }
            }
        });
        this.treeTable.setRootVisible(false);
        this.treeTable.setShowsRootHandles(true);
        this.treeTable.makeTreeAutoExpandable(2);
        this.treeTable.setMainColumn(1 + n);
        this.treeTable.setFitWidthColumn(1 + n);
        this.treeTable.setSortColumn(2 + n);
        this.treeTable.setDefaultSortOrder(1 + n, SortOrder.ASCENDING);
        if (this.selection != null) {
            this.treeTable.setColumnVisibility(0, false);
        }
        this.renderers = new HideableBarRenderer[2];
        this.renderers[0] = new HideableBarRenderer(new NumberPercentRenderer(Formatters.bytesFormat()));
        this.renderers[1] = new HideableBarRenderer(new NumberPercentRenderer());
        this.renderers[0].setMaxValue(123456789L);
        this.renderers[1].setMaxValue(12345678L);
        if (this.selection != null) {
            this.treeTable.setColumnRenderer(0, new CheckBoxRenderer(){
                private boolean visible;

                @Override
                public void setValue(Object object, int n) {
                    TreePath treePath = AllocTreeTableView.this.treeTable.getPathForRow(n);
                    this.visible = AllocTreeTableView.this.nodesMap.containsKey((TreeNode)treePath.getLastPathComponent());
                    if (this.visible) {
                        super.setValue(object, n);
                    }
                }

                @Override
                public void paint(Graphics graphics) {
                    if (this.visible) {
                        super.paint(graphics);
                    } else {
                        graphics.setColor(this.getBackground());
                        graphics.fillRect(0, 0, this.size.width, this.size.height);
                    }
                }
            });
        }
        this.treeTable.setTreeCellRenderer(new MemoryJavaNameRenderer());
        this.treeTable.setColumnRenderer(2 + n, this.renderers[0]);
        this.treeTable.setColumnRenderer(3 + n, this.renderers[1]);
        if (this.selection != null) {
            int n2 = new JLabel((String)this.treeTable.getColumnName((int)0)).getPreferredSize().width;
            this.treeTable.setDefaultColumnWidth(0, n2 + 15);
        }
        this.treeTable.setDefaultColumnWidth(2 + n, this.renderers[0].getOptimalWidth());
        this.treeTable.setDefaultColumnWidth(3 + n, this.renderers[1].getMaxNoBarWidth());
        ProfilerTableContainer profilerTableContainer = new ProfilerTableContainer(this.treeTable, false, null);
        this.setLayout(new BorderLayout());
        this.add((Component)profilerTableContainer, "Center");
    }

    @Override
    protected ClientUtils.SourceCodeSelection getUserValueForRow(int n) {
        PresoObjAllocCCTNode presoObjAllocCCTNode = (PresoObjAllocCCTNode)this.treeTable.getValueForRow(n);
        if (presoObjAllocCCTNode == null || presoObjAllocCCTNode.isFiltered()) {
            return null;
        }
        String[] stringArray = presoObjAllocCCTNode.getMethodClassNameAndSig();
        return new ClientUtils.SourceCodeSelection(stringArray[0], stringArray[1], stringArray[2]);
    }

    private class AllocTreeTableModel
    extends ProfilerTreeTableModel.Abstract {
        AllocTreeTableModel(TreeNode treeNode) {
            super(treeNode);
        }

        @Override
        public String getColumnName(int n) {
            if (AllocTreeTableView.this.selection == null) {
                ++n;
            }
            if (n == 1) {
                return MemoryView.COLUMN_NAME;
            }
            if (n == 2) {
                return MemoryView.COLUMN_ALLOCATED_BYTES;
            }
            if (n == 3) {
                return MemoryView.COLUMN_ALLOCATED_OBJECTS;
            }
            if (n == 0) {
                return MemoryView.COLUMN_SELECTED;
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (AllocTreeTableView.this.selection == null) {
                ++n;
            }
            if (n == 1) {
                return JTree.class;
            }
            if (n == 2) {
                return Long.class;
            }
            if (n == 3) {
                return Integer.class;
            }
            if (n == 0) {
                return Boolean.class;
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return AllocTreeTableView.this.selection == null ? 3 : 4;
        }

        @Override
        public Object getValueAt(TreeNode treeNode, int n) {
            PresoObjAllocCCTNode presoObjAllocCCTNode = (PresoObjAllocCCTNode)treeNode;
            if (AllocTreeTableView.this.selection == null) {
                ++n;
            }
            if (n == 1) {
                return presoObjAllocCCTNode.getNodeName();
            }
            if (n == 2) {
                return presoObjAllocCCTNode.totalObjSize;
            }
            if (n == 3) {
                return presoObjAllocCCTNode.nCalls;
            }
            if (n == 0) {
                if (AllocTreeTableView.this.selection.isEmpty()) {
                    return Boolean.FALSE;
                }
                return AllocTreeTableView.this.selection.contains(AllocTreeTableView.this.nodesMap.get(treeNode));
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, TreeNode treeNode, int n) {
            if (AllocTreeTableView.this.selection == null) {
                ++n;
            }
            if (n == 0) {
                if (Boolean.TRUE.equals(object)) {
                    AllocTreeTableView.this.selection.add(AllocTreeTableView.this.nodesMap.get(treeNode));
                } else {
                    AllocTreeTableView.this.selection.remove(AllocTreeTableView.this.nodesMap.get(treeNode));
                }
            }
        }

        @Override
        public boolean isCellEditable(TreeNode treeNode, int n) {
            if (AllocTreeTableView.this.selection == null) {
                ++n;
            }
            if (n != 0) {
                return false;
            }
            return AllocTreeTableView.this.nodesMap.containsKey(treeNode);
        }
    }
}

