/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio;

import com.ibm.media.codec.audio.AudioCodec;
import javax.media.Buffer;

public abstract class AudioPacketizer
extends AudioCodec {
    protected byte[] history;
    protected int packetSize;
    protected int historyLength;
    protected int sample_count;

    public synchronized int process(Buffer inputBuffer, Buffer outputBuffer) {
        int inpLength = inputBuffer.getLength();
        int outLength = this.packetSize;
        byte[] inpData = (byte[])inputBuffer.getData();
        byte[] outData = this.validateByteArraySize(outputBuffer, outLength);
        if (inpLength + this.historyLength >= this.packetSize) {
            int copyFromHistory = Math.min(this.historyLength, this.packetSize);
            System.arraycopy(this.history, 0, outData, 0, copyFromHistory);
            int remainingBytes = this.packetSize - copyFromHistory;
            System.arraycopy(inpData, inputBuffer.getOffset(), outData, this.historyLength, remainingBytes);
            this.historyLength -= copyFromHistory;
            inputBuffer.setOffset(inputBuffer.getOffset() + remainingBytes);
            inputBuffer.setLength(inpLength - remainingBytes);
            this.updateOutput(outputBuffer, this.outputFormat, outLength, 0);
            return 2;
        }
        if (inputBuffer.isEOM()) {
            System.arraycopy(this.history, 0, outData, 0, this.historyLength);
            System.arraycopy(inpData, inputBuffer.getOffset(), outData, this.historyLength, inpLength);
            this.updateOutput(outputBuffer, this.outputFormat, inpLength + this.historyLength, 0);
            this.historyLength = 0;
            return 0;
        }
        System.arraycopy(inpData, inputBuffer.getOffset(), this.history, this.historyLength, inpLength);
        this.historyLength += inpLength;
        return 4;
    }

    public void reset() {
        this.historyLength = 0;
    }
}

