/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.sensor;

import javax.media.j3d.Sensor;
import javax.media.j3d.Transform3D;

public class SensorEvent {
    public static final int PRESSED = 1;
    public static final int RELEASED = 2;
    public static final int DRAGGED = 3;
    public static final int READ = 4;
    public static final int NOBUTTON = -1;
    private int id = 0;
    private Object source = null;
    private Sensor sensor = null;
    private int button = -1;
    private int[] buttonState = null;
    private Transform3D sensorRead = null;
    private long time = 0L;
    private long lastTime = 0L;
    private boolean ephemeral = false;

    public SensorEvent(Object object, int n, Sensor sensor, Transform3D transform3D, int[] nArray, int n2, long l, long l2) {
        this.source = object;
        this.id = n;
        this.sensor = sensor;
        this.button = n2;
        this.time = l;
        this.lastTime = l2;
        if (transform3D == null) {
            throw new NullPointerException("sensorRead can't be null");
        }
        this.sensorRead = new Transform3D(transform3D);
        if (nArray != null) {
            this.buttonState = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                this.buttonState[i] = nArray[i];
            }
        }
        this.ephemeral = false;
    }

    public SensorEvent() {
        this.ephemeral = true;
    }

    public SensorEvent(SensorEvent sensorEvent) {
        this.source = sensorEvent.source;
        this.id = sensorEvent.id;
        this.sensor = sensorEvent.sensor;
        this.button = sensorEvent.button;
        this.time = sensorEvent.time;
        this.lastTime = sensorEvent.lastTime;
        if (sensorEvent.sensorRead == null) {
            throw new NullPointerException("sensorRead can't be null");
        }
        this.sensorRead = new Transform3D(sensorEvent.sensorRead);
        if (sensorEvent.buttonState != null) {
            this.buttonState = new int[sensorEvent.buttonState.length];
            for (int i = 0; i < sensorEvent.buttonState.length; ++i) {
                this.buttonState[i] = sensorEvent.buttonState[i];
            }
        }
        this.ephemeral = false;
    }

    public void set(Object object, int n, Sensor sensor, Transform3D transform3D, int[] nArray, int n2, long l, long l2) {
        if (!this.ephemeral) {
            throw new IllegalStateException("Can't set the fields of non-ephemeral events");
        }
        this.source = object;
        this.id = n;
        this.sensor = sensor;
        if (transform3D == null) {
            throw new NullPointerException("sensorRead can't be null");
        }
        this.sensorRead = transform3D;
        this.buttonState = nArray;
        this.button = n2;
        this.time = l;
        this.lastTime = l2;
    }

    public Object getSource() {
        return this.source;
    }

    public int getID() {
        return this.id;
    }

    public Sensor getSensor() {
        return this.sensor;
    }

    public long getTime() {
        return this.time;
    }

    public long getLastTime() {
        return this.lastTime;
    }

    public void getSensorRead(Transform3D transform3D) {
        transform3D.set(this.sensorRead);
    }

    public int getButton() {
        return this.button;
    }

    public void getButtonState(int[] nArray) {
        if (nArray.length != this.buttonState.length) {
            throw new ArrayIndexOutOfBoundsException("buttonState array is the wrong length");
        }
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.buttonState[i];
        }
    }

    public boolean isEphemeral() {
        return this.ephemeral;
    }
}

