/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.ietf.jgss.Oid;
import sun.security.action.GetPropertyAction;
import sun.security.jgss.GSSCaller;
import sun.security.jgss.GSSUtil;
import sun.security.jgss.HttpCaller;
import sun.security.util.Debug;

public class LoginConfigImpl
extends Configuration {
    private final Configuration config;
    private final GSSCaller caller;
    private final String mechName;
    private static final Debug debug = Debug.getInstance("gssloginconfig", "\t[GSS LoginConfigImpl]");
    public static final boolean HTTP_USE_GLOBAL_CREDS;

    public LoginConfigImpl(GSSCaller caller, Oid mech) {
        this.caller = caller;
        if (!mech.equals(GSSUtil.GSS_KRB5_MECH_OID)) {
            throw new IllegalArgumentException(mech.toString() + " not supported");
        }
        this.mechName = "krb5";
        this.config = AccessController.doPrivileged(new PrivilegedAction<Configuration>(){

            @Override
            public Configuration run() {
                return Configuration.getConfiguration();
            }
        });
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        AppConfigurationEntry[] entries = null;
        if ("OTHER".equalsIgnoreCase(name)) {
            return null;
        }
        String[] alts = null;
        if ("krb5".equals(this.mechName)) {
            if (this.caller == GSSCaller.CALLER_INITIATE) {
                alts = new String[]{"com.sun.security.jgss.krb5.initiate", "com.sun.security.jgss.initiate"};
            } else if (this.caller == GSSCaller.CALLER_ACCEPT) {
                alts = new String[]{"com.sun.security.jgss.krb5.accept", "com.sun.security.jgss.accept"};
            } else if (this.caller == GSSCaller.CALLER_SSL_CLIENT) {
                alts = new String[]{"com.sun.security.jgss.krb5.initiate", "com.sun.net.ssl.client"};
            } else if (this.caller == GSSCaller.CALLER_SSL_SERVER) {
                alts = new String[]{"com.sun.security.jgss.krb5.accept", "com.sun.net.ssl.server"};
            } else if (this.caller instanceof HttpCaller) {
                alts = new String[]{"com.sun.security.jgss.krb5.initiate"};
            } else if (this.caller == GSSCaller.CALLER_UNKNOWN) {
                throw new AssertionError((Object)"caller not defined");
            }
        } else {
            throw new IllegalArgumentException(this.mechName + " not supported");
        }
        for (String alt : alts) {
            entries = this.config.getAppConfigurationEntry(alt);
            if (debug != null) {
                debug.println("Trying " + alt + (entries == null ? ": does not exist." : ": Found!"));
            }
            if (entries != null) break;
        }
        if (entries == null) {
            if (debug != null) {
                debug.println("Cannot read JGSS entry, use default values instead.");
            }
            entries = this.getDefaultConfigurationEntry();
        }
        return entries;
    }

    private AppConfigurationEntry[] getDefaultConfigurationEntry() {
        HashMap<String, String> options = new HashMap<String, String>(2);
        if (this.mechName == null || this.mechName.equals("krb5")) {
            if (LoginConfigImpl.isServerSide(this.caller)) {
                options.put("useKeyTab", "true");
                options.put("storeKey", "true");
                options.put("doNotPrompt", "true");
                options.put("isInitiator", "false");
            } else {
                if (this.caller instanceof HttpCaller && !HTTP_USE_GLOBAL_CREDS) {
                    options.put("useTicketCache", "false");
                } else {
                    options.put("useTicketCache", "true");
                }
                options.put("doNotPrompt", "false");
            }
            return new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        }
        return null;
    }

    private static boolean isServerSide(GSSCaller caller) {
        return GSSCaller.CALLER_ACCEPT == caller || GSSCaller.CALLER_SSL_SERVER == caller;
    }

    static {
        String prop = GetPropertyAction.privilegedGetProperty("http.use.global.creds");
        HTTP_USE_GLOBAL_CREDS = !"false".equalsIgnoreCase(prop);
    }
}

