/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.nio.cs.ext.DoubleByte;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.HKSCS;
import sun.nio.cs.ext.HKSCS_XPMapping;
import sun.nio.cs.ext.MS950;

public class MS950_HKSCS_XP
extends Charset {
    public MS950_HKSCS_XP() {
        super("x-MS950-HKSCS-XP", ExtendedCharsets.aliasesFor("x-MS950-HKSCS-XP"));
    }

    @Override
    public boolean contains(Charset cs) {
        return cs.name().equals("US-ASCII") || cs instanceof MS950 || cs instanceof MS950_HKSCS_XP;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Encoder
    extends HKSCS.Encoder {
        private static DoubleByte.Encoder ms950 = (DoubleByte.Encoder)new MS950().newEncoder();
        static char[][] c2bBmp = new char[256][];

        @Override
        public int encodeSupp(int cp) {
            return 65533;
        }

        private Encoder(Charset cs) {
            super(cs, ms950, c2bBmp, (char[][])null);
        }

        static {
            Encoder.initc2b(c2bBmp, HKSCS_XPMapping.b2cBmpStr, null);
        }
    }

    static class Decoder
    extends HKSCS.Decoder {
        private static DoubleByte.Decoder ms950 = (DoubleByte.Decoder)new MS950().newDecoder();
        private static char[][] b2cBmp = new char[256][];

        @Override
        public char decodeDoubleEx(int b1, int b2) {
            return '\ufffd';
        }

        private Decoder(Charset cs) {
            super(cs, ms950, b2cBmp, null);
        }

        static {
            Decoder.initb2c(b2cBmp, HKSCS_XPMapping.b2cBmpStr);
        }
    }
}

