/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.jmx;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.core.datasource.Storage;
import com.sun.tools.visualvm.core.datasupport.Utils;
import com.sun.tools.visualvm.jmx.EnvironmentProvider;
import java.util.HashMap;
import java.util.Map;

public abstract class CredentialsProvider
extends EnvironmentProvider {
    private static final String PROPERTY_USERNAME = "prop_credentials_username";
    private static final String PROPERTY_PASSWORD = "prop_credentials_password";
    private static Persistent PERSISTENT_PROVIDER;

    static synchronized Persistent persistent() {
        if (PERSISTENT_PROVIDER == null) {
            PERSISTENT_PROVIDER = new Persistent();
        }
        return PERSISTENT_PROVIDER;
    }

    @Override
    public String getId() {
        return CredentialsProvider.class.getName();
    }

    abstract String getUsername(Storage var1);

    abstract boolean hasPassword(Storage var1);

    abstract boolean isPersistent(Storage var1);

    private static Map<String, ?> createMap(String username, String password) {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        if (username != null && !username.isEmpty()) {
            map.put("jmx.remote.credentials", new String[]{username, CredentialsProvider.decodePassword(password)});
        }
        return map;
    }

    private static char[] encodePassword(char[] password) {
        if (password == null) {
            return null;
        }
        return Utils.encodePassword((String)new String(password)).toCharArray();
    }

    private static String decodePassword(String password) {
        if (password == null) {
            return null;
        }
        return Utils.decodePassword((String)password);
    }

    public static class Persistent
    extends CredentialsProvider {
        @Override
        public Map<String, ?> getEnvironment(Application application, Storage storage) {
            String username = storage.getCustomProperty(CredentialsProvider.PROPERTY_USERNAME);
            String password = storage.getCustomProperty(CredentialsProvider.PROPERTY_PASSWORD);
            return CredentialsProvider.createMap(username, password);
        }

        @Override
        public String getEnvironmentId(Storage storage) {
            String username;
            if (storage != null && (username = storage.getCustomProperty(CredentialsProvider.PROPERTY_USERNAME)) != null) {
                return username;
            }
            return super.getEnvironmentId(storage);
        }

        @Override
        String getUsername(Storage storage) {
            return storage.getCustomProperty(CredentialsProvider.PROPERTY_USERNAME);
        }

        @Override
        boolean hasPassword(Storage storage) {
            String password = storage.getCustomProperty(CredentialsProvider.PROPERTY_PASSWORD);
            return password != null && password.length() > 0;
        }

        @Override
        boolean isPersistent(Storage storage) {
            return this.getUsername(storage) != null || this.hasPassword(storage);
        }
    }

    public static class Custom
    extends CredentialsProvider {
        private final String username;
        private final char[] password;
        private final boolean persistent;

        public Custom(String username, char[] password, boolean persistent) {
            this.username = username;
            this.password = CredentialsProvider.encodePassword(password);
            this.persistent = persistent;
        }

        @Override
        public Map<String, ?> getEnvironment(Application application, Storage storage) {
            return CredentialsProvider.createMap(this.username, this.password != null ? new String(this.password) : null);
        }

        @Override
        public String getEnvironmentId(Storage storage) {
            if (this.username != null) {
                return this.username;
            }
            return super.getEnvironmentId(storage);
        }

        @Override
        public void saveEnvironment(Storage storage) {
            if (!this.persistent) {
                return;
            }
            storage.setCustomProperty(CredentialsProvider.PROPERTY_USERNAME, this.username);
            storage.setCustomProperty(CredentialsProvider.PROPERTY_PASSWORD, new String(this.password));
        }

        @Override
        String getUsername(Storage storage) {
            return this.username;
        }

        @Override
        boolean hasPassword(Storage storage) {
            return this.password != null && this.password.length > 0;
        }

        @Override
        boolean isPersistent(Storage storage) {
            return this.persistent;
        }
    }
}

