/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.profiling.presets;

import com.sun.tools.visualvm.core.ui.components.Spacer;
import com.sun.tools.visualvm.profiling.presets.PresetsUtils;
import com.sun.tools.visualvm.profiling.presets.ProfilerCPUSettings;
import com.sun.tools.visualvm.profiling.presets.ProfilerPreset;
import com.sun.tools.visualvm.profiling.presets.ProfilerPresets;
import com.sun.tools.visualvm.uisupport.JExtendedSpinner;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.filters.GenericFilter;
import org.netbeans.lib.profiler.filters.JavaTypeFilter;
import org.netbeans.lib.profiler.ui.swing.GrayLabel;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public abstract class ProfilerMemoryPanel
extends JPanel {
    private TextAreaComponent filtersArea;
    private JCheckBox lifecycleCheckbox;
    private JCheckBox outgoingCheckbox;
    private JExtendedSpinner outgoingSpinner;
    private JLabel unlimited;
    private JLabel noAllocs;
    private final Runnable validator;
    private boolean rootsValid = true;
    private boolean internalChange;

    public ProfilerMemoryPanel() {
        this((Runnable)null, false);
    }

    ProfilerMemoryPanel(Runnable validator, boolean mnemonics) {
        this.validator = validator;
        this.initComponents(mnemonics);
    }

    public ProfilingSettings getSettings() {
        ProfilingSettings settings = ProfilerIDESettings.getInstance().createDefaultProfilingSettings();
        settings.setProfilingType(this.lifecycleCheckbox.isSelected() ? 4 : 2);
        String filterValue = PresetsUtils.normalizeValue(this.getFilterValue());
        settings.setInstrumentationFilter((GenericFilter)new JavaTypeFilter(filterValue, 10));
        boolean limitAlloc = this.outgoingCheckbox.isSelected();
        int limit = (Integer)this.outgoingSpinner.getValue();
        settings.setAllocStackTraceLimit(!limitAlloc ? -10 : limit);
        return settings;
    }

    public boolean settingsValid() {
        return this.rootsValid;
    }

    public void highlighInvalid() {
        if (this.getFilterValue().isEmpty()) {
            this.filtersArea.getTextArea().setText(ProfilerPresets.DEFINE_CLASSES);
        }
    }

    public void loadFromPreset(ProfilerPreset preset) {
        if (preset == null) {
            return;
        }
        this.internalChange = true;
        this.filtersArea.getTextArea().setText(preset.getMemoryFilterP().trim());
        this.lifecycleCheckbox.setSelected(preset.getMemoryModeP());
        this.outgoingCheckbox.setSelected(preset.getStacksP());
        this.outgoingSpinner.setValue((Object)preset.getAllocP());
        this.highlighInvalid();
        this.internalChange = false;
        this.checkRootValidity();
        this.updateAllocControls();
    }

    public void saveToPreset(ProfilerPreset preset) {
        if (preset == null) {
            return;
        }
        preset.setMemoryFilterP(this.getFilterValue());
        preset.setMemoryModeP(this.lifecycleCheckbox.isSelected());
        preset.setStacksP(this.outgoingCheckbox.isSelected());
        preset.setAllocP((Integer)this.outgoingSpinner.getValue());
    }

    public abstract void settingsChanged();

    private void syncUI() {
        if (this.internalChange) {
            return;
        }
        this.settingsChanged();
    }

    private void updateAllocControls() {
        boolean selected = this.outgoingCheckbox.isSelected();
        this.unlimited.setVisible(!selected);
        this.outgoingSpinner.setVisible(selected);
        this.noAllocs.setVisible(selected && (Integer)this.outgoingSpinner.getValue() == 0);
    }

    private void checkRootValidity() {
        this.rootsValid = this.isRootValueValid();
        this.filtersArea.getTextArea().setForeground(this.rootsValid ? UIManager.getColor("TextArea.foreground") : Color.RED);
        if (this.validator != null) {
            this.validator.run();
        }
    }

    public boolean isRootValueValid() {
        String filterValue = PresetsUtils.normalizeValue(this.getFilterValue());
        return PresetsUtils.isValidJavaValue(filterValue, false, true);
    }

    private String getFilterValue() {
        return this.filtersArea.getTextArea().getText().trim();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (Component c : this.getComponents()) {
            c.setEnabled(enabled);
        }
    }

    private void initComponents(boolean mnemonics) {
        JFormattedTextField field;
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        JLabel filtersLabel = new JLabel();
        ProfilerMemoryPanel.setText(filtersLabel, NbBundle.getMessage(ProfilerCPUSettings.class, (String)"LBL_Root_Classes"), mnemonics);
        Dimension d = filtersLabel.getPreferredSize();
        JRadioButton refRadion = new JRadioButton(NbBundle.getMessage(ProfilerCPUSettings.class, (String)"LBL_Root_Classes"));
        refRadion.setBorder(filtersLabel.getBorder());
        d.height = Math.max(d.height, refRadion.getPreferredSize().height);
        filtersLabel.setPreferredSize(d);
        filtersLabel.setToolTipText(NbBundle.getMessage(ProfilerCPUSettings.class, (String)"TOOLTIP_Root_Classes"));
        filtersLabel.setOpaque(false);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(10, 10, 5, 10);
        this.add((Component)filtersLabel, constraints);
        this.filtersArea = ProfilerMemoryPanel.createTextArea(2);
        filtersLabel.setLabelFor(this.filtersArea.getTextArea());
        this.filtersArea.getTextArea().setToolTipText(NbBundle.getMessage(ProfilerMemoryPanel.class, (String)"ProfilerMemoryPanel_TOOLTIP_Filter"));
        this.filtersArea.getTextArea().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ProfilerMemoryPanel.this.checkRootValidity();
                ProfilerMemoryPanel.this.syncUI();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ProfilerMemoryPanel.this.checkRootValidity();
                ProfilerMemoryPanel.this.syncUI();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ProfilerMemoryPanel.this.checkRootValidity();
                ProfilerMemoryPanel.this.syncUI();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.65;
        constraints.gridwidth = 0;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 10, 10, 10);
        this.add((Component)this.filtersArea, constraints);
        this.lifecycleCheckbox = new JCheckBox(NbBundle.getMessage(ProfilerMemoryPanel.class, (String)"ProfilerMemoryPanel_BTN_Track_live")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                ProfilerMemoryPanel.this.syncUI();
            }
        };
        this.lifecycleCheckbox.setToolTipText(NbBundle.getMessage(ProfilerMemoryPanel.class, (String)"ProfilerMemoryPanel_TOOLTIP_Track_live"));
        this.lifecycleCheckbox.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(5, 10, 0, 5);
        this.add((Component)this.lifecycleCheckbox, constraints);
        this.outgoingCheckbox = new JCheckBox(NbBundle.getMessage(ProfilerMemoryPanel.class, (String)"ProfilerMemoryPanel_BTN_Limit_alloc")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                ProfilerMemoryPanel.this.updateAllocControls();
                ProfilerMemoryPanel.this.syncUI();
            }
        };
        this.outgoingCheckbox.setToolTipText(NbBundle.getMessage(ProfilerMemoryPanel.class, (String)"ProfilerMemoryPanel_TOOLTIP_Limit_alloc"));
        this.outgoingCheckbox.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(5, 10, 5, 5);
        this.add((Component)this.outgoingCheckbox, constraints);
        this.outgoingSpinner = new JExtendedSpinner(new SpinnerNumberModel(Math.abs(10), 0, 99, 1)){

            protected void fireStateChanged() {
                ProfilerMemoryPanel.this.updateAllocControls();
                ProfilerMemoryPanel.this.syncUI();
                super.fireStateChanged();
            }
        };
        this.outgoingSpinner.setToolTipText(NbBundle.getMessage(ProfilerMemoryPanel.class, (String)"ProfilerMemoryPanel_TOOLTIP_Limit_alloc2"));
        JComponent editor = this.outgoingSpinner.getEditor();
        JFormattedTextField jFormattedTextField = field = editor instanceof JSpinner.DefaultEditor ? ((JSpinner.DefaultEditor)editor).getTextField() : null;
        if (field != null) {
            field.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.change();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.change();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.change();
                }

                private void change() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ProfilerMemoryPanel.this.noAllocs.setVisible(ProfilerMemoryPanel.this.outgoingSpinner.isVisible() && (Integer)ProfilerMemoryPanel.this.outgoingSpinner.getValue() == 0);
                        }
                    });
                    ProfilerMemoryPanel.this.updateAllocControls();
                    ProfilerMemoryPanel.this.syncUI();
                }
            });
        }
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(5, 0, 5, 5);
        this.add((Component)this.outgoingSpinner, constraints);
        this.unlimited = new GrayLabel(NbBundle.getMessage(ProfilerMemoryPanel.class, (String)"ProfilerMemoryPanel_LBL_unlimited"));
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(5, 0, 5, 5);
        this.add((Component)this.unlimited, constraints);
        this.noAllocs = new GrayLabel(NbBundle.getMessage(ProfilerMemoryPanel.class, (String)"ProfilerMemoryPanel_LBL_No_alloc"));
        constraints = new GridBagConstraints();
        constraints.gridx = 3;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.noAllocs, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.weightx = 1.0;
        constraints.weighty = 0.35;
        constraints.gridwidth = 0;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)Spacer.create(), constraints);
    }

    private static void setText(JLabel l, String text, boolean mnemonics) {
        if (mnemonics) {
            Mnemonics.setLocalizedText((JLabel)l, (String)text);
        } else {
            l.setText(text.replace("&", ""));
        }
    }

    private static TextAreaComponent createTextArea(int rows) {
        final JTextArea rootsArea = new JTextArea();
        rootsArea.setFont(new Font("Monospaced", 0, UIManager.getFont("Label.font").getSize()));
        TextAreaComponent rootsAreaScrollPane = new TextAreaComponent(rootsArea, 20, 30){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                rootsArea.setEnabled(enabled);
            }
        };
        rootsAreaScrollPane.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        JTextArea referenceArea = new JTextArea("X");
        referenceArea.setFont(rootsArea.getFont());
        referenceArea.setRows(rows);
        Insets insets = rootsAreaScrollPane.getInsets();
        rootsAreaScrollPane.setPreferredSize(new Dimension(1, referenceArea.getPreferredSize().height + (insets != null ? insets.top + insets.bottom : 0)));
        return rootsAreaScrollPane;
    }

    private static class TextAreaComponent
    extends JScrollPane {
        public TextAreaComponent(JTextArea textArea, int vPolicy, int hPolicy) {
            super(textArea, vPolicy, hPolicy);
        }

        public JTextArea getTextArea() {
            return (JTextArea)this.getViewport().getView();
        }
    }
}

