/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.SwingUtilities;

public final class HeapProgress {
    public static final int PROGRESS_MAX = 1000;
    private static ThreadLocal progressThreadLocal = new ThreadLocal();

    private HeapProgress() {
    }

    public static BoundedRangeModel getProgress() {
        ModelInfo modelInfo = (ModelInfo)progressThreadLocal.get();
        if (modelInfo == null) {
            modelInfo = new ModelInfo();
            progressThreadLocal.set(modelInfo);
        }
        return modelInfo.model;
    }

    static void progress(long l, long l2, long l3, long l4) {
        if (l % 100000L == 0L) {
            HeapProgress.progress(l3, l4, l2);
        }
    }

    static void progress(long l, long l2) {
        HeapProgress.progress(l, 0L, l, l2);
    }

    private static void progress(long l, long l2, long l3) {
        ModelInfo modelInfo = (ModelInfo)progressThreadLocal.get();
        if (modelInfo != null) {
            if (modelInfo.level > modelInfo.divider) {
                modelInfo.divider = modelInfo.level;
            }
            long l4 = 1000L * (l - l3) / (l2 - l3);
            int n = (int)((long)modelInfo.offset + l4 / (long)modelInfo.divider);
            HeapProgress.setValue(modelInfo.model, n);
        }
    }

    private static int levelAdd(ModelInfo modelInfo, int n) {
        ModelInfo modelInfo2 = modelInfo;
        modelInfo2.level = modelInfo2.level + n;
        return modelInfo.level;
    }

    static void progressStart() {
        ModelInfo modelInfo = (ModelInfo)progressThreadLocal.get();
        if (modelInfo != null) {
            HeapProgress.levelAdd(modelInfo, 1);
        }
    }

    static void progressFinish() {
        ModelInfo modelInfo = (ModelInfo)progressThreadLocal.get();
        if (modelInfo != null) {
            int n = HeapProgress.levelAdd(modelInfo, -1);
            assert (n >= 0);
            if (n == 0) {
                progressThreadLocal.remove();
            }
            modelInfo.offset = modelInfo.model.getValue();
        }
    }

    private static void setValue(final BoundedRangeModel boundedRangeModel, final int n) {
        if (SwingUtilities.isEventDispatchThread()) {
            boundedRangeModel.setValue(n);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    boundedRangeModel.setValue(n);
                }
            });
        }
    }

    private static class ModelInfo {
        private BoundedRangeModel model = new DefaultBoundedRangeModel(0, 0, 0, 1000);
        private int level;
        private int divider;
        private int offset;

        private ModelInfo() {
        }
    }
}

