/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.util.AstUtil;

public class JsBlock
extends SourceInfoAwareJsNode
implements JsStatement {
    @NotNull
    private final List<JsStatement> statements;

    public JsBlock() {
        this(new ArrayList<JsStatement>());
    }

    public JsBlock(JsStatement statement2) {
        this(new SmartList<JsStatement>(statement2));
    }

    public JsBlock(JsStatement ... statements) {
        this(new SmartList<JsStatement>(statements));
    }

    public JsBlock(@NotNull List<JsStatement> statements) {
        this.statements = statements;
    }

    @NotNull
    public List<JsStatement> getStatements() {
        return this.statements;
    }

    public boolean isEmpty() {
        return this.statements.isEmpty();
    }

    public boolean isGlobalBlock() {
        return false;
    }

    @Override
    public void accept(JsVisitor v2) {
        v2.visitBlock(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        visitor2.acceptWithInsertRemove(this.statements);
    }

    @Override
    public void traverse(JsVisitorWithContext v2, JsContext ctx) {
        if (v2.visit(this, ctx)) {
            v2.acceptStatementList(this.statements);
        }
        v2.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsBlock deepCopy() {
        return new JsBlock(AstUtil.deepCopy(this.statements)).withMetadataFrom(this);
    }
}

