/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.operation;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsPostfixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.operation.IncrementTranslator;
import org.jetbrains.kotlin.js.translate.operation.OperatorTable;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtUnaryExpression;

public class DynamicIncrementTranslator
extends IncrementTranslator {
    @NotNull
    public static JsExpression doTranslate(@NotNull KtUnaryExpression expression2, @NotNull TranslationContext context) {
        return new DynamicIncrementTranslator(expression2, context).translate();
    }

    private DynamicIncrementTranslator(@NotNull KtUnaryExpression expression2, @NotNull TranslationContext context) {
        super(expression2, context);
    }

    @NotNull
    private JsExpression translate() {
        if (TranslationUtils.isSimpleNameExpressionNotDelegatedLocalVar(this.expression.getBaseExpression(), this.context())) {
            return this.primitiveExpressionIncrement();
        }
        return this.translateIncrementExpression();
    }

    @NotNull
    private JsExpression primitiveExpressionIncrement() {
        JsUnaryOperator operator = OperatorTable.getUnaryOperator(PsiUtils.getOperationToken(this.expression));
        JsExpression getExpression = this.accessTranslator.translateAsGet();
        if (PsiUtils.isPrefix(this.expression)) {
            return new JsPrefixOperation(operator, getExpression);
        }
        return new JsPostfixOperation(operator, getExpression);
    }

    @Override
    @NotNull
    protected JsExpression operationExpression(@NotNull TranslationContext context, @NotNull JsExpression receiver2) {
        return this.unaryAsBinary(receiver2);
    }

    @NotNull
    private JsBinaryOperation unaryAsBinary(@NotNull JsExpression leftExpression) {
        JsIntLiteral oneLiteral = new JsIntLiteral(1);
        KtToken token = PsiUtils.getOperationToken(this.expression);
        if (token.equals(KtTokens.PLUSPLUS)) {
            return new JsBinaryOperation(JsBinaryOperator.ADD, leftExpression, oneLiteral);
        }
        if (token.equals(KtTokens.MINUSMINUS)) {
            return new JsBinaryOperation(JsBinaryOperator.SUB, leftExpression, oneLiteral);
        }
        throw new AssertionError((Object)"This method should be called only for increment and decrement operators");
    }
}

