/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.hierarchy.cls;

import java.util.Collections;
import java.util.Set;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.hierarchy.AbstractSuperClassHierarchyProvider;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class InferredSuperClassHierarchyProvider
extends AbstractSuperClassHierarchyProvider {
    private OWLReasoner reasoner;

    public InferredSuperClassHierarchyProvider(OWLModelManager manager) {
        super(manager.getOWLOntologyManager());
    }

    public void setReasoner(OWLReasoner reasoner) {
        this.reasoner = reasoner;
        this.fireHierarchyChanged();
    }

    protected Set<? extends OWLClassExpression> getEquivalentClasses(OWLClass cls) {
        OWLReasoner myReasoner = this.reasoner;
        if (myReasoner == null) {
            return Collections.emptySet();
        }
        if (!myReasoner.isSatisfiable((OWLClassExpression)cls)) {
            return Collections.emptySet();
        }
        return myReasoner.getEquivalentClasses((OWLClassExpression)cls).getEntities();
    }

    @Override
    public Set<OWLClass> getUnfilteredChildren(OWLClass object) {
        OWLReasoner myReasoner = this.reasoner;
        if (myReasoner == null) {
            return Collections.emptySet();
        }
        if (!myReasoner.isSatisfiable((OWLClassExpression)object)) {
            return Collections.emptySet();
        }
        return myReasoner.getSuperClasses((OWLClassExpression)object, true).getFlattened();
    }

    @Override
    public Set<OWLClass> getEquivalents(OWLClass object) {
        return Collections.emptySet();
    }

    @Override
    public Set<OWLClass> getParents(OWLClass object) {
        OWLReasoner myReasoner = this.reasoner;
        if (myReasoner == null) {
            return Collections.emptySet();
        }
        if (!myReasoner.isSatisfiable((OWLClassExpression)object)) {
            return Collections.emptySet();
        }
        return myReasoner.getSubClasses((OWLClassExpression)object, true).getFlattened();
    }

    @Override
    public boolean containsReference(OWLClass object) {
        return false;
    }

    @Override
    public void setOntologies(Set<OWLOntology> ontologies) {
    }
}

