/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.Attribute;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.transport.netty4.Netty4TcpChannel;
import org.elasticsearch.transport.netty4.Netty4Transport;
import org.elasticsearch.transport.netty4.Netty4Utils;

final class Netty4MessageChannelHandler
extends ChannelDuplexHandler {
    private final Netty4Transport transport;

    Netty4MessageChannelHandler(Netty4Transport transport) {
        this.transport = transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        Transports.assertTransportThread();
        assert (msg instanceof ByteBuf) : "Expected message type ByteBuf, found: " + msg.getClass();
        ByteBuf buffer = (ByteBuf)msg;
        try {
            Channel channel = ctx.channel();
            Attribute channelAttribute = channel.attr(Netty4Transport.CHANNEL_KEY);
            this.transport.inboundMessage((TcpChannel)channelAttribute.get(), Netty4Utils.toBytesReference(buffer));
        }
        finally {
            buffer.release();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
        Throwable unwrapped = ExceptionsHelper.unwrap((Throwable)cause, (Class[])new Class[]{ElasticsearchException.class});
        Throwable newCause = unwrapped != null ? unwrapped : cause;
        Netty4TcpChannel tcpChannel = (Netty4TcpChannel)ctx.channel().attr(Netty4Transport.CHANNEL_KEY).get();
        if (newCause instanceof Error) {
            this.transport.onException(tcpChannel, new Exception(newCause));
        } else {
            this.transport.onException(tcpChannel, (Exception)newCause);
        }
    }
}

