/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.gui.menus;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.fibs.geotag.Settings;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.googleearth.GoogleEarthLauncher;
import org.fibs.geotag.googleearth.GoogleearthFileFilter;
import org.fibs.geotag.gui.MainWindow;
import org.fibs.geotag.gui.menus.MenuConstants;
import org.fibs.geotag.image.ThumbnailWorker;
import org.fibs.geotag.table.ImagesTable;
import org.fibs.geotag.table.ImagesTableModel;
import org.fibs.geotag.tasks.GoogleEarthExportTask;
import org.fibs.geotag.tasks.TaskExecutor;
import org.fibs.geotag.tasks.ThumbnailsTask;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class GoogleEarthMenu
extends JMenu
implements ActionListener,
MenuConstants {
    private static final I18n i18n = I18nFactory.getI18n(GoogleEarthMenu.class);
    private JMenuItem showInGoogleEarthItem;
    private JMenuItem exportOneImageToKmlItem;
    private JMenuItem exportSelectedToKmlItem;
    private JMenuItem exportAllToKmlItem;
    ImageInfo currentImage;
    private ImagesTableModel tableModel;
    private int[] selectedRows;

    public GoogleEarthMenu(boolean backgroundTask, ImagesTable imagesTable, ImageInfo currentImage) {
        super(GOOGLEEARTH);
        this.currentImage = currentImage;
        this.tableModel = (ImagesTableModel)imagesTable.getModel();
        this.selectedRows = imagesTable.getSelectedRows();
        this.showInGoogleEarthItem = new JMenuItem(SHOW_IN_GOOGLEEARTH);
        boolean enabled = true;
        this.showInGoogleEarthItem.setEnabled(enabled);
        this.showInGoogleEarthItem.addActionListener(this);
        this.add(this.showInGoogleEarthItem);
        this.exportOneImageToKmlItem = new JMenuItem(EXPORT_THIS);
        enabled = !backgroundTask && currentImage.hasLocation();
        this.exportOneImageToKmlItem.setEnabled(enabled);
        this.exportOneImageToKmlItem.addActionListener(this);
        this.add(this.exportOneImageToKmlItem);
        this.exportSelectedToKmlItem = new JMenuItem(EXPORT_SELECTED);
        enabled = false;
        int index = 0;
        while (index < this.selectedRows.length) {
            if (this.tableModel.getImageInfo(this.selectedRows[index]).hasLocation()) {
                enabled = !backgroundTask;
                break;
            }
            ++index;
        }
        this.exportSelectedToKmlItem.setEnabled(enabled);
        this.exportSelectedToKmlItem.addActionListener(this);
        this.add(this.exportSelectedToKmlItem);
        this.exportAllToKmlItem = new JMenuItem(EXPORT_ALL);
        enabled = false;
        index = 0;
        while (index < this.tableModel.getRowCount()) {
            if (this.tableModel.getImageInfo(index).hasLocation()) {
                enabled = !backgroundTask;
                break;
            }
            ++index;
        }
        this.exportAllToKmlItem.setEnabled(enabled);
        this.exportAllToKmlItem.addActionListener(this);
        this.add(this.exportAllToKmlItem);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.showInGoogleEarthItem) {
            this.showInGoogleEarth();
        } else if (event.getSource() == this.exportOneImageToKmlItem) {
            this.exportOneToKml();
        } else if (event.getSource() == this.exportSelectedToKmlItem) {
            this.exportSelectedToKml();
        } else if (event.getSource() == this.exportAllToKmlItem) {
            this.exportAllToKml();
        }
    }

    private void showInGoogleEarth() {
        ThumbnailWorker worker = new ThumbnailWorker(this.currentImage){

            @Override
            protected void done() {
                GoogleEarthLauncher.launch(GoogleEarthMenu.this.currentImage);
            }
        };
        TaskExecutor.execute(worker);
    }

    private void exportOneToKml() {
        ArrayList<ImageInfo> images = new ArrayList<ImageInfo>();
        images.add(this.currentImage);
        this.exportToKml(images);
    }

    private void exportSelectedToKml() {
        ArrayList<ImageInfo> images = new ArrayList<ImageInfo>();
        int index = 0;
        while (index < this.selectedRows.length) {
            ImageInfo candidate = this.tableModel.getImageInfo(this.selectedRows[index]);
            if (candidate.hasLocation()) {
                images.add(candidate);
            }
            ++index;
        }
        this.exportToKml(images);
    }

    private void exportAllToKml() {
        ArrayList<ImageInfo> images = new ArrayList<ImageInfo>();
        int index = 0;
        while (index < this.tableModel.getRowCount()) {
            ImageInfo candidate = this.tableModel.getImageInfo(index);
            if (candidate.hasLocation()) {
                images.add(candidate);
            }
            ++index;
        }
        this.exportToKml(images);
    }

    private void exportToKml(final List<ImageInfo> images) {
        File file;
        JFileChooser chooser = new JFileChooser();
        String lastFile = Settings.get(Settings.SETTING.GOOGLEEARTH_LAST_FILE_SAVED, null);
        if (lastFile != null && (file = new File(lastFile)).exists() && file.getParentFile() != null) {
            chooser.setCurrentDirectory(file.getParentFile());
        }
        GoogleearthFileFilter fileFilter = new GoogleearthFileFilter();
        chooser.setFileFilter(fileFilter);
        chooser.setMultiSelectionEnabled(false);
        JFrame parentFrame = MainWindow.getMainWindow(this);
        if (chooser.showSaveDialog(parentFrame) == 0) {
            try {
                File outputFile = chooser.getSelectedFile();
                if (!fileFilter.accept(outputFile)) {
                    outputFile = new File(String.valueOf(chooser.getSelectedFile().getPath()) + ".kml");
                }
                if (outputFile.exists()) {
                    String title = i18n.tr("File exists");
                    String message = String.format(i18n.tr("Overwrite existing file %s?"), outputFile.getName());
                    if (JOptionPane.showConfirmDialog(parentFrame, message, title, 0, 3) == 1) {
                        return;
                    }
                }
                if (GoogleearthFileFilter.isKmzFile(outputFile) && Settings.get(Settings.SETTING.KMZ_STORE_THUMBNAILS, false)) {
                    final File file2 = outputFile;
                    TaskExecutor.execute(new ThumbnailsTask(i18n.tr("Generate thumbnails"), images){

                        @Override
                        public void done() {
                            GoogleEarthMenu.this.exportToKml(images, file2);
                        }
                    });
                } else {
                    this.exportToKml(images, outputFile);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void exportToKml(List<ImageInfo> images, File file) {
        TaskExecutor.execute(new GoogleEarthExportTask(i18n.tr("Export for Google Earth"), images, file));
        Settings.put(Settings.SETTING.GOOGLEEARTH_LAST_FILE_SAVED, file.getPath());
    }
}

