/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.threedee;

import com.sun.j3d.utils.behaviors.vp.OrbitBehavior;
import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.image.TextureLoader;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Billboard;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.Group;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PointLight;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Text3D;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import tim.prune.DataStatus;
import tim.prune.FunctionLibrary;
import tim.prune.I18nManager;
import tim.prune.data.Track;
import tim.prune.function.Export3dFunction;
import tim.prune.function.srtm.LookupSrtmFunction;
import tim.prune.gui.map.MapSourceLibrary;
import tim.prune.save.GroutedImage;
import tim.prune.save.MapGrouter;
import tim.prune.threedee.ImageDefinition;
import tim.prune.threedee.TerrainCache;
import tim.prune.threedee.TerrainDefinition;
import tim.prune.threedee.TerrainHelper;
import tim.prune.threedee.ThreeDException;
import tim.prune.threedee.ThreeDModel;
import tim.prune.threedee.ThreeDWindow;

public class Java3DWindow
implements ThreeDWindow {
    private Track _track = null;
    private JFrame _parentFrame = null;
    private JFrame _frame = null;
    private ThreeDModel _model = null;
    private OrbitBehavior _orbit = null;
    private double _altFactor = -1.0;
    private ImageDefinition _imageDefinition = null;
    private GroutedImage _baseImage = null;
    private TerrainDefinition _terrainDefinition = null;
    private DataStatus _dataStatus = null;
    private static boolean TRACK_SIZE_WARNING_GIVEN = false;
    private static final double INITIAL_Y_ROTATION = -25.0;
    private static final double INITIAL_X_ROTATION = 15.0;
    private static final String CARDINALS_FONT = "Arial";
    private static final int MAX_TRACK_SIZE = 2500;
    private static final double MODEL_SCALE_FACTOR = 20.0;

    public Java3DWindow(JFrame jFrame) {
        this._parentFrame = jFrame;
    }

    public void setTrack(Track track) {
        this._track = track;
    }

    public void setAltitudeFactor(double d) {
        this._altFactor = d;
    }

    public void setBaseImageParameters(ImageDefinition imageDefinition) {
        this._imageDefinition = imageDefinition;
        this._baseImage = imageDefinition != null && imageDefinition.getUseImage() ? new MapGrouter().createMapImage(this._track, MapSourceLibrary.getSource(imageDefinition.getSourceIndex()), imageDefinition.getZoom()) : null;
    }

    public void setTerrainParameters(TerrainDefinition terrainDefinition) {
        this._terrainDefinition = terrainDefinition;
    }

    public void setDataStatus(DataStatus dataStatus) {
        this._dataStatus = dataStatus;
    }

    public void show() throws ThreeDException {
        Object[] objectArray;
        GraphicsConfiguration graphicsConfiguration;
        if (this._altFactor < 0.0) {
            this._altFactor = 1.0;
        }
        if ((graphicsConfiguration = SimpleUniverse.getPreferredConfiguration()) == null) {
            objectArray = new GraphicsConfigTemplate3D();
            objectArray.setDepthSize(0);
            graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration((GraphicsConfigTemplate)objectArray);
        }
        if (graphicsConfiguration == null) {
            throw new ThreeDException("Couldn't create graphics config");
        }
        objectArray = new Object[]{I18nManager.getText("button.continue"), I18nManager.getText("button.cancel")};
        if (this._track.getNumPoints() > 2500 && !TRACK_SIZE_WARNING_GIVEN) {
            if (JOptionPane.showOptionDialog(this._parentFrame, I18nManager.getText("dialog.3d.warningtracksize"), I18nManager.getText("function.show3d"), 2, 2, null, objectArray, objectArray[1]) == 0) {
                TRACK_SIZE_WARNING_GIVEN = true;
            } else {
                return;
            }
        }
        Canvas3D canvas3D = new Canvas3D(graphicsConfiguration);
        canvas3D.setSize(400, 300);
        BranchGroup branchGroup = this.createSceneGraph();
        SimpleUniverse simpleUniverse = new SimpleUniverse(canvas3D);
        simpleUniverse.getViewingPlatform().setNominalViewingTransform();
        this._orbit = new OrbitBehavior(canvas3D, 368);
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        this._orbit.setSchedulingBounds((Bounds)boundingSphere);
        simpleUniverse.getViewingPlatform().setViewPlatformBehavior((ViewPlatformBehavior)this._orbit);
        simpleUniverse.addBranchGraph(branchGroup);
        this._frame = new JFrame(I18nManager.getText("dialog.3d.title"));
        this._frame.getContentPane().setLayout(new BorderLayout());
        this._frame.getContentPane().add((Component)canvas3D, "Center");
        this._frame.setIconImage(this._parentFrame.getIconImage());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(I18nManager.getText("function.exportpov"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Java3DWindow.this._orbit != null) {
                    Java3DWindow.this.callbackRender(FunctionLibrary.FUNCTION_POVEXPORT);
                }
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton(I18nManager.getText("button.close"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Java3DWindow.this.dispose();
                Java3DWindow.this._orbit = null;
            }
        });
        jPanel.add(jButton2);
        this._frame.getContentPane().add((Component)jPanel, "South");
        this._frame.setSize(500, 350);
        this._frame.pack();
        this._frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Java3DWindow.this.dispose();
            }
        });
        this._frame.setVisible(true);
        if (this._frame.getState() == 1) {
            this._frame.setState(0);
        }
    }

    public void dispose() {
        if (this._frame != null) {
            this._frame.dispose();
            this._frame = null;
        }
    }

    private BranchGroup createSceneGraph() {
        LookupSrtmFunction lookupSrtmFunction;
        Track track;
        Object object;
        boolean bl;
        BranchGroup branchGroup = new BranchGroup();
        TransformGroup transformGroup = new TransformGroup();
        transformGroup.setCapability(18);
        Transform3D transform3D = new Transform3D();
        transform3D.setScale(0.055);
        TransformGroup transformGroup2 = new TransformGroup(transform3D);
        branchGroup.addChild((Node)transformGroup2);
        Transform3D transform3D2 = new Transform3D();
        transform3D2.rotY(Math.toRadians(-25.0));
        Transform3D transform3D3 = new Transform3D();
        transform3D3.rotX(Math.toRadians(15.0));
        TransformGroup transformGroup3 = new TransformGroup(transform3D3);
        transformGroup.setTransform(transform3D2);
        transformGroup2.addChild((Node)transformGroup3);
        transformGroup3.addChild((Node)transformGroup);
        Appearance appearance = null;
        Box box = null;
        appearance = new Appearance();
        appearance.setMaterial(new Material(new Color3f(0.1f, 0.2f, 0.2f), new Color3f(0.0f, 0.0f, 0.0f), new Color3f(0.3f, 0.4f, 0.4f), new Color3f(0.3f, 0.3f, 0.3f), 0.0f));
        box = new Box(10.0f, 0.04f, 10.0f, appearance);
        transformGroup.addChild((Node)box);
        boolean bl2 = bl = this._terrainDefinition != null && this._terrainDefinition.getUseTerrain();
        if (this._baseImage != null && !bl) {
            object = new QuadArray(4, 33);
            object.setCoordinate(0, new Point3f(-10.0f, 0.05f, -10.0f));
            object.setCoordinate(1, new Point3f(-10.0f, 0.05f, 10.0f));
            object.setCoordinate(2, new Point3f(10.0f, 0.05f, 10.0f));
            object.setCoordinate(3, new Point3f(10.0f, 0.05f, -10.0f));
            object.setTextureCoordinate(0, 0, new TexCoord2f(0.0f, 1.0f));
            object.setTextureCoordinate(0, 1, new TexCoord2f(0.0f, 0.0f));
            object.setTextureCoordinate(0, 2, new TexCoord2f(1.0f, 0.0f));
            object.setTextureCoordinate(0, 3, new TexCoord2f(1.0f, 1.0f));
            track = new Appearance();
            lookupSrtmFunction = new TextureLoader((Image)this._baseImage.getImage(), (Component)this._frame).getTexture();
            track.setTexture((Texture)lookupSrtmFunction);
            transformGroup.addChild((Node)new Shape3D((Geometry)object, (Appearance)track));
        }
        this._model = new ThreeDModel(this._track);
        this._model.setAltitudeFactor(this._altFactor);
        if (bl) {
            object = new TerrainHelper(this._terrainDefinition.getGridSize());
            track = TerrainCache.getTerrainTrack(this._dataStatus, this._terrainDefinition);
            if (track == null) {
                track = ((TerrainHelper)object).createGridTrack(this._track);
                lookupSrtmFunction = (LookupSrtmFunction)FunctionLibrary.FUNCTION_LOOKUP_SRTM;
                lookupSrtmFunction.begin(track);
                while (lookupSrtmFunction.isRunning()) {
                    try {
                        Thread.sleep(750L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                ((TerrainHelper)object).fixVoids(track);
                TerrainCache.storeTerrainTrack(track, this._dataStatus, this._terrainDefinition);
            }
            this._model.setTerrain(track);
            this._model.scale();
            transformGroup.addChild((Node)Java3DWindow.createTerrain(this._model, (TerrainHelper)object, this._baseImage));
        } else {
            this._model.scale();
        }
        object = new GeneralPath();
        ((Path2D.Float)object).moveTo(0.0f, 0.0f);
        int n = 0;
        while (n < 91) {
            ((Path2D.Float)object).lineTo((float)(0.1 - 0.1 * Math.cos(Math.toRadians(n))), (float)(0.1 * Math.sin(Math.toRadians(n))));
            n += 5;
        }
        n = 90;
        while (n > 0) {
            ((Path2D.Float)object).lineTo((float)(0.3 + 0.1 * Math.cos(Math.toRadians(n))), (float)(0.1 * Math.sin(Math.toRadians(n))));
            n -= 5;
        }
        Font3D font3D = new Font3D(new Font(CARDINALS_FONT, 0, 1), new FontExtrusion((Shape)object));
        transformGroup.addChild((Node)this.createCompassPoint(I18nManager.getText("cardinal.n"), new Point3f(0.0f, 0.0f, -11.5f), font3D));
        transformGroup.addChild((Node)this.createCompassPoint(I18nManager.getText("cardinal.s"), new Point3f(0.0f, 0.0f, 11.5f), font3D));
        transformGroup.addChild((Node)this.createCompassPoint(I18nManager.getText("cardinal.w"), new Point3f(-11.5f, 0.0f, 0.0f), font3D));
        transformGroup.addChild((Node)this.createCompassPoint(I18nManager.getText("cardinal.e"), new Point3f(11.5f, 0.0f, 0.0f), font3D));
        transformGroup.addChild((Node)Java3DWindow.createDataPoints(this._model));
        lookupSrtmFunction = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        AmbientLight ambientLight = new AmbientLight(new Color3f(1.0f, 1.0f, 1.0f));
        ambientLight.setInfluencingBounds((Bounds)lookupSrtmFunction);
        transformGroup.addChild((Node)ambientLight);
        if (bl) {
            DirectionalLight directionalLight = new DirectionalLight(true, new Color3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, -1.0f, 1.0f));
            directionalLight.setInfluencingBounds((Bounds)lookupSrtmFunction);
            transformGroup.addChild((Node)directionalLight);
        } else {
            PointLight pointLight = new PointLight(new Color3f(1.0f, 1.0f, 1.0f), new Point3f(0.0f, 0.0f, 2.0f), new Point3f(0.25f, 0.05f, 0.0f));
            pointLight.setInfluencingBounds((Bounds)lookupSrtmFunction);
            transformGroup.addChild((Node)pointLight);
            PointLight pointLight2 = new PointLight(new Color3f(0.8f, 0.9f, 0.4f), new Point3f(6.0f, 1.0f, 6.0f), new Point3f(0.2f, 0.1f, 0.05f));
            pointLight2.setInfluencingBounds((Bounds)lookupSrtmFunction);
            transformGroup.addChild((Node)pointLight2);
            PointLight pointLight3 = new PointLight(new Color3f(0.7f, 0.7f, 0.7f), new Point3f(0.0f, 12.0f, -2.0f), new Point3f(0.1f, 0.1f, 0.0f));
            pointLight3.setInfluencingBounds((Bounds)lookupSrtmFunction);
            transformGroup.addChild((Node)pointLight3);
        }
        branchGroup.compile();
        return branchGroup;
    }

    private TransformGroup createCompassPoint(String string, Point3f point3f, Font3D font3D) {
        Text3D text3D = new Text3D(font3D, string, point3f, 1, 1);
        Material material = new Material(new Color3f(0.5f, 0.5f, 0.55f), new Color3f(0.05f, 0.05f, 0.1f), new Color3f(0.3f, 0.4f, 0.5f), new Color3f(0.4f, 0.5f, 0.7f), 70.0f);
        material.setLightingEnable(true);
        Appearance appearance = new Appearance();
        appearance.setMaterial(material);
        Shape3D shape3D = new Shape3D((Geometry)text3D, appearance);
        TransformGroup transformGroup = new TransformGroup();
        transformGroup.setCapability(18);
        transformGroup.addChild((Node)shape3D);
        Billboard billboard = new Billboard(transformGroup, 1, point3f);
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        billboard.setSchedulingBounds((Bounds)boundingSphere);
        transformGroup.addChild((Node)billboard);
        return transformGroup;
    }

    private static Group createDataPoints(ThreeDModel threeDModel) {
        Group group = new Group();
        int n = threeDModel.getNumPoints();
        int n2 = 0;
        while (n2 < n) {
            byte by = threeDModel.getPointType(n2);
            if (by == 1) {
                group.addChild((Node)Java3DWindow.createWaypoint(new Point3d(threeDModel.getScaledHorizValue(n2) * 20.0, threeDModel.getScaledAltValue(n2) * 20.0, -threeDModel.getScaledVertValue(n2) * 20.0)));
            } else {
                group.addChild((Node)Java3DWindow.createTrackpoint(new Point3d(threeDModel.getScaledHorizValue(n2) * 20.0, threeDModel.getScaledAltValue(n2) * 20.0, -threeDModel.getScaledVertValue(n2) * 20.0), threeDModel.getPointHeightCode(n2)));
            }
            ++n2;
        }
        return group;
    }

    private static Group createWaypoint(Point3d point3d) {
        Material material = Java3DWindow.getWaypointMaterial();
        Sphere sphere = new Sphere(0.35f);
        return Java3DWindow.createBall(point3d, sphere, material);
    }

    private static Material getWaypointMaterial() {
        return new Material(new Color3f(0.1f, 0.1f, 0.4f), new Color3f(0.0f, 0.0f, 0.0f), new Color3f(0.0f, 0.2f, 0.7f), new Color3f(1.0f, 0.6f, 0.6f), 40.0f);
    }

    private static Group createTrackpoint(Point3d point3d, byte by) {
        Material material = Java3DWindow.getTrackpointMaterial(by);
        Sphere sphere = new Sphere(0.2f);
        return Java3DWindow.createBall(point3d, sphere, material);
    }

    private static Material getTrackpointMaterial(byte by) {
        Material material = new Material(new Color3f(0.3f, 0.2f, 0.1f), new Color3f(0.0f, 0.0f, 0.0f), new Color3f(0.0f, 0.6f, 0.0f), new Color3f(1.0f, 0.6f, 0.6f), 70.0f);
        if (by == 1) {
            material.setDiffuseColor(new Color3f(0.4f, 0.9f, 0.2f));
        } else if (by == 2) {
            material.setDiffuseColor(new Color3f(0.7f, 0.8f, 0.2f));
        } else if (by == 3) {
            material.setDiffuseColor(new Color3f(0.3f, 0.6f, 0.4f));
        } else if (by == 4) {
            material.setDiffuseColor(new Color3f(0.1f, 0.9f, 0.9f));
        } else if (by >= 5) {
            material.setDiffuseColor(new Color3f(1.0f, 1.0f, 1.0f));
        }
        return material;
    }

    private static Group createBall(Point3d point3d, Sphere sphere, Material material) {
        Group group = new Group();
        Transform3D transform3D = new Transform3D();
        transform3D.setTranslation(new Vector3d((Tuple3d)point3d));
        TransformGroup transformGroup = new TransformGroup(transform3D);
        material.setLightingEnable(true);
        Appearance appearance = new Appearance();
        appearance.setMaterial(material);
        sphere.setAppearance(appearance);
        transformGroup.addChild((Node)sphere);
        group.addChild((Node)transformGroup);
        Cylinder cylinder = new Cylinder(0.1f, (float)point3d.y);
        Material material2 = new Material(new Color3f(0.2f, 0.2f, 0.2f), new Color3f(0.0f, 0.0f, 0.0f), new Color3f(0.2f, 0.2f, 0.2f), new Color3f(0.05f, 0.05f, 0.05f), 0.4f);
        material2.setLightingEnable(true);
        Appearance appearance2 = new Appearance();
        appearance2.setMaterial(material2);
        cylinder.setAppearance(appearance2);
        Transform3D transform3D2 = new Transform3D();
        transform3D2.setTranslation(new Vector3d(point3d.x, point3d.y / 2.0, point3d.z));
        TransformGroup transformGroup2 = new TransformGroup(transform3D2);
        transformGroup2.addChild((Node)cylinder);
        group.addChild((Node)transformGroup2);
        return group;
    }

    private static Shape3D createTerrain(ThreeDModel threeDModel, TerrainHelper terrainHelper, GroutedImage groutedImage) {
        Texture texture;
        int n = terrainHelper.getGridSize();
        int n2 = n * (n * 2 - 2);
        int[] nArray = terrainHelper.getStripLengths();
        int n3 = n * n;
        Point3d[] point3dArray = new Point3d[n3];
        int n4 = 0;
        while (n4 < n3) {
            double d = threeDModel.getScaledTerrainValue(n4) * 20.0;
            point3dArray[n4] = new Point3d(threeDModel.getScaledTerrainHorizValue(n4) * 20.0, Math.max(d, 0.05), -threeDModel.getScaledTerrainVertValue(n4) * 20.0);
            ++n4;
        }
        GeometryInfo geometryInfo = new GeometryInfo(4);
        geometryInfo.setCoordinates(terrainHelper.getTerrainCoordinates(point3dArray));
        geometryInfo.setStripCounts(nArray);
        Appearance appearance = new Appearance();
        if (groutedImage != null) {
            geometryInfo.setTextureCoordinateParams(1, 2);
            geometryInfo.setTextureCoordinates(0, terrainHelper.getTextureCoordinates());
            texture = new TextureLoader(groutedImage.getImage()).getTexture();
            appearance.setTexture(texture);
            TextureAttributes textureAttributes = new TextureAttributes();
            textureAttributes.setTextureMode(2);
            appearance.setTextureAttributes(textureAttributes);
        } else {
            texture = new Color3f[n2];
            Color3f color3f = new Color3f(0.1f, 0.2f, 0.2f);
            int n5 = 0;
            while (n5 < n2) {
                texture[n5] = color3f;
                ++n5;
            }
            geometryInfo.setColors((Color3f[])texture);
        }
        new NormalGenerator().generateNormals(geometryInfo);
        texture = new Material(new Color3f(0.4f, 0.4f, 0.4f), new Color3f(0.0f, 0.0f, 0.0f), new Color3f(0.8f, 0.8f, 0.8f), new Color3f(0.2f, 0.2f, 0.2f), 30.0f);
        appearance.setMaterial((Material)texture);
        return new Shape3D((Geometry)geometryInfo.getGeometryArray(), appearance);
    }

    private void callbackRender(Export3dFunction export3dFunction) {
        Transform3D transform3D = new Transform3D();
        this._orbit.getViewingPlatform().getViewPlatformTransform().getTransform(transform3D);
        Matrix3d matrix3d = new Matrix3d();
        transform3D.get(matrix3d);
        Point3d point3d = new Point3d(0.0, 0.0, 1.0);
        matrix3d.transform((Tuple3d)point3d);
        Transform3D transform3D2 = new Transform3D();
        transform3D2.rotY(Math.toRadians(25.0));
        Transform3D transform3D3 = new Transform3D();
        transform3D3.rotX(Math.toRadians(-15.0));
        Point3d point3d2 = new Point3d();
        transform3D3.transform(point3d, point3d2);
        transform3D2.transform(point3d2);
        export3dFunction.setCameraCoordinates(point3d2.x, point3d2.y, point3d2.z);
        export3dFunction.setAltitudeExaggeration(this._altFactor);
        export3dFunction.setTerrainDefinition(this._terrainDefinition);
        export3dFunction.setImageDefinition(this._imageDefinition);
        export3dFunction.begin();
    }
}

