/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.changes;

import org.gradle.StartParameter;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.TaskExecutionMode;
import org.gradle.api.internal.changedetection.TaskExecutionModeResolver;
import org.gradle.api.internal.tasks.execution.TaskProperties;
import org.gradle.api.specs.AndSpec;

@NonNullApi
public class DefaultTaskExecutionModeResolver
implements TaskExecutionModeResolver {
    private final StartParameter startParameter;

    public DefaultTaskExecutionModeResolver(StartParameter startParameter) {
        this.startParameter = startParameter;
    }

    @Override
    public TaskExecutionMode getExecutionMode(TaskInternal task, TaskProperties taskProperties) {
        AndSpec<? super TaskInternal> upToDateSpec = task.getOutputs().getUpToDateSpec();
        if (!taskProperties.hasDeclaredOutputs() && upToDateSpec.isEmpty()) {
            if (task.hasTaskActions()) {
                return TaskExecutionMode.NO_OUTPUTS_WITH_ACTIONS;
            }
            return TaskExecutionMode.NO_OUTPUTS_WITHOUT_ACTIONS;
        }
        if (this.startParameter.isRerunTasks()) {
            return TaskExecutionMode.RERUN_TASKS_ENABLED;
        }
        if (!upToDateSpec.isSatisfiedBy((Object)task)) {
            return TaskExecutionMode.UP_TO_DATE_WHEN_FALSE;
        }
        return TaskExecutionMode.INCREMENTAL;
    }
}

