/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.io.File;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.buildinit.plugins.internal.SimpleTemplateOperation;
import org.gradle.buildinit.plugins.internal.TemplateOperation;
import org.gradle.buildinit.plugins.internal.TemplateValue;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.util.GradleVersion;

public class TemplateOperationFactory {
    private final String templatepackage;
    private final PathToFileResolver fileResolver;
    private final DocumentationRegistry documentationRegistry;
    private final Map defaultBindings;

    public TemplateOperationFactory(String templatepackage, PathToFileResolver fileResolver, DocumentationRegistry documentationRegistry) {
        this.documentationRegistry = documentationRegistry;
        this.fileResolver = fileResolver;
        this.templatepackage = templatepackage;
        this.defaultBindings = this.loadDefaultBindings();
    }

    private Map<String, String> loadDefaultBindings() {
        String now = DateFormat.getDateTimeInstance(3, 3).format(new Date());
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(3);
        map.put("genDate", now);
        map.put("genUser", System.getProperty("user.name"));
        map.put("genGradleVersion", GradleVersion.current().toString());
        return map;
    }

    public TemplateOperationBuilder newTemplateOperation() {
        return new TemplateOperationBuilder(this.defaultBindings);
    }

    public class TemplateOperationBuilder {
        private File target;
        private Map<String, String> bindings = new HashMap<String, String>();
        private URL templateUrl;

        public TemplateOperationBuilder(Map defaultBindings) {
            this.bindings.putAll(defaultBindings);
        }

        public TemplateOperationBuilder withTemplate(String relativeTemplatePath) {
            this.templateUrl = this.getClass().getResource(TemplateOperationFactory.this.templatepackage + "/" + relativeTemplatePath);
            if (this.templateUrl == null) {
                throw new IllegalArgumentException(String.format("Could not find template '%s' in classpath.", relativeTemplatePath));
            }
            return this;
        }

        public TemplateOperationBuilder withTemplate(URL templateURL) {
            this.templateUrl = templateURL;
            return this;
        }

        public TemplateOperationBuilder withTarget(String targetFilePath) {
            this.target = TemplateOperationFactory.this.fileResolver.resolve((Object)targetFilePath);
            return this;
        }

        public TemplateOperationBuilder withDocumentationBindings(Map<String, String> documentationBindings) {
            for (Map.Entry<String, String> entry : documentationBindings.entrySet()) {
                this.bindings.put(entry.getKey(), TemplateOperationFactory.this.documentationRegistry.getDocumentationFor(entry.getValue()));
            }
            return this;
        }

        public TemplateOperationBuilder withBindings(Map<String, String> bindings) {
            this.bindings.putAll(bindings);
            return this;
        }

        public TemplateOperationBuilder withBinding(String name, String value) {
            this.bindings.put(name, value);
            return this;
        }

        public TemplateOperation create() {
            Set<Map.Entry<String, String>> entries = this.bindings.entrySet();
            HashMap<String, TemplateValue> wrappedBindings = new HashMap<String, TemplateValue>(entries.size());
            for (Map.Entry<String, String> entry : entries) {
                if (entry.getValue() == null) {
                    throw new IllegalArgumentException("Null value provided for binding '" + entry.getKey() + "'.");
                }
                wrappedBindings.put(entry.getKey(), new TemplateValue(entry.getValue()));
            }
            return new SimpleTemplateOperation(this.templateUrl, this.target, wrappedBindings);
        }
    }
}

