/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.internal.provider.AbstractProperty;
import org.gradle.api.internal.provider.CollectionPropertyInternal;
import org.gradle.api.internal.provider.Collector;
import org.gradle.api.internal.provider.Collectors;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.provider.ValidatingValueCollector;
import org.gradle.api.internal.provider.ValueCollector;
import org.gradle.api.internal.provider.ValueSanitizers;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.provider.HasMultipleValues;
import org.gradle.api.provider.Provider;

public abstract class AbstractCollectionProperty<T, C extends Collection<T>>
extends AbstractProperty<C>
implements CollectionPropertyInternal<T, C> {
    private static final Collectors.EmptyCollection EMPTY_COLLECTION = new Collectors.EmptyCollection();
    private static final Collectors.NoValueCollector NO_VALUE_COLLECTOR = new Collectors.NoValueCollector();
    private final Class<? extends Collection> collectionType;
    private final Class<T> elementType;
    private final ValueCollector<T> valueCollector;
    private Collector<T> value;
    private List<Collector<T>> collectors = new LinkedList<Collector<T>>();

    AbstractCollectionProperty(Class<? extends Collection> collectionType, Class<T> elementType) {
        this.applyDefaultValue();
        this.collectionType = collectionType;
        this.elementType = elementType;
        this.valueCollector = new ValidatingValueCollector<T>(collectionType, elementType, ValueSanitizers.forType(elementType));
    }

    protected abstract C fromValue(Collection<T> var1);

    public void add(T element) {
        Preconditions.checkNotNull(element, (Object)String.format("Cannot add a null element to a property of type %s.", this.collectionType.getSimpleName()));
        if (!this.beforeMutate()) {
            return;
        }
        this.addCollector(new Collectors.SingleElement<T>(element));
    }

    public void add(Provider<? extends T> providerOfElement) {
        if (!this.beforeMutate()) {
            return;
        }
        this.addCollector(new Collectors.ElementFromProvider<T>(Providers.internal(providerOfElement)));
    }

    public void addAll(T ... elements) {
        if (!this.beforeMutate()) {
            return;
        }
        this.addCollector(new Collectors.ElementsFromArray<T>(elements));
    }

    public void addAll(Iterable<? extends T> elements) {
        if (!this.beforeMutate()) {
            return;
        }
        this.addCollector(new Collectors.ElementsFromCollection<T>(elements));
    }

    public void addAll(Provider<? extends Iterable<? extends T>> provider) {
        if (!this.beforeMutate()) {
            return;
        }
        this.addCollector(new Collectors.ElementsFromCollectionProvider(Providers.internal(provider)));
    }

    private void addCollector(Collector<T> collector) {
        this.collectors.add(collector);
        this.afterMutate();
    }

    @Override
    @Nullable
    public Class<C> getType() {
        return this.collectionType;
    }

    @Override
    public Class<T> getElementType() {
        return this.elementType;
    }

    @Override
    public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
        if (super.maybeVisitBuildDependencies(context)) {
            return true;
        }
        boolean visitedAll = true;
        if (!this.value.maybeVisitBuildDependencies(context)) {
            visitedAll = false;
        }
        for (Collector<T> collector : this.collectors) {
            if (collector.maybeVisitBuildDependencies(context)) continue;
            visitedAll = false;
        }
        return visitedAll;
    }

    @Override
    public boolean isPresent() {
        this.beforeRead();
        if (!this.value.present()) {
            return false;
        }
        for (Collector<T> collector : this.collectors) {
            if (collector.present()) continue;
            return false;
        }
        return true;
    }

    public C get() {
        this.beforeRead();
        ArrayList values = new ArrayList(1 + this.collectors.size());
        this.value.collectInto(this.valueCollector, values);
        for (Collector<T> collector : this.collectors) {
            collector.collectInto(this.valueCollector, values);
        }
        return this.fromValue(values);
    }

    @Nullable
    public C getOrNull() {
        this.beforeRead();
        return this.doGetOrNull();
    }

    @Nullable
    private C doGetOrNull() {
        ArrayList values = new ArrayList(1 + this.collectors.size());
        if (!this.value.maybeCollectInto(this.valueCollector, values)) {
            return null;
        }
        for (Collector<T> collector : this.collectors) {
            if (collector.maybeCollectInto(this.valueCollector, values)) continue;
            return null;
        }
        return this.fromValue(values);
    }

    @Override
    public void setFromAnyValue(Object object) {
        if (object instanceof Provider) {
            this.set((Provider)object);
        } else {
            if (object != null && !(object instanceof Iterable)) {
                throw new IllegalArgumentException(String.format("Cannot set the value of a property of type %s using an instance of type %s.", this.collectionType.getName(), object.getClass().getName()));
            }
            this.set((Iterable)object);
        }
    }

    public void set(@Nullable Iterable<? extends T> elements) {
        if (!this.beforeMutate()) {
            return;
        }
        if (elements == null) {
            this.set(NO_VALUE_COLLECTOR);
        } else {
            this.set(new Collectors.ElementsFromCollection<T>(elements));
        }
    }

    public void set(Provider<? extends Iterable<? extends T>> provider) {
        CollectionPropertyInternal collectionProp;
        if (!this.beforeMutate()) {
            return;
        }
        if (provider == null) {
            throw new IllegalArgumentException("Cannot set the value of a property using a null provider.");
        }
        ProviderInternal<Iterable<T>> p = Providers.internal(provider);
        if (p.getType() != null && !Iterable.class.isAssignableFrom(p.getType())) {
            throw new IllegalArgumentException(String.format("Cannot set the value of a property of type %s using a provider of type %s.", this.collectionType.getName(), p.getType().getName()));
        }
        if (p instanceof CollectionPropertyInternal && !this.elementType.isAssignableFrom((collectionProp = (CollectionPropertyInternal)p).getElementType())) {
            throw new IllegalArgumentException(String.format("Cannot set the value of a property of type %s with element type %s using a provider with element type %s.", this.collectionType.getName(), this.elementType.getName(), collectionProp.getElementType().getName()));
        }
        this.set(new Collectors.ElementsFromCollectionProvider(p));
    }

    public HasMultipleValues<T> empty() {
        if (!this.beforeMutate()) {
            return this;
        }
        this.set(EMPTY_COLLECTION);
        return this;
    }

    @Override
    protected void applyDefaultValue() {
        this.value = EMPTY_COLLECTION;
        this.collectors.clear();
    }

    @Override
    protected void makeFinal() {
        C collection = this.doGetOrNull();
        if (collection != null) {
            this.set(new Collectors.ElementsFromCollection(collection));
        } else {
            this.set(NO_VALUE_COLLECTOR);
        }
    }

    private void set(Collector<T> collector) {
        this.collectors.clear();
        this.value = collector;
        this.afterMutate();
    }

    public HasMultipleValues<T> convention(Iterable<? extends T> elements) {
        if (this.shouldApplyConvention()) {
            this.value = new Collectors.ElementsFromCollection<T>(elements);
            this.collectors.clear();
        }
        return this;
    }

    public HasMultipleValues<T> convention(Provider<? extends Iterable<? extends T>> provider) {
        if (this.shouldApplyConvention()) {
            this.value = new Collectors.ElementsFromCollectionProvider(Providers.internal(provider));
            this.collectors.clear();
        }
        return this;
    }

    @Override
    public String toString() {
        ArrayList<String> values = new ArrayList<String>(1 + this.collectors.size());
        values.add(this.value.toString());
        for (Collector<T> collector : this.collectors) {
            values.add(collector.toString());
        }
        return String.format("%s(%s, %s)", this.collectionType.getSimpleName().toLowerCase(), this.elementType, values);
    }
}

