/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.api.artifacts.component.LibraryComponentSelector;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.attributes.ImmutableAttributes;

public class DefaultLibraryComponentSelector
implements LibraryComponentSelector {
    private final String projectPath;
    private final String libraryName;
    private final String variant;

    public DefaultLibraryComponentSelector(String projectPath, String libraryName) {
        this(projectPath, libraryName, null);
    }

    public DefaultLibraryComponentSelector(String projectPath, String libraryName, String variant) {
        assert (!Strings.isNullOrEmpty((String)projectPath)) : "project path cannot be null or empty";
        this.projectPath = projectPath;
        this.libraryName = Strings.emptyToNull((String)libraryName);
        this.variant = variant;
    }

    public String getDisplayName() {
        String txt = Strings.isNullOrEmpty((String)this.libraryName) ? "project '" + this.projectPath + "'" : (Strings.isNullOrEmpty((String)this.variant) ? "project '" + this.projectPath + "' library '" + this.libraryName + "'" : "project '" + this.projectPath + "' library '" + this.libraryName + "' binary '" + this.variant + "'");
        return txt;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    @Nullable
    public String getVariant() {
        return this.variant;
    }

    public boolean matchesStrictly(ComponentIdentifier identifier) {
        assert (identifier != null) : "identifier cannot be null";
        if (identifier instanceof LibraryBinaryIdentifier) {
            LibraryBinaryIdentifier projectComponentIdentifier = (LibraryBinaryIdentifier)identifier;
            return Objects.equal((Object)projectComponentIdentifier.getProjectPath(), (Object)this.projectPath) && Objects.equal((Object)projectComponentIdentifier.getLibraryName(), (Object)this.libraryName) && Objects.equal((Object)projectComponentIdentifier.getVariant(), (Object)this.variant);
        }
        return false;
    }

    public AttributeContainer getAttributes() {
        return ImmutableAttributes.EMPTY;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultLibraryComponentSelector that = (DefaultLibraryComponentSelector)o;
        return Objects.equal((Object)this.projectPath, (Object)that.projectPath) && Objects.equal((Object)this.libraryName, (Object)that.libraryName) && Objects.equal((Object)this.variant, (Object)that.variant);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.projectPath, this.libraryName, this.variant});
    }

    public String toString() {
        return this.getDisplayName();
    }
}

