/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.ir.backend.js.lower.inline.IrUtils2Kt;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.impl.IrExternalPackageFragmentImpl;
import org.jetbrains.kotlin.ir.symbols.IrExternalPackageFragmentSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/MoveExternalDeclarationsToSeparatePlace;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "()V", "packageFragment", "Lorg/jetbrains/kotlin/ir/declarations/impl/IrExternalPackageFragmentImpl;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "backend.js"})
public final class MoveExternalDeclarationsToSeparatePlace
implements FileLoweringPass {
    private final IrExternalPackageFragmentImpl packageFragment;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        Iterator<IrDeclaration> it = irFile.getDeclarations().iterator();
        while (it.hasNext()) {
            IrDeclaration d = it.next();
            if (!IrUtilsKt.isEffectivelyExternal(d)) continue;
            it.remove();
            IrUtils2Kt.addChild(this.packageFragment, d);
        }
    }

    public MoveExternalDeclarationsToSeparatePlace() {
        IrExternalPackageFragmentSymbol irExternalPackageFragmentSymbol = new IrExternalPackageFragmentSymbol(){
            private IrExternalPackageFragment _owner;

            @NotNull
            public PackageFragmentDescriptor getDescriptor() {
                String string = "Operation is unsupported";
                throw (Throwable)new IllegalStateException(string.toString());
            }

            @NotNull
            public IrExternalPackageFragment getOwner() {
                IrExternalPackageFragment irExternalPackageFragment = this._owner;
                if (irExternalPackageFragment == null) {
                    Intrinsics.throwNpe();
                }
                return irExternalPackageFragment;
            }

            public boolean isBound() {
                return this._owner != null;
            }

            public void bind(@NotNull IrExternalPackageFragment owner) {
                Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
                this._owner = owner;
            }
        };
        FqName fqName2 = FqName.ROOT;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"FqName.ROOT");
        this.packageFragment = new IrExternalPackageFragmentImpl(irExternalPackageFragmentSymbol, fqName2);
    }
}

