/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import javajs.util.PT;
import javajs.util.SB;
import javajs.util.V3;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Vibration;

public class BilbaoReader
extends AtomSetCollectionReader {
    private boolean getHigh;
    private boolean getSym;
    private boolean normDispl;
    private boolean doDisplace;
    private String kvec;
    private int i0;
    private int nAtoms;
    private boolean isBCSfile;

    @Override
    public void initializeReader() throws Exception {
        this.normDispl = !this.checkFilterKey("NONORM");
        this.doDisplace = this.isTrajectory;
        this.getSym = true;
        this.getHigh = this.checkFilterKey("HIGH") && !this.doDisplace;
        this.asc.vibScale = 1;
        this.appendLoadNote("Bilbao Crystallographic Server\ncryst@wm.lc.ehu.es");
        if (this.rd().indexOf("<") < 0) {
            this.readBilbaoDataFile();
            this.continuing = false;
        }
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.contains(">Bilbao Crystallographic Server<")) {
            this.line = this.line.substring(this.line.lastIndexOf(">") + 1).trim();
            if (this.line.length() > 0) {
                this.appendLoadNote(String.valueOf(this.line) + "\n");
            }
        } else if (this.line.contains("High symmetry structure<")) {
            if (this.getHigh) {
                this.readBilbaoFormat("high symmetry", Float.NaN);
            }
        } else if (this.line.contains("Low symmetry structure<")) {
            if (!this.doDisplace) {
                this.readBilbaoFormat("low symmetry", Float.NaN);
            }
        } else if (this.line.contains("structure in the subgroup basis<")) {
            if (!this.doDisplace) {
                this.readBilbaoFormat("high symmetry in the subgroup basis", Float.NaN);
            }
        } else if (this.line.contains("Low symmetry structure after the origin shift<")) {
            this.readBilbaoFormat("low symmetry after origin shift", Float.NaN);
        } else if (this.line.contains("<h3>Irrep:")) {
            this.readVirtual();
        }
        return true;
    }

    private void readBilbaoDataFile() throws Exception {
        this.isBCSfile = true;
        this.checkComment();
        while (this.line != null) {
            this.readBilbaoFormat(null, Float.NaN);
            if (this.rdLine() == null || this.line.indexOf("##disp-par##") < 0) {
                this.applySymmetryAndSetTrajectory();
                continue;
            }
            this.readDisplacements(1.0f);
            this.rdLine();
        }
    }

    private boolean checkComment() {
        if (!this.line.startsWith("#") || this.line.indexOf("disp-par") >= 0) {
            return false;
        }
        if (this.isBCSfile) {
            this.appendLoadNote(this.line);
            if (this.line.startsWith("# Title:")) {
                this.asc.setAtomSetName(this.line.substring(8).trim());
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private void readBilbaoFormat(String var1_1, float var2_2) throws Exception {
        block9: {
            this.setFractionalCoordinates(true);
            if (!this.doGetModel(++this.modelNumber, var1_1)) {
                return;
            }
            this.asc.newAtomSet();
            if (this.line.startsWith("Bilbao Crys:")) {
                var1_1 = this.line.substring(13).trim();
                this.rdLine();
            }
            this.setTitle(var1_1);
            var3_3 = this.line.indexOf("<pre>");
            if (var3_3 >= 0) {
                this.line = this.line.substring(var3_3 + 5);
            }
            if ((var4_4 = this.parseIntStr(this.line)) != 0) ** GOTO lbl17
            this.setSpaceGroupName("bilbao:" + this.line.substring(2));
            break block9;
lbl-1000:
            // 1 sources

            {
                var4_4 = this.parseIntStr(this.line);
lbl17:
                // 2 sources

                ** while (var4_4 < 0 && this.rdLine() != null)
            }
lbl18:
            // 1 sources

            this.setSpaceGroupName("bilbao:" + var4_4);
        }
        var5_5 = new float[6];
        this.fillFloatArray(null, 0, var5_5);
        var6_6 = 0;
        while (var6_6 < 6) {
            this.setUnitCellItem(var6_6, var5_5[var6_6]);
            ++var6_6;
        }
        this.i0 = this.asc.ac;
        var6_6 = this.nAtoms = this.parseIntStr(this.rdLine());
        while (--var6_6 >= 0) {
            var7_7 = PT.getTokens(this.rdLine());
            if (!this.getSym && var7_7[1].contains("_")) continue;
            if (var7_7.length == 3) {
                this.addAtomXYZSymName(var7_7, 0, "Be", "Be1");
                continue;
            }
            this.addAtomXYZSymName(var7_7, 3, var7_7[0], String.valueOf(var7_7[0]) + var7_7[1]);
        }
        if (Float.isNaN(var2_2)) {
            if (var3_3 >= 0) {
                this.applySymmetryAndSetTrajectory();
            }
            return;
        }
        this.line = null;
        this.readDisplacements(var2_2);
    }

    private void readDisplacements(float f) throws Exception {
        Object object;
        int n = 0;
        while (n < this.nAtoms) {
            if (this.line == null) {
                this.rdLine();
            }
            object = PT.split(this.line, "x|x");
            if (this.getSym || !object[0].contains("_")) {
                this.asc.atoms[this.i0 + n].vib = V3.new3(this.parseFloatStr(object[1]), this.parseFloatStr(object[2]), this.parseFloatStr(object[3]));
            }
            this.line = null;
            ++n;
        }
        this.applySymmetryAndSetTrajectory();
        n = this.asc.ac;
        while (--n >= this.i0) {
            object = this.asc.atoms[n];
            if (object.vib == null) continue;
            Vibration vibration = new Vibration();
            vibration.setT(object.vib);
            object.vib = vibration;
            this.asc.getSymmetry().toCartesian(vibration, true);
            vibration.scale(1.0f / f);
        }
        this.appendLoadNote(String.valueOf(this.asc.ac - this.i0) + " displacements");
    }

    private void setTitle(String string) {
        if (string != null) {
            this.asc.setAtomSetName(string);
            this.appendLoadNote(string);
        }
    }

    private String rdLine() throws Exception {
        while (this.rd() != null && (this.line.trim().length() == 0 || this.checkComment())) {
        }
        return this.line;
    }

    private void readVirtual() throws Exception {
        if (this.line.contains("<h3>K-vector:")) {
            this.kvec = this.line.substring(this.line.indexOf("("), this.line.indexOf(")") + 1);
        }
        String string = this.getLinesUntil("\"BCS\"");
        int n = string.indexOf("The amplitude");
        n = string.indexOf("=", n);
        String string2 = string.substring(n + 2, string.indexOf(" ", n + 2));
        float f = this.normDispl ? this.parseFloatStr(string2) : 1.0f;
        String string3 = this.getAttr(string, "irrep");
        if (string3.indexOf(":") >= 0) {
            string3 = string3.substring(0, string3.indexOf(":"));
        }
        this.line = this.line.substring(this.line.indexOf("value=") + 7);
        this.readBilbaoFormat(String.valueOf(this.kvec) + " " + string3 + " (" + string2 + " Ang.)", f);
    }

    private String getAttr(String string, String string2) {
        int n = string.indexOf("value", string.indexOf("\"" + string2 + "\""));
        string = PT.getQuotedStringAt(string, n);
        string = PT.rep(string, "<i>", "");
        string = PT.rep(string, "</i>", "");
        return string.trim();
    }

    private String getLinesUntil(String string) throws Exception {
        SB sB = new SB();
        do {
            sB.append(this.line);
        } while (!this.rd().contains(string));
        return sB.toString();
    }
}

