/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.surfacetool;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.ListCellRenderer;
import javax.swing.WindowConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jmol.api.JmolViewer;
import org.jmol.i18n.GT;
import org.openscience.jmol.app.HistoryFile;
import org.openscience.jmol.app.surfacetool.SurfaceStatus;
import org.openscience.jmol.app.surfacetool.SurfaceTool;

class SurfaceToolGUI
extends JPanel
implements WindowConstants,
WindowListener,
WindowFocusListener,
ChangeListener,
ActionListener,
ListSelectionListener {
    private HistoryFile historyFile;
    private String histWinName;
    private JFrame slicerFrame;
    private SurfaceTool slicer;
    private JPanel tabPanel;
    private JPanel objectsPanel;
    private JPanel topPanel;
    private JPanel angleUnitsPanel;
    private JComboBox<String> angleUnitsList;
    private JPanel originPanel;
    private JRadioButton viewCenterButton;
    private JRadioButton absoluteButton;
    private JCheckBox capCheck;
    private JPanel capPlanesPanel;
    private JPanel ghostPanel;
    private JCheckBox ghostCheck;
    private JCheckBox boundaryPlaneCheck;
    private JPanel sliderPanel;
    private JPanel normAnglePanel;
    private JSlider angleXYSlider;
    private JSlider angleZSlider;
    private JPanel positionThicknessPanel;
    private JSlider positionSlider;
    private JSlider thicknessSlider;
    private ButtonGroup whichOrigin;
    private JScrollPane surfaceScrollPane;
    private JList<SurfaceStatus> surfaceList;

    SurfaceToolGUI(JmolViewer jmolViewer, HistoryFile historyFile, String string, SurfaceTool surfaceTool) {
        super(new BorderLayout());
        this.historyFile = historyFile;
        this.histWinName = string;
        this.slicer = surfaceTool;
        if (this.slicerFrame != null) {
            this.slicerFrame.setVisible(true);
            this.slicerFrame.toFront();
        } else {
            this.slicerFrame = new JFrame(GT.$("SurfaceTool"));
            this.slicerFrame.setDefaultCloseOperation(2);
            String string2 = "org/openscience/jmol/app/images/icon.png";
            URL uRL = this.getClass().getClassLoader().getResource(string2);
            ImageIcon imageIcon = new ImageIcon(uRL);
            this.slicerFrame.setIconImage(imageIcon.getImage());
            this.slicerFrame.addWindowFocusListener(this);
            this.slicerFrame.addWindowListener(this);
            this.setOpaque(true);
            this.tabPanel = new JPanel(new BorderLayout());
            this.topPanel = new JPanel(new GridLayout(1, 0));
            this.whichOrigin = new ButtonGroup();
            this.originPanel = new JPanel(new GridLayout(0, 1));
            if (surfaceTool.getUseMolecular()) {
                this.viewCenterButton = new JRadioButton(GT.$("View Center"), false);
                this.absoluteButton = new JRadioButton(GT.$("Absolute"), true);
            } else {
                this.viewCenterButton = new JRadioButton(GT.$("View Center"), true);
                this.absoluteButton = new JRadioButton(GT.$("Absolute"), false);
            }
            this.viewCenterButton.addActionListener(this);
            this.absoluteButton.addActionListener(this);
            this.whichOrigin.add(this.viewCenterButton);
            this.whichOrigin.add(this.absoluteButton);
            this.originPanel.add(this.viewCenterButton);
            this.originPanel.add(this.absoluteButton);
            this.originPanel.setBorder(BorderFactory.createTitledBorder(GT.$("Origin")));
            this.capPlanesPanel = new JPanel(new GridLayout(0, 1));
            this.capCheck = new JCheckBox(GT.$("Cap"));
            this.capCheck.setToolTipText(GT.$("Caps slice with opaque surfaces.\nIgnores MOs and surfaces with interior layers."));
            this.capCheck.setSelected(surfaceTool.getCapOn());
            this.capCheck.addActionListener(this);
            this.capPlanesPanel.add(this.capCheck);
            this.boundaryPlaneCheck = new JCheckBox(GT.$("Slice Planes"));
            this.boundaryPlaneCheck.setToolTipText(GT.$("Shows planes at slicing surfaces."));
            this.boundaryPlaneCheck.setSelected(false);
            surfaceTool.showSliceBoundaryPlanes(false);
            this.boundaryPlaneCheck.addActionListener(this);
            this.capPlanesPanel.add(this.boundaryPlaneCheck);
            this.ghostPanel = new JPanel(new GridLayout(0, 1));
            this.ghostCheck = new JCheckBox(GT.$("Ghost On"));
            this.ghostCheck.setSelected(surfaceTool.getGhostOn());
            this.ghostCheck.addActionListener(this);
            this.ghostCheck.setToolTipText(GT.$("Shows an unsliced \"ghost\"."));
            this.ghostPanel.add(this.ghostCheck);
            this.topPanel.add(this.originPanel);
            this.topPanel.add(this.capPlanesPanel);
            this.topPanel.add(this.ghostPanel);
            this.topPanel.setSize(200, 40);
            this.sliderPanel = new JPanel(new GridLayout(0, 1));
            this.normAnglePanel = new JPanel(new GridLayout(0, 1));
            this.angleUnitsPanel = new JPanel(new BorderLayout());
            JLabel jLabel = new JLabel("   ");
            this.angleUnitsPanel.add((Component)jLabel, "West");
            String[] stringArray = surfaceTool.getAngleUnitsList();
            this.angleUnitsList = new JComboBox<String>(stringArray);
            this.angleUnitsList.setSelectedIndex(surfaceTool.getAngleUnits());
            this.angleUnitsList.addActionListener(this);
            this.angleUnitsPanel.add(this.angleUnitsList, "East");
            JPanel jPanel = new JPanel(new GridLayout(1, 0));
            JLabel jLabel2 = new JLabel(GT.$("Angle from X-axis in XY plane"), 0);
            jLabel2.setAlignmentX(0.5f);
            jPanel.add(jLabel2);
            jPanel.add(this.angleUnitsPanel);
            this.normAnglePanel.add(jPanel);
            this.angleXYSlider = new JSlider(0, 180, 0);
            this.angleXYSlider.setMajorTickSpacing(30);
            this.angleXYSlider.setPaintTicks(true);
            this.angleXYSlider.addChangeListener(this);
            this.normAnglePanel.add(this.angleXYSlider);
            JLabel jLabel3 = new JLabel(GT.$("Angle from Z-axis"), 0);
            jLabel3.setAlignmentX(0.5f);
            this.normAnglePanel.add(jLabel3);
            this.angleZSlider = new JSlider(0, 180, 0);
            this.angleZSlider.setMajorTickSpacing(30);
            this.angleZSlider.setPaintTicks(true);
            this.angleZSlider.addChangeListener(this);
            this.updateAngleSliders();
            this.normAnglePanel.add(this.angleZSlider);
            this.normAnglePanel.setBorder(BorderFactory.createTitledBorder(GT.$("Direction vector of normal to slice")));
            this.sliderPanel.add(this.normAnglePanel);
            this.positionThicknessPanel = new JPanel(new GridLayout(0, 1));
            JLabel jLabel4 = new JLabel(GT.$("Distance of slice from origin"), 0);
            jLabel4.setAlignmentX(0.5f);
            this.positionThicknessPanel.add(jLabel4);
            int n = (int)(180.0f * (surfaceTool.getSlicePosition() - surfaceTool.getPositionMin()) / surfaceTool.getThicknessMax());
            this.positionSlider = new JSlider(0, 180, n);
            this.positionSlider.setMajorTickSpacing(30);
            this.positionSlider.setPaintTicks(true);
            this.positionSlider.addChangeListener(this);
            this.updatePositionSlider();
            this.positionThicknessPanel.add(this.positionSlider);
            JLabel jLabel5 = new JLabel(GT.$("Thickness of slice"), 0);
            jLabel5.setAlignmentX(0.5f);
            this.positionThicknessPanel.add(jLabel5);
            this.thicknessSlider = new JSlider(0, 180, (int)(180.0f * surfaceTool.getSliceThickness() / surfaceTool.getThicknessMax()));
            this.thicknessSlider.setMajorTickSpacing(30);
            this.thicknessSlider.setPaintTicks(true);
            this.thicknessSlider.addChangeListener(this);
            this.updateThicknessSlider();
            this.positionThicknessPanel.add(this.thicknessSlider);
            this.sliderPanel.add(this.positionThicknessPanel);
            this.tabPanel.add((Component)this.topPanel, "North");
            this.tabPanel.add((Component)this.sliderPanel, "South");
            this.objectsPanel = new JPanel();
            this.objectsPanel.setBorder(BorderFactory.createTitledBorder(GT.$("Select Surface(s)")));
            this.surfaceList = new JList(new DefaultListModel());
            this.surfaceList.setCellRenderer(new SurfaceListCellRenderer());
            this.surfaceList.addListSelectionListener(this);
            this.updateSurfaceList();
            this.surfaceScrollPane = new JScrollPane(this.surfaceList);
            this.surfaceScrollPane.setPreferredSize(new Dimension(120, 300));
            this.objectsPanel.add(this.surfaceScrollPane);
            this.add((Component)this.tabPanel, "West");
            this.add((Component)this.objectsPanel, "East");
            this.slicerFrame.setContentPane(this);
            this.slicerFrame.addWindowListener(this);
            this.historyFile.repositionWindow(string, this.slicerFrame, 200, 300, true);
            this.slicerFrame.pack();
            this.slicerFrame.setVisible(true);
            this.saveHistory();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl;
        if (actionEvent.getSource() == this.angleUnitsList) {
            this.slicer.setAngleUnits(this.angleUnitsList.getSelectedIndex());
            this.updateAngleSliders();
        }
        if (actionEvent.getSource() == this.viewCenterButton || actionEvent.getSource() == this.absoluteButton) {
            if (this.absoluteButton.isSelected() && !this.slicer.getUseMolecular()) {
                this.slicer.setUseMolecular(true);
                this.slicer.setSurfaceToolParam();
                this.updatePositionSlider();
            }
            if (this.viewCenterButton.isSelected() && this.slicer.getUseMolecular()) {
                this.slicer.setUseMolecular(false);
                this.slicer.setSurfaceToolParam();
                this.updatePositionSlider();
            }
        }
        if (actionEvent.getSource() == this.ghostCheck) {
            bl = this.ghostCheck.isSelected();
            this.slicer.setGhostOn(bl);
            if (bl) {
                this.slicer.setCapOn(false);
                this.capCheck.setSelected(false);
            }
            this.sliceSelected();
        }
        if (actionEvent.getSource() == this.boundaryPlaneCheck) {
            this.slicer.showSliceBoundaryPlanes(this.boundaryPlaneCheck.isSelected());
        }
        if (actionEvent.getSource() == this.capCheck) {
            bl = this.capCheck.isSelected();
            this.slicer.setCapOn(bl);
            if (bl) {
                this.slicer.setGhostOn(false);
                this.ghostCheck.setSelected(false);
            }
            this.sliceSelected();
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        float f;
        float f2;
        JSlider jSlider = (JSlider)changeEvent.getSource();
        if (jSlider == this.angleXYSlider || jSlider == this.angleZSlider) {
            f2 = (float)(Math.PI * (double)this.angleZSlider.getValue() / 180.0);
            f = (float)(Math.PI * (double)this.angleXYSlider.getValue() / 180.0);
            this.slicer.setSliceAnglefromZ(f2);
            this.slicer.setSliceAngleXY(f);
            if (!jSlider.getValueIsAdjusting()) {
                this.sliceSelected();
            }
        }
        if (jSlider == this.positionSlider || jSlider == this.thicknessSlider) {
            f2 = (float)this.thicknessSlider.getValue() * this.slicer.getThicknessMax() / 180.0f;
            f = (float)this.positionSlider.getValue() * this.slicer.getThicknessMax() / 180.0f + this.slicer.getPositionMin();
            this.slicer.setSliceThickness(f2);
            this.slicer.setSlicePosition(f);
            if (!jSlider.getValueIsAdjusting()) {
                this.sliceSelected();
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        JList jList = (JList)listSelectionEvent.getSource();
        if (jList.isSelectionEmpty()) {
            return;
        }
        int[] nArray = jList.getSelectedIndices();
        if (nArray != null) {
            int n = nArray[nArray.length - 1];
            List<SurfaceStatus> list = this.slicer.getSurfaces();
            SurfaceStatus surfaceStatus = list.get(n);
            if (surfaceStatus.beenSliced) {
                this.slicer.setSlice(surfaceStatus.slice.angleXY, surfaceStatus.slice.anglefromZ, surfaceStatus.slice.position, surfaceStatus.slice.thickness);
                this.slicer.setCapOn(surfaceStatus.capOn);
                this.capCheck.setSelected(surfaceStatus.capOn);
                this.slicer.setGhostOn(surfaceStatus.ghostOn);
                this.ghostCheck.setSelected(surfaceStatus.ghostOn);
                this.updateAngleSliders();
                this.updatePositionSlider();
                this.updateThicknessSlider();
            }
            this.sliceSelected();
        }
    }

    private void sliceSelected() {
        if (this.surfaceList == null) {
            return;
        }
        int[] nArray = this.surfaceList.getSelectedIndices();
        if (nArray == null || nArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < nArray.length) {
            List<SurfaceStatus> list = this.slicer.getSurfaces();
            int n2 = nArray[n];
            this.slicer.sliceObject(list.get((int)n2).id, list.get((int)n2).kind);
            list.get((int)n2).beenSliced = true;
            list.get((int)n2).capOn = this.slicer.getCapOn();
            list.get((int)n2).ghostOn = this.slicer.getGhostOn();
            list.get((int)n2).slice.setSlice(this.slicer.getSliceAngleXY(), this.slicer.getAnglefromZ(), this.slicer.getSlicePosition(), this.slicer.getSliceThickness(), this.slicer.getCenter(), this.slicer.getBoxVec(), this.slicer.getUseMolecular());
            ++n;
        }
    }

    private void updatePositionSlider() {
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        String string = "";
        int n = 0;
        while (n < 7) {
            float f = (float)((double)this.slicer.getPositionMin() + (double)n * 0.16666666666 * (double)this.slicer.getThicknessMax());
            if ((double)Math.abs(f) < 0.001) {
                f = 0.0f;
            }
            if ((string = "" + f).length() > 5) {
                string = f < 0.0f ? string.substring(0, 5) : string.substring(0, 4);
            }
            hashtable.put(n * 30, new JLabel(string));
            ++n;
        }
        this.positionSlider.setLabelTable(hashtable);
        this.positionSlider.setPaintLabels(true);
        n = (int)(180.0f * (this.slicer.getSlicePosition() - this.slicer.getPositionMin()) / this.slicer.getThicknessMax());
        this.positionSlider.setValue(n);
    }

    private void updateThicknessSlider() {
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        String string = "";
        int n = 0;
        while (n < 7) {
            float f = (float)((double)n * 0.16666666666 * (double)this.slicer.getThicknessMax());
            string = "" + f;
            if (string.length() > 5) {
                string = string.substring(0, 4);
            }
            hashtable.put(n * 30, new JLabel(string));
            ++n;
        }
        this.thicknessSlider.setLabelTable(hashtable);
        this.thicknessSlider.setPaintLabels(true);
        n = (int)(180.0f * this.slicer.getSliceThickness() / this.slicer.getThicknessMax());
        this.thicknessSlider.setValue(n);
    }

    private void updateAngleSliders() {
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(0, new JLabel("0"));
        switch (this.slicer.getAngleUnits()) {
            case 0: {
                hashtable.put(30, new JLabel("30"));
                hashtable.put(60, new JLabel("60"));
                hashtable.put(90, new JLabel("90"));
                hashtable.put(120, new JLabel("120"));
                hashtable.put(150, new JLabel("150"));
                hashtable.put(180, new JLabel("180"));
                break;
            }
            case 1: {
                hashtable.put(30, new JLabel("0.52"));
                hashtable.put(60, new JLabel("1.05"));
                hashtable.put(90, new JLabel("1.75"));
                hashtable.put(120, new JLabel("2.09"));
                hashtable.put(150, new JLabel("2.62"));
                hashtable.put(180, new JLabel("3.14"));
                break;
            }
            case 2: {
                hashtable.put(30, new JLabel("33.3"));
                hashtable.put(60, new JLabel("66.7"));
                hashtable.put(90, new JLabel("100"));
                hashtable.put(120, new JLabel("133"));
                hashtable.put(150, new JLabel("167"));
                hashtable.put(180, new JLabel("200"));
                break;
            }
            case 3: {
                hashtable.put(30, new JLabel("1/12"));
                hashtable.put(60, new JLabel("1/6"));
                hashtable.put(90, new JLabel("1/4"));
                hashtable.put(120, new JLabel("1/3"));
                hashtable.put(150, new JLabel("5/12"));
                hashtable.put(180, new JLabel("1/2"));
                break;
            }
            case 4: {
                String string = "\u03c0";
                hashtable.put(30, new JLabel(String.valueOf(string) + "/6"));
                hashtable.put(60, new JLabel(String.valueOf(string) + "/3"));
                hashtable.put(90, new JLabel(String.valueOf(string) + "/2"));
                hashtable.put(120, new JLabel("2" + string + "/3"));
                hashtable.put(150, new JLabel("5" + string + "/6"));
                hashtable.put(180, new JLabel(string));
            }
        }
        this.angleXYSlider.setLabelTable(hashtable);
        this.angleXYSlider.setPaintLabels(true);
        this.angleZSlider.setLabelTable(hashtable);
        this.angleZSlider.setPaintLabels(true);
        int n = (int)((double)(180.0f * this.slicer.getSliceAngleXY()) / Math.PI);
        this.angleXYSlider.setValue(n);
        n = (int)((double)(180.0f * this.slicer.getAnglefromZ()) / Math.PI);
        this.angleZSlider.setValue(n);
    }

    void updateSurfaceList() {
        DefaultListModel defaultListModel = (DefaultListModel)this.surfaceList.getModel();
        defaultListModel.removeAllElements();
        int n = this.slicer.getSurfaces().size();
        int n2 = 0;
        while (n2 < n) {
            defaultListModel.addElement(this.slicer.getSurfaces().get(n2));
            ++n2;
        }
    }

    void saveHistory() {
        if (this.historyFile == null) {
            return;
        }
        this.historyFile.addWindowInfo(this.histWinName, this.slicerFrame, null);
    }

    SurfaceToolGUI(LayoutManager layoutManager) {
        super(layoutManager);
    }

    SurfaceToolGUI(boolean bl) {
        super(bl);
    }

    SurfaceToolGUI(LayoutManager layoutManager, boolean bl) {
        super(layoutManager, bl);
    }

    JFrame getFrame() {
        return this.slicerFrame;
    }

    void toFront() {
        this.slicer.toFrontOrGotFocus();
        this.updateAngleSliders();
        this.updatePositionSlider();
        this.updateThicknessSlider();
        this.updateSurfaceList();
        this.slicerFrame.setVisible(true);
        this.slicerFrame.toFront();
    }

    @Override
    public void windowGainedFocus(WindowEvent windowEvent) {
        this.slicer.toFrontOrGotFocus();
        this.updateAngleSliders();
        this.updatePositionSlider();
        this.updateThicknessSlider();
        this.updateSurfaceList();
    }

    @Override
    public void windowLostFocus(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        this.slicer.toFrontOrGotFocus();
        this.updateAngleSliders();
        this.updatePositionSlider();
        this.updateThicknessSlider();
        this.updateSurfaceList();
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
        this.slicer.toFrontOrGotFocus();
        this.updateAngleSliders();
        this.updatePositionSlider();
        this.updateThicknessSlider();
        this.updateSurfaceList();
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        this.slicer.toFrontOrGotFocus();
        this.updateAngleSliders();
        this.updatePositionSlider();
        this.updateThicknessSlider();
        this.updateSurfaceList();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    class SurfaceListCellRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        SurfaceListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
            this.setText(" " + ((SurfaceStatus)object).id);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(new Color(((SurfaceStatus)object).color));
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(new Color(((SurfaceStatus)object).color));
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.setOpaque(true);
            return this;
        }
    }
}

