/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.report;

import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.daemon.common.CompilationOptions;
import org.jetbrains.kotlin.daemon.common.CompilationResultCategory;
import org.jetbrains.kotlin.daemon.common.CompilationResults;
import org.jetbrains.kotlin.daemon.common.CompileIterationResult;
import org.jetbrains.kotlin.daemon.common.CompilerServicesFacadeBase;
import org.jetbrains.kotlin.daemon.common.CompilerServicesFacadeBaseKt;
import org.jetbrains.kotlin.daemon.common.ReportCategory;
import org.jetbrains.kotlin.daemon.common.ReportSeverity;
import org.jetbrains.kotlin.incremental.ICReporter;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u001e\u0010\u0012\u001a\u00020\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/daemon/report/RemoteICReporter;", "Lorg/jetbrains/kotlin/incremental/ICReporter;", "servicesFacade", "Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBase;", "compilationResults", "Lorg/jetbrains/kotlin/daemon/common/CompilationResults;", "compilationOptions", "Lorg/jetbrains/kotlin/daemon/common/CompilationOptions;", "(Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBase;Lorg/jetbrains/kotlin/daemon/common/CompilationResults;Lorg/jetbrains/kotlin/daemon/common/CompilationOptions;)V", "isVerbose", "", "shouldReportCompileIteration", "shouldReportMessages", "report", "", "message", "Lkotlin/Function0;", "", "reportCompileIteration", "sourceFiles", "", "Ljava/io/File;", "exitCode", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "daemon"})
public final class RemoteICReporter
implements ICReporter {
    private final boolean shouldReportMessages;
    private final boolean isVerbose;
    private final boolean shouldReportCompileIteration;
    private final CompilerServicesFacadeBase servicesFacade;
    private final CompilationResults compilationResults;

    @Override
    public void report(@NotNull Function0<String> message) {
        Intrinsics.checkParameterIsNotNull(message, "message");
        if (this.shouldReportMessages && this.isVerbose) {
            CompilerServicesFacadeBaseKt.report$default(this.servicesFacade, ReportCategory.IC_MESSAGE, ReportSeverity.DEBUG, message.invoke(), null, 8, null);
        }
    }

    @Override
    public void reportCompileIteration(@NotNull Collection<? extends File> sourceFiles2, @NotNull ExitCode exitCode2) {
        Intrinsics.checkParameterIsNotNull(sourceFiles2, "sourceFiles");
        Intrinsics.checkParameterIsNotNull((Object)exitCode2, "exitCode");
        if (this.shouldReportCompileIteration) {
            this.compilationResults.add(CompilationResultCategory.IC_COMPILE_ITERATION.getCode(), new CompileIterationResult((Iterable<? extends File>)sourceFiles2, exitCode2.toString()));
        }
    }

    public RemoteICReporter(@NotNull CompilerServicesFacadeBase servicesFacade, @NotNull CompilationResults compilationResults, @NotNull CompilationOptions compilationOptions) {
        Intrinsics.checkParameterIsNotNull(servicesFacade, "servicesFacade");
        Intrinsics.checkParameterIsNotNull(compilationResults, "compilationResults");
        Intrinsics.checkParameterIsNotNull(compilationOptions, "compilationOptions");
        this.servicesFacade = servicesFacade;
        this.compilationResults = compilationResults;
        this.shouldReportMessages = ArraysKt.contains(compilationOptions.getReportCategories(), Integer.valueOf(ReportCategory.IC_MESSAGE.getCode()));
        this.isVerbose = compilationOptions.getReportSeverity() == ReportSeverity.DEBUG.getCode();
        this.shouldReportCompileIteration = ArraysKt.contains(compilationOptions.getRequestedCompilationResults(), Integer.valueOf(CompilationResultCategory.IC_COMPILE_ITERATION.getCode()));
    }

    @Override
    @NotNull
    public String pathsAsString(File ... files2) {
        Intrinsics.checkParameterIsNotNull(files2, "files");
        return ICReporter.DefaultImpls.pathsAsString((ICReporter)this, files2);
    }

    @Override
    @NotNull
    public String pathsAsString(@NotNull Iterable<? extends File> files2) {
        Intrinsics.checkParameterIsNotNull(files2, "files");
        return ICReporter.DefaultImpls.pathsAsString((ICReporter)this, files2);
    }
}

