/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.xml.stream.XMLStreamException;
import org.jetbrains.annotations.NotNull;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Experimental;
import org.languagetool.Language;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.server.RemoteRuleMatch;
import org.languagetool.tools.Tools;

@Experimental
class ResultExtender {
    private final URL url;
    private final int connectTimeoutMillis;
    private final ObjectMapper mapper = new ObjectMapper();
    private final ExecutorService executor = Executors.newSingleThreadExecutor();

    ResultExtender(String url, int connectTimeoutMillis) {
        this.url = Tools.getUrl(url);
        if (connectTimeoutMillis <= 0) {
            throw new IllegalArgumentException("connectTimeoutMillis must be > 0: " + connectTimeoutMillis);
        }
        this.connectTimeoutMillis = connectTimeoutMillis;
    }

    @NotNull
    List<RuleMatch> getFilteredExtensionMatches(List<RuleMatch> matches, List<RemoteRuleMatch> extensionMatches) {
        RuleMatch hiddenRuleMatch = new RuleMatch(new HiddenRule(), new AnalyzedSentence(new AnalyzedTokenReadings[0]), 0, 1, "(hidden message)");
        ArrayList<RuleMatch> filteredExtMatches = new ArrayList<RuleMatch>();
        for (RemoteRuleMatch extensionMatch : extensionMatches) {
            if (extensionMatch.isTouchedByOneOf(matches)) continue;
            filteredExtMatches.add(hiddenRuleMatch);
        }
        return filteredExtMatches;
    }

    @NotNull
    Future<List<RemoteRuleMatch>> getExtensionMatchesFuture(String plainText, Language lang) throws IOException, XMLStreamException {
        return this.executor.submit(() -> this.getExtensionMatches(plainText, lang));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    List<RemoteRuleMatch> getExtensionMatches(String plainText, Language lang) throws IOException, XMLStreamException {
        HttpURLConnection huc = (HttpURLConnection)this.url.openConnection();
        HttpURLConnection.setFollowRedirects(false);
        huc.setConnectTimeout(this.connectTimeoutMillis);
        huc.setReadTimeout(this.connectTimeoutMillis * 2);
        huc.setRequestMethod("POST");
        huc.setDoOutput(true);
        try {
            huc.connect();
            DataOutputStream wr = new DataOutputStream(huc.getOutputStream());
            Object object = null;
            try {
                String urlParameters = "language=" + lang.getShortCodeWithCountryAndVariant() + "&text=" + plainText;
                byte[] postData = urlParameters.getBytes(StandardCharsets.UTF_8);
                wr.write(postData);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (wr != null) {
                    if (object != null) {
                        try {
                            wr.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        wr.close();
                    }
                }
            }
            InputStream input = huc.getInputStream();
            object = this.parseJson(input);
            return object;
        }
        finally {
            huc.disconnect();
        }
    }

    @NotNull
    private List<RemoteRuleMatch> parseJson(InputStream inputStream) throws XMLStreamException, IOException {
        Map map = this.mapper.readValue(inputStream, Map.class);
        ArrayList matches = (ArrayList)map.get("matches");
        ArrayList<RemoteRuleMatch> result = new ArrayList<RemoteRuleMatch>();
        for (Object match : matches) {
            RemoteRuleMatch remoteMatch = this.getMatch((Map)match);
            result.add(remoteMatch);
        }
        return result;
    }

    @NotNull
    private RemoteRuleMatch getMatch(Map<String, Object> match) {
        Map rule = (Map)match.get("rule");
        int offset = (Integer)this.getRequired(match, "offset");
        int errorLength = (Integer)this.getRequired(match, "length");
        Map context = (Map)match.get("context");
        int contextOffset = (Integer)this.getRequired(context, "offset");
        RemoteRuleMatch remoteMatch = new RemoteRuleMatch(this.getRequiredString(rule, "id"), this.getRequiredString(match, "message"), this.getRequiredString(context, "text"), contextOffset, offset, errorLength);
        remoteMatch.setShortMsg(this.getOrNull(match, "shortMessage"));
        remoteMatch.setRuleSubId(this.getOrNull(rule, "subId"));
        remoteMatch.setLocQualityIssueType(this.getOrNull(rule, "issueType"));
        List<String> urls = this.getValueList(rule, "urls");
        if (urls.size() > 0) {
            remoteMatch.setUrl(urls.get(0));
        }
        Map category = (Map)rule.get("category");
        remoteMatch.setCategory(this.getOrNull(category, "name"));
        remoteMatch.setCategoryId(this.getOrNull(category, "id"));
        remoteMatch.setReplacements(this.getValueList(match, "replacements"));
        return remoteMatch;
    }

    private Object getRequired(Map<String, Object> elem, String propertyName) {
        Object val = elem.get(propertyName);
        if (val != null) {
            return val;
        }
        throw new RuntimeException("JSON item " + elem + " doesn't contain required property '" + propertyName + "'");
    }

    private String getRequiredString(Map<String, Object> elem, String propertyName) {
        return (String)this.getRequired(elem, propertyName);
    }

    private String getOrNull(Map<String, Object> elem, String propertyName) {
        Object val = elem.get(propertyName);
        if (val != null) {
            return (String)val;
        }
        return null;
    }

    private List<String> getValueList(Map<String, Object> match, String propertyName) {
        List matches = (List)match.get(propertyName);
        ArrayList<String> l = new ArrayList<String>();
        if (matches != null) {
            for (Object o : matches) {
                Map item = (Map)o;
                l.add((String)item.get("value"));
            }
        }
        return l;
    }

    class HiddenRule
    extends Rule {
        HiddenRule() {
        }

        @Override
        public String getId() {
            return "HIDDEN_RULE";
        }

        @Override
        public String getDescription() {
            return "(description hidden)";
        }

        @Override
        public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
            throw new RuntimeException("not implemented");
        }
    }
}

