package Devel::PatchPerl::Hints;
$Devel::PatchPerl::Hints::VERSION = '1.52';
#ABSTRACT: replacement 'hints' files

use strict;
use warnings;
use MIME::Base64 qw[decode_base64];
use File::Spec;

our @ISA            = qw[Exporter];
our @EXPORT_OK      = qw[hint_file hints];

my %hints = (
'bitrig' =>
'IyBoaW50cy9vcGVuYnNkLnNoCiMKIyBoaW50cyBmaWxlIGZvciBPcGVuQlNEOyBUb2RkIE1pbGxl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',
'cygwin' =>
'IyEgL2Jpbi9zaAojIGN5Z3dpbi5zaCAtIGhpbnRzIGZvciBidWlsZGluZyBwZXJsIHVzaW5nIHRo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==',
'darwin' =>
'IyMKIyBEYXJ3aW4gKE1hYyBPUykgaGludHMKIyBXaWxmcmVkbyBTYW5jaGV6IDx3c2FuY2hlekB3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',
'dragonfly' =>
'IyBoaW50cy9kcmFnb25mbHkuc2gKIwojIFRoaXMgZmlsZSBpcyBtb3N0bHkgY29waWVkIGZyb20g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',
'freebsd' =>
'IyBPcmlnaW5hbCBiYXNlZCBvbiBpbmZvIGZyb20KIyBDYXJsIE0uIEZvbmdoZWlzZXIgPGNtZkBp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',
'gnu' =>
'IyBoaW50cy9nbnUuc2gKIyBPcmlnaW5hbGx5IGNvbnRyaWJ1dGVkIGJ5OiAgTWFyayBLZXR0ZW5p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=',
'gnukfreebsd' =>
'IyEgL2Jpbi9zaAoKIyBTdXBwb3J0IGZvciBEZWJpYW4gR05VL2tGcmVlQlNEIChrZnJlZWJzZC1n
bnUpCiMgQSBwb3J0IG9mIHRoZSBEZWJpYW4gR05VIHN5c3RlbSB1c2luZyB0aGUgRnJlZUJTRCBr
ZXJuZWwuCgouIC4vaGludHMvbGludXguc2gKCg==',
'hpux' =>
'IyEvdXNyL2Jpbi9zaAoKIyMjIFNZU1RFTSBBUkNISVRFQ1RVUkUKCiMgRGV0ZXJtaW5lIHRoZSBh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',
'linux' =>
'IyBoaW50cy9saW51eC5zaAojIE9yaWdpbmFsIHZlcnNpb24gYnkgcnNhbmRlcnMKIyBBZGRpdGlv
bmFsIHN1cHBvcnQgYnkgS2VubmV0aCBBbGJhbm93c2tpIDxramFoZHNAa2phaGRzLmNvbT4KIwoj
IEVMRiBzdXBwb3J0IGJ5IEguSi4gTHUgPGhqbEBueW5leHN0LmNvbT4KIyBBZGRpdGlvbmFsIGlu
Zm8gZnJvbSBOaWdlbCBIZWFkIDxuaGVhZEBFU09DLmJpdG5ldD4KIyBhbmQgS2VubmV0aCBBbGJh
bm93c2tpIDxramFoZHNAa2phaGRzLmNvbT4KIwojIENvbnNvbGlkYXRlZCBieSBBbmR5IERvdWdo
ZXJ0eSA8ZG91Z2hlcmFAbGFmYXlldHRlLmVkdT4KIwojIFVwZGF0ZWQgVGh1IEZlYiAgOCAxMTo1
NjoxMCBFU1QgMTk5NgoKIyBVcGRhdGVkIFRodSBNYXkgMzAgMTA6NTA6MjIgRURUIDE5OTYgYnkg
PGRvdWdoZXJhQGxhZmF5ZXR0ZS5lZHU+CgojIFVwZGF0ZWQgRnJpIEp1biAyMSAxMTowNzo1NCBF
RFQgMTk5NgojIE5EQk0gc3VwcG9ydCBmb3IgRUxGIHJlLWVuYWJsZWQgYnkgPGtqYWhkc0BramFo
ZHMuY29tPgoKIyBObyB2ZXJzaW9uIG9mIExpbnV4IHN1cHBvcnRzIHNldHVpZCBzY3JpcHRzLgpk
X3N1aWRzYWZlPSd1bmRlZicKCiMgTm8gdmVyc2lvbiBvZiBMaW51eCBuZWVkcyBsaWJ1dGlsIGZv
ciBwZXJsLgppX2xpYnV0aWw9J3VuZGVmJwoKIyBEZWJpYW4gYW5kIFJlZCBIYXQsIGFuZCBwZXJo
YXBzIG90aGVyIHZlbmRvcnMsIHByb3ZpZGUgYm90aCBydW50aW1lIGFuZAojIGRldmVsb3BtZW50
IHBhY2thZ2VzIGZvciBzb21lIGxpYnJhcmllcy4gIFRoZSBydW50aW1lIHBhY2thZ2VzIGNvbnRh
aW4gc2hhcmVkCiMgbGlicmFyaWVzIHdpdGggdmVyc2lvbiBpbmZvcm1hdGlvbiBpbiB0aGVpciBu
YW1lcyAoZS5nLiwgbGliZ2RibS5zby4xLjcuMyk7CiMgdGhlIGRldmVsb3BtZW50IHBhY2thZ2Vz
IHN1cHBsZW1lbnQgdGhpcyB3aXRoIHZlcnNpb25sZXNzIHNoYXJlZCBsaWJyYXJpZXMKIyAoZS5n
LiwgbGliZ2RibS5zbykuCiMKIyBJZiB5b3Ugd2FudCB0byBsaW5rIGFnYWluc3Qgc3VjaCBhIGxp
YnJhcnksIHlvdSBtdXN0IGluc3RhbGwgdGhlIGRldmVsb3BtZW50CiMgdmVyc2lvbiBvZiB0aGUg
cGFja2FnZS4KIwojIFRoZXNlIHBhY2thZ2VzIHVzZSBhIC1kZXYgbmFtaW5nIGNvbnZlbnRpb24g
aW4gYm90aCBEZWJpYW4gYW5kIFJlZCBIYXQ6CiMgICBsaWJnZGJtZzEgIChub24tZGV2ZWxvcG1l
bnQgdmVyc2lvbiBvZiBHTlUgbGliYyAyLWxpbmtlZCBHREJNIGxpYnJhcnkpCiMgICBsaWJnZGJt
ZzEtZGV2IChkZXZlbG9wbWVudCB2ZXJzaW9uIG9mIEdOVSBsaWJjIDItbGlua2VkIEdEQk0gbGli
cmFyeSkKIyBTbyBtYWtlIHN1cmUgdGhhdCBmb3IgYW55IGxpYnJhcmllcyB5b3Ugd2lzaCB0byBs
aW5rIFBlcmwgd2l0aCB1bmRlcgojIERlYmlhbiBvciBSZWQgSGF0IHlvdSBoYXZlIHRoZSAtZGV2
IHBhY2thZ2VzIGluc3RhbGxlZC4KCiMgU3VTRSBMaW51eCBjYW4gYmUgdXNlZCBhcyBjcm9zcy1j
b21waWxhdGlvbiBob3N0IGZvciBDcmF5IFhUNCBDYXRhbW91bnQvUWsuCmlmIHRlc3QgLWQgL29w
dC94dC1wZQp0aGVuCiAgY2FzZSAiYCR7Y2M6LWNjfSAtViAyPiYxYCIgaW4KICAqY2F0YW1vdW50
KikgLiBoaW50cy9jYXRhbW91bnQuc2g7IHJldHVybiA7OwogIGVzYWMKZmkKCiMgU29tZSBvcGVy
YXRpbmcgc3lzdGVtcyAoZS5nLiwgU29sYXJpcyAyLjYpIHdpbGwgbGluayB0byBhIHZlcnNpb25l
ZCBzaGFyZWQKIyBsaWJyYXJ5IGltcGxpY2l0bHkuICBGb3IgZXhhbXBsZSwgb24gU29sYXJpcywg
YGxkIGZvby5vIC1sZ2RibScgd2lsbCBmaW5kIGFuCiMgYXBwcm9wcmlhdGUgdmVyc2lvbiBvZiBs
aWJnZGJtLCBpZiBvbmUgaXMgYXZhaWxhYmxlOyBMaW51eCwgaG93ZXZlciwgZG9lc24ndAojIGRv
IHRoZSBpbXBsaWNpdCBtYXBwaW5nLgppZ25vcmVfdmVyc2lvbmVkX3NvbGlicz0neScKCiMgQlNE
IGNvbXBhdGliaWxpdHkgbGlicmFyeSBubyBsb25nZXIgbmVlZGVkCiMgJ2thZmZlJyBoYXMgYSAv
dXNyL2xpYi9saWJuZXQuc28gd2hpY2ggaXMgbm90IGF0IGFsbCByZWxldmFudCBmb3IgcGVybC4K
IyBiaW5kIGNhdXNlcyBpc3N1ZXMgd2l0aCBzZXZlcmFsIHJlZW50cmFudCBmdW5jdGlvbnMKc2V0
IGBlY2hvIFggIiRsaWJzd2FudGVkICJ8IHNlZCAtZSAncy8gYnNkIC8gLycgLWUgJ3MvIG5ldCAv
IC8nIC1lICdzLyBiaW5kIC8gLydgCnNoaWZ0CmxpYnN3YW50ZWQ9IiQqIgoKIyBEZWJpYW4gNC4w
IHB1dHMgbmRibSBpbiB0aGUgLWxnZGJtX2NvbXBhdCBsaWJyYXJ5LgplY2hvICRsaWJzCmlmIGVj
aG8gIiAkbGlic3dhbnRlZCAiIHwgZ3JlcCAtcSAnIGdkYm0gJzsgdGhlbgogICAgIyBPbmx5IGFk
ZCBpZiBnZGJtIGlzIGluIGxpYnN3YW50ZWQuCiAgICBsaWJzd2FudGVkPSIkbGlic3dhbnRlZCBn
ZGJtX2NvbXBhdCIKZmkKCiMgQ29uZmlndXJlIG1heSBmYWlsIHRvIGZpbmQgbHN0YXQoKSBzaW5j
ZSBpdCdzIGEgc3RhdGljL2lubGluZQojIGZ1bmN0aW9uIGluIDxzeXMvc3RhdC5oPi4KZF9sc3Rh
dD1kZWZpbmUKCiMgbWFsbG9jIHdyYXAgd29ya3MKY2FzZSAiJHVzZW1hbGxvY3dyYXAiIGluCicn
KSB1c2VtYWxsb2N3cmFwPSdkZWZpbmUnIDs7CmVzYWMKCiMgVGhlIHN5c3RlbSBtYWxsb2MoKSBp
cyBhYm91dCBhcyBmYXN0IGFuZCBhcyBmcnVnYWwgYXMgcGVybCdzLgojIFNpbmNlIHRoZSBzeXN0
ZW0gbWFsbG9jKCkgaGFzIGJlZW4gdGhlIGRlZmF1bHQgc2luY2UgYXQgbGVhc3QKIyA1LjAwMSwg
d2UgbWlnaHQgYXMgd2VsbCBsZWF2ZSBpdCB0aGF0IHdheS4gIC0tQUQgIDEwIEphbiAyMDAyCmNh
c2UgIiR1c2VteW1hbGxvYyIgaW4KJycpIHVzZW15bWFsbG9jPSduJyA7Owplc2FjCgp1bmFtZV9t
aW51c19tPSJgJHJ1biB1bmFtZSAtbSAyPi9kZXYvbnVsbGAiCnVuYW1lX21pbnVzX209IiR7dW5h
bWVfbWludXNfbTotIiR0YXJnZXRhcmNoIn0iCgojIENoZWNrIGlmIHdlJ3JlIGFib3V0IHRvIHVz
ZSBJbnRlbCdzIElDQyBjb21waWxlcgpjYXNlICJgJHtjYzotY2N9IC1WIDI+JjFgIiBpbgoqIklu
dGVsKFIpIEMrKyBDb21waWxlciIqfCoiSW50ZWwoUikgQyBDb21waWxlciIqKQogICAgIyByZWNv
cmQgdGhlIHZlcnNpb24sIGZvcm1hdHM6CiAgICAjIGljYyAoSUNDKSAxMC4xIDIwMDgwODAxCiAg
ICAjIGljcGMgKElDQykgMTAuMSAyMDA4MDgwMQogICAgIyBmb2xsb3dlZCBieSBhIGNvcHlyaWdo
dCBvbiB0aGUgc2Vjb25kIGxpbmUKICAgIGNjdmVyc2lvbj1gJHtjYzotY2N9IC0tdmVyc2lvbiB8
IHNlZCAtbiAtZSAncy9eaWNwXD9jIFwoKElDQykgXClcPy8vcCdgCiAgICAjIFRoaXMgaXMgbmVl
ZGVkIGZvciBDb25maWd1cmUncyBwcm90b3R5cGUgY2hlY2tzIHRvIHdvcmsgY29ycmVjdGx5CiAg
ICAjIFRoZSAtbXAgZmxhZyBpcyBuZWVkZWQgdG8gcGFzcyB2YXJpb3VzIGZsb2F0aW5nIHBvaW50
IHJlbGF0ZWQgdGVzdHMKICAgICMgVGhlIC1uby1nY2MgZmxhZyBpcyBuZWVkZWQgb3RoZXJ3aXNl
LCBpY2MgcHJldGVuZHMgKHBvb3JseSkgdG8gYmUgZ2NjCiAgICBjY2ZsYWdzPSItd2UxNDcgLW1w
IC1uby1nY2MgJGNjZmxhZ3MiCiAgICAjIFByZXZlbnQgcmVsb2NhdGlvbiBlcnJvcnMgb24gNjRi
aXRzIGFyY2gKICAgIGNhc2UgIiR1bmFtZV9taW51c19tIiBpbgoJKmlhNjQqfCp4ODZfNjQqKQoJ
ICAgIGNjY2RsZmxhZ3M9Jy1mUElDJwoJOzsKICAgIGVzYWMKICAgICMgSWYgd2UncmUgdXNpbmcg
SUNDLCB3ZSB1c3VhbGx5IHdhbnQgdGhlIGJlc3QgcGVyZm9ybWFuY2UKICAgIGNhc2UgIiRvcHRp
bWl6ZSIgaW4KICAgICcnKSBvcHRpbWl6ZT0nLU8zJyA7OwogICAgZXNhYwogICAgOzsKKiIgU3Vu
ICIqIkMiKikKICAgICMgU3VuJ3MgQyBjb21waWxlciwgd2hpY2ggbWlnaHQgaGF2ZSBhICd0YWcn
IG5hbWUgYmV0d2VlbgogICAgIyAnU3VuJyBhbmQgdGhlICdDJzogIEV4YW1wbGVzOgogICAgIyBj
YzogU3VuIEMgNS45IExpbnV4X2kzODYgUGF0Y2ggMTI0ODcxLTAxIDIwMDcvMDcvMzEKICAgICMg
Y2M6IFN1biBDZXJlcyBDIDUuMTAgTGludXhfaTM4NiAyMDA4LzA3LzEwCiAgICB0ZXN0ICIkb3B0
aW1pemUiIHx8IG9wdGltaXplPScteE8yJwogICAgY2NjZGxmbGFncz0nLUtQSUMnCiAgICBsZGRs
ZmxhZ3M9Jy1HIC1CZHluYW1pYycKICAgICMgU3VuIEMgZG9lc24ndCBzdXBwb3J0IGdjYyBhdHRy
aWJ1dGVzLCBidXQsIGluIG1hbnkgY2FzZXMsIGRvZXNuJ3QKICAgICMgY29tcGxhaW4gZWl0aGVy
LiAgTm90IGFsbCBjYXNlcywgdGhvdWdoLgogICAgZF9hdHRyaWJ1dGVfZm9ybWF0PSd1bmRlZicK
ICAgIGRfYXR0cmlidXRlX21hbGxvYz0ndW5kZWYnCiAgICBkX2F0dHJpYnV0ZV9ub25udWxsPSd1
bmRlZicKICAgIGRfYXR0cmlidXRlX25vcmV0dXJuPSd1bmRlZicKICAgIGRfYXR0cmlidXRlX3B1
cmU9J3VuZGVmJwogICAgZF9hdHRyaWJ1dGVfdW51c2VkPSd1bmRlZicKICAgIGRfYXR0cmlidXRl
X3dhcm5fdW51c2VkX3Jlc3VsdD0ndW5kZWYnCiAgICA7Owplc2FjCgpjYXNlICIkb3B0aW1pemUi
IGluCiMgdXNlIC1PMiBieSBkZWZhdWx0IDsgLU8zIGRvZXNuJ3Qgc2VlbSB0byBicmluZyBzaWdu
aWZpY2FudCBiZW5lZml0cyB3aXRoIGdjYwonJykKICAgIG9wdGltaXplPSctTzInCiAgICBjYXNl
ICIkdW5hbWVfbWludXNfbSIgaW4KICAgICAgICBwcGMqKQogICAgICAgICAgICAjIG9uIHBwYywg
aXQgc2VlbXMgdGhhdCBnY2MgKGF0IGxlYXN0IGdjYyAzLjMuMikgaXNuJ3QgaGFwcHkKICAgICAg
ICAgICAgIyB3aXRoIC1PMiA7IHNvIGRvd25ncmFkZSB0byAtTzEuCiAgICAgICAgICAgIG9wdGlt
aXplPSctTzEnCiAgICAgICAgOzsKICAgICAgICBpYTY0KikKICAgICAgICAgICAgIyBUaGlzIGFy
Y2hpdGVjdHVyZSBoYXMgaGFkIHZhcmlvdXMgcHJvYmxlbXMgd2l0aCBnY2MncwogICAgICAgICAg
ICAjIGluIHRoZSAzLjIsIDMuMywgYW5kIDMuNCByZWxlYXNlcyB3aGVuIG9wdGltaXplZCB0byAt
TzIuICBTZWUKICAgICAgICAgICAgIyBSVCAjMzcxNTYgZm9yIGEgZGlzY3Vzc2lvbiBvZiB0aGUg
cHJvYmxlbS4KICAgICAgICAgICAgY2FzZSAiYCR7Y2M6LWdjY30gLXYgMj4mMWAiIGluCiAgICAg
ICAgICAgICoidmVyc2lvbiAzLjIiKnwqInZlcnNpb24gMy4zIip8KiJ2ZXJzaW9uIDMuNCIqKQog
ICAgICAgICAgICAgICAgY2NmbGFncz0iLWZuby1kZWxldGUtbnVsbC1wb2ludGVyLWNoZWNrcyAk
Y2NmbGFncyIKICAgICAgICAgICAgOzsKICAgICAgICAgICAgZXNhYwogICAgICAgIDs7CiAgICBl
c2FjCiAgICA7Owplc2FjCgojIFVidW50dSAxMS4wNCAoYW5kIGxhdGVyLCBwcmVzdW1hYmx5KSBk
b2Vzbid0IGtlZXAgbW9zdCBsaWJyYXJpZXMKIyAoc3VjaCBhcyAtbG0pIGluIC9saWIgb3IgL3Vz
ci9saWIuICBTbyB3ZSBoYXZlIHRvIGFzayBnY2MgdG8gdGVsbCB1cwojIHdoZXJlIHRvIGxvb2su
ICBXZSBkb24ndCB3YW50IGdjYydzIG93biBsaWJyYXJpZXMsIGhvd2V2ZXIsIHNvIHdlCiMgZmls
dGVyIHRob3NlIG91dC4KIyBUaGlzIGNvdWxkIGJlIGNvbmRpdGlvbmFsIG9uIFVuYnVudHUsIGJ1
dCBvdGhlciBkaXN0cmlidXRpb25zIG1heQojIGZvbGxvdyBzdWl0LCBhbmQgdGhpcyBzY2hlbWUg
c2VlbXMgdG8gd29yayBldmVuIG9uIHJhdGhlciBvbGQgZ2NjJ3MuCiMgVGhpcyB1bmNvbmRpdGlv
bmFsbHkgdXNlcyBnY2MgYmVjYXVzZSBldmVuIGlmIHRoZSB1c2VyIGlzIHVzaW5nIGFub3RoZXIK
IyBjb21waWxlciwgd2Ugc3RpbGwgbmVlZCB0byBmaW5kIHRoZSBtYXRoIGxpYnJhcnkgYW5kIGZy
aWVuZHMsIGFuZCBJIGRvbid0CiMga25vdyBob3cgb3RoZXIgY29tcGlsZXJzIHdpbGwgY29wZSB3
aXRoIHRoYXQgc2l0dWF0aW9uLgojIE1vcmV2ZXIsIGlmIHRoZSB1c2VyIGhhcyB0aGVpciBvd24g
Z2NjIGVhcmxpZXIgaW4gJFBBVEggdGhhbiB0aGUgc3lzdGVtIGdjYywKIyB3ZSBkb24ndCB3YW50
IGl0cyBsaWJyYXJpZXMuIFNvIHdlIHRyeSB0byBwcmVmZXIgdGhlIHN5c3RlbSBnY2MKIyBTdGls
bCwgYXMgYW4gZXNjYXBlIGhhdGNoLCBhbGxvdyBDb25maWd1cmUgY29tbWFuZCBsaW5lIG92ZXJy
aWRlcyB0bwojIHBsaWJwdGggdG8gYnlwYXNzIHRoaXMgY2hlY2suCmlmIFsgLXggL3Vzci9iaW4v
Z2NjIF0gOyB0aGVuCiAgICBnY2M9L3Vzci9iaW4vZ2NjCmVsc2UKICAgIGdjYz1nY2MKZmkKCmNh
c2UgIiRwbGlicHRoIiBpbgonJykgcGxpYnB0aD1gTEFORz1DIExDX0FMTD1DICRnY2MgJGNjZmxh
Z3MgJGxkZmxhZ3MgLXByaW50LXNlYXJjaC1kaXJzIHwgZ3JlcCBsaWJyYXJpZXMgfAoJY3V0IC1m
Mi0gLWQ9IHwgdHIgJzonICR0cm5sIHwgZ3JlcCAtdiAnZ2NjJyB8IHNlZCAtZSAnczovJDo6J2AK
ICAgIHNldCBYICRwbGlicHRoICMgQ29sbGFwc2UgYWxsIGVudHJpZXMgb24gb25lIGxpbmUKICAg
IHNoaWZ0CiAgICBwbGlicHRoPSIkKiIKICAgIDs7CmVzYWMKCiMgbGlicXVhZG1hdGggaXMgc29t
ZXRpbWVzIGluc3RhbGxlZCBhcyBnY2MgaW50ZXJuYWwgbGlicmFyeSwKIyBzbyBjb250cmFyeSB0
byBvdXIgdXN1YWwgcG9saWN5IG9mICpub3QqIGxvb2tpbmcgYXQgZ2NjIGludGVybmFsCiMgZGly
ZWN0b3JpZXMgd2Ugbm93ICpkbyogbG9vayBhdCB0aGVtLCBpbiBjYXNlIHRoZXkgY29udGFpbgoj
IHRoZSBxdWFkbWF0aCBsaWJyYXJ5LgojIFhYWCBUaGlzIG1heSBhcHBseSB0byBvdGhlciBnY2Mg
aW50ZXJuYWwgbGlicmFyaWVzLCBpZiBzdWNoIGV4aXN0LgojIFhYWCBUaGlzIGNvdWxkIGJlIGF0
IENvbmZpZ3VyZSBsZXZlbCwgYnV0IHRoZW4gdGhlICRnY2MgaXMgbWVzc3kuCmNhc2UgIiR1c2Vx
dWFkbWF0aCIgaW4KIiRkZWZpbmUiKQogIGZvciBkIGluIGBMQU5HPUMgTENfQUxMPUMgJGdjYyAk
Y2NmbGFncyAkbGRmbGFncyAtcHJpbnQtc2VhcmNoLWRpcnMgfCBncmVwIGxpYnJhcmllcyB8IGN1
dCAtZjItIC1kPSB8IHRyICc6JyAkdHJubCB8IGdyZXAgJ2djYycgfCBzZWQgLWUgJ3M6LyQ6Oidg
CiAgZG8KICAgIGNhc2UgYGxzICRkLypsaWJxdWFkbWF0aCokc28qIDI+L2Rldi9udWxsYCBpbgog
ICAgJGQvKmxpYnF1YWRtYXRoKiRzbyopIHhsaWJwdGg9IiR4bGlicHRoICRkIiA7OwogICAgZXNh
YwogIGRvbmUKICA7Owplc2FjCgpjYXNlICIkbGliYyIgaW4KJycpCiMgSWYgeW91IGhhdmUgZ2xp
YmMsIHRoZW4gcmVwb3J0IHRoZSB2ZXJzaW9uIGZvciAuL215Y29uZmlnIGJ1ZyByZXBvcnRpbmcu
CiMgKENvbmZpZ3VyZSBkb2Vzbid0IG5lZWQgdG8ga25vdyB0aGUgc3BlY2lmaWMgdmVyc2lvbiBz
aW5jZSBpdCBqdXN0IHVzZXMKIyBnY2MgdG8gbG9hZCB0aGUgbGlicmFyeSBmb3IgYWxsIHRlc3Rz
LikKIyBXZSBkb24ndCB1c2UgX19HTElCQ19fIGFuZCAgX19HTElCQ19NSU5PUl9fIGJlY2F1c2Ug
dGhleQojIGFyZSBpbnN1ZmZpY2llbnRseSBwcmVjaXNlIHRvIGRpc3Rpbmd1aXNoIHRoaW5ncyBs
aWtlCiMgbGliYy0yLjAuNiBhbmQgbGliYy0yLjAuNy4KICAgIGZvciBwIGluICRwbGlicHRoCiAg
ICBkbwogICAgICAgIGZvciB0cnlsaWIgaW4gbGliYy5zby42IGxpYmMuc28KICAgICAgICBkbwog
ICAgICAgICAgICBpZiAkdGVzdCAtZSAkcC8kdHJ5bGliOyB0aGVuCiAgICAgICAgICAgICAgICBs
aWJjPWBscyAtbCAkcC8kdHJ5bGliIHwgYXdrICd7cHJpbnQgJE5GfSdgCiAgICAgICAgICAgICAg
ICBpZiAkdGVzdCAiWCRsaWJjIiAhPSBYOyB0aGVuCiAgICAgICAgICAgICAgICAgICAgYnJlYWsK
ICAgICAgICAgICAgICAgIGZpCiAgICAgICAgICAgIGZpCiAgICAgICAgZG9uZQogICAgICAgIGlm
ICR0ZXN0ICJYJGxpYmMiICE9IFg7IHRoZW4KICAgICAgICAgICAgYnJlYWsKICAgICAgICBmaQog
ICAgZG9uZQogICAgOzsKZXNhYwoKaWYgJHtzaDotL2Jpbi9zaH0gLWMgZXhpdDsgdGhlbgogIGVj
aG8gJycKICBlY2hvICdZb3UgYXBwZWFyIHRvIGhhdmUgYSB3b3JraW5nIGJhc2guICBHb29kLicK
ZWxzZQogIGNhdCA8PCAnRU9NJyA+JjQKCioqKioqKioqKioqKioqKioqKioqKioqIFdhcm5pbmch
ICoqKioqKioqKioqKioqKioqKioqKgpJdCB3b3VsZCBhcHBlYXIgeW91IGhhdmUgYSBkZWZlY3Rp
dmUgYmFzaCBzaGVsbCBpbnN0YWxsZWQuIFRoaXMgaXMgbGlrZWx5IHRvCmdpdmUgeW91IGEgZmFp
bHVyZSBvZiBvcC9leGVjIHRlc3QgIzUgZHVyaW5nIHRoZSB0ZXN0IHBoYXNlIG9mIHRoZSBidWls
ZCwKVXBncmFkaW5nIHRvIGEgcmVjZW50IHZlcnNpb24gKDEuMTQuNCBvciBsYXRlcikgc2hvdWxk
IGZpeCB0aGUgcHJvYmxlbS4KKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioq
KioqKioqKioqKioqKioqCkVPTQoKZmkKCiMgT24gU1BBUkNsaW51eCwKIyBUaGUgZm9sbG93aW5n
IGNzaCBjb25zaXN0ZW50bHkgY29yZWR1bXBlZCBpbiB0aGUgdGVzdCBkaXJlY3RvcnkKIyAiL2hv
bWUvbWlrZWRsci9wZXJsNS4wMDNfOTQvdCIsIHRob3VnaCBub3QgbW9zdCBvdGhlciBkaXJlY3Rv
cmllcy4KCiNOYW1lICAgICAgICA6IGNzaCAgICAgICAgICAgICAgICAgICAgRGlzdHJpYnV0aW9u
OiBSZWQgSGF0IExpbnV4IChSZW1icmFuZHQpCiNWZXJzaW9uICAgICA6IDUuMi42ICAgICAgICAg
ICAgICAgICAgICAgICAgVmVuZG9yOiBSZWQgSGF0IFNvZnR3YXJlCiNSZWxlYXNlICAgICA6IDMg
ICAgICAgICAgICAgICAgICAgICAgICBCdWlsZCBEYXRlOiBGcmkgTWF5IDI0IDE5OjQyOjE0IDE5
OTYKI0luc3RhbGwgZGF0ZTogVGh1IEp1bCAxMSAxNjoyMDoxNCAxOTk2IEJ1aWxkIEhvc3Q6IGl0
Y2h5LnJlZGhhdC5jb20KI0dyb3VwICAgICAgIDogU2hlbGxzICAgICAgICAgICAgICAgICAgIFNv
dXJjZSBSUE06IGNzaC01LjIuNi0zLnNyYy5ycG0KI1NpemUgICAgICAgIDogMTg0NDE3CiNEZXNj
cmlwdGlvbiA6IEJTRCBjLXNoZWxsCgojIEZvciB0aGlzIHJlYXNvbiBJIHN1Z2dlc3QgdXNpbmcg
dGhlIG11Y2ggYnVnLWZpeGVkIHRjc2ggZm9yIGdsb2JiaW5nCiMgd2hlcmUgYXZhaWxhYmxlLgoK
IyBOb3ZlbWJlciAyMDAxOiAgVGhhdCB3YXJuaW5nJ3MgcHJldHR5IG9sZCBub3cgYW5kIHByb2Jh
Ymx5IG5vdCBzbwojIHJlbGV2YW50LCBlc3BlY2lhbGx5IHNpbmNlIHBlcmwgbm93IHVzZXMgRmls
ZTo6R2xvYiBmb3IgZ2xvYmJpbmcuCiMgV2UnbGwgc3RpbGwgbG9vayBmb3IgdGNzaCwgYnV0IHRv
bmUgZG93biB0aGUgd2FybmluZ3MuCiMgQW5keSBEb3VnaGVydHksIE5vdi4gNiwgMjAwMQppZiAk
Y3NoIC1jICdlY2hvICR2ZXJzaW9uJyA+L2Rldi9udWxsIDI+JjE7IHRoZW4KICAgIGVjaG8gJ1lv
dXIgY3NoIGlzIHJlYWxseSB0Y3NoLiAgR29vZC4nCmVsc2UKICAgIGlmIHh4eD1gLi9VVS9sb2Mg
dGNzaCBibHVyZmwgJHB0aGA7ICR0ZXN0IC1mICIkeHh4IjsgdGhlbgoJZWNobyAiRm91bmQgdGNz
aC4gIEknbGwgdXNlIGl0IGZvciBnbG9iYmluZy4iCgkjIFdlIGNhbid0IGNoYW5nZSBDb25maWd1
cmUncyBzZXR0aW5nIG9mICRjc2gsIGR1ZSB0byB0aGUgd2F5CgkjIENvbmZpZ3VyZSBoYW5kbGVz
ICRkX3BvcnRhYmxlIGFuZCBjb21tYW5kcyBmb3VuZCBpbiAkbG9jbGlzdC4KCSMgV2UgY2FuIHNl
dCB0aGUgdmFsdWUgZm9yIENTSCBpbiBjb25maWcuaCBieSBzZXR0aW5nIGZ1bGxfY3NoLgoJZnVs
bF9jc2g9JHh4eAogICAgZWxpZiBbIC1mICIkY3NoIiBdOyB0aGVuCgllY2hvICJDb3VsZG4ndCBm
aW5kIHRjc2guICBDc2gtYmFzZWQgZ2xvYmJpbmcgbWlnaHQgYmUgYnJva2VuLiIKICAgIGZpCmZp
CgojIFNoaW1wZWkgWWFtYXNoaXRhIDxzaGltcGVpQHNvY3JhdGVzLnBhdG5ldC5jYWx0ZWNoLmVk
dT4KIyBNZXNzYWdlLUlkOiA8MzNFRjE2MzQuQjM2QjY1MDBAcG9ib3guY29tPgojCiMgVGhlIERS
MiBvZiBNa0xpbnV4IChvc25hbWU9bGludXgsYXJjaG5hbWU9cHBjLWxpbnV4KSBtYXkgbmVlZAoj
IHNwZWNpYWwgZmxhZ3MgcGFzc2VkIGluIG9yZGVyIGZvciBkeW5hbWljIGxvYWRpbmcgdG8gd29y
ay4KIyBpbnN0ZWFkIG9mIHRoZSByZWNvbW1lbmRlZDoKIwojIGNjZGxmbGFncz0nLXJkeW5hbWlj
JwojCiMgaXQgc2hvdWxkIGJlOgojIGNjZGxmbGFncz0nLVdsLC1FJwojCiMgU28gaWYgeW91ciBE
UjIgKERSMyBjYW1lIG91dCBzdW1tZXIgMTk5OCwgY29uc2lkZXIgdXBncmFkaW5nKQojIGhhcyBw
cm9ibGVtcyB3aXRoIGR5bmFtaWMgbG9hZGluZywgdW5jb21tZW50IHRoZQojIGZvbGxvd2luZyB0
aHJlZSBsaW5lcywgbWFrZSBkaXN0Y2xlYW4sIGFuZCByZS1Db25maWd1cmU6CiNjYXNlICJgdW5h
bWUgLXIgfCBzZWQgJ3MvXlswLTkuLV0qLy8nYGBhcmNoYCIgaW4KIydvc2ZtYWNoM3BwYycpIGNj
ZGxmbGFncz0nLVdsLC1FJyA7OwojZXNhYwoKY2FzZSAiJHVuYW1lX21pbnVzX20iIGluCnNwYXJj
KikKCWNhc2UgIiRjY2NkbGZsYWdzIiBpbgoJKi1mcGljKikgY2NjZGxmbGFncz0iYGVjaG8gJGNj
Y2RsZmxhZ3N8c2VkICdzLy1mcGljLy1mUElDLydgIiA7OwoJKi1mUElDKikgOzsKCSopCSBjY2Nk
bGZsYWdzPSIkY2NjZGxmbGFncyAtZlBJQyIgOzsKCWVzYWMKCTs7CmVzYWMKCiMgU3VTRTguMiBo
YXMgL3Vzci9saWIvbGlibmRibSogd2hpY2ggYXJlIGxkIHNjcmlwdHMgcmF0aGVyIHRoYW4KIyB0
cnVlIGxpYnJhcmllcy4gVGhlIHNjcmlwdHMgY2F1c2UgYmluZGluZyBhZ2FpbnN0IHN0YXRpYwoj
IHZlcnNpb24gb2YgLWxnZGJtIHdoaWNoIGlzIGEgYmFkIGlkZWEuIFNvIGlmIHdlIGhhdmUgJ25t
JwojIG1ha2Ugc3VyZSBpdCBjYW4gcmVhZCB0aGUgZmlsZQojIE5JLVMgMjAwMy8wOC8wNwpjYXNl
ICIkbm0iIGluCiAgICAnJykgOzsKICAgICopCiAgICBmb3IgcCBpbiAkcGxpYnB0aAogICAgZG8K
ICAgICAgICBpZiAkdGVzdCAtciAkcC9saWJuZGJtLnNvOyB0aGVuCiAgICAgICAgICAgIGlmICRu
bSAkcC9saWJuZGJtLnNvID4vZGV2L251bGwgMj4mMSA7IHRoZW4KICAgICAgICAgICAgICAgIGVj
aG8gJ1lvdXIgc2hhcmVkIC1sbmRibSBzZWVtcyB0byBiZSBhIHJlYWwgbGlicmFyeS4nCiAgICAg
ICAgICAgICAgICBfbGlibmRibV9yZWFsPTEKICAgICAgICAgICAgICAgIGJyZWFrCiAgICAgICAg
ICAgIGZpCiAgICAgICAgZmkKICAgIGRvbmUKICAgIGlmICR0ZXN0ICJYJF9saWJuZGJtX3JlYWwi
ID0gWDsgdGhlbgogICAgICAgIGVjaG8gJ1lvdXIgc2hhcmVkIC1sbmRibSBpcyBub3QgYSByZWFs
IGxpYnJhcnkuJwogICAgICAgIHNldCBgZWNobyBYICIkbGlic3dhbnRlZCAifCBzZWQgLWUgJ3Mv
IG5kYm0gLyAvJ2AKICAgICAgICBzaGlmdAogICAgICAgIGxpYnN3YW50ZWQ9IiQqIgogICAgZmkK
ICAgIDs7CmVzYWMKCiMgTGludXggb24gU3lub2xvZ3kuCmlmIFsgLWYgL2V0Yy9zeW5vaW5mby5j
b25mIC1hIC1kIC91c3Ivc3lubyBdOyB0aGVuCiAgICAjIFRlc3RlZCBvbiBTeW5vbG9neSBEUzIx
MyBhbmQgRFM0MTMKICAgICMgIE9TIHZlcnNpb24gaW5mbyBpbiAvZXRjLmRlZmF1bHRzL1ZFUlNJ
T04KICAgICMgIGh0dHA6Ly9mb3J1bS5zeW5vbG9neS5jb20vd2lraS9pbmRleC5waHAvV2hhdF9r
aW5kX29mX0NQVV9kb2VzX215X05BU19oYXZlCiAgICAjIFN5bm9sb2d5IERTMjEzIHJ1bm5pbmcg
RFNNIDQuMy0zODEwLTAgKDIwMTMtMTEtMDYpCiAgICAjICBDUFUgbW9kZWwgTWFydmVsbCBLaXJr
d29vZCBtdjYyODIgQVJNdjV0ZQogICAgIyAgTGludXggMi42LjMyLjEyICMzODEwIFdlZCBOb3Yg
NiAwNToxMzo0MSBDU1QgMjAxMyBhcm12NXRlbCBHTlUvTGludXgKICAgICMgU3lub2xvZ3kgRFM0
MTMgcnVubmluZyBEU00gNC4zLTM4MTAtMCAoMjAxMy0xMS0wNikKICAgICMgIENQVSBtb2RlbCBG
cmVlc2NhbGUgUW9ySVEgUDEwMjIgcHBjIChlNTAwdjIpCiAgICAjICBsaW51eCAyLjYuMzIuMTIg
IzM4MTAgcHBjIEdOVS9MaW51eAogICAgIyBBbGwgZGV2ZWxvcG1lbnQgc3R1ZmYgaW5zdGFsbGVk
IHdpdGggaXBrZyBpcyBpbiAvb3B0CiAgICBpZiBbICIkTEFORyIgPSAiIiAtbyAiJExBTkciID0g
IkMiIF07IHRoZW4KCWVjaG8gJ1lvdXIgTEFORyBpcyBzYWZlJwogICAgZWxzZQoJZWNobyAnUGxl
YXNlIHNldCAkTEFORyB0byAiQyIuIEFsbCBvdGhlciAkTEFORyBzZXR0aW5ncyB3aWxsIGNhdXNl
IGhhdm9jJyA+JjQKCUxBTkc9QwogICAgZmkKICAgIGVjaG8gJ1NldHRpbmcgdXAgdG8gdXNlIC9v
cHQvKicgPiY0CiAgICBsb2NpbmNwdGg9Ii9vcHQvaW5jbHVkZSAkbG9jaW5jcHRoIgogICAgbGli
cHRoPSIvb3B0L2xpYiAkbGlicHRoIgogICAgbGlic3B0aD0iL29wdC9saWIgJGxpYnNwdGgiCiAg
ICBsb2NsaWJwdGg9Ii9vcHQvbGliICRsb2NsaWJwdGgiCiAgICAjIFBPU0lYIHdpbGwgbm90IGxp
bmsgd2l0aG91dCB0aGUgcHRocmVhZCBsaWIKICAgIGxpYnN3YW50ZWQ9IiRsaWJzd2FudGVkIHB0
aHJlYWQiCiAgICBlY2hvICIkbGlic3dhbnRlZCIgPiY0CmZpCgojIFRoaXMgc2NyaXB0IFVVL3Vz
ZXRocmVhZHMuY2J1IHdpbGwgZ2V0ICdjYWxsZWQtYmFjaycgYnkgQ29uZmlndXJlCiMgYWZ0ZXIg
aXQgaGFzIHByb21wdGVkIHRoZSB1c2VyIGZvciB3aGV0aGVyIHRvIHVzZSB0aHJlYWRzLgpjYXQg
PiBVVS91c2V0aHJlYWRzLmNidSA8PCdFT0NCVScKY2FzZSAiJHVzZXRocmVhZHMiIGluCiRkZWZp
bmV8dHJ1ZXxbeVldKikKICAgICAgICBjY2ZsYWdzPSItRF9SRUVOVFJBTlQgLURfR05VX1NPVVJD
RSAkY2NmbGFncyIKICAgICAgICBpZiBlY2hvICRsaWJzd2FudGVkIHwgZ3JlcCAtdiBwdGhyZWFk
ID4vZGV2L251bGwKICAgICAgICB0aGVuCiAgICAgICAgICAgIHNldCBgZWNobyBYICIkbGlic3dh
bnRlZCAifCBzZWQgLWUgJ3MvIGMgLyBwdGhyZWFkIGMgLydgCiAgICAgICAgICAgIHNoaWZ0CiAg
ICAgICAgICAgIGxpYnN3YW50ZWQ9IiQqIgogICAgICAgIGZpCgoJIyBTb21laG93IGF0IGxlYXN0
IGluIERlYmlhbiAyLjIgdGhlc2UgbWFuYWdlIHRvIGVzY2FwZQoJIyB0aGUgI2RlZmluZSBmb3Jl
c3Qgb2YgPGZlYXR1cmVzLmg+IGFuZCA8dGltZS5oPiBzbyB0aGF0CgkjIHRoZSBoYXNwcm90byBt
YWNybyBvZiBDb25maWd1cmUgZG9lc24ndCBzZWUgdGhlc2UgcHJvdG9zLAoJIyBldmVuIHdpdGgg
dGhlIC1EX0dOVV9TT1VSQ0UuCgoJZF9hc2N0aW1lX3JfcHJvdG89IiRkZWZpbmUiCglkX2NyeXB0
X3JfcHJvdG89IiRkZWZpbmUiCglkX2N0aW1lX3JfcHJvdG89IiRkZWZpbmUiCglkX2dtdGltZV9y
X3Byb3RvPSIkZGVmaW5lIgoJZF9sb2NhbHRpbWVfcl9wcm90bz0iJGRlZmluZSIKCWRfcmFuZG9t
X3JfcHJvdG89IiRkZWZpbmUiCgoJOzsKZXNhYwpFT0NCVQoKY2F0ID4gVVUvdXNlbGFyZ2VmaWxl
cy5jYnUgPDwnRU9DQlUnCiMgVGhpcyBzY3JpcHQgVVUvdXNlbGFyZ2VmaWxlcy5jYnUgd2lsbCBn
ZXQgJ2NhbGxlZC1iYWNrJyBieSBDb25maWd1cmUKIyBhZnRlciBpdCBoYXMgcHJvbXB0ZWQgdGhl
IHVzZXIgZm9yIHdoZXRoZXIgdG8gdXNlIGxhcmdlIGZpbGVzLgpjYXNlICIkdXNlbGFyZ2VmaWxl
cyIgaW4KJyd8JGRlZmluZXx0cnVlfFt5WV0qKQojIEtlZXAgdGhpcyBpbiB0aGUgbGVmdCBtYXJn
aW4uCmNjZmxhZ3NfdXNlbGFyZ2VmaWxlcz0iLURfTEFSR0VGSUxFX1NPVVJDRSAtRF9GSUxFX09G
RlNFVF9CSVRTPTY0IgoKCWNjZmxhZ3M9IiRjY2ZsYWdzICRjY2ZsYWdzX3VzZWxhcmdlZmlsZXMi
Cgk7Owplc2FjCkVPQ0JVCgojIFB1cmlmeSBmYWlscyB0byBsaW5rIFBlcmwgaWYgYSAiLWxjIiBp
cyBwYXNzZWQgaW50byBpdHMgbGlua2VyCiMgZHVlIHRvIGR1cGxpY2F0ZSBzeW1ib2xzLgpjYXNl
ICIkUFVSSUZZIiBpbgokZGVmaW5lfHRydWV8W3lZXSopCiAgICBzZXQgYGVjaG8gWCAiJGxpYnN3
YW50ZWQgInwgc2VkIC1lICdzLyBjIC8gLydgCiAgICBzaGlmdAogICAgbGlic3dhbnRlZD0iJCoi
CiAgICA7Owplc2FjCgojIElmIHVzaW5nIGcrKywgdGhlIENvbmZpZ3VyZSBzY2FuIGZvciBkbG9w
ZW4oKSBhbmQgKGVzcGVjaWFsbHkpCiMgZGxlcnJvcigpIG1pZ2h0IGZhaWwsIGVhc2llciBqdXN0
IHRvIGZvcmNpYmx5IGhpbnQgdGhlbSBpbi4KY2FzZSAiJGNjIiBpbgoqZysrKikKICBkX2Rsb3Bl
bj0nZGVmaW5lJwogIGRfZGxlcnJvcj0nZGVmaW5lJwogIDs7CmVzYWMKCiMgVW5kZXIgc29tZSBj
aXJjdW1zdGFuY2VzIGxpYmRiIGNhbiBnZXQgYnVpbHQgaW4gc3VjaCBhIHdheSBhcyB0bwojIG5l
ZWQgcHRocmVhZCBleHBsaWNpdGx5IGxpbmtlZC4KCmxpYmRiX25lZWRzX3B0aHJlYWQ9Ik4iCgpp
ZiBlY2hvICIgJGxpYnN3YW50ZWQgIiB8IGdyZXAgLXYgIiBwdGhyZWFkICIgPi9kZXYvbnVsbAp0
aGVuCiAgIGlmIGVjaG8gIiAkbGlic3dhbnRlZCAiIHwgZ3JlcCAiIGRiICIgPi9kZXYvbnVsbAog
ICB0aGVuCiAgICAgZm9yIERCRElSIGluICRnbGlicHRoCiAgICAgZG8KICAgICAgIERCTElCPSIk
REJESVIvbGliZGIuc28iCiAgICAgICBpZiBbIC1mICREQkxJQiBdCiAgICAgICB0aGVuCiAgICAg
ICAgIGlmICR7bm06LW5tfSAtdSAkREJMSUIgMj4vZGV2L251bGwgfCBncmVwIHB0aHJlYWQgPi9k
ZXYvbnVsbAogICAgICAgICB0aGVuCiAgICAgICAgICAgaWYgbGRkICREQkxJQiB8IGdyZXAgcHRo
cmVhZCA+L2Rldi9udWxsCiAgICAgICAgICAgdGhlbgogICAgICAgICAgICAgbGliZGJfbmVlZHNf
cHRocmVhZD0iTiIKICAgICAgICAgICBlbHNlCiAgICAgICAgICAgICBsaWJkYl9uZWVkc19wdGhy
ZWFkPSJZIgogICAgICAgICAgIGZpCiAgICAgICAgIGZpCiAgICAgICBmaQogICAgIGRvbmUKICAg
ZmkKZmkKCmNhc2UgIiRsaWJkYl9uZWVkc19wdGhyZWFkIiBpbgogICJZIikKICAgIGxpYnN3YW50
ZWQ9IiRsaWJzd2FudGVkIHB0aHJlYWQiCiAgICA7Owplc2FjCg==',
'midnightbsd' =>
'dXNldmZvcms9J3RydWUnCmNhc2UgIiR1c2VteW1hbGxvYyIgaW4KICAgICIiKSB1c2VteW1hbGxv
Yz0nbicKICAgICAgICA7Owplc2FjCmxpYnN3YW50ZWQ9YGVjaG8gJGxpYnN3YW50ZWQgfCBzZWQg
J3MvIG1hbGxvYyAvIC8nYAoKb2JqZm9ybWF0PWAvdXNyL2Jpbi9vYmpmb3JtYXRgCmlmIFsgeCRv
Ympmb3JtYXQgPSB4YW91dCBdOyB0aGVuCiAgICBpZiBbIC1lIC91c3IvbGliL2FvdXQgXTsgdGhl
bgogICAgICAgIGxpYnB0aD0iL3Vzci9saWIvYW91dCAvdXNyL2xvY2FsL2xpYiAvdXNyL2xpYiIK
ICAgICAgICBnbGlicHRoPSIvdXNyL2xpYi9hb3V0IC91c3IvbG9jYWwvbGliIC91c3IvbGliIgog
ICAgZmkKICAgIGxkZGxmbGFncz0nLUJzaGFyZWFibGUnCmVsc2UKICAgIGxpYnB0aD0iL3Vzci9s
aWIgL3Vzci9sb2NhbC9saWIiCiAgICBnbGlicHRoPSIvdXNyL2xpYiAvdXNyL2xvY2FsL2xpYiIK
ICAgIGxkZmxhZ3M9Ii1XbCwtRSAiCiAgICBsZGRsZmxhZ3M9Ii1zaGFyZWQgIgpmaQpjY2NkbGZs
YWdzPSctRFBJQyAtZlBJQycKCmNjZmxhZ3M9IiR7Y2NmbGFnc30gLURIQVNfRlBTRVRNQVNLIC1E
SEFTX0ZMT0FUSU5HUE9JTlRfSCIKaWYgL3Vzci9iaW4vZmlsZSAtTCAvdXNyL2xpYi9saWJjLnNv
IHwgL3Vzci9iaW4vZ3JlcCAtdnEgIm5vdCBzdHJpcHBlZCIgOyB0aGVuCiAgICB1c2VubT1mYWxz
ZQpmaQoKc2lnbmFsX3Q9J3ZvaWQnCmRfdm9pZHNpZz0nZGVmaW5lJwoKIyBUaGlzIHNjcmlwdCBV
VS91c2V0aHJlYWRzLmNidSB3aWxsIGdldCAnY2FsbGVkLWJhY2snIGJ5IENvbmZpZ3VyZSAKIyBh
ZnRlciBpdCBoYXMgcHJvbXB0ZWQgdGhlIHVzZXIgZm9yIHdoZXRoZXIgdG8gdXNlIHRocmVhZHMu
CmNhdCA+IFVVL3VzZXRocmVhZHMuY2J1IDw8J0VPQ0JVJwpjYXNlICIkdXNldGhyZWFkcyIgaW4K
JGRlZmluZXx0cnVlfFt5WV0qKQoJbGRmbGFncz0iLXB0aHJlYWQgJGxkZmxhZ3MiCglzZXQgYGVj
aG8gWCAiJGxpYnN3YW50ZWQgInwgc2VkIC1lICdzLyBjIC8vJ2AKCXNoaWZ0CglsaWJzd2FudGVk
PSIkKiIKCSMgQ29uZmlndXJlIHdpbGwgcHJvYmFibHkgcGljayB0aGUgd3JvbmcgbGliYyB0byB1
c2UgZm9yIG5tIHNjYW4uCgkjIFRoZSBzYWZlc3QgcXVpY2stZml4IGlzIGp1c3QgdG8gbm90IHVz
ZSBubSBhdCBhbGwuLi4KCXVzZW5tPWZhbHNlCgogICAgICAgIHVuc2V0IGxjX3IKCgkjIEV2ZW4g
d2l0aCB0aGUgbWFsbG9jIG11dGV4ZXMgdGhlIFBlcmwgbWFsbG9jIGRvZXMgbm90CgkjIHNlZW0g
dG8gYmUgdGhyZWFkc2FmZSBpbiBNaWRuaWdodEJTRD8KCWNhc2UgIiR1c2VteW1hbGxvYyIgaW4K
CScnKSB1c2VteW1hbGxvYz1uIDs7Cgllc2FjCmVzYWMKRU9DQlUKCiMgbWFsbG9jIHdyYXAgd29y
a3MKY2FzZSAiJHVzZW1hbGxvY3dyYXAiIGluCicnKSB1c2VtYWxsb2N3cmFwPSdkZWZpbmUnIDs7
CmVzYWMK',
'netbsd' =>
'IyBoaW50cy9uZXRic2Quc2gKIwojIFBsZWFzZSBjaGVjayB3aXRoIHBhY2thZ2VzQG5ldGJzZC5v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=',
'openbsd' =>
'IyBoaW50cy9vcGVuYnNkLnNoCiMKIyBoaW50cyBmaWxlIGZvciBPcGVuQlNEOyBUb2RkIE1pbGxl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',
'solaris' =>
'IyBoaW50cy9zb2xhcmlzXzIuc2gKIyBDb250cmlidXRpb25zIGJ5IChpbiBhbHBoYWJldGljYWwg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',
);

my %files = (
  'freebsd' => 'freebsd.sh',
  'netbsd'  => 'netbsd.sh',
  'openbsd' => 'openbsd.sh',
  'linux'   => 'linux.sh',
  'dragonfly' => 'dragonfly.sh',
  'darwin' => 'darwin.sh',
  'hpux' => 'hpux.sh',
  'cygwin' => 'cygwin.sh',
  'midnightbsd' => 'midnightbsd.sh',
  'gnukfreebsd' => 'gnukfreebsd.sh',
  'solaris' => 'solaris_2.sh',
  'bitrig' => 'bitrig.sh',
  'gnu' => 'gnu.sh',
);

sub hint_file {
  my $os = shift;
  $os = shift if eval { $os->isa(__PACKAGE__) };
  $os = $^O unless $os;
  return unless defined $hints{ $os };
  my $content = decode_base64( $hints{ $os } );
  return $content unless wantarray;
  return ( $files{ $os }, $content );
}

sub hints {
  return sort keys %hints;
}

qq'nudge nudge wink wink';

__END__

=pod

=encoding UTF-8

=head1 NAME

Devel::PatchPerl::Hints - replacement 'hints' files

=head1 VERSION

version 1.52

=head1 SYNOPSIS

  use Devel::PatchPerl::Hints;

  if ( my $content = Devel::PatchPerl::Hints->hint_file() ) {
    chmod 0644, 'hints/netbsd.sh' or die "$!";
    open my $hints, '>', 'hints/netbsd.sh' or die "$!";
    print $hints $content;
    close $hints;
  }

  # Get a list of OS for which we have hints

  my @os = Devel::PatchPerl::Hints->hints();

=head1 DESCRIPTION

Sometimes there is a problem with Perls C<hints> file for a particular
perl port. This module provides fixed C<hints> files encoded using
C<MIME::Base64>.

=head1 FUNCTION

The function is exported, but has to implicitly imported into the
requesting package.

  use Devel::PatchPerl::Hints qw[hint_file];

It may also be called as a class method:

  use Devel::PatchPerl::Hints;

  my $content = Devel::PatchPerl::Hints->hint_file();

=over

=item C<hint_file>

Takes an optional argument which is the OS name ( as would be returned by C<$^O> ).
By default it will use C<$^O>.

In a scalar context, Will return the decoded content of the C<hints> file suitable for writing straight to a
file handle or undef list if there isn't an applicable C<hints> file for the given or derived
OS.

If called in a list context, will return a list, the first item will be the name of the C<hints> file that
will need to be amended, the second item will be a string with the decoded content of the C<hints> file suitable
for writing straight to a file handle. Otherwise an empty list will be returned.

=item C<hints>

Takes no arguments, returns a list of OS names for which there are C<hints> files.

=back

=head1 AUTHOR

Chris Williams <chris@bingosnet.co.uk>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Chris Williams and Marcus Holland-Moritz.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
