/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.signer.bouncycastle;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.util.Iterator;
import org.apache.ivy.plugins.signer.SignatureGenerator;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPUtil;

public class OpenPGPSignatureGenerator
implements SignatureGenerator {
    private static final long MASK = 0xFFFFFFFFL;
    private String name;
    private String secring;
    private String password;
    private String keyId;
    private PGPSecretKey pgpSec;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getExtension() {
        return "asc";
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setSecring(String string) {
        this.secring = string;
    }

    public void setKeyId(String string) {
        if (!"auto".equals(string)) {
            this.keyId = string;
        }
    }

    @Override
    public void sign(File file, File file2) throws IOException {
        OutputStream outputStream = null;
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        try {
            if (this.secring == null) {
                this.secring = System.getProperty("user.home") + "/.gnupg/secring.gpg";
            }
            if (this.pgpSec == null) {
                inputStream2 = new FileInputStream(this.secring);
                this.pgpSec = this.readSecretKey(inputStream2);
            }
            PGPPrivateKey pGPPrivateKey = this.pgpSec.extractPrivateKey(this.password.toCharArray(), BouncyCastleProvider.PROVIDER_NAME);
            PGPSignatureGenerator pGPSignatureGenerator = new PGPSignatureGenerator(this.pgpSec.getPublicKey().getAlgorithm(), 2, BouncyCastleProvider.PROVIDER_NAME);
            pGPSignatureGenerator.initSign(0, pGPPrivateKey);
            inputStream = new FileInputStream(file);
            outputStream = new BCPGOutputStream((OutputStream)new ArmoredOutputStream((OutputStream)new FileOutputStream(file2)));
            int n = 0;
            while ((n = inputStream.read()) >= 0) {
                pGPSignatureGenerator.update((byte)n);
            }
            pGPSignatureGenerator.generate().encode(outputStream);
        }
        catch (SignatureException signatureException) {
            IOException iOException = new IOException();
            iOException.initCause(signatureException);
            throw iOException;
        }
        catch (PGPException pGPException) {
            IOException iOException = new IOException();
            iOException.initCause(pGPException);
            throw iOException;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            IOException iOException = new IOException();
            iOException.initCause(noSuchAlgorithmException);
            throw iOException;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            IOException iOException = new IOException();
            iOException.initCause(noSuchProviderException);
            throw iOException;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream2 != null) {
                try {
                    inputStream2.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private PGPSecretKey readSecretKey(InputStream inputStream) throws IOException, PGPException {
        inputStream = PGPUtil.getDecoderStream((InputStream)inputStream);
        PGPSecretKeyRingCollection pGPSecretKeyRingCollection = new PGPSecretKeyRingCollection(inputStream);
        PGPSecretKey pGPSecretKey = null;
        Iterator iterator = pGPSecretKeyRingCollection.getKeyRings();
        while (pGPSecretKey == null && iterator.hasNext()) {
            PGPSecretKeyRing pGPSecretKeyRing = (PGPSecretKeyRing)iterator.next();
            Iterator iterator2 = pGPSecretKeyRing.getSecretKeys();
            while (pGPSecretKey == null && iterator2.hasNext()) {
                PGPSecretKey pGPSecretKey2 = (PGPSecretKey)iterator2.next();
                if (this.keyId == null && pGPSecretKey2.isSigningKey()) {
                    pGPSecretKey = pGPSecretKey2;
                }
                if (this.keyId == null || Long.valueOf(this.keyId, 16) != (pGPSecretKey2.getKeyID() & 0xFFFFFFFFL)) continue;
                pGPSecretKey = pGPSecretKey2;
            }
        }
        if (pGPSecretKey == null) {
            throw new IllegalArgumentException("Can't find encryption key" + (this.keyId != null ? " '" + this.keyId + "' " : " ") + "in key ring.");
        }
        return pGPSecretKey;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

