/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkFiltersParallelGeometryObjectFactory.h

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/

#ifndef vtkFiltersParallelGeometryObjectFactory_h
#define vtkFiltersParallelGeometryObjectFactory_h

#include "vtkFiltersParallelGeometryModule.h" // For export macro
#include "vtkObjectFactory.h"

class VTKFILTERSPARALLELGEOMETRY_EXPORT vtkFiltersParallelGeometryObjectFactory : public vtkObjectFactory
{
public:
  static vtkFiltersParallelGeometryObjectFactory * New();
  vtkTypeMacro(vtkFiltersParallelGeometryObjectFactory, vtkObjectFactory)

  const char * GetDescription() override { return "vtkFiltersParallelGeometry factory overrides."; }

  const char * GetVTKSourceVersion() override;

  void PrintSelf(ostream &os, vtkIndent indent) override;

protected:
  vtkFiltersParallelGeometryObjectFactory();

private:
  vtkFiltersParallelGeometryObjectFactory(const vtkFiltersParallelGeometryObjectFactory&) = delete;
  void operator=(const vtkFiltersParallelGeometryObjectFactory&) = delete;
};

#endif // vtkFiltersParallelGeometryObjectFactory_h
