/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common.icon;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Map;
import org.pushingpixels.flamingo.api.common.AsynchronousLoadListener;
import org.pushingpixels.flamingo.api.common.AsynchronousLoading;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;

public class IconDeckResizableIcon<T>
implements ResizableIcon,
AsynchronousLoading {
    private ResizableIcon currentIcon;
    private final Map<T, ? extends ResizableIcon> iconDeck;

    public IconDeckResizableIcon(Map<T, ? extends ResizableIcon> iconDeck) {
        if (iconDeck.isEmpty()) {
            throw new IllegalArgumentException("Icon deck is empty; must have at least one icon");
        }
        this.iconDeck = iconDeck;
        this.currentIcon = iconDeck.values().iterator().next();
    }

    public void setIcon(T key) {
        this.currentIcon = this.iconDeck.get(key);
    }

    @Override
    public void setDimension(Dimension dim) {
        for (ResizableIcon resizableIcon : this.iconDeck.values()) {
            int currH = resizableIcon.getIconHeight();
            int currW = resizableIcon.getIconWidth();
            if (currH == dim.height && currW == dim.width) continue;
            resizableIcon.setDimension(dim);
        }
    }

    @Override
    public int getIconHeight() {
        return this.currentIcon.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        return this.currentIcon.getIconWidth();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.currentIcon.paintIcon(c, g, x, y);
    }

    @Override
    public void addAsynchronousLoadListener(AsynchronousLoadListener l) {
        for (ResizableIcon resizableIcon : this.iconDeck.values()) {
            if (!(resizableIcon instanceof AsynchronousLoading)) continue;
            ((AsynchronousLoading)((Object)resizableIcon)).addAsynchronousLoadListener(l);
        }
    }

    @Override
    public boolean isLoading() {
        for (ResizableIcon resizableIcon : this.iconDeck.values()) {
            if (!(resizableIcon instanceof AsynchronousLoading) || !((AsynchronousLoading)((Object)resizableIcon)).isLoading()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeAsynchronousLoadListener(AsynchronousLoadListener l) {
        for (ResizableIcon resizableIcon : this.iconDeck.values()) {
            if (!(resizableIcon instanceof AsynchronousLoading)) continue;
            ((AsynchronousLoading)((Object)resizableIcon)).removeAsynchronousLoadListener(l);
        }
    }
}

