/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtilRt;
import org.jetbrains.kotlin.com.intellij.util.io.DirectBufferWrapper;

public class ReadWriteDirectBufferWrapper
extends DirectBufferWrapper {
    protected ReadWriteDirectBufferWrapper(File file2, long offset2, long length) {
        super(file2, offset2, length);
        assert (length <= Integer.MAX_VALUE) : length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ByteBuffer create() throws IOException {
        FileContext fileContext = new FileContext(this.myFile);
        try {
            FileChannel channel = fileContext.myFile.getChannel();
            channel.position(this.myPosition);
            ByteBuffer buffer = ByteBuffer.allocateDirect((int)this.myLength);
            channel.read(buffer);
            ByteBuffer byteBuffer = buffer;
            return byteBuffer;
        }
        finally {
            fileContext.dispose();
        }
    }

    public <T extends Disposable> T flushWithContext(@Nullable T context) {
        ByteBuffer buffer = this.getCachedBuffer();
        if (buffer == null || !this.isDirty()) {
            return context;
        }
        return this.doFlush((FileContext)context, buffer);
    }

    private <T extends Disposable> T doFlush(@Nullable FileContext fileContext, ByteBuffer buffer) {
        try {
            if (fileContext == null) {
                fileContext = new FileContext(this.myFile);
            }
            FileChannel channel = fileContext.myFile.getChannel();
            channel.position(this.myPosition);
            buffer.rewind();
            channel.write(buffer);
            this.myDirty = false;
        }
        catch (IOException e) {
            LOG.error(e);
        }
        return (T)fileContext;
    }

    @Override
    public void flush() {
        ByteBuffer buffer = this.getCachedBuffer();
        if (buffer == null || !this.isDirty()) {
            return;
        }
        Object disposable = this.doFlush(null, buffer);
        if (disposable != null) {
            Disposer.dispose(disposable);
        }
    }

    static class FileContext
    implements Disposable {
        final RandomAccessFile myFile;

        FileContext(final File file2) throws IOException {
            this.myFile = FileUtilRt.doIOOperation(new FileUtilRt.RepeatableIOOperation<RandomAccessFile, IOException>(){
                boolean parentWasCreated;

                @Override
                @Nullable
                public RandomAccessFile execute(boolean finalAttempt) throws IOException {
                    try {
                        return new RandomAccessFile(file2, "rw");
                    }
                    catch (FileNotFoundException ex) {
                        File parentFile = file2.getParentFile();
                        if (!parentFile.exists()) {
                            if (!this.parentWasCreated) {
                                parentFile.mkdirs();
                                this.parentWasCreated = true;
                            } else {
                                throw new IOException("Parent file still doesn't exist:" + file2);
                            }
                        }
                        if (!finalAttempt) {
                            return null;
                        }
                        throw ex;
                    }
                }
            });
        }

        @Override
        public void dispose() {
            try {
                if (this.myFile != null) {
                    this.myFile.close();
                }
            }
            catch (IOException ex) {
                DirectBufferWrapper.LOG.error(ex);
            }
        }
    }
}

