/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.sourceMap;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.inline.util.RelativePathCalculator;

public class SourceFilePathResolver {
    @NotNull
    private final Set<File> sourceRoots;
    @Nullable
    private final RelativePathCalculator outputDirPathResolver;
    @NotNull
    private final Map<File, String> cache = new HashMap<File, String>();

    public SourceFilePathResolver(@NotNull List<File> sourceRoots) {
        this(sourceRoots, null);
    }

    public SourceFilePathResolver(@NotNull List<File> sourceRoots, @Nullable File outputDir2) {
        this.sourceRoots = new HashSet<File>();
        for (File sourceRoot : sourceRoots) {
            this.sourceRoots.add(sourceRoot.getAbsoluteFile());
        }
        this.outputDirPathResolver = outputDir2 != null ? new RelativePathCalculator(outputDir2) : null;
    }

    @NotNull
    public String getPathRelativeToSourceRoots(@NotNull File file2) throws IOException {
        String path2 = this.cache.get(file2);
        if (path2 == null) {
            path2 = this.calculatePathRelativeToSourceRoots(file2);
            this.cache.put(file2, path2);
        }
        return path2;
    }

    @NotNull
    private String calculatePathRelativeToSourceRoots(@NotNull File file2) throws IOException {
        String pathRelativeToOutput = this.calculatePathRelativeToOutput(file2);
        if (pathRelativeToOutput != null) {
            return pathRelativeToOutput;
        }
        ArrayList<String> parts = new ArrayList<String>();
        for (File currentFile = file2.getCanonicalFile(); currentFile != null; currentFile = currentFile.getParentFile()) {
            if (this.sourceRoots.contains(currentFile)) {
                if (parts.isEmpty()) break;
                Collections.reverse(parts);
                return StringUtil.join(parts, File.separator);
            }
            parts.add(currentFile.getName());
        }
        return file2.getName();
    }

    @Nullable
    private String calculatePathRelativeToOutput(@NotNull File file2) {
        return this.outputDirPathResolver != null ? this.outputDirPathResolver.calculateRelativePathTo(file2) : null;
    }

    @NotNull
    public static SourceFilePathResolver create(@NotNull JsConfig config) {
        List<File> sourceRoots = config.getSourceMapRoots().stream().map(File::new).collect(Collectors.toList());
        File outputDir2 = null;
        if (config.shouldGenerateRelativePathsInSourceMap()) {
            outputDir2 = config.getConfiguration().get(JSConfigurationKeys.OUTPUT_DIR);
        }
        return new SourceFilePathResolver(sourceRoots, outputDir2);
    }
}

