/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testkit.runner.internal;

import java.util.List;
import javax.annotation.Nullable;
import org.gradle.testkit.runner.BuildResult;
import org.gradle.testkit.runner.BuildTask;
import org.gradle.testkit.runner.TaskOutcome;
import org.gradle.testkit.runner.internal.BuildOperationParameters;
import org.gradle.testkit.runner.internal.DefaultBuildResult;
import org.gradle.testkit.runner.internal.feature.BuildResultOutputFeatureCheck;
import org.gradle.testkit.runner.internal.feature.FeatureCheck;

public class FeatureCheckBuildResult
implements BuildResult {
    private final BuildResult delegateBuildResult;
    private final FeatureCheck outputFeatureCheck;

    public FeatureCheckBuildResult(BuildOperationParameters buildOperationParameters, String output, List<BuildTask> tasks) {
        this.delegateBuildResult = new DefaultBuildResult(output, tasks);
        this.outputFeatureCheck = new BuildResultOutputFeatureCheck(buildOperationParameters.getTargetGradleVersion(), buildOperationParameters.isEmbedded());
    }

    @Override
    public String getOutput() {
        this.outputFeatureCheck.verify();
        return this.delegateBuildResult.getOutput();
    }

    @Override
    public List<BuildTask> getTasks() {
        return this.delegateBuildResult.getTasks();
    }

    @Override
    public List<BuildTask> tasks(TaskOutcome outcome) {
        return this.delegateBuildResult.tasks(outcome);
    }

    @Override
    public List<String> taskPaths(TaskOutcome outcome) {
        return this.delegateBuildResult.taskPaths(outcome);
    }

    @Override
    @Nullable
    public BuildTask task(String taskPath) {
        return this.delegateBuildResult.task(taskPath);
    }
}

