/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.molxyz;

import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;

public class XyzReader
extends AtomSetCollectionReader {
    @Override
    protected boolean checkLine() throws Exception {
        int n = this.parseIntStr(this.line);
        if (n == Integer.MIN_VALUE) {
            this.continuing = false;
            return false;
        }
        this.vibrationNumber = ++this.modelNumber;
        if (this.desiredVibrationNumber <= 0 ? this.doGetModel(this.modelNumber, null) : this.doGetVibration(this.vibrationNumber)) {
            this.rd();
            this.checkCurrentLineForScript();
            this.asc.newAtomSet();
            String string = this.line.trim();
            this.readAtoms(n);
            this.applySymmetryAndSetTrajectory();
            this.asc.setAtomSetName(string);
            if (this.isLastModel(this.modelNumber)) {
                this.continuing = false;
                return false;
            }
        } else {
            this.skipAtomSet(n);
        }
        this.discardLinesUntilNonBlank();
        return false;
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        this.isTrajectory = false;
        this.finalizeReaderASCR();
    }

    private void skipAtomSet(int n) throws Exception {
        this.rd();
        int n2 = n;
        while (--n2 >= 0) {
            this.rd();
        }
    }

    private void readAtoms(int n) throws Exception {
        int n2 = 0;
        while (n2 < n) {
            this.rd();
            String[] stringArray = this.getTokens();
            if (stringArray.length < 4) {
                Logger.warn("line cannot be read for XYZ atom data: " + this.line);
            } else {
                Atom atom = this.addAtomXYZSymName(stringArray, 1, null, null);
                this.setElementAndIsotope(atom, stringArray[0]);
                int n3 = 4;
                block0 : switch (stringArray.length) {
                    case 4: {
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: {
                        if (stringArray[4].indexOf(".") >= 0) {
                            atom.partialCharge = this.parseFloatStr(stringArray[4]);
                        } else {
                            int n4 = this.parseIntStr(stringArray[4]);
                            if (n4 != Integer.MIN_VALUE) {
                                atom.formalCharge = n4;
                            }
                        }
                        switch (stringArray.length) {
                            case 5: {
                                break block0;
                            }
                            case 6: {
                                atom.radius = this.parseFloatStr(stringArray[5]);
                                break block0;
                            }
                            case 9: {
                                atom.atomSerial = this.parseIntStr(stringArray[8]);
                            }
                        }
                    }
                    default: {
                        int n5 = ++n3;
                        float f = this.parseFloatStr(stringArray[n5]);
                        int n6 = ++n3;
                        float f2 = this.parseFloatStr(stringArray[n6]);
                        int n7 = ++n3;
                        ++n3;
                        float f3 = this.parseFloatStr(stringArray[n7]);
                        if (Float.isNaN(f) || Float.isNaN(f2) || Float.isNaN(f3)) break;
                        this.asc.addVibrationVector(atom.index, f, f2, f3);
                    }
                }
            }
            ++n2;
        }
    }
}

