/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import java.io.BufferedInputStream;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.Rdr;
import javajs.util.SB;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jmol.adapter.readers.xml.XmlHandler;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.Resolver;
import org.jmol.api.Interface;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;
import org.xml.sax.XMLReader;

public class XmlReader
extends AtomSetCollectionReader {
    protected Atom atom;
    protected Bond bond;
    protected XmlReader parent;
    public Map<String, String> atts;
    protected boolean keepChars;
    protected SB chars = SB.newN(2000);
    private Object[] domObj = new Object[1];
    private Object[] attribs;
    private Object[] attArgs;
    private Object[] nullObj = new Object[0];

    @Override
    public void initializeReader() throws Exception {
        this.initCML();
    }

    protected void initCML() {
        this.atts = new Hashtable<String, String>();
        this.setMyError(this.parseXML());
        this.continuing = false;
    }

    private void setMyError(String string) {
        if (string != null && (this.asc == null || this.asc.errorMessage == null)) {
            this.asc = new AtomSetCollection("xml", this, null, null);
            this.asc.errorMessage = string;
        }
    }

    private String parseXML() {
        XMLReader xMLReader;
        block4: {
            xMLReader = null;
            try {
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                sAXParserFactory.setNamespaceAware(true);
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                xMLReader = sAXParser.getXMLReader();
                if (this.debugging) {
                    Logger.debug("Using JAXP/SAX XML parser.");
                }
            }
            catch (Exception exception) {
                if (!this.debugging) break block4;
                Viewer cfr_ignored_0 = (this.parent == null ? this : this.parent).vwr;
                Logger.debug("Could not instantiate JAXP/SAX XML reader: " + (Viewer.isJS ? exception : exception.getMessage()));
            }
        }
        if (xMLReader == null) {
            return "No XML reader found";
        }
        return this.selectReaderAndGo(xMLReader);
    }

    private String selectReaderAndGo(Object object) {
        this.asc = new AtomSetCollection(this.readerName, this, null, null);
        String string = null;
        XmlReader xmlReader = null;
        int n = this.readerName.indexOf("(");
        String string2 = n < 0 ? this.readerName : this.readerName.substring(0, n);
        string = Resolver.getReaderClassBase(string2);
        xmlReader = (XmlReader)this.getInterface(string);
        if (xmlReader == null) {
            return "File reader was not found: " + string;
        }
        try {
            xmlReader.processXml(this, object);
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder("Error reading XML: ");
            if (this.parent != null) {
                Viewer cfr_ignored_0 = this.parent.vwr;
            }
            return stringBuilder.append(Viewer.isJS ? exception : exception.getMessage()).toString();
        }
        return null;
    }

    protected void processXml(XmlReader xmlReader, Object object) throws Exception {
        this.processXml2(xmlReader, object);
    }

    protected void processXml2(XmlReader xmlReader, Object object) throws Exception {
        this.parent = xmlReader;
        this.asc = xmlReader.asc;
        this.reader = xmlReader.reader;
        this.atts = xmlReader.atts;
        if (object == null) {
            this.attribs = new Object[1];
            this.attArgs = new Object[1];
            this.domObj = new Object[1];
            String string = "";
            byte[] byArray = null;
            if (string instanceof BufferedInputStream) {
                string = Rdr.streamToUTF8String(Rdr.getBIS(byArray));
            }
            boolean bl = false;
            this.walkDOMTree();
            if (bl) {
                this.domObj[0] = this.createDomNodeJS("xmlReader", string);
                this.walkDOMTree();
                this.createDomNodeJS("xmlReader", null);
            }
        } else {
            ((XmlHandler)Interface.getOption("adapter.readers.xml.XmlHandler", this.vwr, "file")).parseXML(this, object, this.reader);
        }
    }

    Object createDomNodeJS(String string, Object object) {
        Object object2 = this.parent.vwr.html5Applet;
        Object var4_4 = null;
        return var4_4;
    }

    @Override
    public void applySymmetryAndSetTrajectory() {
        try {
            if (this.parent == null) {
                this.applySymTrajASCR();
            } else {
                this.parent.applySymmetryAndSetTrajectory();
            }
        }
        catch (Exception exception) {
            Viewer cfr_ignored_0 = (this.parent == null ? this : this.parent).vwr;
            System.out.println(Viewer.isJS ? exception : exception.getMessage());
            Logger.error("applySymmetry failed: " + exception);
        }
    }

    @Override
    protected void processDOM(Object object) {
        this.domObj = new Object[]{object};
        this.setMyError(this.selectReaderAndGo(null));
    }

    protected void processStartElement(String string, String string2) {
    }

    protected void setKeepChars(boolean bl) {
        this.keepChars = bl;
        this.chars.setLength(0);
    }

    void processEndElement(String string) {
    }

    private void walkDOMTree() {
        String string = "localName";
        String string2 = (String)this.jsObjectGetMember(this.domObj, string);
        if ((string = this.fixLocal(string2)) == null) {
            return;
        }
        if (string.equals("#text")) {
            if (this.keepChars) {
                this.chars.append((String)this.jsObjectGetMember(this.domObj, "data"));
            }
            return;
        }
        string = string.toLowerCase();
        string2 = string2.toLowerCase();
        this.attribs[0] = this.jsObjectGetMember(this.domObj, "attributes");
        this.getDOMAttributesA(this.attribs);
        this.processStartElement(string, string2);
        boolean bl = (Boolean)this.jsObjectCall(this.domObj, "hasChildNodes", null);
        if (bl) {
            Object object = this.jsObjectGetMember(this.domObj, "firstChild");
            while (object != null) {
                this.domObj[0] = object;
                this.walkDOMTree();
                this.domObj[0] = object;
                object = this.jsObjectGetMember(this.domObj, "nextSibling");
            }
        }
        this.processEndElement(string);
    }

    private String fixLocal(String string) {
        return string;
    }

    private void getDOMAttributesA(Object[] objectArray) {
        int n;
        this.atts.clear();
        if (objectArray == null) {
            return;
        }
        Object var2_2 = null;
        Number number = (Number)this.jsObjectGetMember(objectArray, "length");
        int n2 = n = number == null ? 0 : number.intValue();
        while (--n2 >= 0) {
            String string;
            this.attArgs[0] = n2;
            this.attArgs[0] = this.jsObjectCall(objectArray, "item", this.attArgs);
            if (this.attArgs[0] == null || (string = (String)this.jsObjectGetMember(this.attArgs, "value")) == null) continue;
            this.atts.put(((String)this.jsObjectGetMember(this.attArgs, "name")).toLowerCase(), string);
        }
    }

    private Object jsObjectCall(Object[] objectArray, String string, Object[] objectArray2) {
        return this.parent.vwr.apiPlatform.getJsObjectInfo(objectArray, string, objectArray2 == null ? this.nullObj : objectArray2);
    }

    private Object jsObjectGetMember(Object[] objectArray, String string) {
        return this.parent.vwr.apiPlatform.getJsObjectInfo(objectArray, string, null);
    }

    public void endDocument() {
    }

    private class NVPair {
        String name;
        String value;

        private NVPair() {
        }
    }
}

