/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javajs.util.AU;
import javajs.util.BS;
import org.jmol.c.PAL;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.modelsetbio.BioModel;
import org.jmol.util.C;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Elements;
import org.jmol.util.GData;
import org.jmol.util.Logger;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

public class ColorManager {
    public ColorEncoder ce;
    private Viewer vwr;
    private GData g3d;
    private int[] argbsCpk;
    private int[] altArgbsCpk;
    private float[] colorData;
    boolean isDefaultColorRasmol;
    public short colixRubberband = (short)22;
    public short colixBackgroundContrast;

    ColorManager(Viewer viewer, GData gData) {
        this.vwr = viewer;
        this.ce = new ColorEncoder(null, viewer);
        this.g3d = gData;
        this.argbsCpk = PAL.argbsCpk;
        this.altArgbsCpk = AU.arrayCopyRangeI(JC.altArgbsCpk, 0, -1);
    }

    void setDefaultColors(boolean bl) {
        if (bl) {
            this.isDefaultColorRasmol = true;
            this.argbsCpk = AU.arrayCopyI(ColorEncoder.getRasmolScale(), -1);
        } else {
            this.isDefaultColorRasmol = false;
            this.argbsCpk = PAL.argbsCpk;
        }
        this.altArgbsCpk = AU.arrayCopyRangeI(JC.altArgbsCpk, 0, -1);
        this.ce.createColorScheme(bl ? "Rasmol=" : "Jmol=", true, true);
        int n = PAL.argbsCpk.length;
        while (--n >= 0) {
            this.g3d.changeColixArgb(n, this.argbsCpk[n]);
        }
        n = JC.altArgbsCpk.length;
        while (--n >= 0) {
            this.g3d.changeColixArgb(Elements.elementNumberMax + n, this.altArgbsCpk[n]);
        }
    }

    public void setRubberbandArgb(int n) {
        this.colixRubberband = n == 0 ? (short)0 : C.getColix(n);
    }

    void setColixBackgroundContrast(int n) {
        this.colixBackgroundContrast = C.getBgContrast(n);
    }

    public short getColixBondPalette(Bond bond, int n) {
        int n2 = 0;
        switch (n) {
            case 19: {
                return this.ce.getColorIndexFromPalette(bond.getEnergy(), -2.5f, -0.5f, 7, false);
            }
        }
        return n2 == 0 ? (short)10 : (short)C.getColix(n2);
    }

    public short getColixAtomPalette(Atom atom, byte by) {
        int n = 0;
        ModelSet modelSet = this.vwr.ms;
        switch (by) {
            case 84: {
                return this.colorData == null || atom.i >= this.colorData.length || Float.isNaN(this.colorData[atom.i]) ? (short)12 : this.ce.getColorIndex(this.colorData[atom.i]);
            }
            case 0: 
            case 1: {
                int n2 = atom.getAtomicAndIsotopeNumber();
                if (n2 < Elements.elementNumberMax) {
                    return this.g3d.getChangeableColix(n2, this.argbsCpk[n2]);
                }
                int n3 = n2;
                if ((n2 = Elements.altElementIndexFromNumber(n2)) > 0) {
                    return this.g3d.getChangeableColix(Elements.elementNumberMax + n2, this.altArgbsCpk[n2]);
                }
                n2 = Elements.getElementNumber(n3);
                return this.g3d.getChangeableColix(n2, this.argbsCpk[n2]);
            }
            case 2: {
                int n4 = ColorEncoder.quantize4(atom.getPartialCharge(), -1.0f, 1.0f, JC.PARTIAL_CHARGE_RANGE_SIZE);
                return this.g3d.getChangeableColix(JC.PARTIAL_CHARGE_COLIX_RED + n4, JC.argbsRwbScale[n4]);
            }
            case 3: {
                int n5 = atom.getFormalCharge() - -4;
                return this.g3d.getChangeableColix(JC.FORMAL_CHARGE_COLIX_RED + n5, JC.argbsFormalCharge[n5]);
            }
            case 5: 
            case 68: {
                float f;
                float f2;
                if (by == 68) {
                    f2 = this.vwr.ms.getBfactor100Lo();
                    f = this.vwr.ms.getBfactor100Hi();
                } else {
                    f2 = 0.0f;
                    f = 10000.0f;
                }
                return this.ce.getColorIndexFromPalette(atom.getBfactor100(), f2, f, 7, false);
            }
            case 86: {
                return this.ce.getColorIndexFromPalette(atom.group.getGroupParameter(1111490574), -1.0f, 1.0f, 7, false);
            }
            case 70: {
                float f = this.vwr.ms.getSurfaceDistanceMax();
                return this.ce.getColorIndexFromPalette(atom.getSurfaceDistance100(), 0.0f, f, 7, false);
            }
            case 24: {
                int n6 = atom.group.groupID;
                if (n6 >= 42) {
                    n6 = 24 + "PGCATU".indexOf(Character.toUpperCase(atom.group.group1)) - 1;
                }
                return this.ce.getColorIndexFromPalette(n6, 0.0f, 0.0f, 17, false);
            }
            case 8: {
                return this.ce.getColorIndexFromPalette(atom.group.groupID, 0.0f, 0.0f, 5, false);
            }
            case 9: {
                return this.ce.getColorIndexFromPalette(atom.group.groupID, 0.0f, 0.0f, 4, false);
            }
            case 75: {
                return this.ce.getColorIndexFromPalette(atom.group.selectedIndex, 0.0f, atom.group.chain.selectedGroupCount - 1, 1, false);
            }
            case 87: {
                Model model = this.vwr.ms.am[atom.mi];
                return this.ce.getColorIndexFromPalette(atom.group.getBioPolymerIndexInModel(), 0.0f, (model.isBioModel ? ((BioModel)model).getBioPolymerCount() : 0) - 1, 1, false);
            }
            case 76: {
                return this.ce.getColorIndexFromPalette(atom.group.getSelectedMonomerIndex(), 0.0f, atom.group.getSelectedMonomerCount() - 1, 1, false);
            }
            case 77: {
                return this.ce.getColorIndexFromPalette(modelSet.getMoleculeIndex(atom.i, true), 0.0f, modelSet.getMoleculeCountInModel(atom.mi) - 1, 0, false);
            }
            case 14: {
                short s = atom.mi;
                return this.ce.getColorIndexFromPalette(modelSet.getAltLocIndexInModel(s, atom.altloc), 0.0f, modelSet.getAltLocCountInModel(s), 0, false);
            }
            case 15: {
                short s = atom.mi;
                return this.ce.getColorIndexFromPalette(modelSet.getInsertionCodeIndexInModel(s, atom.group.getInsertionCode()), 0.0f, modelSet.getInsertionCountInModel(s), 0, false);
            }
            case 16: {
                int n7 = atom.getAtomicAndIsotopeNumber();
                n = this.getJmolOrRasmolArgb(n7, 1073741991);
                break;
            }
            case 17: {
                int n8 = atom.getAtomicAndIsotopeNumber();
                n = this.getJmolOrRasmolArgb(n8, 1073742116);
                break;
            }
            case 7: {
                n = atom.group.getProteinStructureSubType().getColor();
                break;
            }
            case 10: {
                int n9 = atom.getChainID();
                if (ColorEncoder.argbsChainAtom == null) {
                    ColorEncoder.argbsChainAtom = this.getArgbs(0x44000001);
                    ColorEncoder.argbsChainHetero = this.getArgbs(0x60200006);
                }
                n9 = ((n9 < 0 ? 0 : (n9 >= 256 ? n9 - 256 : n9)) & 0x1F) % ColorEncoder.argbsChainAtom.length;
                n = (atom.isHetero() ? ColorEncoder.argbsChainHetero : ColorEncoder.argbsChainAtom)[n9];
            }
        }
        return n == 0 ? (short)22 : (short)C.getColix(n);
    }

    private int[] getArgbs(int n) {
        return this.vwr.getJBR().getArgbs(n);
    }

    private int getJmolOrRasmolArgb(int n, int n2) {
        switch (n2) {
            case 1073741991: {
                if (n >= Elements.elementNumberMax) break;
                return this.ce.getArgbFromPalette(n, 0.0f, 0.0f, 2);
            }
            case 1073742116: {
                if (n >= Elements.elementNumberMax) break;
                return this.ce.getArgbFromPalette(n, 0.0f, 0.0f, 3);
            }
            default: {
                return n2;
            }
        }
        return JC.altArgbsCpk[Elements.altElementIndexFromNumber(n)];
    }

    public short setElementArgb(int n, int n2) {
        if (n2 == 1073741991 && this.argbsCpk == PAL.argbsCpk) {
            return 0;
        }
        n2 = this.getJmolOrRasmolArgb(n, n2);
        if (this.argbsCpk == PAL.argbsCpk) {
            this.argbsCpk = AU.arrayCopyRangeI(PAL.argbsCpk, 0, -1);
            this.altArgbsCpk = AU.arrayCopyRangeI(JC.altArgbsCpk, 0, -1);
        }
        if (n < Elements.elementNumberMax) {
            if (n2 == Integer.MAX_VALUE) {
                return C.getColix(this.argbsCpk[n]);
            }
            this.argbsCpk[n] = n2;
            this.g3d.changeColixArgb(n, n2);
            return 0;
        }
        n = Elements.altElementIndexFromNumber(n);
        this.altArgbsCpk[n] = n2;
        this.g3d.changeColixArgb(Elements.elementNumberMax + n, n2);
        return 0;
    }

    float[] getPropertyColorRange() {
        float[] fArray;
        if (this.ce.isReversed) {
            float[] fArray2 = new float[2];
            fArray2[0] = this.ce.hi;
            fArray = fArray2;
            fArray2[1] = this.ce.lo;
        } else {
            float[] fArray3 = new float[2];
            fArray3[0] = this.ce.lo;
            fArray = fArray3;
            fArray3[1] = this.ce.hi;
        }
        return fArray;
    }

    public void setPropertyColorRangeData(float[] fArray, BS bS) {
        int n;
        this.colorData = fArray;
        this.ce.currentPalette = this.ce.createColorScheme(this.vwr.g.propertyColorScheme, true, false);
        this.ce.hi = -3.4028235E38f;
        this.ce.lo = Float.MAX_VALUE;
        if (fArray == null) {
            return;
        }
        boolean bl = bS == null;
        int n2 = n = bl ? fArray.length - 1 : bS.nextSetBit(0);
        while (n2 >= 0) {
            float f = fArray[n2];
            if (!Float.isNaN(f)) {
                this.ce.hi = Math.max(this.ce.hi, f);
                this.ce.lo = Math.min(this.ce.lo, f);
            }
            int n3 = n2 = bl ? n2 - 1 : bS.nextSetBit(n2 + 1);
        }
        this.setPropertyColorRange(this.ce.lo, this.ce.hi);
    }

    public void setPropertyColorRange(float f, float f2) {
        this.ce.setRange(f, f2, f > f2);
        if (Logger.debugging) {
            Logger.debug("ColorManager: color \"" + this.ce.getCurrentColorSchemeName() + "\" range " + f + " " + f2);
        }
    }

    void setPropertyColorScheme(String string, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = string.length() == 0;
        if (bl3) {
            string = "=";
        }
        float[] fArray = this.getPropertyColorRange();
        this.ce.currentPalette = this.ce.createColorScheme(string, true, bl2);
        if (!bl3) {
            this.setPropertyColorRange(fArray[0], fArray[1]);
        }
        this.ce.isTranslucent = bl;
    }

    public String getColorSchemeList(String string) {
        int n = string == null || string.length() == 0 ? this.ce.currentPalette : this.ce.createColorScheme(string, true, false);
        return ColorEncoder.getColorSchemeList(this.ce.getColorSchemeArray(n));
    }

    public ColorEncoder getColorEncoder(String string) {
        if (string == null || string.length() == 0) {
            return this.ce;
        }
        ColorEncoder colorEncoder = new ColorEncoder(this.ce, this.vwr);
        colorEncoder.currentPalette = colorEncoder.createColorScheme(string, false, true);
        return colorEncoder.currentPalette == Integer.MAX_VALUE ? null : colorEncoder;
    }
}

