/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.resources;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.osmand.AndroidUtils;
import net.osmand.GeoidAltitudeCorrection;
import net.osmand.IProgress;
import net.osmand.Location;
import net.osmand.PlatformUtil;
import net.osmand.ResultMatcher;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.CachedOsmandIndexes;
import net.osmand.data.Amenity;
import net.osmand.data.TransportStop;
import net.osmand.osm.PoiCategory;
import net.osmand.plus.render.MapRenderRepositories;
import net.osmand.plus.resources.AmenityIndexRepository;
import net.osmand.plus.resources.AmenityIndexRepositoryBinary;
import net.osmand.plus.resources.IncrementalChangesManager;
import net.osmand.plus.resources.RegionAddressRepository;
import net.osmand.plus.resources.RegionAddressRepositoryBinary;
import net.osmand.plus.resources.TransportIndexRepository;
import net.osmand.plus.resources.TransportIndexRepositoryBinary;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import net.sourceforge.offroad.OsmWindow;
import org.apache.commons.logging.Log;

public class ResourceManager {
    public static final String VECTOR_MAP = "#vector_map";
    private static final String INDEXES_CACHE = "ind.cache";
    private static final Log log = PlatformUtil.getLog(ResourceManager.class);
    protected static ResourceManager manager = null;
    protected int maxImgCacheSize = 28;
    protected Map<String, BufferedImage> cacheOfImages = new LinkedHashMap<String, BufferedImage>();
    protected Map<String, Boolean> imagesOnFS = new LinkedHashMap<String, Boolean>();
    protected File dirWithTiles;
    private final Map<String, RegionAddressRepository> addressMap = new ConcurrentHashMap<String, RegionAddressRepository>();
    protected final Map<String, AmenityIndexRepository> amenityRepositories = new ConcurrentHashMap<String, AmenityIndexRepository>();
    protected final Map<String, String> indexFileNames = new ConcurrentHashMap<String, String>();
    protected final Map<String, String> basemapFileNames = new ConcurrentHashMap<String, String>();
    protected final Map<String, BinaryMapIndexReader> routingMapFiles = new ConcurrentHashMap<String, BinaryMapIndexReader>();
    protected final Map<String, TransportIndexRepository> transportRepositories = new ConcurrentHashMap<String, TransportIndexRepository>();
    protected final IncrementalChangesManager changesManager = new IncrementalChangesManager(this);
    protected final MapRenderRepositories renderer;
    protected boolean internetIsNotAccessible = false;
    private DateFormat dateFormat;
    private OsmWindow context;
    protected StringBuilder builder = new StringBuilder(40);
    protected char[] tileId = new char[120];
    private GeoidAltitudeCorrection geoidAltitudeCorrection;
    private boolean searchAmenitiesInProgress;

    public ResourceManager(OsmWindow pContext) {
        this.context = pContext;
        this.renderer = new MapRenderRepositories(pContext.getSettings());
        this.dateFormat = DateFormat.getDateInstance();
        this.resetStoreDirectory();
    }

    public void resetStoreDirectory() {
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public List<String> reloadIndexesOnStart(IProgress progress, List<String> warnings) {
        this.close();
        this.reloadIndexes(progress, warnings);
        return warnings;
    }

    public List<String> reloadIndexes(IProgress progress, List<String> warnings) {
        this.geoidAltitudeCorrection = new GeoidAltitudeCorrection(this.context.getAppPath("geoid"));
        warnings.addAll(this.indexingMaps(progress));
        warnings.addAll(this.indexVoiceFiles(progress));
        warnings.addAll(this.indexAdditionalMaps(progress));
        return warnings;
    }

    public List<String> indexAdditionalMaps(IProgress progress) {
        return Collections.EMPTY_LIST;
    }

    public List<String> indexVoiceFiles(IProgress progress) {
        File[] lf;
        File file = this.context.getAppPath("voice");
        file.mkdirs();
        ArrayList<String> warnings = new ArrayList<String>();
        if (file.exists() && file.canRead() && (lf = file.listFiles()) != null) {
            for (File f : lf) {
                if (!f.isDirectory()) continue;
                File conf = new File(f, "_config.p");
                if (!conf.exists()) {
                    conf = new File(f, "_ttsconfig.p");
                }
                if (!conf.exists()) continue;
                this.indexFileNames.put(f.getName(), this.dateFormat.format(conf.lastModified()));
            }
        }
        return warnings;
    }

    private List<String> checkAssets(IProgress progress) {
        return Collections.emptyList();
    }

    private void copyRegionsBoundaries() {
        try {
            File file = this.context.getAppPath("regions.ocbf");
            if (file != null) {
                FileOutputStream fout = new FileOutputStream(file);
                Algorithms.streamCopy(this.context.getResource("regions.ocbf"), fout);
                fout.close();
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void copyPoiTypes() {
        try {
            File file = this.context.getAppPath("poi_types.xml");
            if (file != null) {
                FileOutputStream fout = new FileOutputStream(file);
                Algorithms.streamCopy(this.context.getResource("poi_types.xml"), fout);
                fout.close();
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private List<File> collectFiles(File dir, String ext, List<File> files) {
        if (dir.exists() && dir.canRead()) {
            File[] lf = dir.listFiles();
            if (lf == null || lf.length == 0) {
                return files;
            }
            for (File f : lf) {
                if (!f.getName().endsWith(ext)) continue;
                System.out.println("Found " + f.getName() + " on search for " + dir.getAbsolutePath());
                files.add(f);
            }
        }
        return files;
    }

    private void renameRoadsFiles(ArrayList<File> files, File roadsPath) {
        for (File f : files) {
            if (f.getName().endsWith("-roads.obf")) {
                f.renameTo(new File(roadsPath, f.getName().replace("-roads.obf", ".road.obf")));
                continue;
            }
            if (!f.getName().endsWith(".road.obf")) continue;
            f.renameTo(new File(roadsPath, f.getName()));
        }
    }

    public List<String> indexingMaps(IProgress progress) {
        long val = System.currentTimeMillis();
        ArrayList<File> files = new ArrayList<File>();
        File appPath = this.context.getAppPath(null);
        File roadsPath = this.context.getAppPath("roads/");
        roadsPath.mkdirs();
        this.collectFiles(appPath, ".obf", files);
        this.renameRoadsFiles(files, roadsPath);
        this.collectFiles(roadsPath, ".obf", files);
        this.collectFiles(this.context.getAppPath("wiki/"), ".obf", files);
        this.collectFiles(this.context.getAppPath("srtm/"), ".obf", files);
        this.changesManager.collectChangesFiles(this.context.getAppPath("live/"), ".obf", files);
        Collections.sort(files, Algorithms.getFileVersionComparator());
        ArrayList<String> warnings = new ArrayList<String>();
        this.renderer.clearAllResources();
        CachedOsmandIndexes cachedOsmandIndexes = new CachedOsmandIndexes();
        File indCache = this.context.getAppPath(INDEXES_CACHE);
        if (indCache.exists()) {
            try {
                cachedOsmandIndexes.readFromFile(indCache, 2);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        File liveDir = this.context.getAppPath("live/");
        for (File f : files) {
            try {
                long dateCreated;
                BinaryMapIndexReader mapReader = null;
                try {
                    mapReader = cachedOsmandIndexes.getReader(f);
                    if (mapReader.getVersion() != 2) {
                        mapReader = null;
                    }
                    if (mapReader != null) {
                        this.renderer.initializeNewResource(progress, f, mapReader);
                    }
                }
                catch (IOException e) {
                    log.error((Object)String.format("File %s could not be read", f.getName()), (Throwable)e);
                }
                if (mapReader == null) continue;
                if (mapReader.isBasemap()) {
                    this.basemapFileNames.put(f.getName(), f.getName());
                }
                if ((dateCreated = mapReader.getDateCreated()) == 0L) {
                    dateCreated = f.lastModified();
                }
                if (f.getParentFile().getName().equals(liveDir.getName())) {
                    boolean toUse = this.changesManager.index(f, dateCreated, mapReader);
                    if (!toUse) {
                        try {
                            mapReader.close();
                        }
                        catch (IOException e) {
                            log.error((Object)e.getMessage(), (Throwable)e);
                        }
                        continue;
                    }
                } else {
                    this.changesManager.indexMainMap(f, dateCreated);
                    this.indexFileNames.put(f.getName(), this.dateFormat.format(dateCreated));
                }
                if (!mapReader.getRegionNames().isEmpty()) {
                    try {
                        RandomAccessFile raf = new RandomAccessFile(f, "r");
                        RegionAddressRepositoryBinary rarb = new RegionAddressRepositoryBinary(this, new BinaryMapIndexReader(raf, mapReader), f.getName());
                        this.addressMap.put(f.getName(), rarb);
                    }
                    catch (IOException e) {
                        log.error((Object)("Exception reading " + f.getAbsolutePath()), (Throwable)e);
                    }
                }
                if (mapReader.hasTransportData()) {
                    try {
                        RandomAccessFile raf = new RandomAccessFile(f, "r");
                        this.transportRepositories.put(f.getName(), new TransportIndexRepositoryBinary(new BinaryMapIndexReader(raf, mapReader)));
                    }
                    catch (IOException e) {
                        log.error((Object)("Exception reading " + f.getAbsolutePath()), (Throwable)e);
                    }
                }
                if (mapReader.containsRouteData() && (!f.getParentFile().equals(liveDir) || this.context.getSettings().USE_OSM_LIVE_FOR_ROUTING.get().booleanValue())) {
                    try {
                        RandomAccessFile raf = new RandomAccessFile(f, "r");
                        this.routingMapFiles.put(f.getName(), new BinaryMapIndexReader(raf, mapReader));
                    }
                    catch (IOException e) {
                        log.error((Object)("Exception reading " + f.getAbsolutePath()), (Throwable)e);
                        warnings.add(MessageFormat.format(this.context.getString(556), f.getName()));
                    }
                }
                if (!mapReader.containsPoiData()) continue;
                try {
                    RandomAccessFile raf = new RandomAccessFile(f, "r");
                    this.amenityRepositories.put(f.getName(), new AmenityIndexRepositoryBinary(new BinaryMapIndexReader(raf, mapReader)));
                }
                catch (IOException e) {
                    log.error((Object)("Exception reading " + f.getAbsolutePath()), (Throwable)e);
                }
            }
            catch (OutOfMemoryError oome) {
                log.error((Object)("Exception reading " + f.getAbsolutePath()), (Throwable)oome);
            }
        }
        log.debug((Object)("All map files initialized " + (System.currentTimeMillis() - val) + " ms"));
        if (files.size() > 0 && (!indCache.exists() || indCache.canWrite())) {
            try {
                cachedOsmandIndexes.writeToFile(indCache);
            }
            catch (Exception e) {
                log.error((Object)"Index file could not be written", (Throwable)e);
            }
        }
        return warnings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Amenity> searchAmenities(BinaryMapIndexReader.SearchPoiTypeFilter filter, double topLatitude, double leftLongitude, double bottomLatitude, double rightLongitude, int zoom, ResultMatcher<Amenity> matcher) {
        ArrayList<Amenity> amenities = new ArrayList<Amenity>();
        this.searchAmenitiesInProgress = true;
        try {
            if (!filter.isEmpty()) {
                for (AmenityIndexRepository index : this.amenityRepositories.values()) {
                    List<Amenity> r;
                    if (!index.checkContains(topLatitude, leftLongitude, bottomLatitude, rightLongitude) || (r = index.searchAmenities(MapUtils.get31TileNumberY(topLatitude), MapUtils.get31TileNumberX(leftLongitude), MapUtils.get31TileNumberY(bottomLatitude), MapUtils.get31TileNumberX(rightLongitude), zoom, filter, matcher)) == null) continue;
                    amenities.addAll(r);
                }
            }
        }
        finally {
            this.searchAmenitiesInProgress = false;
        }
        return amenities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Amenity> searchAmenitiesOnThePath(List<Location> locations, double radius, BinaryMapIndexReader.SearchPoiTypeFilter filter, ResultMatcher<Amenity> matcher) {
        this.searchAmenitiesInProgress = true;
        ArrayList<Amenity> amenities = new ArrayList<Amenity>();
        try {
            if (locations != null && locations.size() > 0) {
                ArrayList<AmenityIndexRepository> repos = new ArrayList<AmenityIndexRepository>();
                double topLatitude = locations.get(0).getLatitude();
                double bottomLatitude = locations.get(0).getLatitude();
                double leftLongitude = locations.get(0).getLongitude();
                double rightLongitude = locations.get(0).getLongitude();
                for (Location l : locations) {
                    topLatitude = Math.max(topLatitude, l.getLatitude());
                    bottomLatitude = Math.min(bottomLatitude, l.getLatitude());
                    leftLongitude = Math.min(leftLongitude, l.getLongitude());
                    rightLongitude = Math.max(rightLongitude, l.getLongitude());
                }
                if (!filter.isEmpty()) {
                    for (AmenityIndexRepository index : this.amenityRepositories.values()) {
                        if (!index.checkContains(topLatitude, leftLongitude, bottomLatitude, rightLongitude)) continue;
                        repos.add(index);
                    }
                    if (!repos.isEmpty()) {
                        for (AmenityIndexRepository r : repos) {
                            List<Amenity> res = r.searchAmenitiesOnThePath(locations, radius, filter, matcher);
                            if (res == null) continue;
                            amenities.addAll(res);
                        }
                    }
                }
            }
        }
        finally {
            this.searchAmenitiesInProgress = false;
        }
        return amenities;
    }

    public boolean containsAmenityRepositoryToSearch(boolean searchByName) {
        for (AmenityIndexRepository index : this.amenityRepositories.values()) {
            if (searchByName) {
                if (!(index instanceof AmenityIndexRepositoryBinary)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public List<Amenity> searchAmenitiesByName(String searchQuery, double topLatitude, double leftLongitude, double bottomLatitude, double rightLongitude, double lat, double lon, ResultMatcher<Amenity> matcher) {
        ArrayList<Amenity> amenities = new ArrayList<Amenity>();
        ArrayList<AmenityIndexRepositoryBinary> list = new ArrayList<AmenityIndexRepositoryBinary>();
        for (AmenityIndexRepository index : this.amenityRepositories.values()) {
            if (!(index instanceof AmenityIndexRepositoryBinary) || !index.checkContains(topLatitude, leftLongitude, bottomLatitude, rightLongitude)) continue;
            if (index.checkContains(lat, lon)) {
                list.add(0, (AmenityIndexRepositoryBinary)index);
                continue;
            }
            list.add((AmenityIndexRepositoryBinary)index);
        }
        int left = 0;
        int top = 0;
        int right = Integer.MAX_VALUE;
        int bottom = Integer.MAX_VALUE;
        for (AmenityIndexRepositoryBinary index : list) {
            if (matcher != null && matcher.isCancelled()) break;
            List<Amenity> result = index.searchAmenitiesByName(MapUtils.get31TileNumberX(lon), MapUtils.get31TileNumberY(lat), left, top, right, bottom, searchQuery, matcher);
            amenities.addAll(result);
        }
        return amenities;
    }

    public Map<PoiCategory, List<String>> searchAmenityCategoriesByName(String searchQuery, double lat, double lon) {
        LinkedHashMap<PoiCategory, List<String>> map = new LinkedHashMap<PoiCategory, List<String>>();
        for (AmenityIndexRepository index : this.amenityRepositories.values()) {
            if (!(index instanceof AmenityIndexRepositoryBinary) || !index.checkContains(lat, lon)) continue;
            ((AmenityIndexRepositoryBinary)index).searchAmenityCategoriesByName(searchQuery, map);
        }
        return map;
    }

    public RegionAddressRepository getRegionRepository(String name) {
        return this.addressMap.get(name);
    }

    public Collection<RegionAddressRepository> getAddressRepositories() {
        return this.addressMap.values();
    }

    public List<TransportIndexRepository> searchTransportRepositories(double latitude, double longitude) {
        ArrayList<TransportIndexRepository> repos = new ArrayList<TransportIndexRepository>();
        for (TransportIndexRepository index : this.transportRepositories.values()) {
            if (!index.checkContains(latitude, longitude)) continue;
            repos.add(index);
        }
        return repos;
    }

    public void searchTransportAsync(double topLatitude, double leftLongitude, double bottomLatitude, double rightLongitude, int zoom, List<TransportStop> toFill) {
        ArrayList<TransportIndexRepository> repos = new ArrayList<TransportIndexRepository>();
        for (TransportIndexRepository index : this.transportRepositories.values()) {
            if (!index.checkContains(topLatitude, leftLongitude, bottomLatitude, rightLongitude) || index.checkCachedObjects(topLatitude, leftLongitude, bottomLatitude, rightLongitude, zoom, toFill, true)) continue;
            repos.add(index);
        }
        if (!repos.isEmpty()) {
            // empty if block
        }
    }

    public boolean isSearchAmenitiesInProgress() {
        return this.searchAmenitiesInProgress;
    }

    public MapRenderRepositories getRenderer() {
        return this.renderer;
    }

    public void closeFile(String fileName) {
        BinaryMapIndexReader rmp;
        TransportIndexRepository tir;
        RegionAddressRepository rar;
        AmenityIndexRepository rep = this.amenityRepositories.remove(fileName);
        if (rep != null) {
            rep.close();
        }
        if ((rar = this.addressMap.remove(fileName)) != null) {
            rar.close();
        }
        if ((tir = this.transportRepositories.remove(fileName)) != null) {
            tir.close();
        }
        if ((rmp = this.routingMapFiles.remove(fileName)) != null) {
            try {
                rmp.close();
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        this.indexFileNames.remove(fileName);
        this.renderer.closeConnection(fileName);
    }

    public void closeAmenities() {
        for (AmenityIndexRepository r : this.amenityRepositories.values()) {
            r.close();
        }
        this.amenityRepositories.clear();
    }

    public void closeAddresses() {
        for (RegionAddressRepository r : this.addressMap.values()) {
            r.close();
        }
        this.addressMap.clear();
    }

    public void closeTransport() {
        for (TransportIndexRepository r : this.transportRepositories.values()) {
            r.close();
        }
        this.transportRepositories.clear();
    }

    public synchronized void close() {
        this.imagesOnFS.clear();
        this.indexFileNames.clear();
        this.basemapFileNames.clear();
        this.renderer.clearAllResources();
        this.closeAmenities();
        this.closeRouteFiles();
        this.closeAddresses();
        this.closeTransport();
    }

    public BinaryMapIndexReader[] getRoutingMapFiles() {
        return this.routingMapFiles.values().toArray(new BinaryMapIndexReader[this.routingMapFiles.size()]);
    }

    public void closeRouteFiles() {
        ArrayList<String> map = new ArrayList<String>(this.routingMapFiles.keySet());
        for (String m : map) {
            try {
                BinaryMapIndexReader ind = this.routingMapFiles.remove(m);
                if (ind == null) continue;
                ind.getRaf().close();
            }
            catch (IOException e) {
                log.error((Object)("Error closing resource " + m), (Throwable)e);
            }
        }
    }

    public Map<String, String> getIndexFileNames() {
        return new LinkedHashMap<String, String>(this.indexFileNames);
    }

    public boolean containsBasemap() {
        return !this.basemapFileNames.isEmpty();
    }

    public Map<String, String> getBackupIndexes(Map<String, String> map) {
        File[] lf;
        File file = this.context.getAppPath("backup/");
        if (file != null && file.isDirectory() && (lf = file.listFiles()) != null) {
            for (File f : lf) {
                if (f == null || !f.getName().endsWith(".obf")) continue;
                map.put(f.getName(), AndroidUtils.formatDate(f.lastModified()));
            }
        }
        return map;
    }

    public synchronized void reloadTilesFromFS() {
        this.imagesOnFS.clear();
    }

    public void onLowMemory() {
        log.info((Object)("On low memory : cleaning tiles - size = " + this.cacheOfImages.size()));
        this.clearTiles();
        for (RegionAddressRepository r : this.addressMap.values()) {
            r.clearCache();
        }
        this.renderer.clearCache();
        System.gc();
    }

    public GeoidAltitudeCorrection getGeoidAltitudeCorrection() {
        return this.geoidAltitudeCorrection;
    }

    protected synchronized void clearTiles() {
        log.info((Object)("Cleaning tiles - size = " + this.cacheOfImages.size()));
        ArrayList<String> list = new ArrayList<String>(this.cacheOfImages.keySet());
        for (int i = 0; i < list.size() / 2; ++i) {
            this.cacheOfImages.remove(list.get(i));
        }
    }

    public IncrementalChangesManager getChangesManager() {
        return this.changesManager;
    }

    public OsmWindow getContext() {
        return this.context;
    }

    public static interface ResourceWatcher {
        public boolean indexResource(File var1);

        public List<String> getWatchWorkspaceFolder();
    }
}

