/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.check;

import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.ivy.core.check.CheckEngineSettings;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolveEngine;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.util.Message;

public class CheckEngine {
    private CheckEngineSettings settings;
    private ResolveEngine resolveEngine;

    public CheckEngine(CheckEngineSettings checkEngineSettings, ResolveEngine resolveEngine) {
        this.settings = checkEngineSettings;
        this.resolveEngine = resolveEngine;
    }

    /*
     * WARNING - void declaration
     */
    public boolean check(URL uRL, String string) {
        try {
            Object object;
            Object object2;
            boolean bl = true;
            ModuleDescriptor moduleDescriptor = ModuleDescriptorParserRegistry.getInstance().parseDescriptor(this.settings, uRL, this.settings.doValidate());
            if (string != null) {
                object2 = this.settings.getResolver(string);
                object = moduleDescriptor.getConfigurationsNames();
                HashSet<Artifact> hashSet = new HashSet<Artifact>();
                for (int i = 0; i < ((String[])object).length; ++i) {
                    hashSet.addAll(Arrays.asList(moduleDescriptor.getArtifacts(object[i])));
                }
                for (Artifact object3 : hashSet) {
                    if (object2.exists(object3)) continue;
                    Message.info("declared publication not found: " + object3);
                    bl = false;
                }
            }
            object2 = moduleDescriptor.getDependencies();
            object = new ResolveData(this.resolveEngine, new ResolveOptions());
            for (int i = 0; i < ((DependencyDescriptor[])object2).length; ++i) {
                void var9_17;
                String[] stringArray = object2[i].getModuleConfigurations();
                boolean bl2 = false;
                while (var9_17 < stringArray.length) {
                    if (!"*".equals(stringArray[var9_17].trim()) && moduleDescriptor.getConfiguration(stringArray[var9_17]) == null) {
                        Message.info("dependency required in non existing conf for " + uRL + " \n\tin " + object2[i] + ": " + stringArray[var9_17]);
                        bl = false;
                    }
                    ++var9_17;
                }
                DependencyResolver dependencyResolver = this.settings.getResolver(object2[i].getDependencyRevisionId());
                ResolvedModuleRevision resolvedModuleRevision = dependencyResolver.getDependency((DependencyDescriptor)object2[i], (ResolveData)object);
                if (resolvedModuleRevision == null) {
                    Message.info("dependency not found in " + uRL + ":\n\t" + object2[i]);
                    bl = false;
                    continue;
                }
                String[] stringArray2 = object2[i].getDependencyConfigurations(moduleDescriptor.getConfigurationsNames());
                for (int j = 0; j < stringArray2.length; ++j) {
                    if (!Arrays.asList(resolvedModuleRevision.getDescriptor().getConfigurationsNames()).contains(stringArray2[j])) {
                        Message.info("dependency configuration is missing for " + uRL + "\n\tin " + object2[i] + ": " + stringArray2[j]);
                        bl = false;
                    }
                    Artifact[] artifactArray = resolvedModuleRevision.getDescriptor().getArtifacts(stringArray2[j]);
                    for (int k = 0; k < artifactArray.length; ++k) {
                        if (dependencyResolver.exists(artifactArray[k])) continue;
                        Message.info("dependency artifact is missing for " + uRL + "\n\t in " + object2[i] + ": " + artifactArray[k]);
                        bl = false;
                    }
                }
            }
            return bl;
        }
        catch (ParseException parseException) {
            Message.info("parse problem on " + uRL + ": " + parseException);
            return false;
        }
        catch (IOException iOException) {
            Message.info("io problem on " + uRL + ": " + iOException);
            return false;
        }
        catch (Exception exception) {
            Message.info("problem on " + uRL + ": " + exception);
            return false;
        }
    }
}

