/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.LiveDeployment;

import com.zeroc.Ice.FacetNotExistException;
import com.zeroc.Ice.FileException;
import com.zeroc.Ice.ObjectNotExistException;
import com.zeroc.Ice.Properties;
import com.zeroc.Ice.Util;
import com.zeroc.IceGridGUI.Coordinator;
import com.zeroc.IceGridGUI.LiveDeployment.Communicator;
import com.zeroc.IceGridGUI.LiveDeployment.Editor;
import com.zeroc.IceGridGUI.LiveDeployment.MetricsFieldContext;
import com.zeroc.IceGridGUI.LiveDeployment.MetricsView;
import com.zeroc.IceGridGUI.LiveDeployment.Root;
import com.zeroc.IceInternal.HashUtil;
import com.zeroc.IceMX.Metrics;
import com.zeroc.IceMX.MetricsAdminPrx;
import com.zeroc.IceMX.MetricsFailures;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;

public class MetricsViewEditor
extends Editor
implements MetricsFieldContext {
    private static Future<?> _refreshFuture;
    private Map<String, JTable> _tables = new HashMap<String, JTable>();
    private static final int _refreshPeriod = 5;
    private static Properties _properties;
    private static String[] _sectionSort;
    private static Map<String, String> _sectionNames;
    private static TreePath _selectedPath;
    private final Preferences _prefs = Coordinator.getPreferences().node("MetricsView");

    MetricsViewEditor(Root root) {
        if (_properties == null) {
            Coordinator coord = root.getCoordinator();
            JTree tree = root.getTree();
            tree.addTreeSelectionListener(new SelectionListener());
            LinkedHashSet<String> sectionSort = new LinkedHashSet<String>();
            _properties = Util.createProperties();
            _properties.load("metrics.cfg");
            sectionSort.addAll(Arrays.asList(_properties.getPropertyAsList("IceGridGUI.Metrics")));
            String metricsDefs = coord.getProperties().getProperty("IceGridAdmin.MetricsConfigs");
            if (!metricsDefs.isEmpty()) {
                for (String s : metricsDefs.split(",")) {
                    try {
                        _properties.load(s.trim());
                    }
                    catch (FileException ex) {
                        coord.getCommunicator().getLogger().warning("unable to load `" + ex.path + "'");
                    }
                    sectionSort.addAll(Arrays.asList(_properties.getPropertyAsList("IceGridGUI.Metrics")));
                }
            }
            for (String name : sectionSort) {
                String displayName = _properties.getPropertyWithDefault("IceGridGUI.Metrics." + name, "");
                if (displayName.equals("")) continue;
                _sectionNames.put(name, displayName);
            }
            _sectionSort = sectionSort.toArray(new String[sectionSort.size()]);
        }
    }

    @Override
    public int getRefreshPeriod() {
        return 5;
    }

    static synchronized void startRefresh(MetricsView node) {
        assert (_refreshFuture == null);
        _refreshFuture = node.getCoordinator().getScheduledExecutor().scheduleAtFixedRate(() -> node.fetchMetricsView(), 0L, 5L, TimeUnit.SECONDS);
    }

    static synchronized void stopRefresh() {
        if (_refreshFuture != null) {
            _refreshFuture.cancel(false);
            _refreshFuture = null;
        }
    }

    static void setSelectedPath(TreePath path) {
        _selectedPath = path;
    }

    public Map<String, List<MetricsCell>> getSelectedRows(JTable table, boolean numeric) {
        int[] selectedRows = table.getSelectedRows();
        int[] selectedColumns = table.getSelectedColumns();
        HashMap<String, List<MetricsCell>> rows = new HashMap<String, List<MetricsCell>>();
        if (selectedRows.length > 0 && selectedColumns.length > 0) {
            TableModel model = (TableModel)table.getModel();
            int idColumn = table.getColumnModel().getColumnIndex(_properties.getProperty("IceGridGUI.Metrics." + model.getMetricsName() + ".id.columnName"));
            for (int row : selectedRows) {
                ArrayList<MetricsCell> cells = new ArrayList<MetricsCell>();
                String id = model.getValueAt(table.convertRowIndexToModel(row), idColumn).toString();
                for (int col : selectedColumns) {
                    MetricsField field = model.getMetricFields().get(table.convertColumnIndexToModel(col));
                    Class columnClass = field.getColumnClass();
                    if (!numeric) {
                        cells.add(new MetricsCell(id, field.createField()));
                        continue;
                    }
                    if (!columnClass.equals(Integer.TYPE) && !columnClass.equals(Integer.class) && !columnClass.equals(Long.TYPE) && !columnClass.equals(Long.class) && !columnClass.equals(Float.TYPE) && !columnClass.equals(Float.class) && !columnClass.equals(Double.TYPE) && !columnClass.equals(Double.class)) continue;
                    cells.add(new MetricsCell(id, field.createField()));
                }
                if (cells.size() <= 0) continue;
                rows.put(id, cells);
            }
        }
        return rows;
    }

    /*
     * WARNING - void declaration
     */
    public void show(final MetricsView node, Map<String, Metrics[]> data, long timestamp) {
        int minRowHeight;
        boolean rebuildPanel = false;
        if (!node.isEnabled()) {
            this._tables.clear();
            rebuildPanel = true;
        } else if (data != null) {
            for (final Map.Entry<String, Metrics[]> entry : data.entrySet()) {
                String[] names;
                Metrics[] objects;
                if (this._tables.get(entry.getKey()) != null || (objects = entry.getValue()) == null || objects.length == 0) continue;
                final TableModel model = new TableModel(entry.getKey());
                String prefix = "IceGridGUI.Metrics." + entry.getKey();
                for (String string : names = _properties.getPropertyAsList(prefix + ".fields")) {
                    Field objectField = null;
                    try {
                        objectField = objects[0].getClass().getField(string);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                    MetricsField field = MetricsViewEditor.createField(node, prefix + "." + string, entry.getKey(), string, objectField, this);
                    if (field == null) continue;
                    model.addField(field);
                }
                if (model.getMetricFields().size() == 0) continue;
                final JTable table = new JTable(model){

                    @Override
                    protected JTableHeader createDefaultTableHeader() {
                        return new JTableHeader(this.columnModel){

                            @Override
                            public String getToolTipText(MouseEvent e) {
                                int index = this.columnModel.getColumn(this.columnModel.getColumnIndexAtX(e.getPoint().x)).getModelIndex();
                                return model.getMetricFields().get(index).getColumnToolTip();
                            }
                        };
                    }
                };
                int fontSize = table.getFont().getSize();
                minRowHeight = fontSize + fontSize / 3;
                if (table.getRowHeight() < minRowHeight) {
                    table.setRowHeight(minRowHeight);
                }
                table.setDragEnabled(true);
                table.setSelectionMode(2);
                table.setCellSelectionEnabled(true);
                table.addMouseListener(new ButtonMouseListener(table));
                table.setAutoCreateRowSorter(true);
                table.setTransferHandler(new TransferHandler(node));
                table.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        this.createAndShowMenu(e);
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        this.createAndShowMenu(e);
                    }

                    public void createAndShowMenu(MouseEvent e) {
                        if (e.isPopupTrigger()) {
                            Coordinator.IGraphView[] graphs;
                            JPopupMenu popup = new JPopupMenu();
                            JMenu addToGraph = new JMenu("Add To Metrics Graph");
                            popup.add(addToGraph);
                            final Map<String, List<MetricsCell>> rows = MetricsViewEditor.this.getSelectedRows(table, true);
                            addToGraph.setEnabled(rows.size() > 0);
                            JMenuItem newGraph = new JMenuItem("New Metrics Graph");
                            newGraph.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    Coordinator.IGraphView view = node.getCoordinator().createGraphView();
                                    if (view != null) {
                                        view.addSeries(new MetricsViewTransferableData(new MetricsViewInfo(node), (String)entry.getKey(), rows));
                                    }
                                }
                            });
                            addToGraph.add(newGraph);
                            for (final Coordinator.IGraphView view : graphs = node.getCoordinator().getGraphViews()) {
                                JMenuItem item = new JMenuItem(view.getTitle());
                                addToGraph.add(item);
                                item.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        view.addSeries(new MetricsViewTransferableData(new MetricsViewInfo(node), (String)entry.getKey(), rows));
                                    }
                                });
                            }
                            popup.show(e.getComponent(), e.getX(), e.getY());
                        }
                    }
                });
                for (Map.Entry<Integer, MetricsField> fieldEntry : model.getMetricFields().entrySet()) {
                    if (fieldEntry.getValue().getCellRenderer() == null) continue;
                    table.getColumnModel().getColumn(fieldEntry.getKey()).setCellRenderer(fieldEntry.getValue().getCellRenderer());
                }
                this._tables.put(entry.getKey(), table);
                rebuildPanel = true;
            }
        }
        if (rebuildPanel) {
            this.buildPropertiesPanel();
        }
        if (data != null) {
            for (final Map.Entry<String, Metrics[]> entry : data.entrySet()) {
                void var15_19;
                String key = entry.getKey();
                Metrics[] values = entry.getValue();
                JTable table = this._tables.get(key);
                if (table == null) continue;
                TableModel model = (TableModel)table.getModel();
                Map<String, List<MetricsCell>> rows = this.getSelectedRows(table, false);
                model.getDataVector().removeAllElements();
                model.fireTableDataChanged();
                Metrics[] fontSize = values;
                minRowHeight = fontSize.length;
                boolean bl = false;
                while (var15_19 < minRowHeight) {
                    Metrics m = fontSize[var15_19];
                    model.addMetrics(m, timestamp);
                    ++var15_19;
                }
                int idColumn = table.getColumnModel().getColumnIndex(_properties.getProperty("IceGridGUI.Metrics." + key + ".id.columnName"));
                if (rows.size() <= 0) continue;
                for (int i = table.getRowCount() - 1; i >= 0; --i) {
                    String string = (String)table.getValueAt(i, idColumn);
                    List<MetricsCell> columns = rows.get(string);
                    if (columns == null) continue;
                    for (MetricsCell cell : columns) {
                        int j = table.getColumnModel().getColumnIndex(cell.getField().getColumnName());
                        table.getSelectionModel().addSelectionInterval(i, i);
                        table.getColumnModel().getSelectionModel().addSelectionInterval(j, j);
                    }
                }
            }
        }
    }

    private static MetricsField createField(MetricsView node, String prefix, String mapName, String name, Field objectField, MetricsFieldContext context) {
        Class cls;
        String className = _properties.getPropertyWithDefault(prefix + ".fieldClass", "com.zeroc.IceGridGUI.LiveDeployment.MetricsViewEditor$DeclaredMetricsField");
        if (!className.startsWith("com.zeroc.")) {
            className = "com.zeroc." + className;
        }
        if ((cls = com.zeroc.IceInternal.Util.findClass((String)className, null)) == null) {
            System.err.println("Could not find class " + className);
            return null;
        }
        try {
            Constructor ctor = cls.getDeclaredConstructor(MetricsView.class, String.class, String.class, String.class, Field.class);
            MetricsField field = (MetricsField)ctor.newInstance(node, prefix, mapName, name, objectField);
            field.setContext(context);
            Map properties = _properties.getPropertiesForPrefix(prefix);
            for (Map.Entry propEntry : properties.entrySet()) {
                if (((String)propEntry.getKey()).equals(prefix + "." + name + ".fieldClass") || !((String)propEntry.getKey()).substring(0, ((String)propEntry.getKey()).lastIndexOf(".")).equals(prefix)) continue;
                String setterName = ((String)propEntry.getKey()).substring(((String)propEntry.getKey()).lastIndexOf(".") + 1);
                setterName = "set" + Character.toUpperCase(setterName.charAt(0)) + setterName.substring(1);
                try {
                    Method setter = cls.getMethod(setterName, String.class);
                    setter.invoke((Object)field, propEntry.getValue());
                }
                catch (NoSuchMethodException ex) {
                }
                catch (InvocationTargetException ex) {
                    ex.printStackTrace();
                }
            }
            return field;
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    @Override
    protected JComponent createPropertiesPanel() {
        JSplitPane current = null;
        JSplitPane top = null;
        HashMap<String, JTable> tables = new HashMap<String, JTable>(this._tables);
        StringBuilder sb = new StringBuilder();
        Object[] elements = _selectedPath.getPath();
        for (Object element : elements) {
            sb.append(element.toString());
            sb.append(".");
        }
        for (String name : _sectionSort) {
            JTable table = (JTable)tables.remove(name);
            if (table == null) continue;
            Object section = _sectionNames.get(name);
            if (section == null) {
                section = name;
            }
            current = this.createScrollTable(current, sb.toString() + (String)name, (String)section, table);
            if (top != null) continue;
            top = current;
        }
        for (Map.Entry entry : tables.entrySet()) {
            current = this.createScrollTable(current, sb.toString() + (String)entry.getKey(), (String)entry.getKey(), (JTable)entry.getValue());
            if (top != null) continue;
            top = current;
        }
        if (current != null) {
            current.setBottomComponent(new JPanel());
        }
        return top;
    }

    private JSplitPane createScrollTable(JSplitPane currentPane, final String key, String title, JTable table) {
        JPanel panel = new JPanel();
        TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), title, 1, 2);
        panel.setBorder(border);
        panel.setLayout(new BorderLayout(0, 0));
        panel.add((Component)new JScrollPane(table), "Center");
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setTopComponent(panel);
        if (currentPane != null) {
            currentPane.setBottomComponent(splitPane);
            currentPane.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        }
        splitPane.setDividerLocation(this._prefs.getInt(key, 120));
        splitPane.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                MetricsViewEditor.this._prefs.putInt(key, (Integer)e.getNewValue());
                try {
                    MetricsViewEditor.this._prefs.flush();
                }
                catch (BackingStoreException ex) {
                    JOptionPane.showMessageDialog(null, ex.toString(), "Error saving preferences", 0);
                }
            }
        });
        return splitPane;
    }

    @Override
    protected void buildPropertiesPanel() {
        super.buildPropertiesPanel();
        this._propertiesPanel.setName("Metrics Report");
    }

    static {
        _sectionNames = new HashMap<String, String>();
    }

    public static class SubMetricsField
    extends AbstractField {
        private static final TableCellRenderer _cellRenderer = new ButtonRenderer();

        public SubMetricsField(MetricsView node, String prefix, String metricsName, String fieldName, Field field) {
            super(node, prefix, metricsName, fieldName, field);
        }

        @Override
        public Class getColumnClass() {
            return JButton.class;
        }

        @Override
        public TableCellRenderer getCellRenderer() {
            return _cellRenderer;
        }

        @Override
        public Object getValue(Metrics m, final long timestamp) {
            try {
                final Metrics[] objects = (Metrics[])m.getClass().getField(this.getFieldName()).get(m);
                JButton button = new JButton(Integer.toString(objects.length));
                button.setEnabled(objects.length > 0);
                if (objects.length > 0) {
                    button.addActionListener(new ActionListener(){

                        /*
                         * WARNING - void declaration
                         */
                        @Override
                        public void actionPerformed(ActionEvent event) {
                            String[] names;
                            final TableModel model = new TableModel(this.getMetricsName());
                            String prefix = "IceGridGUI.Metrics." + this.getMetricsName() + "." + this.getFieldName();
                            for (String name : names = _properties.getPropertyAsList(prefix + ".fields")) {
                                void var9_10;
                                Object var9_11 = null;
                                try {
                                    Field field = objects[0].getClass().getField(name);
                                }
                                catch (NoSuchFieldException noSuchFieldException) {
                                    // empty catch block
                                }
                                MetricsField field = MetricsViewEditor.createField(this.getMetricsNode(), prefix + "." + (String)name, this.getFieldName(), name, (Field)var9_10, this.getContext());
                                if (field == null) continue;
                                model.addField(field);
                            }
                            if (model.getMetricFields().size() == 0) {
                                return;
                            }
                            JTable table = new JTable(model){

                                @Override
                                protected JTableHeader createDefaultTableHeader() {
                                    return new JTableHeader(this.columnModel){

                                        @Override
                                        public String getToolTipText(MouseEvent e) {
                                            int index = this.columnModel.getColumn(this.columnModel.getColumnIndexAtX(e.getPoint().x)).getModelIndex();
                                            return model.getMetricFields().get(index).getColumnToolTip();
                                        }
                                    };
                                }
                            };
                            table.addMouseListener(new ButtonMouseListener(table));
                            table.setAutoCreateRowSorter(true);
                            int fontSize = table.getFont().getSize();
                            int minRowHeight = fontSize + fontSize / 3;
                            if (table.getRowHeight() < minRowHeight) {
                                table.setRowHeight(minRowHeight);
                            }
                            for (Map.Entry entry : model.getMetricFields().entrySet()) {
                                if (((MetricsField)entry.getValue()).getCellRenderer() == null) continue;
                                table.getColumnModel().getColumn((Integer)entry.getKey()).setCellRenderer(((MetricsField)entry.getValue()).getCellRenderer());
                            }
                            int idColumn = table.getColumnModel().getColumnIndex(_properties.getProperty(prefix + ".id.columnName"));
                            for (Metrics m : objects) {
                                model.addMetrics(m, timestamp);
                            }
                            JScrollPane jScrollPane = new JScrollPane(table);
                            jScrollPane.setPreferredSize(new Dimension(800, 600));
                            JOptionPane.showMessageDialog(this.getMetricsNode().getCoordinator().getMainFrame(), jScrollPane, this.getColumnName(), -1);
                        }
                    });
                }
                return button;
            }
            catch (NoSuchFieldException ex) {
                return null;
            }
            catch (IllegalAccessException ex) {
                return null;
            }
        }
    }

    public static class FailuresMetricsField
    extends AbstractField {
        private static final TableCellRenderer _cellRenderer = new ButtonRenderer();

        public FailuresMetricsField(MetricsView node, String prefix, String metricsName, String fieldName, Field field) {
            super(node, prefix, metricsName, fieldName, field);
        }

        @Override
        public Class getColumnClass() {
            return JButton.class;
        }

        @Override
        public TableCellRenderer getCellRenderer() {
            return _cellRenderer;
        }

        @Override
        public Object getValue(final Metrics m, long timestamp) {
            JButton button = new JButton(Integer.toString(m.failures));
            if (m.failures > 0) {
                button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DefaultTableModel model = new DefaultTableModel();
                        model.addColumn("Count");
                        model.addColumn("Type");
                        model.addColumn("Identity");
                        JTable table = new JTable(model);
                        int fontSize = table.getFont().getSize();
                        int minRowHeight = fontSize + fontSize / 3;
                        if (table.getRowHeight() < minRowHeight) {
                            table.setRowHeight(minRowHeight);
                        }
                        table.setPreferredSize(new Dimension(550, 200));
                        table.setPreferredScrollableViewportSize(table.getPreferredSize());
                        table.setCellSelectionEnabled(false);
                        table.setAutoResizeMode(0);
                        table.getColumnModel().getColumn(0).setPreferredWidth(50);
                        table.getColumnModel().getColumn(1).setPreferredWidth(250);
                        table.getColumnModel().getColumn(2).setPreferredWidth(250);
                        JScrollPane scrollPane = new JScrollPane(table);
                        this.getMetricsNode().getCoordinator().getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
                        CompletableFuture<MetricsFailures> r = this.getMetricsNode().fetchMetricsFailures(this.getMetricsName(), m.id);
                        if (r != null) {
                            r.whenComplete((result, ex) -> {
                                if (ex == null) {
                                    SwingUtilities.invokeLater(() -> {
                                        for (Map.Entry entry : result.failures.entrySet()) {
                                            Object[] row = new Object[]{((Integer)entry.getValue()).toString(), entry.getKey(), m2.id};
                                            model.addRow(row);
                                        }
                                        this.getMetricsNode().getCoordinator().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
                                    });
                                } else {
                                    SwingUtilities.invokeLater(() -> {
                                        this.getMetricsNode().getCoordinator().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
                                        if (!(ex instanceof ObjectNotExistException) && !(ex instanceof FacetNotExistException)) {
                                            ex.printStackTrace();
                                            JOptionPane.showMessageDialog(this.getMetricsNode().getCoordinator().getMainFrame(), "Error: " + ex.toString(), "Error", 0);
                                        }
                                    });
                                }
                            });
                        }
                        JOptionPane.showMessageDialog(this.getMetricsNode().getCoordinator().getMainFrame(), scrollPane, "Metrics Failures", -1);
                        this.getMetricsNode().getCoordinator().getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
                    }
                });
            } else {
                button.setEnabled(false);
            }
            return button;
        }
    }

    public static class DeltaAverageMetricsField
    extends AbstractField {
        private double _scaleFactor = 1.0;
        private String _dataField;
        private final Map<String, DeltaMeasurement> _deltas = new HashMap<String, DeltaMeasurement>();
        private final Map<String, Double> _last = new HashMap<String, Double>();
        private TableCellRenderer _cellRenderer;

        public DeltaAverageMetricsField(MetricsView node, String prefix, String metricsName, String fieldName, Field field) {
            super(node, prefix, metricsName, fieldName, field);
            this.setFormat("#0.000");
        }

        public void setFormat(String format) {
            this._cellRenderer = new FormatedNumberRenderer(format);
        }

        @Override
        public Class getColumnClass() {
            return Double.class;
        }

        @Override
        public TableCellRenderer getCellRenderer() {
            return this._cellRenderer;
        }

        public void setDataField(String dataField) {
            this._dataField = dataField;
        }

        public void setScaleFactor(String scaleFactor) throws NumberFormatException {
            this._scaleFactor = Double.parseDouble(scaleFactor);
        }

        @Override
        public Object getValue(Metrics m, long timestamp) {
            DeltaMeasurement d1 = this._deltas.get(m.id);
            DeltaMeasurement d2 = new DeltaMeasurement();
            try {
                Object v = m.getClass().getField(this._dataField).get(m);
                if (v instanceof Integer) {
                    d2.value = ((Integer)v).intValue();
                } else if (v instanceof Long) {
                    d2.value = ((Long)v).longValue();
                } else if (v instanceof Float) {
                    d2.value = ((Float)v).floatValue();
                } else if (v instanceof Double) {
                    d2.value = (Double)v;
                }
            }
            catch (NoSuchFieldException ex) {
                ex.printStackTrace();
                return null;
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
                return null;
            }
            d2.timestamp = timestamp;
            this._deltas.put(m.id, d2);
            if (d1 == null) {
                return null;
            }
            Double last = this._last.get(m.id);
            if (last == null) {
                if (d2.timestamp - d1.timestamp >= (long)(this.getContext().getRefreshPeriod() * 1000)) {
                    last = 0.0;
                } else {
                    return null;
                }
            }
            if (d2.timestamp - d1.timestamp >= (long)(this.getContext().getRefreshPeriod() * 1000)) {
                last = d2.value - d1.value == 0.0 || d2.timestamp - d1.timestamp == 0L ? Double.valueOf(0.0) : Double.valueOf((d2.value - d1.value) / ((double)(d2.timestamp - d1.timestamp) / this._scaleFactor));
            }
            this._last.put(m.id, last);
            return last;
        }
    }

    public static class DeltaMeasurement {
        public double value;
        public long timestamp;
    }

    public static class AverageLifetimeMetricsField
    extends AbstractField {
        private double _scaleFactor = 1.0;
        private String _columnName;
        private TableCellRenderer _cellRenderer;
        private final Map<String, Metrics> _deltas = new HashMap<String, Metrics>();

        public AverageLifetimeMetricsField(MetricsView node, String prefix, String metricsName, String fieldName, Field field) {
            super(node, prefix, metricsName, fieldName, field);
            this.setFormat("#0.000");
        }

        public void setFormat(String format) {
            this._cellRenderer = new FormatedNumberRenderer(format);
        }

        @Override
        public Class getColumnClass() {
            return Float.class;
        }

        @Override
        public TableCellRenderer getCellRenderer() {
            return this._cellRenderer;
        }

        public void setScaleFactor(String scaleFactor) throws NumberFormatException {
            this._scaleFactor = Double.parseDouble(scaleFactor);
        }

        @Override
        public Object getValue(Metrics m2, long timestamp) {
            Metrics m1 = this._deltas.get(m2.id);
            this._deltas.put(m2.id, m2);
            if (m1 == null) {
                return null;
            }
            if (m2.total - m1.total - (long)(m2.current - m1.current) == 0L || m2.totalLifetime - m1.totalLifetime == 0L) {
                return Float.valueOf(0.0f);
            }
            return Float.valueOf((float)((double)(m2.totalLifetime - m1.totalLifetime) / this._scaleFactor / (double)(m2.total - m1.total) - (double)(m2.current - m1.current)));
        }
    }

    public static class DeclaredMetricsField
    extends AbstractField {
        private Class _columnClass;
        private TableCellRenderer _cellRenderer;

        public DeclaredMetricsField(MetricsView node, String prefix, String metricsName, String fieldName, Field field) {
            super(node, prefix, metricsName, fieldName, field);
            if (field == null) {
                throw new IllegalArgumentException("Field argument must be non null, Metrics object: `" + metricsName + "' field: `" + fieldName + "'");
            }
            Class<?> columnClass = field.getType();
            if (columnClass.equals(Integer.TYPE)) {
                this._columnClass = Integer.class;
            } else if (columnClass.equals(Long.TYPE)) {
                this._columnClass = Long.class;
            } else if (columnClass.equals(Float.TYPE)) {
                this._columnClass = Float.class;
                this.setFormat("#0.000");
            } else if (columnClass.equals(Double.TYPE)) {
                this._columnClass = Double.class;
                this.setFormat("#0.000");
            } else {
                this._columnClass = columnClass;
            }
        }

        @Override
        public Class getColumnClass() {
            return this._columnClass;
        }

        public void setFormat(String format) {
            this._cellRenderer = new FormatedNumberRenderer(format);
        }

        @Override
        public TableCellRenderer getCellRenderer() {
            return this._cellRenderer;
        }

        @Override
        public Object getValue(Metrics m, long timestamp) {
            try {
                return m.getClass().getField(this.getFieldName()).get(m);
            }
            catch (NoSuchFieldException ex) {
                return null;
            }
            catch (IllegalAccessException ex) {
                return null;
            }
        }
    }

    public static abstract class AbstractField
    implements MetricsField {
        private final MetricsView _node;
        private final String _prefix;
        private final String _metricsName;
        private final String _fieldName;
        private final Field _objectField;
        private String _columnName;
        private String _columnToolTip;
        private MetricsFieldContext _context;

        public AbstractField(MetricsView node, String prefix, String metricsName, String fieldName, Field objectField) {
            this._node = node;
            this._prefix = prefix;
            this._metricsName = metricsName;
            this._fieldName = fieldName;
            this._objectField = objectField;
        }

        @Override
        public MetricsView getMetricsNode() {
            return this._node;
        }

        @Override
        public String getMetricsName() {
            return this._metricsName;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        @Override
        public String getColumnName() {
            return this._columnName == null ? this._fieldName : this._columnName;
        }

        public void setColumnName(String columnName) {
            this._columnName = columnName;
        }

        @Override
        public String getColumnToolTip() {
            return this._columnToolTip;
        }

        public void setColumnToolTip(String columnToolTip) {
            this._columnToolTip = columnToolTip;
        }

        @Override
        public MetricsField createField() {
            return MetricsViewEditor.createField(this._node, this._prefix, this._metricsName, this._fieldName, this._objectField, this._context);
        }

        @Override
        public String getPropertyPrefix() {
            return this._prefix;
        }

        @Override
        public MetricsFieldContext getContext() {
            return this._context;
        }

        @Override
        public void setContext(MetricsFieldContext context) {
            this._context = context;
        }
    }

    public static interface MetricsField {
        public MetricsView getMetricsNode();

        public String getPropertyPrefix();

        public String getMetricsName();

        public String getFieldName();

        public String getColumnName();

        public String getColumnToolTip();

        public Class getColumnClass();

        public TableCellRenderer getCellRenderer();

        public Object getValue(Metrics var1, long var2);

        public MetricsField createField();

        public MetricsFieldContext getContext();

        public void setContext(MetricsFieldContext var1);
    }

    static class ColumnInfo {
        public String name;
        public String displayName;

        public ColumnInfo(String name, String displayName) {
            this.name = name;
            this.displayName = displayName;
        }
    }

    public static class TableModel
    extends DefaultTableModel {
        String _metricsName;
        Map<Integer, MetricsField> _fields = new HashMap<Integer, MetricsField>();

        public TableModel(String metricsName) {
            this._metricsName = metricsName;
        }

        public void addMetrics(Metrics m, long timestamp) {
            Object[] row = new Object[this._fields.size()];
            for (Map.Entry<Integer, MetricsField> entry : this._fields.entrySet()) {
                Object value = entry.getValue().getValue(m, timestamp);
                if (value == null) {
                    Class c = this.getColumnClass(entry.getKey());
                    if (c.equals(Integer.class)) {
                        value = new Integer(0);
                    } else if (c.equals(Long.class)) {
                        value = new Long(0L);
                    } else if (c.equals(Float.class)) {
                        value = new Float(0.0f);
                    } else if (c.equals(Double.class)) {
                        value = new Double(0.0);
                    }
                }
                row[entry.getKey().intValue()] = value;
            }
            this.addRow(row);
        }

        public void addField(MetricsField field) {
            this.addColumn(field.getColumnName());
            this._fields.put(this._fields.size(), field);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public Class getColumnClass(int index) {
            return this._fields.get(index).getColumnClass();
        }

        public Map<Integer, MetricsField> getMetricFields() {
            return this._fields;
        }

        public String getMetricsName() {
            return this._metricsName;
        }
    }

    class TransferHandler
    extends javax.swing.TransferHandler {
        private MetricsView _node;

        public TransferHandler(MetricsView node) {
            this._node = node;
        }

        @Override
        public int getSourceActions(JComponent component) {
            return 1;
        }

        @Override
        public Transferable createTransferable(JComponent component) {
            JTable table = (JTable)component;
            TableModel model = (TableModel)table.getModel();
            Map<String, List<MetricsCell>> rows = MetricsViewEditor.this.getSelectedRows(table, true);
            if (rows.size() > 0) {
                return new Transferable(new MetricsViewTransferableData(new MetricsViewInfo(this._node), model.getMetricsName(), rows));
            }
            return null;
        }

        protected void exportDone(JComponent source, Transferable data, int action) {
        }
    }

    public static class MetricsViewTransferableData {
        public final MetricsViewInfo info;
        public final String name;
        public final Map<String, List<MetricsCell>> rows;
        private static DataFlavor _flavor;

        public MetricsViewTransferableData(MetricsViewInfo info, String name, Map<String, List<MetricsCell>> rows) {
            this.info = info;
            this.name = name;
            this.rows = rows;
        }

        public static DataFlavor dataFlavor() {
            if (_flavor == null) {
                try {
                    _flavor = new DataFlavor("application/x-java-jvm-local-objectref;class=\"" + MetricsViewTransferableData.class.getName() + "\"");
                }
                catch (ClassNotFoundException ex) {
                    ex.printStackTrace();
                }
            }
            return _flavor;
        }
    }

    class Transferable
    implements java.awt.datatransfer.Transferable {
        private DataFlavor[] _flavors;
        private MetricsViewTransferableData _data;

        public Transferable(MetricsViewTransferableData data) {
            this._data = data;
            try {
                this._flavors = new DataFlavor[]{(DataFlavor)MetricsViewTransferableData.dataFlavor().clone()};
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this._data;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this._flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return this._flavors[0].equals(flavor);
        }
    }

    public static class MetricsCell {
        private String _id;
        private MetricsField _field;
        private double _scaleFactor = 1.0;
        private double _last;
        private double _average = 0.0;
        private int _samples = 0;
        private double _min;
        private double _max;

        public MetricsCell(String id, MetricsField field) {
            this._id = id;
            this._field = field;
        }

        public String getId() {
            return this._id;
        }

        public MetricsField getField() {
            return this._field;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof MetricsCell)) {
                return false;
            }
            MetricsCell that = (MetricsCell)other;
            return this._id.equals(that._id) && this._field.getFieldName().equals(that._field.getFieldName());
        }

        public int hashCode() {
            int h = HashUtil.hashAdd((int)5381, (Object)this._id);
            return HashUtil.hashAdd((int)h, (Object)this._field.getFieldName());
        }

        public double getScaleFactor() {
            return this._scaleFactor;
        }

        public void setScaleFactor(double scaleFactor) {
            this._scaleFactor = scaleFactor;
        }

        public Number getValue(Metrics m, long timestamp) {
            Number value = (Number)this.getField().getValue(m, timestamp);
            if (value == null) {
                return value;
            }
            ++this._samples;
            this._last = value.doubleValue();
            this._average += (this._last - this._average) / (double)this._samples;
            if (this._last < this._min || this._samples == 1) {
                this._min = this._last;
            }
            if (this._last > this._max || this._samples == 1) {
                this._max = this._last;
            }
            return this._last * this._scaleFactor;
        }

        public Number getLast() {
            return this._last;
        }

        public Number getAverage() {
            return this._average;
        }

        public Number getMin() {
            return this._min;
        }

        public Number getMax() {
            return this._max;
        }

        public void resetField() {
            this._field = this._field.createField();
        }
    }

    public static class MetricsViewInfo {
        public String component;
        public String view;
        public MetricsAdminPrx admin;

        public MetricsViewInfo(MetricsView view) {
            LinkedList<String> fullId = ((Communicator)view.getParent()).getFullId();
            assert (fullId.size() > 0);
            if (fullId.size() == 1) {
                this.component = "/";
            } else {
                StringBuilder builder = null;
                for (String s : fullId) {
                    if (builder == null) {
                        builder = new StringBuilder();
                        continue;
                    }
                    builder.append('/');
                    builder.append(s);
                }
                this.component = builder.toString();
            }
            this.view = view.getId();
            this.admin = view.getMetricsAdmin();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof MetricsViewInfo)) {
                return false;
            }
            MetricsViewInfo that = (MetricsViewInfo)other;
            return this.component.equals(that.component) && this.view.equals(that.view);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.component);
            builder.append("/");
            builder.append(this.view);
            return builder.toString();
        }

        public int hashCode() {
            int h = HashUtil.hashAdd((int)5381, (Object)this.component);
            return HashUtil.hashAdd((int)h, (Object)this.view);
        }
    }

    private static class SelectionListener
    implements TreeSelectionListener {
        private SelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            MetricsViewEditor.stopRefresh();
            if (e.isAddedPath() && e.getPath().getLastPathComponent() instanceof MetricsView && ((MetricsView)e.getPath().getLastPathComponent()).isEnabled()) {
                MetricsViewEditor.startRefresh((MetricsView)e.getPath().getLastPathComponent());
            }
            if (e.isAddedPath()) {
                MetricsViewEditor.setSelectedPath(e.getPath());
            }
        }
    }

    public static class ButtonMouseListener
    extends MouseAdapter {
        private final JTable _table;

        public ButtonMouseListener(JTable table) {
            this._table = table;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Object value;
            int column = this._table.getColumnModel().getColumnIndexAtX(e.getX());
            int row = e.getY() / this._table.getRowHeight();
            if (row < this._table.getRowCount() && row >= 0 && column < this._table.getColumnCount() && column >= 0 && (value = this._table.getValueAt(row, column)) instanceof JButton) {
                ((JButton)value).doClick();
            }
        }
    }

    public static class FormatedNumberRenderer
    extends DefaultTableCellRenderer {
        private final DecimalFormat _format;

        public FormatedNumberRenderer(String format) {
            this._format = new DecimalFormat(format);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                this.setText(this._format.format(Double.parseDouble(value.toString())));
            } else {
                this.setText("");
            }
            this.setHorizontalAlignment(4);
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            return this;
        }
    }

    public static class ButtonRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return null;
            }
            JButton button = (JButton)value;
            if (selected) {
                button.setForeground(table.getSelectionForeground());
                button.setBackground(table.getSelectionBackground());
            } else {
                button.setForeground(table.getForeground());
                button.setBackground(UIManager.getColor("Button.background"));
            }
            return button;
        }
    }
}

