/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.jules;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import sun.java2d.jules.IdleTileCache;
import sun.java2d.jules.JulesPathBuf;
import sun.java2d.jules.JulesTile;
import sun.java2d.jules.TileTrapContainer;
import sun.java2d.jules.TileWorker;
import sun.java2d.jules.TrapezoidList;
import sun.java2d.pipe.AATileGenerator;
import sun.java2d.pipe.Region;
import sun.java2d.xr.GrowableIntArray;
import sun.java2d.xr.XRUtils;

public class JulesAATileGenerator
implements AATileGenerator {
    static final ExecutorService rasterThreadPool = Executors.newCachedThreadPool();
    static final int CPU_CNT = Runtime.getRuntime().availableProcessors();
    static final boolean ENABLE_THREADING = false;
    static final int THREAD_MIN = 16;
    static final int THREAD_BEGIN = 16;
    IdleTileCache tileCache;
    TileWorker worker;
    boolean threaded = false;
    int rasterTileCnt;
    static final int TILE_SIZE = 32;
    static final int TILE_SIZE_FP = 0x200000;
    int left;
    int right;
    int top;
    int bottom;
    int width;
    int height;
    int leftFP;
    int topFP;
    int tileCnt;
    int tilesX;
    int tilesY;
    int currTilePos = 0;
    TrapezoidList traps;
    TileTrapContainer[] tiledTrapArray;
    JulesTile mainTile;

    public JulesAATileGenerator(Shape s, AffineTransform at, Region clip, BasicStroke bs, boolean thin, boolean normalize, int[] bbox) {
        JulesPathBuf buf = new JulesPathBuf();
        this.traps = bs == null ? buf.tesselateFill(s, at, clip) : buf.tesselateStroke(s, bs, thin, false, true, at, clip);
        this.calculateArea(bbox);
        this.bucketSortTraps();
        this.calculateTypicalAlpha();
        this.threaded = false;
        if (this.threaded) {
            this.tileCache = new IdleTileCache();
            this.worker = new TileWorker(this, 16, this.tileCache);
            rasterThreadPool.execute(this.worker);
        }
        this.mainTile = new JulesTile();
    }

    private static native long rasterizeTrapezoidsNative(long var0, int[] var2, int[] var3, int var4, byte[] var5, int var6, int var7);

    private static native void freePixmanImgPtr(long var0);

    private void calculateArea(int[] bbox) {
        this.tilesX = 0;
        this.tilesY = 0;
        this.tileCnt = 0;
        bbox[0] = 0;
        bbox[1] = 0;
        bbox[2] = 0;
        bbox[3] = 0;
        if (this.traps.getSize() > 0) {
            this.left = this.traps.getLeft();
            this.right = this.traps.getRight();
            this.top = this.traps.getTop();
            this.bottom = this.traps.getBottom();
            this.leftFP = this.left << 16;
            this.topFP = this.top << 16;
            bbox[0] = this.left;
            bbox[1] = this.top;
            bbox[2] = this.right;
            bbox[3] = this.bottom;
            this.width = this.right - this.left;
            this.height = this.bottom - this.top;
            if (this.width > 0 && this.height > 0) {
                this.tilesX = (int)Math.ceil((double)this.width / 32.0);
                this.tilesY = (int)Math.ceil((double)this.height / 32.0);
                this.tileCnt = this.tilesY * this.tilesX;
                this.tiledTrapArray = new TileTrapContainer[this.tileCnt];
            } else {
                this.traps.setSize(0);
            }
        }
    }

    private void bucketSortTraps() {
        for (int i = 0; i < this.traps.getSize(); ++i) {
            int top = this.traps.getTop(i) - XRUtils.XDoubleToFixed(this.top);
            int bottom = this.traps.getBottom(i) - this.topFP;
            int p1xLeft = this.traps.getP1XLeft(i) - this.leftFP;
            int p2xLeft = this.traps.getP2XLeft(i) - this.leftFP;
            int p1xRight = this.traps.getP1XRight(i) - this.leftFP;
            int p2xRight = this.traps.getP2XRight(i) - this.leftFP;
            int minLeft = Math.min(p1xLeft, p2xLeft);
            int maxRight = Math.max(p1xRight, p2xRight);
            maxRight = maxRight > 0 ? maxRight - 1 : maxRight;
            bottom = bottom > 0 ? bottom - 1 : bottom;
            int startTileY = top / 0x200000;
            int endTileY = bottom / 0x200000;
            int startTileX = minLeft / 0x200000;
            int endTileX = maxRight / 0x200000;
            for (int n = startTileY; n <= endTileY; ++n) {
                for (int m = startTileX; m <= endTileX; ++m) {
                    int trapArrayPos = n * this.tilesX + m;
                    TileTrapContainer trapTileList = this.tiledTrapArray[trapArrayPos];
                    if (trapTileList == null) {
                        this.tiledTrapArray[trapArrayPos] = trapTileList = new TileTrapContainer(new GrowableIntArray(1, 16));
                    }
                    trapTileList.getTraps().addInt(i);
                }
            }
        }
    }

    @Override
    public void getAlpha(byte[] tileBuffer, int offset, int rowstride) {
        JulesTile tile = null;
        if (this.threaded) {
            tile = this.worker.getPreRasterizedTile(this.currTilePos);
        }
        if (tile != null) {
            System.arraycopy(tile.getImgBuffer(), 0, tileBuffer, 0, tileBuffer.length);
            this.tileCache.releaseTile(tile);
        } else {
            this.mainTile.setImgBuffer(tileBuffer);
            this.rasterizeTile(this.currTilePos, this.mainTile);
        }
        this.nextTile();
    }

    public void calculateTypicalAlpha() {
        this.rasterTileCnt = 0;
        for (int index = 0; index < this.tileCnt; ++index) {
            TileTrapContainer trapCont = this.tiledTrapArray[index];
            if (trapCont == null) continue;
            GrowableIntArray trapList = trapCont.getTraps();
            int tileAlpha = 127;
            if (trapList == null || trapList.getSize() == 0) {
                tileAlpha = 0;
            } else if (this.doTrapsCoverTile(trapList, index)) {
                tileAlpha = 255;
            }
            if (tileAlpha == 127 || tileAlpha == 255) {
                ++this.rasterTileCnt;
            }
            trapCont.setTileAlpha(tileAlpha);
        }
    }

    protected boolean doTrapsCoverTile(GrowableIntArray trapList, int tileIndex) {
        if (trapList.getSize() > 32) {
            return false;
        }
        int tileStartX = this.getXPos(tileIndex) * 0x200000 + this.leftFP;
        int tileStartY = this.getYPos(tileIndex) * 0x200000 + this.topFP;
        int tileEndX = tileStartX + 0x200000;
        int tileEndY = tileStartY + 0x200000;
        int firstTop = this.traps.getTop(trapList.getInt(0));
        int firstBottom = this.traps.getBottom(trapList.getInt(0));
        if (firstTop > tileStartY || firstBottom < tileStartY) {
            return false;
        }
        int lastBottom = firstTop;
        for (int i = 0; i < trapList.getSize(); ++i) {
            int trapPos = trapList.getInt(i);
            if (this.traps.getP1XLeft(trapPos) > tileStartX || this.traps.getP2XLeft(trapPos) > tileStartX || this.traps.getP1XRight(trapPos) < tileEndX || this.traps.getP2XRight(trapPos) < tileEndX || this.traps.getTop(trapPos) != lastBottom) {
                return false;
            }
            lastBottom = this.traps.getBottom(trapPos);
        }
        return lastBottom >= tileEndY;
    }

    @Override
    public int getTypicalAlpha() {
        if (this.tiledTrapArray[this.currTilePos] == null) {
            return 0;
        }
        return this.tiledTrapArray[this.currTilePos].getTileAlpha();
    }

    @Override
    public void dispose() {
        JulesAATileGenerator.freePixmanImgPtr(this.mainTile.getPixmanImgPtr());
        if (this.threaded) {
            this.tileCache.disposeConsumerResources();
            this.worker.disposeConsumerResources();
        }
    }

    protected JulesTile rasterizeTile(int tileIndex, JulesTile tile) {
        int tileOffsetX = this.left + this.getXPos(tileIndex) * 32;
        int tileOffsetY = this.top + this.getYPos(tileIndex) * 32;
        TileTrapContainer trapCont = this.tiledTrapArray[tileIndex];
        GrowableIntArray trapList = trapCont.getTraps();
        if (trapCont.getTileAlpha() == 127) {
            long pixmanImgPtr = JulesAATileGenerator.rasterizeTrapezoidsNative(tile.getPixmanImgPtr(), this.traps.getTrapArray(), trapList.getArray(), trapList.getSize(), tile.getImgBuffer(), tileOffsetX, tileOffsetY);
            tile.setPixmanImgPtr(pixmanImgPtr);
        }
        tile.setTilePos(tileIndex);
        return tile;
    }

    protected int getXPos(int arrayPos) {
        return arrayPos % this.tilesX;
    }

    protected int getYPos(int arrayPos) {
        return arrayPos / this.tilesX;
    }

    @Override
    public void nextTile() {
        ++this.currTilePos;
    }

    @Override
    public int getTileHeight() {
        return 32;
    }

    @Override
    public int getTileWidth() {
        return 32;
    }

    public int getTileCount() {
        return this.tileCnt;
    }

    public TileTrapContainer getTrapContainer(int index) {
        return this.tiledTrapArray[index];
    }
}

